/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedatamodel.wizards.internal;

import com.ibm.etools.webtools.pagedatamodel.wizards.internal.MultiEditorTableViewer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;

public class FocusTextCellEditor
extends TextCellEditor
implements FocusListener {
    protected String fCurrentValue = null;
    private boolean fApplyEditorValue = false;
    private static boolean IS_GTK = SWT.getPlatform().equalsIgnoreCase("gtk");

    public FocusTextCellEditor(Composite parent) {
        super(parent);
    }

    protected Control createControl(Composite parent) {
        Control retVal = super.createControl(parent);
        this.text.addFocusListener((FocusListener)this);
        return retVal;
    }

    public void deactivate() {
        if (IS_GTK) {
            super.deactivate();
        }
    }

    protected void doSetValue(Object value) {
        Object nonNullValue = value == null ? "" : value;
        super.doSetValue(nonNullValue);
        this.fCurrentValue = (String)nonNullValue;
    }

    public void focusGained(FocusEvent e) {
        if (!IS_GTK) {
            TableEditor tEditor = (TableEditor)this.text.getData();
            Table table = tEditor.getItem().getParent();
            table.setSelection(table.indexOf(tEditor.getItem()));
            table.notifyListeners(13, new Event());
        }
    }

    public void focusLost(FocusEvent e) {
        if (IS_GTK) {
            if (this.text != null && this.fCurrentValue != null && this.fApplyEditorValue) {
                this.fireApplyEditorValue();
            }
        } else {
            TableEditor tEditor = (TableEditor)this.text.getData();
            ((MultiEditorTableViewer)((Object)tEditor.getItem().getData("viewer"))).saveEditorValue((CellEditor)this, (Item)tEditor.getItem());
        }
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        this.fApplyEditorValue = true;
        super.keyReleaseOccured(keyEvent);
    }
}

