/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedatamodel.wizards;

import com.ibm.etools.webtools.pagedatamodel.PageDataModelPlugin;
import com.ibm.etools.webtools.pagedatamodel.databinding.CodeGenUtil;
import com.ibm.etools.webtools.pagedatamodel.databinding.ICodeGenModelFactory;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenModel;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.SelectionEntryList;
import com.ibm.etools.webtools.pagedatamodel.nls.ResourceHandler;
import com.ibm.etools.webtools.pagedatamodel.wizards.Util;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Text;

public class OptionsDialog
extends Dialog
implements Listener {
    protected static final String UPDATE = ResourceHandler.Update;
    protected static final String ADD = ResourceHandler.Add;
    protected static final String SUBMIT = ResourceHandler.Submit;
    protected static final String DELETE = ResourceHandler.Delete;
    protected static final String BACK = ResourceHandler.Back;
    protected static final String DETAILS = ResourceHandler.Details;
    protected static final String LINK = ResourceHandler.Link;
    protected static final String BUTTONS = ResourceHandler.Buttons;
    protected static final String LABELS = ResourceHandler.Labels;
    protected static final String ADVANCED = ResourceHandler.Advanced;
    protected static final String OPTIONS = ResourceHandler.Options;
    protected ICodeGenModel fModel;
    protected Combo fAlignmentCombo;
    protected Button fColonButton;
    protected Button fCapitalizeButton;
    protected Button fValidationButton;
    protected Button fDepthButton;
    protected Button fControlIdButton;
    protected Button fWrapLabelButton;
    protected Text fDepthText;
    protected Button fSubmitButton;
    protected Button fAddButton;
    protected Button fDeleteButton;
    protected Button fUpdateButton;
    protected Button fBackButton;
    protected Text fSubmitButtonText;
    protected Text fAddButtonText;
    protected Text fDeleteButtonText;
    protected Text fUpdateButtonText;
    protected Text fBackButtonText;
    protected Button fLinkRowButton;
    protected Button fLinkFieldButton;
    protected Combo fLinkFieldCombo;
    protected Text fLinkRowText;
    protected Util.UniqueMnemonicLabelProvider fLabelProvider = new Util.UniqueMnemonicLabelProvider();

    public OptionsDialog(Shell parentShell) {
        this(parentShell, null);
    }

    public OptionsDialog(Shell parentShell, ICodeGenModel model) {
        super(parentShell);
        this.fModel = model;
        this.setShellStyle(67696);
        this.create();
        this.getShell().setText(OPTIONS);
    }

    protected Control createDialogArea(Composite parent) {
        new Label(parent, 0);
        Composite a = Util.cc(parent);
        TabFolder folder = new TabFolder(a, 128);
        folder.setLayoutData((Object)new GridData(1808));
        String buttonsTabName = this.fLabelProvider.getUniqueLabel(BUTTONS, Util.UniqueMnemonicLabelProvider.GLOBAL_KEY);
        String labelsTabName = this.fLabelProvider.getUniqueLabel(LABELS, Util.UniqueMnemonicLabelProvider.GLOBAL_KEY);
        String advancedTabName = this.fLabelProvider.getUniqueLabel(ADVANCED, Util.UniqueMnemonicLabelProvider.GLOBAL_KEY);
        this.createTab_Buttons(folder, buttonsTabName);
        this.createTab_Labels(folder, labelsTabName);
        this.createTab_Advanced(folder, advancedTabName);
        return a;
    }

    protected void createTab_Labels(TabFolder folder, String tabName) {
        Composite a = Util.cc((Composite)folder, 1808, 10, -1, 1);
        this.fLabelProvider.setActiveKey(a);
        new Label(a, 0).setText(ResourceHandler.How_to_create_labels__12);
        Composite b = Util.cc(a, 1808, 10, 10, 1);
        Composite alignComp = Util.cc(b, 768, 0, 0, 2);
        String label = this.fLabelProvider.getUniqueLabel(ResourceHandler.Alignment__13);
        new Label(alignComp, 0).setText(label);
        this.fAlignmentCombo = new Combo(alignComp, 2056);
        this.fAlignmentCombo.setItems(new String[]{ResourceHandler.Left_14, ResourceHandler.Center_15, ResourceHandler.Right_16});
        this.fAlignmentCombo.select(this.fModel.getAlignment());
        GridData gd = new GridData(768);
        gd.widthHint = 50;
        this.fAlignmentCombo.setLayoutData((Object)gd);
        label = this.fLabelProvider.getUniqueLabel(ResourceHandler.Append_a_colon_to_each_label_17);
        this.fColonButton = Util.cb(b, 32, label);
        this.fColonButton.setSelection(this.fModel.isUseColon());
        label = this.fLabelProvider.getUniqueLabel(ResourceHandler.Capitalize_the_first_letter_of_each_label_18);
        this.fCapitalizeButton = Util.cb(b, 32, label);
        this.fCapitalizeButton.setSelection(this.fModel.isCapitalizeLabel());
        Util.cTab(folder, tabName).setControl((Control)a);
        this.fLabelProvider.flush(a);
    }

    protected void createColonButton(Composite parent) {
    }

    protected void createTab_Advanced(TabFolder folder, String tabName) {
        boolean createDepthControl = this.fModel == this.fModel.getRoot().getCodeGenModel();
        boolean createJSFControls = this.fModel.getPageType().equals("JSF");
        if (createDepthControl || createJSFControls) {
            String label;
            Composite a = Util.cc((Composite)folder, 1808, 10, -1, 1);
            this.fLabelProvider.setActiveKey(a);
            if (createDepthControl) {
                Composite b = Util.cc(a, 768, 5, -1, 2);
                label = this.fLabelProvider.getUniqueLabel(ResourceHandler.Depth);
                new Label(b, 0).setText(label);
                this.fDepthText = new Text(b, 2048);
                this.fDepthText.setLayoutData((Object)new GridData(768));
                this.fDepthText.setText(Integer.toString(this.fModel.getDepth()));
                Composite c = Util.cc(a, 768, 0, -1, 1);
                label = this.fLabelProvider.getUniqueLabel(ResourceHandler.DefaultDepthButton);
                this.fDepthButton = Util.cb(c, 32, label);
            }
            if (createJSFControls) {
                if (createDepthControl) {
                    new Label(a, 258).setLayoutData((Object)new GridData(768));
                }
                Composite d = Util.cc(a, 768, -1, -1, 1);
                label = this.fLabelProvider.getUniqueLabel(ResourceHandler.OnlyDataControlsButton);
                this.fControlIdButton = Util.cb(d, 32, label);
                this.fControlIdButton.setSelection(this.fModel.getControlId() != null && this.fModel.getControlId() == "unformattedControls");
                label = this.fLabelProvider.getUniqueLabel(ResourceHandler.wrapTextInLabelTag);
                this.fWrapLabelButton = Util.cb(d, 32, label);
                this.fWrapLabelButton.setSelection(Boolean.TRUE == this.fModel.getCustomProperty("add_label_component"));
            }
            Util.cTab(folder, tabName).setControl((Control)a);
            this.fLabelProvider.flush(a);
        }
    }

    protected void createTab_Buttons(TabFolder folder, String tabName) {
        if (this.fModel.getControlType() != 0 && !CodeGenUtil.isModelContainedInList(this.fModel)) {
            Composite a = Util.cc((Composite)folder, 1808, 10, -1, 1);
            this.fLabelProvider.setActiveKey(a);
            new Label(a, 0).setText(ResourceHandler.Buttons_to_create__20);
            Composite b = Util.cc(a, 1808, 10, 10, 1);
            this.createButtons(b);
            Util.cTab(folder, tabName).setControl((Control)a);
            this.fLabelProvider.flush(a);
        }
    }

    protected void createButtons(Composite parent) {
        if (this.fModel.getControlType() == 1) {
            this.createSubmit(parent);
            this.createDelete(parent);
        } else if (this.fModel.getControlType() == 2) {
            this.createSubmit(parent);
        }
    }

    protected void createAdd(Composite c) {
        this.fAddButton = this.createButton(c, ADD);
        Composite child = this.createTextComposite(c);
        this.fAddButtonText = this.createText(child, ADD);
    }

    protected void createBack(Composite c) {
        this.fBackButton = this.createButton(c, BACK);
        Composite child = this.createTextComposite(c);
        this.fBackButtonText = this.createText(child, BACK);
    }

    protected void createDelete(Composite c) {
        this.fDeleteButton = this.createButton(c, DELETE, this.fModel.isCreateDeleteButton());
        Composite child = this.createTextComposite(c);
        this.fDeleteButtonText = this.createText(child, DELETE, this.fModel.getDeleteButtonLabel(), this.fModel.isCreateDeleteButton());
    }

    protected void createSubmit(Composite c) {
        this.fSubmitButton = this.createButton(c, SUBMIT, this.fModel.isCreateSubmitButton());
        Composite child = this.createTextComposite(c);
        this.fSubmitButtonText = this.createText(child, SUBMIT, this.fModel.getSubmitButtonLabel(), this.fModel.isCreateSubmitButton());
    }

    protected void createUpdate(Composite c) {
        this.fUpdateButton = this.createButton(c, UPDATE);
        Composite child = this.createTextComposite(c);
        this.fUpdateButtonText = this.createText(child, UPDATE);
    }

    protected Button createButton(Composite c, String label) {
        String mneLabel = this.fLabelProvider.getUniqueLabel(NLS.bind((String)ResourceHandler.button, (Object[])new Object[]{label}));
        return Util.cb(c, 32, mneLabel, 256);
    }

    protected Button createButton(Composite c, String label, boolean selected) {
        Button b = this.createButton(c, label);
        b.setSelection(selected);
        b.addListener(13, (Listener)this);
        return b;
    }

    protected Text createText(Composite c, String textText, String contents, boolean enabled) {
        Text text = this.createText(c, textText);
        if (contents != null) {
            text.setText(contents);
        }
        text.setEnabled(enabled);
        ((Label)text.getData()).setEnabled(enabled);
        return text;
    }

    protected Text createText(Composite c, String textText) {
        String mneLabel = this.fLabelProvider.getUniqueLabel(ResourceHandler.Label__29);
        return this.createText(c, textText, mneLabel, 2048);
    }

    protected Text createText(Composite c, String textText, String label, int style) {
        Label l = new Label(c, 0);
        l.setText(label);
        Text text = new Text(c, style);
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 120;
        text.setLayoutData((Object)gd);
        text.setText(textText);
        text.setData((Object)l);
        return text;
    }

    protected Composite createTextComposite(Composite parent) {
        return Util.cc(parent, 784, 0, 10, 2);
    }

    protected void okPressed() {
        if (this.fDepthText != null) {
            try {
                int depth = Integer.valueOf(this.fDepthText.getText());
                if (this.fDepthButton.getSelection()) {
                    PageDataModelPlugin.getDefault().getDialogSettings().put("DEPTH", depth);
                }
                if (depth != this.fModel.getDepth()) {
                    this.fModel.setDepth(depth);
                    if (this.fColonButton != null) {
                        this.fModel.setUseColon(this.fColonButton.getSelection());
                    }
                    if (this.fCapitalizeButton != null) {
                        this.fModel.setCapitalizeLabel(this.fCapitalizeButton.getSelection());
                    }
                    this.handleDepthChange(depth);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (this.fSubmitButton != null) {
            this.fModel.setCreateSubmitButton(this.fSubmitButton.getSelection());
            this.fModel.setSubmitButtonLabel(this.fSubmitButtonText.getText());
        }
        if (this.fDeleteButton != null) {
            this.fModel.setCreateDeleteButton(this.fDeleteButton.getSelection());
            this.fModel.setDeleteButtonLabel(this.fDeleteButtonText.getText());
        }
        if (this.fValidationButton != null) {
            this.fModel.setGenValidation(this.fValidationButton.getSelection());
        }
        if (this.fAlignmentCombo != null) {
            this.fModel.setAlignment(this.fAlignmentCombo.getSelectionIndex());
        }
        if (this.fColonButton != null && this.fModel.isUseColon() != this.fColonButton.getSelection()) {
            CodeGenUtil.setUseColon(this.fColonButton.getSelection(), this.fModel);
        }
        if (this.fCapitalizeButton != null && this.fModel.isCapitalizeLabel() != this.fCapitalizeButton.getSelection()) {
            CodeGenUtil.setCapitalize(this.fCapitalizeButton.getSelection(), this.fModel);
        }
        if (this.fControlIdButton != null) {
            this.fModel.setControlId(this.fControlIdButton.getSelection() ? "unformattedControls" : "formattedControls");
        }
        if (this.fWrapLabelButton != null) {
            this.fModel.addCustomProperty("add_label_component", this.fWrapLabelButton.getSelection() ? Boolean.TRUE : Boolean.FALSE);
        }
        super.okPressed();
    }

    protected void handleDepthChange(int depth) {
        try {
            SelectionEntryList normalizedSelections = (SelectionEntryList)this.fModel.getLocalProperty("normalizedSelections");
            if (normalizedSelections != null) {
                this.fModel.addCustomProperty(ICodeGenModel.DEPTH_LIMITED_KEY, Boolean.FALSE);
                ICodeGenModelFactory factory = this.fModel.getRoot().getEnclosedNode().getCodeGenModelFactory();
                factory.initializeModel(this.fModel, normalizedSelections);
                factory.initializeNodes(this.fModel);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void handleEvent(Event e) {
        if (e.widget == this.fSubmitButton) {
            this.fSubmitButtonText.setEnabled(this.fSubmitButton.getSelection());
            ((Label)this.fSubmitButtonText.getData()).setEnabled(this.fSubmitButton.getSelection());
        } else if (e.widget == this.fDeleteButton) {
            this.fDeleteButtonText.setEnabled(this.fDeleteButton.getSelection());
            ((Label)this.fDeleteButtonText.getData()).setEnabled(this.fDeleteButton.getSelection());
        }
    }
}

