/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedatamodel.impl.internal;

import com.ibm.etools.webtools.pagedatamodel.PageDataModelPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;

public class Debug {
    private static final String PREFIX = "[webtools.pagedatamodel] ";
    public static final int OK_DEBUG = 0;
    public static final int INFO_DEBUG = 1;
    public static final int WARNING_DEBUG = 2;
    public static final int ERROR_DEBUG = 3;
    public static final int OK_ALWAYS = 4;
    public static final int INFO_ALWAYS = 5;
    public static final int WARNING_ALWAYS = 6;
    public static final int ERROR_ALWAYS = 7;

    public static void trace(String message) {
        if (!PageDataModelPlugin.getDefault().isDebugging()) {
            return;
        }
        if (message == null) {
            return;
        }
        System.out.println("[webtools.pagedatamodel]  " + message);
    }

    public static void log(int level, String message) {
        if (message == null) {
            return;
        }
        message = "[webtools.pagedatamodel]  " + message;
        if (!(level != 0 && level != 1 && level != 2 && level != 3 || PageDataModelPlugin.getDefault().isDebugging())) {
            return;
        }
        int severity = 0;
        switch (level) {
            case 1: 
            case 5: {
                severity = 1;
                break;
            }
            case 2: 
            case 6: {
                severity = 2;
                break;
            }
            case 3: 
            case 7: {
                severity = 4;
            }
        }
        String pluginID = PageDataModelPlugin.getDefault().getBundle().getSymbolicName();
        Status StatusObj = new Status(severity, pluginID, severity, message, null);
        PageDataModelPlugin.getDefault().getLog().log((IStatus)StatusObj);
    }

    public static void alert(int level, String message, String reason, String details) {
        if (message == null) {
            return;
        }
        if (!(level != 0 && level != 1 && level != 2 && level != 3 || PageDataModelPlugin.getDefault().isDebugging())) {
            return;
        }
        int severity = 0;
        switch (level) {
            case 1: 
            case 5: {
                severity = 1;
                break;
            }
            case 2: 
            case 6: {
                severity = 2;
                break;
            }
            case 3: 
            case 7: {
                severity = 4;
            }
        }
        String pluginID = PageDataModelPlugin.getDefault().getBundle().getSymbolicName();
        MultiStatus multiStatus = new MultiStatus(pluginID, severity, reason, null);
        if (details != null) {
            Status StatusObj = new Status(severity, pluginID, severity, details, null);
            multiStatus.add((IStatus)StatusObj);
        }
        ErrorDialog.openError(null, (String)((String)PageDataModelPlugin.getDefault().getBundle().getHeaders().get("Bundle-Name")), (String)message, (IStatus)multiStatus);
    }
}

