/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedatamodel.impl;

import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.sse.api.ISSEPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.util.PageDataModelUtil;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class PageDataNodeAdapter
implements INodeAdapter {
    protected INodeAdapterFactory adapterFactory;
    private String adapterKey;
    private IPageDataNode pageDataNode;
    private IPageDataModel pageDataModel;

    public PageDataNodeAdapter(INodeAdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    public boolean isAdapterForType(Object type) {
        if (type instanceof String) {
            return ((String)type).equals(this.adapterKey);
        }
        return false;
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (eventType == 3) {
            if (oldValue instanceof IDOMNode) {
                PageDataModelUtil.handleRemove((IDOMNode)oldValue);
            }
        } else if (this.pageDataNode != null) {
            IPageDataNode originalNode = this.pageDataNode.copy();
            if (((ISSEPageDataNode)this.pageDataNode).refresh((IDOMNode)notifier, changedFeature, oldValue, newValue) && this.pageDataModel != null) {
                this.pageDataModel.getPageDataNotifier().firePageNodeChanged(originalNode, this.pageDataNode);
            }
        }
    }

    public IPageDataNode getPageDataNode() {
        return this.pageDataNode;
    }

    public void setPageDataNode(IPageDataNode pageDataNode) {
        if (pageDataNode != null) {
            this.pageDataNode = pageDataNode;
            if (this.pageDataModel == null) {
                this.retrievePageDataModel(pageDataNode);
            }
        }
    }

    private void retrievePageDataModel(IPageDataNode node) {
        this.pageDataModel = node.getPageDataModel();
    }

    public String getAdapterKey() {
        return this.adapterKey;
    }

    public IPageDataModel getPageDataModel() {
        return this.pageDataModel;
    }

    public void setAdapterKey(String adapterKey) {
        this.adapterKey = adapterKey;
    }

    public void setPageDataModel(IPageDataModel pageDataModel) {
        this.pageDataModel = pageDataModel;
    }
}

