/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedatamodel.databinding.api;

import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.SelectionEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SelectionEntryList
extends ArrayList {
    private static final long serialVersionUID = 1L;

    public SelectionEntryList() {
    }

    public SelectionEntryList(int initialCapacity) {
        super(initialCapacity);
    }

    public SelectionEntryList(Collection c) {
        super(c);
    }

    @Override
    public boolean add(Object o) {
        if (!(o instanceof SelectionEntry)) {
            throw new IllegalArgumentException();
        }
        return super.add(o);
    }

    public boolean contains(IPageDataNode node) {
        if (this.isEmpty()) {
            return false;
        }
        int i = 0;
        while (i < this.size()) {
            SelectionEntry one = (SelectionEntry)this.get(i);
            if (one.selectedNode == node) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int distanceOf(IPageDataNode node) {
        if (this.isEmpty()) {
            return -1;
        }
        int i = 0;
        while (i < this.size()) {
            SelectionEntry one = (SelectionEntry)this.get(i);
            if (one.selectedNode == node) {
                return one.distance;
            }
            ++i;
        }
        return -1;
    }

    public List getNodesOfDistance(int dist) {
        if (this.isEmpty()) {
            return null;
        }
        ArrayList<IPageDataNode> ret = null;
        int i = 0;
        while (i < this.size()) {
            SelectionEntry one = (SelectionEntry)this.get(i);
            if (one.distance == dist) {
                if (ret == null) {
                    ret = new ArrayList<IPageDataNode>(1);
                }
                ret.add(one.selectedNode);
            }
            ++i;
        }
        return ret;
    }

    public int getBaseline() {
        if (this.isEmpty()) {
            return -1;
        }
        int ret = -1;
        int i = 0;
        while (i < this.size()) {
            SelectionEntry one = (SelectionEntry)this.get(i);
            if (ret == -1 || ret > one.distance) {
                ret = one.distance;
            }
            ++i;
        }
        return ret;
    }
}

