/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedatamodel.databinding.api;

import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.CodeGenerationManager;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.Generator;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IBindingAttribute;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenModel;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.exceptions.NoAdapterFoundException;
import com.ibm.etools.webtools.pagedatamodel.databinding.exceptions.NoControlMapFoundException;
import com.ibm.etools.webtools.pagedatamodel.databinding.exceptions.NoGeneratorFoundException;
import com.ibm.etools.webtools.pagedatamodel.nls.ResourceHandler;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class CodeGenerationOperation
implements IRunnableWithProgress {
    private ICodeGenModel codeGenModel;
    private PrintWriter writer;

    public CodeGenerationOperation(ICodeGenModel config, PrintWriter writer) {
        this.codeGenModel = config;
        this.writer = writer;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        ICodeGenNode modelRoot = this.codeGenModel.getRoot();
        IPageDataNode root = modelRoot.getEnclosedNode();
        Object adapter = root.getAdapter(IBindingAttribute.ADAPTER_KEY);
        Exception e = null;
        if (adapter != null) {
            IBindingAttribute binding = (IBindingAttribute)adapter;
            String runtimeType = binding.getRuntimeType(root);
            if (runtimeType != null && !runtimeType.equals("")) {
                Generator gen = null;
                try {
                    monitor.subTask(ResourceHandler.Gen_Srch);
                    gen = CodeGenerationManager.getGeneratorForRT(this.codeGenModel.getPageType(), runtimeType, this.codeGenModel.getTarget().getWebModel().getComponent());
                }
                catch (NoControlMapFoundException ncme) {
                    e = ncme;
                }
                catch (ClassNotFoundException cnfe) {
                    e = cnfe;
                }
                if (gen != null) {
                    monitor.subTask(ResourceHandler.Gen_Perf);
                    this.writer.print(gen.perform(modelRoot));
                } else if (e == null) {
                    e = new NoGeneratorFoundException(runtimeType);
                }
            } else {
                e = new NoAdapterFoundException((Object)"Runtime Type", root);
            }
        } else {
            e = new NoAdapterFoundException(IBindingAttribute.ADAPTER_KEY, root);
        }
        if (e != null) {
            throw new InvocationTargetException(e);
        }
    }
}

