/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedatamodel.databinding.api;

import com.ibm.etools.webtools.pagedatamodel.api.IGenControlPanel;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.Generator;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IGenerationTemplate;
import com.ibm.etools.webtools.pagedatamodel.databinding.exceptions.NoControlMapFoundException;
import com.ibm.etools.webtools.pagedatamodel.impl.internal.CodeGenRegistryReader;
import java.util.List;
import org.eclipse.jdt.core.Signature;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class CodeGenerationManager {
    public static final short INPUT = 1;
    public static final short OUTPUT = 2;
    public static final short INPUT_AND_OUTPUT = 0;

    public static IGenControlPanel getControlMap(String pageType, IVirtualComponent vc) throws NoControlMapFoundException {
        IGenControlPanel map = CodeGenRegistryReader.getControlMapForPageType(pageType, vc);
        if (map == null) {
            throw new NoControlMapFoundException(pageType);
        }
        return map;
    }

    public static IGenControlPanel getControlMap(String pageType) throws NoControlMapFoundException {
        IGenControlPanel map = CodeGenRegistryReader.getControlMapForPageType(pageType);
        if (map == null) {
            throw new NoControlMapFoundException(pageType);
        }
        return map;
    }

    public static String getDefaultControlId(String pageType) {
        IGenControlPanel map = CodeGenerationManager.getControlMap(pageType);
        return map.getDefaultControlId();
    }

    public static String getDefaultControlLable(String pageType) {
        IGenControlPanel map = CodeGenerationManager.getControlMap(pageType);
        return map.getDefaultControlLabel();
    }

    public static IGenerationTemplate getDefaultControlTemplate(String pageType) {
        IGenControlPanel map = CodeGenerationManager.getControlMap(pageType);
        return map.getDefaultControlTemplate();
    }

    public static Generator getDefaultGenerator(String pageType, IVirtualComponent vc) {
        IGenControlPanel map = CodeGenerationManager.getControlMap(pageType, vc);
        return map.getDefaultGenerator().getGenerator();
    }

    public static List getControlsForRT(String pageType, String runtimeType, short io, IVirtualComponent vc) throws ClassNotFoundException {
        IGenControlPanel map = CodeGenerationManager.getControlMap(pageType, vc);
        return map.getControlsForRT(runtimeType, io, vc);
    }

    public static Generator getGeneratorForRT(String pageType, String runtimeType, IVirtualComponent vc) throws ClassNotFoundException {
        IGenControlPanel map = CodeGenerationManager.getControlMap(pageType, vc);
        String rtTypeErasure = Signature.toString((String)Signature.getTypeErasure((String)Signature.createTypeSignature((String)runtimeType, (boolean)true)));
        return map.getGeneratorForRT(rtTypeErasure, vc);
    }

    public static String getLabelForControl(String pageType, String controlId) {
        IGenControlPanel map = CodeGenerationManager.getControlMap(pageType);
        return map.getLabelForControl(controlId);
    }

    public static IGenerationTemplate getTemplateForControl(String pageType, String controlId) {
        IGenControlPanel map = CodeGenerationManager.getControlMap(pageType);
        return map.getTemplateForControl(controlId);
    }

    public static boolean isRTExplicitlyDefined(String pageType, String runtimeType, IVirtualComponent vc) {
        return CodeGenerationManager.getControlMap(pageType, vc).isRTExplicitlyDefined(runtimeType);
    }
}

