/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedatamodel.databinding;

import com.ibm.etools.webtools.pagedatamodel.PageDataModelPlugin;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.CodeGenModelFactory;
import com.ibm.etools.webtools.pagedatamodel.databinding.ICodeGenModelFactory;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.CodeGenerationManager;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IBindingAttribute;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenModel;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.SelectionEntry;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.SelectionEntryList;
import com.ibm.etools.webtools.pagedatamodel.databinding.internal.CodeGenModel;
import com.ibm.etools.webtools.pagedatamodel.databinding.internal.CodeGenNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.internal.ControlsMap;
import com.ibm.etools.webtools.pagedatamodel.util.PageDataModelUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.IDialogSettings;

public class CodeGenUtil {
    public static boolean isTopModel(ICodeGenModel model) {
        boolean isTop = true;
        if (model != null) {
            ICodeGenModel previous = model.getPreviousModel();
            if (previous != null && previous != model) {
                isTop = false;
            } else {
                ICodeGenModel rootsModel;
                ICodeGenNode root = model.getRoot();
                if (root != null && (rootsModel = root.getCodeGenModel()) != null && rootsModel != model) {
                    isTop = false;
                }
            }
        }
        return isTop;
    }

    public static boolean hasPreviousModel(ICodeGenModel model) {
        boolean hasPreviousModel = false;
        if (model != null) {
            ICodeGenModel topModel;
            boolean bl = hasPreviousModel = model.getPreviousModel() != null;
            if (!hasPreviousModel && (topModel = CodeGenUtil.getTopModel(model)) != null) {
                hasPreviousModel = model.getPreviousModel() != null;
            }
        }
        return hasPreviousModel;
    }

    private static ICodeGenModel getTopModel(ICodeGenModel model) {
        ICodeGenNode cgRoot;
        ICodeGenModel rootModel = null;
        if (model != null && (cgRoot = model.getRoot()) != null && (rootModel = cgRoot.getCodeGenModel()) != model) {
            rootModel = CodeGenUtil.getTopModel(rootModel);
        }
        return rootModel;
    }

    public static void setCapitalize(boolean capitalize, ICodeGenModel model) {
        model.setCapitalizeLabel(capitalize);
        List nodes = model.getCodeGenNodes();
        if (nodes != null) {
            for (ICodeGenNode cgNode : nodes) {
                if (capitalize) {
                    cgNode.setLabel(CodeGenUtil.applyCapitalize(capitalize, cgNode.getLabel()));
                    continue;
                }
                String label = cgNode.getLabel();
                ICodeGenModelFactory factory = model.getRoot().getEnclosedNode().getCodeGenModelFactory();
                String defaultLabel = factory.getLabel(cgNode, model.isUseColon(), model.isCapitalizeLabel());
                if (defaultLabel == null || label == null || label.length() <= 0) continue;
                if (defaultLabel.equalsIgnoreCase(label)) {
                    cgNode.setLabel(defaultLabel);
                    continue;
                }
                if (!Character.isUpperCase(label.charAt(0))) continue;
                if (label.length() == 1) {
                    cgNode.setLabel(label.toLowerCase());
                    continue;
                }
                String sub = label.substring(1, label.length());
                if (!sub.equals(sub.toLowerCase())) continue;
                cgNode.setLabel(label.toLowerCase());
            }
        }
    }

    public static String applyCapitalize(boolean capitalize, String label) {
        if (label != null && label.length() > 0 && capitalize) {
            label = label.equals(label.toUpperCase()) || label.equals(label.toLowerCase()) ? String.valueOf(label.substring(0, 1).toUpperCase()) + (label.length() > 1 ? label.substring(1, label.length()).toLowerCase() : "") : String.valueOf(label.substring(0, 1).toUpperCase()) + (label.length() > 1 ? label.substring(1, label.length()) : "");
        }
        return label;
    }

    public static void setUseColon(boolean useColon, ICodeGenModel model) {
        model.setUseColon(useColon);
        List nodes = model.getCodeGenNodes();
        if (nodes != null) {
            for (ICodeGenNode node : nodes) {
                String label = node.getLabel();
                if (label == null || label.length() <= 0) continue;
                if (useColon && !label.endsWith(":")) {
                    node.setLabel(String.valueOf(label) + ":");
                    continue;
                }
                if (useColon || !label.endsWith(":")) continue;
                node.setLabel(label.substring(0, label.length() - 1));
            }
        }
    }

    public static List getControlsForRT(IPageDataNode node, ICodeGenModel model) {
        int controlType = model.getControlType();
        short io = controlType == 1 ? (short)0 : (controlType == 2 ? (short)1 : 2);
        return CodeGenUtil.getControlsForRT(node, model, io);
    }

    public static List getControlsForRT(IPageDataNode node, ICodeGenModel model, short io) {
        String runtime;
        List controls;
        ControlsMap controlsMap;
        ControlsMap controlsMap2 = controlsMap = model instanceof CodeGenModel ? CodeGenUtil.getControlsMap(node, ((CodeGenModel)model).getRuntimeToControlsMap()) : null;
        int controlType = io == 0 ? 1 : (io == 1 ? 2 : 0);
        List list = controls = controlsMap != null ? controlsMap.getControls(controlType) : null;
        if (controls == null && (runtime = CodeGenUtil.getRuntime(node)) != null) {
            try {
                controls = CodeGenerationManager.getControlsForRT(model.getPageType(), runtime, io, model.getTarget().getWebModel().getComponent());
                if (controlsMap != null) {
                    controlsMap.setControls(controlType, controls);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return controls;
    }

    public static String getLabelForControl(String controlId, ICodeGenModel model) {
        if ("embedded.form".equals(controlId)) {
            return "";
        }
        if (model != null) {
            if (model instanceof CodeGenModel) {
                HashMap map = ((CodeGenModel)model).getControlIdToLabelMap();
                String label = (String)map.get(controlId);
                if (label == null) {
                    label = CodeGenerationManager.getLabelForControl(model.getPageType(), controlId);
                    map.put(controlId, label);
                }
                return label;
            }
            return CodeGenerationManager.getLabelForControl(model.getPageType(), controlId);
        }
        return "";
    }

    private static ControlsMap getControlsMap(IPageDataNode node, HashMap map) {
        String runtime = CodeGenUtil.getRuntime(node);
        ControlsMap controlsMap = (ControlsMap)map.get(runtime);
        if (controlsMap == null) {
            controlsMap = new ControlsMap();
            map.put(runtime, controlsMap);
        }
        return controlsMap;
    }

    public static String getRuntime(IPageDataNode node) {
        String rt = ((IBindingAttribute)node.getAdapter(IBindingAttribute.ADAPTER_KEY)).getRuntimeType(node);
        return rt;
    }

    public static String getElementRuntime(IPageDataNode node) {
        int genericEndIndex;
        String runtimeType = CodeGenUtil.getRuntime(node);
        int index = runtimeType.indexOf(91, (genericEndIndex = runtimeType.lastIndexOf(62)) + 1);
        return index > 0 ? runtimeType.substring(0, index) : runtimeType;
    }

    public static ICodeGenNode createCodeGenNode(IPageDataNode pdNode, ICodeGenModel model, short ioType) {
        CodeGenNode cgNode;
        List controls = CodeGenModelFactory.getControls(cgNode = new CodeGenNode(pdNode, model), ioType);
        cgNode.setControlId(controls != null ? (String)controls.get(0) : CodeGenerationManager.getDefaultControlId(model.getPageType()));
        if (cgNode.getLabel() == null) {
            ICodeGenModelFactory factory = pdNode.getCodeGenModelFactory();
            cgNode.setLabel(factory.getLabel(cgNode, model.isUseColon(), model.isCapitalizeLabel()));
        }
        return cgNode;
    }

    public static boolean isModelContainedInList(ICodeGenModel model) {
        boolean contained = false;
        if (model != null) {
            if (model.isList()) {
                contained = true;
            } else {
                ICodeGenModel rootModel;
                ICodeGenNode root = model.getRoot();
                if (root != null && (rootModel = root.getCodeGenModel()) != null && rootModel != model) {
                    contained = CodeGenUtil.isModelContainedInList(rootModel);
                }
            }
        }
        return contained;
    }

    public static void initializeControlTypes(ICodeGenModel model) {
        if (model != null) {
            List nodes = model.getCodeGenNodes();
            ICodeGenModelFactory factory = model.getRoot().getEnclosedNode().getCodeGenModelFactory();
            if (nodes != null) {
                for (ICodeGenNode cgNode : nodes) {
                    factory.initializeControlType(cgNode, model);
                }
            }
        }
    }

    public static SelectionEntryList normalizeSelection(IPageDataNode[] nodes) {
        List tmp;
        if (nodes == null) {
            return null;
        }
        SelectionEntryList theList = new SelectionEntryList(1);
        int baseline = -1;
        int i = 0;
        while (i < nodes.length) {
            IPageDataNode temp = nodes[i];
            int dist = 0;
            while (!PageDataModelUtil.isComponentNode(temp)) {
                ++dist;
                temp = temp.getParent();
            }
            if (baseline == -1 || baseline > dist) {
                baseline = dist;
            }
            theList.add(new SelectionEntry(nodes[i], dist));
            ++i;
        }
        SelectionEntryList tempList = null;
        int i2 = 0;
        while (i2 < theList.size()) {
            SelectionEntry entry = (SelectionEntry)theList.get(i2);
            int distance = entry.distance;
            if (distance > baseline) {
                IPageDataNode node = entry.selectedNode;
                while (distance-- > baseline) {
                    boolean existing = theList.contains(node.getParent());
                    if (!existing && tempList != null) {
                        existing = tempList.contains(node.getParent());
                    }
                    if (!existing) {
                        if (tempList == null) {
                            tempList = new SelectionEntryList(1);
                        }
                        tempList.add(new SelectionEntry(node.getParent(), distance));
                    }
                    node = node.getParent();
                }
            }
            ++i2;
        }
        if (tempList != null) {
            theList.addAll(tempList);
        }
        if ((tmp = theList.getNodesOfDistance(baseline)) != null && tmp.size() > 1) {
            IPageDataNode commonParent = CodeGenUtil.findCommonParent(tmp);
            int dist = 0;
            Iterator iter = tmp.iterator();
            block4: while (iter.hasNext()) {
                IPageDataNode node = ((IPageDataNode)iter.next()).getParent();
                dist = 0;
                while (node != null) {
                    ++dist;
                    if (node == commonParent) continue block4;
                    if (!theList.contains(node)) {
                        theList.add(new SelectionEntry(node, baseline - dist));
                    }
                    node = node.getParent();
                }
            }
            theList.add(new SelectionEntry(commonParent, baseline - dist));
        }
        Comparator comp = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((SelectionEntry)o1).distance - ((SelectionEntry)o2).distance;
            }
        };
        Collections.sort(theList, comp);
        return theList;
    }

    public static IPageDataNode findCommonParent(IPageDataNode[] nodes) {
        IPageDataNode pdRoot = nodes[0];
        while (pdRoot != null) {
            boolean allAncestors = true;
            int i = 0;
            while (i < nodes.length) {
                if (!CodeGenUtil.isAncestor(pdRoot, nodes[i])) {
                    pdRoot = pdRoot.getParent();
                    allAncestors = false;
                    break;
                }
                ++i;
            }
            if (allAncestors) break;
        }
        if (pdRoot == null) {
            throw new IllegalArgumentException();
        }
        EList children = pdRoot.getChildren();
        if (children == null || children.size() == 0) {
            pdRoot = pdRoot.getParent();
        }
        return pdRoot;
    }

    public static IPageDataNode findCommonParent(List nodes) {
        IPageDataNode pdRoot = (IPageDataNode)nodes.get(0);
        while (pdRoot != null) {
            boolean allAncestors = true;
            for (IPageDataNode node : nodes) {
                if (CodeGenUtil.isAncestor(pdRoot, node)) continue;
                pdRoot = pdRoot.getParent();
                allAncestors = false;
                break;
            }
            if (allAncestors) break;
        }
        if (pdRoot == null) {
            throw new IllegalArgumentException();
        }
        EList children = pdRoot.getChildren();
        if (children == null || children.size() == 0) {
            pdRoot = pdRoot.getParent();
        }
        return pdRoot;
    }

    public static List getChildren(IPageDataNode pdNode, SelectionEntryList normalizedSelections) {
        EList children = pdNode.getChildren();
        if (children != null) {
            List nodesOfNextLevel;
            int dist = normalizedSelections.distanceOf(pdNode);
            ArrayList pickedChildren = null;
            if (dist >= 0 && (nodesOfNextLevel = normalizedSelections.getNodesOfDistance(dist + 1)) != null) {
                int i = 0;
                while (i < nodesOfNextLevel.size()) {
                    if (children.contains(nodesOfNextLevel.get(i))) {
                        if (pickedChildren == null) {
                            pickedChildren = new ArrayList(1);
                        }
                        pickedChildren.add(nodesOfNextLevel.get(i));
                    }
                    ++i;
                }
            }
            if (pickedChildren != null) {
                children = pickedChildren;
            }
        }
        return children;
    }

    public static IPageDataNode getRoot(SelectionEntryList normalizedSelections, IPageDataNode desiredRoot) {
        IPageDataNode pdRoot = null;
        int distance = 1;
        if (desiredRoot != null) {
            pdRoot = desiredRoot;
        } else if (normalizedSelections != null) {
            SelectionEntry entry = (SelectionEntry)normalizedSelections.get(0);
            pdRoot = entry.selectedNode;
            distance = entry.distance;
        }
        if (pdRoot == null) {
            throw new IllegalArgumentException();
        }
        EList children = pdRoot.getChildren();
        if (!(distance == 0 || children != null && children.size() != 0 || ((IBindingAttribute)pdRoot.getAdapter(IBindingAttribute.ADAPTER_KEY)).isArrayType(pdRoot) || pdRoot.getDataCategory().equals("Action"))) {
            pdRoot = pdRoot.getParent();
        }
        return pdRoot;
    }

    private static boolean isAncestor(IPageDataNode desiredRoot, IPageDataNode child) {
        while (child != null) {
            if (child == desiredRoot) break;
            child = child.getParent();
        }
        return child != null;
    }

    public static void initDialogSettings(ICodeGenModel model) {
        IDialogSettings settings = PageDataModelPlugin.getDefault().getDialogSettings();
        if (settings.get("ALIGNMENT") != null) {
            model.setAlignment(settings.getInt("ALIGNMENT"));
        }
        if (settings.get("CAPITALIZE") != null) {
            model.setCapitalizeLabel(settings.getBoolean("CAPITALIZE"));
        }
        if (settings.get("add_label_component") != null) {
            model.addCustomProperty("add_label_component", settings.getBoolean("add_label_component") ? Boolean.TRUE : Boolean.FALSE);
        }
        if (model.isList()) {
            model.setCreateDeleteButton(false);
            model.setCreateSubmitButton(false);
        } else {
            if (settings.get("CONTROL_TYPE") != null) {
                model.setControlType(settings.getInt("CONTROL_TYPE"));
            }
            if (settings.get("CONTROL_ID") != null) {
                model.setControlId(settings.get("CONTROL_ID"));
            }
            if (settings.get("COLON") != null) {
                model.setUseColon(settings.getBoolean("COLON"));
            }
            model.setCreateSubmitButton(model.getControlType() != 0 && (settings.get("SUBMIT_BUTTON_CREATE") == null || settings.getBoolean("SUBMIT_BUTTON_CREATE")));
            model.setCreateDeleteButton(model.getControlType() == 1 && (settings.get("DELETE_BUTTON_CREATE") == null || settings.getBoolean("DELETE_BUTTON_CREATE")));
            if (settings.get("VALIDATION") != null) {
                model.setGenValidation(settings.getBoolean("VALIDATION"));
            }
            if (settings.get("SUBMIT_BUTTON_LABEL") != null) {
                model.setSubmitButtonLabel(settings.get("SUBMIT_BUTTON_LABEL"));
            }
            if (settings.get("DELETE_BUTTON_LABEL") != null) {
                model.setDeleteButtonLabel(settings.get("DELETE_BUTTON_LABEL"));
            }
        }
    }

    public static void saveDialogSettings(ICodeGenModel model) {
        IDialogSettings settings = PageDataModelPlugin.getDefault().getDialogSettings();
        if (!model.isList()) {
            int controlType = model.getControlType();
            model.setCreateDeleteButton(model.isCreateDeleteButton() && controlType == 1);
            model.setCreateSubmitButton(model.isCreateSubmitButton() && controlType != 0);
            model.setGenValidation(model.isGenValidation() && controlType != 0);
            settings.put("CONTROL_TYPE", controlType);
            settings.put("COLON", model.isUseColon());
            if (controlType != 0) {
                settings.put("SUBMIT_BUTTON_CREATE", model.isCreateSubmitButton());
            }
            if (controlType == 1) {
                settings.put("DELETE_BUTTON_CREATE", model.isCreateDeleteButton());
            }
            settings.put("VALIDATION", model.isGenValidation());
            if (model.getSubmitButtonLabel() != null) {
                settings.put("SUBMIT_BUTTON_LABEL", model.getSubmitButtonLabel());
            }
            if (model.getDeleteButtonLabel() != null) {
                settings.put("DELETE_BUTTON_LABEL", model.getDeleteButtonLabel());
            }
            if (model.getControlId() != null) {
                settings.put("CONTROL_ID", model.getControlId());
            }
        }
        settings.put("add_label_component", Boolean.TRUE == model.getCustomProperty("add_label_component"));
        settings.put("CAPITALIZE", model.isCapitalizeLabel());
        settings.put("ALIGNMENT", model.getAlignment());
    }
}

