/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedatamodel.databinding;

import com.ibm.etools.webtools.model.ModelManager;
import com.ibm.etools.webtools.model.WebModelCreationException;
import com.ibm.etools.webtools.model.api.JSP;
import com.ibm.etools.webtools.pagedatamodel.PageDataModelPlugin;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.CodeGenUtil;
import com.ibm.etools.webtools.pagedatamodel.databinding.ICodeGenModelFactory;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.CodeGenerationManager;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IBindingAttribute;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenModel;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.SelectionEntry;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.SelectionEntryList;
import com.ibm.etools.webtools.pagedatamodel.databinding.exceptions.NoBindingAttributeFoundException;
import com.ibm.etools.webtools.pagedatamodel.databinding.exceptions.UserCancelledException;
import com.ibm.etools.webtools.pagedatamodel.databinding.internal.CodeGenModel;
import com.ibm.etools.webtools.pagedatamodel.databinding.internal.CodeGenNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.internal.ElementCGN;
import com.ibm.etools.webtools.pagedatamodel.nls.ResourceHandler;
import com.ibm.etools.webtools.pagedatamodel.util.PageDataModelUtil;
import com.ibm.etools.webtools.pagedatamodel.wizards.InsertData_Wizard;
import com.ibm.etools.webtools.pagedatamodel.wizards.OptionsDialog;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class CodeGenModelFactory
implements ICodeGenModelFactory {
    public static final String EMBEDDED_FORM_CONTROL_ID = "embedded.form";
    public static final String EMBEDDED_FORM_CONTROL_LABEL = "";
    private static final int WIZARD_SIZE = 550;
    public static final String NORMALIZED_SELECTIONS = "normalizedSelections";

    public static List getControls(ICodeGenNode cgNode, short io) {
        return cgNode.getEnclosedNode().getCodeGenModelFactory().getAvailableControls(cgNode, io);
    }

    public static short getIO(int controlType) {
        return (short)(controlType == 1 ? 0 : (controlType == 2 ? 1 : 2));
    }

    public static List getControls(ICodeGenNode cgNode) {
        int controlType = cgNode.getCodeGenModel().getControlType();
        short io = CodeGenModelFactory.getIO(controlType);
        return CodeGenModelFactory.getControls(cgNode, io);
    }

    @Override
    public List getAvailableControls(ICodeGenNode cgNode, short io) {
        return cgNode != null ? cgNode.getAvailableControls(io) : null;
    }

    public static ICodeGenModel createCodeGenModel(IPageDataNode[] nodes, IProject project, String pageType) throws CoreException, UserCancelledException {
        return CodeGenModelFactory.createCodeGenModel(nodes, project, pageType, false);
    }

    public static ICodeGenModel createCodeGenModel(IPageDataNode[] nodes, IProject project, String pageType, boolean suppressWizard) throws CoreException, UserCancelledException {
        return CodeGenModelFactory.createCodeGenModel(nodes, null, project, pageType, suppressWizard);
    }

    public static void configureInWizard(ICodeGenModel model) throws UserCancelledException {
        CodeGenModelFactory.configureInWizard(model, -1);
    }

    public static void configureInWizard(ICodeGenModel model, boolean forceObjectWizard) throws UserCancelledException {
        boolean modelIsList = model.isList();
        boolean rootIsList = model.getRoot().isListNode();
        if (forceObjectWizard) {
            List cgNodes;
            model.setIsList(false);
            model.getRoot().setIsListNode(false);
            model.getRoot().setChildCodeGenModel(null);
            if (modelIsList && (cgNodes = model.getCodeGenNodes()) != null) {
                ICodeGenModelFactory factory = model.getRoot().getEnclosedNode().getCodeGenModelFactory();
                Iterator iter = cgNodes.iterator();
                while (iter.hasNext()) {
                    factory.initializeControlType((ICodeGenNode)iter.next(), model);
                }
            }
        }
        CodeGenModelFactory.configureInWizard(model, -1);
        model.setIsList(modelIsList);
        model.getRoot().setIsListNode(rootIsList);
    }

    public static void configureInWizard(ICodeGenModel model, int x) throws UserCancelledException {
        IWizard wizard = null;
        if (model.getCodeGenNodes() != null && model.getCodeGenNodes().size() > 0) {
            wizard = model.getRoot().getEnclosedNode().getCodeGenModelFactory().getWizard(model);
        } else {
            ICodeGenModel nextModel = model.getNextModel();
            if (nextModel != null && nextModel.getCodeGenNodes() != null && nextModel.getCodeGenNodes().size() > 0) {
                wizard = nextModel.getRoot().getEnclosedNode().getCodeGenModelFactory().getWizard(nextModel);
            }
        }
        if (wizard != null) {
            WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), wizard){

                protected void setShellStyle(int newShellStyle) {
                    super.setShellStyle(newShellStyle | 0x10);
                }
            };
            dialog.create();
            dialog.getShell().setSize(Math.max(550, dialog.getShell().getSize().x), 550);
            if (x > -1) {
                dialog.getShell().setLocation(x, dialog.getShell().getLocation().y);
            }
            if (dialog.open() == 1) {
                throw new UserCancelledException(ResourceHandler._WARN_cancelled);
            }
        }
        if (CodeGenUtil.isTopModel(model)) {
            CodeGenModelFactory.finalizeModel(model);
        }
    }

    @Override
    public IWizard getWizard(ICodeGenModel model) {
        return new InsertData_Wizard(model);
    }

    public static ICodeGenModel createCodeGenModel(IPageDataNode[] nodes, IPageDataNode desiredRoot, IProject project, String pageType, boolean suppressWizard) throws CoreException, IllegalArgumentException, UserCancelledException {
        IFile file = desiredRoot != null ? desiredRoot.getPageDataModel().getResource() : nodes[0].getPageDataModel().getResource();
        ICodeGenModel model = null;
        try {
            model = CodeGenModelFactory.createCodeGenModel(nodes, desiredRoot, file, pageType, suppressWizard);
        }
        catch (WebModelCreationException e) {
            e.printStackTrace();
        }
        return model;
    }

    public static ICodeGenModel createCodeGenModel(IPageDataNode root, JSP jsp, String pageType) throws CoreException, IllegalArgumentException, UserCancelledException {
        return CodeGenModelFactory.createCodeGenModel(new IPageDataNode[]{root}, null, jsp, pageType, false);
    }

    public static ICodeGenModel createCodeGenModel(IPageDataNode root, JSP jsp, String pageType, boolean suppressWizard) throws CoreException, IllegalArgumentException, UserCancelledException {
        return CodeGenModelFactory.createCodeGenModel(new IPageDataNode[]{root}, null, jsp, pageType, suppressWizard);
    }

    public static ICodeGenModel createCodeGenModel(IPageDataNode[] nodes, JSP jsp, String pageType, boolean suppressWizard) throws CoreException, IllegalArgumentException, UserCancelledException {
        return CodeGenModelFactory.createCodeGenModel(nodes, null, jsp, pageType, suppressWizard);
    }

    public static ICodeGenModel createCodeGenModel(final IPageDataNode[] nodes, final IPageDataNode desiredRoot, final JSP jsp, final String pageType, final boolean suppressWizard) throws CoreException, IllegalArgumentException, UserCancelledException {
        final Exception[] exceptionHolder = new Exception[1];
        final ICodeGenModel[] modelHolder = new ICodeGenModel[1];
        Runnable busyRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    IPageDataNode tempRoot = desiredRoot != null ? desiredRoot : nodes[0];
                    modelHolder[0] = tempRoot.getCodeGenModelFactory().createInitializedModel(nodes, desiredRoot, jsp, pageType, suppressWizard);
                }
                catch (Exception e) {
                    exceptionHolder[0] = new InvocationTargetException(e);
                }
            }
        };
        BusyIndicator.showWhile(null, (Runnable)busyRunnable);
        if (exceptionHolder[0] != null) {
            Throwable throwable = ((InvocationTargetException)exceptionHolder[0]).getCause();
            if (throwable instanceof CoreException) {
                throw (CoreException)throwable;
            }
            if (throwable instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)throwable;
            }
            if (throwable instanceof UserCancelledException) {
                throw (UserCancelledException)throwable;
            }
            IllegalArgumentException e = new IllegalArgumentException();
            e.initCause(exceptionHolder[0]);
            throw e;
        }
        return modelHolder[0];
    }

    public static ICodeGenModel createCodeGenModel(IPageDataNode[] nodes, IPageDataNode desiredRoot, IFile file, String pageType, boolean suppressWizard) throws CoreException, IllegalArgumentException, UserCancelledException, WebModelCreationException {
        return CodeGenModelFactory.createCodeGenModel(nodes, desiredRoot, ModelManager.getModel((IResource)file).getJSP(file), pageType, suppressWizard);
    }

    public static ICodeGenModel createCodeGenModel(IPageDataNode root, IProject project, String pageType) throws CoreException, IllegalArgumentException, UserCancelledException {
        return CodeGenModelFactory.createCodeGenModel(new IPageDataNode[]{root}, project, pageType);
    }

    public static ICodeGenModel createCodeGenModel(IPageDataNode root, IProject project, String pageType, boolean suppressWizard) throws CoreException, IllegalArgumentException, UserCancelledException {
        return CodeGenModelFactory.createCodeGenModel(new IPageDataNode[]{root}, project, pageType, suppressWizard);
    }

    public static ICodeGenModel createCodeGenModel(IPageDataNode[] nodes, IPageDataNode desiredRoot, IProject project, String pageType) throws CoreException, IllegalArgumentException, UserCancelledException {
        return CodeGenModelFactory.createCodeGenModel(nodes, desiredRoot, project, pageType, false);
    }

    @Override
    public SelectionEntryList normalizeSelection(IPageDataNode[] nodes) {
        if (nodes == null) {
            return null;
        }
        SelectionEntryList theList = new SelectionEntryList(1);
        int baseline = -1;
        int i = 0;
        while (i < nodes.length) {
            IPageDataNode temp = nodes[i];
            if (!this.shouldIgnore(temp)) {
                int dist = 0;
                while (!this.isTopLevelNode(temp)) {
                    ++dist;
                    temp = temp.getParent();
                }
                if (baseline == -1 || baseline > dist) {
                    baseline = dist;
                }
                theList.add(new SelectionEntry(nodes[i], dist));
            }
            ++i;
        }
        this.processNormalizedList(theList, baseline);
        return theList;
    }

    protected boolean shouldIgnore(IPageDataNode pdNode) {
        return false;
    }

    protected boolean isTopLevelNode(IPageDataNode pdNode) {
        return PageDataModelUtil.isComponentNode(pdNode);
    }

    protected void processNormalizedList(SelectionEntryList theList, int baseline) {
        List tmp;
        SelectionEntryList tempList = null;
        int i = 0;
        while (i < theList.size()) {
            SelectionEntry entry = (SelectionEntry)theList.get(i);
            int distance = entry.distance;
            if (distance > baseline) {
                IPageDataNode node = entry.selectedNode;
                while (distance-- > baseline) {
                    boolean existing = theList.contains(node.getParent());
                    if (!existing && tempList != null) {
                        existing = tempList.contains(node.getParent());
                    }
                    if (!existing) {
                        if (tempList == null) {
                            tempList = new SelectionEntryList(1);
                        }
                        tempList.add(new SelectionEntry(node.getParent(), distance));
                    }
                    node = node.getParent();
                }
            }
            ++i;
        }
        if (tempList != null) {
            theList.addAll(tempList);
        }
        if ((tmp = theList.getNodesOfDistance(baseline)) != null && tmp.size() > 1) {
            IPageDataNode commonParent = CodeGenUtil.findCommonParent(tmp);
            int dist = 0;
            Iterator iter = tmp.iterator();
            block2: while (iter.hasNext()) {
                IPageDataNode node = ((IPageDataNode)iter.next()).getParent();
                dist = 0;
                while (node != null) {
                    ++dist;
                    if (node == commonParent) continue block2;
                    if (!theList.contains(node)) {
                        theList.add(new SelectionEntry(node, baseline - dist));
                    }
                    node = node.getParent();
                }
            }
            theList.add(new SelectionEntry(commonParent, baseline -= dist));
        }
        SelectionEntryList candidateList = new SelectionEntryList(1);
        for (SelectionEntry entry : theList) {
            IPageDataNode candidate = entry.selectedNode.getParent();
            int distance = entry.distance;
            while (candidate != null && distance-- > baseline) {
                if (!theList.contains(candidate) && !candidateList.contains(candidate)) {
                    candidateList.add(new SelectionEntry(candidate, distance));
                }
                candidate = candidate.getParent();
            }
        }
        theList.addAll(candidateList);
        candidateList = new SelectionEntryList(1);
        IPageDataNode candidate = ((IPageDataNode)theList.getNodesOfDistance(baseline).get(0)).getParent();
        int distance = baseline;
        while (candidate != null && distance-- > 0) {
            candidateList.add(new SelectionEntry(candidate, distance));
            if (this.isListType(candidate)) {
                theList.addAll(candidateList);
                candidateList = new SelectionEntryList(1);
            }
            candidate = candidate.getParent();
        }
        Comparator comp = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((SelectionEntry)o1).distance - ((SelectionEntry)o2).distance;
            }
        };
        Collections.sort(theList, comp);
    }

    @Override
    public ICodeGenModel createInitializedModel(IPageDataNode[] nodes, IPageDataNode desiredRoot, IProject project, String pageType, boolean suppressWizard) throws CoreException, UserCancelledException {
        IFile file = desiredRoot != null ? desiredRoot.getPageDataModel().getResource() : nodes[0].getPageDataModel().getResource();
        JSP jsp = null;
        try {
            jsp = ModelManager.getModel((IResource)file).getJSP(file);
        }
        catch (WebModelCreationException e) {
            e.printStackTrace();
        }
        return this.createInitializedModel(nodes, desiredRoot, jsp, pageType, suppressWizard);
    }

    @Override
    public ICodeGenModel createInitializedModel(IPageDataNode[] nodes, IPageDataNode desiredRoot, JSP jsp, String pageType, boolean suppressWizard) throws CoreException, UserCancelledException {
        SelectionEntryList normalizedSelections = this.normalizeSelection(nodes);
        IPageDataNode pdRoot = this.getRoot(normalizedSelections, desiredRoot);
        ICodeGenNode cgRoot = this.createCodeGenNode(pdRoot, null);
        ICodeGenModel model = this.createModel(cgRoot, jsp, pageType);
        cgRoot.setCodeGenModel(model);
        model.addLocalProperty(NORMALIZED_SELECTIONS, normalizedSelections);
        this.initDialogSettings(model);
        this.initializeModel(model, normalizedSelections);
        this.initializeNodes(model);
        if (!suppressWizard) {
            CodeGenModelFactory.configureInWizard(model);
        }
        return model;
    }

    protected IPageDataNode getRoot(SelectionEntryList normalizedSelections, IPageDataNode desiredRoot) {
        IPageDataNode pdRoot = null;
        if (desiredRoot != null) {
            pdRoot = desiredRoot;
        } else if (normalizedSelections != null) {
            SelectionEntry entry = (SelectionEntry)normalizedSelections.get(0);
            pdRoot = entry.selectedNode;
        }
        if (pdRoot == null) {
            throw new IllegalArgumentException();
        }
        EList children = pdRoot.getChildren();
        if (!(children != null && children.size() != 0 || this.isTopLevelNode(pdRoot) || ((IBindingAttribute)pdRoot.getAdapter(IBindingAttribute.ADAPTER_KEY)).isArrayType(pdRoot) || pdRoot.getDataCategory().equals("Action"))) {
            pdRoot = pdRoot.getParent();
        }
        return pdRoot;
    }

    @Override
    public void initializeModel(final ICodeGenModel model, final SelectionEntryList normalizedSelections) throws CoreException {
        final Exception[] exceptionHolder = new Exception[1];
        Runnable busyRunnable = new Runnable(){

            @Override
            public void run() {
                CodeGenModelFactory.getControls(model.getRoot());
                model.setCodeGenNodes(null);
                if (normalizedSelections != null) {
                    ArrayList<ICodeGenNode> queue = new ArrayList<ICodeGenNode>(1);
                    IPageDataNode firstNode = ((SelectionEntry)normalizedSelections.get((int)0)).selectedNode;
                    if (model.getRoot().getEnclosedNode() != firstNode) {
                        ICodeGenNode cgNode = CodeGenModelFactory.this.createCodeGenNode(firstNode, model);
                        cgNode.setIsListNode(CodeGenModelFactory.this.isListType(cgNode));
                        queue.add(cgNode);
                    } else {
                        queue.add(model.getRoot());
                    }
                    try {
                        CodeGenModelFactory.this.initDialogSettings(model);
                        CodeGenModelFactory.this.iterateChildren2(queue, normalizedSelections, model);
                    }
                    catch (CoreException e) {
                        exceptionHolder[0] = e;
                    }
                }
            }
        };
        BusyIndicator.showWhile(null, (Runnable)busyRunnable);
        if (exceptionHolder[0] != null) {
            throw (CoreException)((Object)exceptionHolder[0]);
        }
    }

    public static void finalizeModel(ICodeGenModel model) {
        if (model != null && !((CodeGenModel)model).isFinalized()) {
            ICodeGenModel nextModel;
            ArrayList<ICodeGenNode> complexNodes = null;
            List cgNodes = model.getCodeGenNodes();
            if (cgNodes != null && cgNodes.size() > 0) {
                for (ICodeGenNode cgNode : cgNodes) {
                    List childNodes;
                    ICodeGenModel childModel = cgNode.getChildCodeGenModel();
                    if (!cgNode.isSelected() || childModel == null || (childNodes = childModel.getCodeGenNodes()) == null || childNodes.size() <= 0) continue;
                    if (cgNode.isListNode()) {
                        CodeGenModelFactory.finalizeModel(childModel);
                        continue;
                    }
                    if (!EMBEDDED_FORM_CONTROL_ID.equals(cgNode.getControlId())) continue;
                    if (complexNodes == null) {
                        complexNodes = new ArrayList<ICodeGenNode>();
                    }
                    complexNodes.add(cgNode);
                }
                if (complexNodes != null && complexNodes.size() > 0) {
                    for (ICodeGenNode complexNode : complexNodes) {
                        int index = cgNodes.indexOf(complexNode);
                        if (index < 0) continue;
                        ICodeGenNode removedNode = (ICodeGenNode)cgNodes.remove(index);
                        ICodeGenModel newParentModel = removedNode.getCodeGenModel();
                        List newChildren = complexNode.getChildCodeGenModel().getCodeGenNodes();
                        if (newChildren == null || newChildren.size() <= 0) continue;
                        for (ICodeGenNode newChild : newChildren) {
                            newChild.setCodeGenModel(newParentModel);
                        }
                        cgNodes.addAll(index, newChildren);
                    }
                    CodeGenModelFactory.finalizeModel(model);
                }
            }
            if ((nextModel = model.getNextModel()) != null && nextModel != model) {
                CodeGenModelFactory.finalizeModel(nextModel);
            }
            ((CodeGenModel)model).setFinalized(true);
        }
    }

    protected ICodeGenNode createCodeGenNode(IPageDataNode pdNode, ICodeGenModel model) {
        return new CodeGenNode(pdNode, model);
    }

    protected void iterateChildren2(List queue, SelectionEntryList normalizedSelections, ICodeGenModel model) throws CoreException {
        while (!queue.isEmpty()) {
            ICodeGenNode one = (ICodeGenNode)queue.remove(0);
            IPageDataNode pdOne = one.getEnclosedNode();
            boolean tooDeep = false;
            int modelDepth = model.getDepth();
            if (modelDepth != -1) {
                IPageDataNode targetNode = pdOne;
                int currentDepth = 0;
                while (targetNode != null && normalizedSelections.distanceOf(targetNode) == -1) {
                    if (++currentDepth >= modelDepth) {
                        tooDeep = true;
                        break;
                    }
                    targetNode = targetNode.getParent();
                }
            }
            if (!tooDeep) {
                List children = this.getChildren(pdOne, normalizedSelections);
                if (children == null || children.size() == 0) {
                    if (this.isListType(one)) {
                        one.setIsListNode(true);
                        model.addNode(new ElementCGN(pdOne, model));
                        continue;
                    }
                    model.addNode(one);
                    continue;
                }
                boolean isArray = ((IBindingAttribute)pdOne.getAdapter(IBindingAttribute.ADAPTER_KEY)).isArrayType(pdOne);
                IVirtualComponent vc = model.getTarget().getWebModel().getComponent();
                if (isArray && children.size() == this.getChildren(pdOne).size() && this.hasControlForType(model.getPageType(), CodeGenUtil.getElementRuntime(pdOne), vc)) {
                    model.addNode(new ElementCGN(pdOne, model));
                    continue;
                }
                if (!this.isListType(pdOne) && children.size() == this.getChildren(pdOne).size() && this.hasControlForType(model.getPageType(), CodeGenUtil.getRuntime(pdOne), vc)) {
                    model.addNode(one);
                    continue;
                }
                int i = 0;
                while (children != null && i < children.size()) {
                    IPageDataNode oneChild = (IPageDataNode)children.get(i);
                    CodeGenNode cgNode = new CodeGenNode(oneChild, model);
                    if (!this.isListType(oneChild)) {
                        boolean nochildren;
                        List oneChildChildren = this.getChildren(oneChild);
                        boolean bl = nochildren = oneChildChildren == null || oneChildChildren.size() == 0;
                        if (nochildren || this.hasControlForType(model.getPageType(), CodeGenUtil.getRuntime(oneChild), vc) && this.getChildren(oneChild, normalizedSelections).size() == oneChildChildren.size()) {
                            model.addNode(cgNode);
                        } else if (!nochildren && children.size() == 1) {
                            queue.add(cgNode);
                        } else {
                            model.addNode(cgNode);
                            this.createComplexTypeChildModel(cgNode, normalizedSelections);
                        }
                    } else {
                        ICodeGenModel childModel = this.createModel((ICodeGenNode)cgNode, model.getTarget(), model.getPageType());
                        childModel.setControlType(model.getControlType());
                        childModel.setDepth(model.getDepth());
                        model.addNode(childModel.getRoot());
                        ArrayList<ICodeGenNode> childQueue = new ArrayList<ICodeGenNode>(1);
                        childQueue.add(childModel.getRoot());
                        this.iterateChildren2(childQueue, normalizedSelections, childModel);
                    }
                    ++i;
                }
                continue;
            }
            model.addCustomProperty(ICodeGenModel.DEPTH_LIMITED_KEY, Boolean.TRUE);
        }
        this.removeEmptyListNodes(model);
    }

    private ICodeGenModel createComplexTypeChildModel(ICodeGenNode cgNode, SelectionEntryList normalizedSelections) throws CoreException {
        ICodeGenModel model = cgNode.getCodeGenModel();
        ICodeGenModel childModel = this.createModel(cgNode, model.getTarget(), model.getPageType());
        childModel.setControlType(model.getControlType());
        childModel.setCreateDeleteButton(false);
        childModel.setCreateSubmitButton(false);
        childModel.setUseColon(model.isUseColon());
        cgNode.setChildCodeGenModel(childModel);
        childModel.setRoot(cgNode);
        childModel.setDepth(model.getDepth());
        ArrayList<ICodeGenNode> childQueue = new ArrayList<ICodeGenNode>(1);
        childQueue.add(childModel.getRoot());
        this.iterateChildren2(childQueue, normalizedSelections, childModel);
        return childModel;
    }

    protected void iterateChildren(List queue, SelectionEntryList normalizedSelections, ICodeGenModel model) throws CoreException {
        while (!queue.isEmpty()) {
            ICodeGenNode one = (ICodeGenNode)queue.remove(0);
            IPageDataNode pdOne = one.getEnclosedNode();
            boolean tooDeep = false;
            int modelDepth = model.getDepth();
            if (modelDepth != -1) {
                IPageDataNode targetNode = pdOne;
                int currentDepth = 0;
                while (targetNode != null && normalizedSelections.distanceOf(targetNode) == -1) {
                    if (++currentDepth >= modelDepth) {
                        tooDeep = true;
                        break;
                    }
                    targetNode = targetNode.getParent();
                }
            }
            if (!tooDeep) {
                List children = this.getChildren(pdOne, normalizedSelections);
                if (children == null || children.size() == 0) {
                    if (this.isListType(one)) {
                        one.setIsListNode(true);
                        model.addNode(new ElementCGN(pdOne, model));
                        continue;
                    }
                    model.addNode(one);
                    continue;
                }
                boolean isArray = ((IBindingAttribute)pdOne.getAdapter(IBindingAttribute.ADAPTER_KEY)).isArrayType(pdOne);
                IVirtualComponent vc = model.getTarget().getWebModel().getComponent();
                if (isArray && children.size() == this.getChildren(pdOne).size() && this.hasControlForType(model.getPageType(), CodeGenUtil.getElementRuntime(pdOne), vc)) {
                    model.addNode(new ElementCGN(pdOne, model));
                    continue;
                }
                if (!this.isListType(pdOne) && children.size() == this.getChildren(pdOne).size() && this.hasControlForType(model.getPageType(), CodeGenUtil.getRuntime(pdOne), vc)) {
                    model.addNode(one);
                    continue;
                }
                int i = 0;
                while (children != null && i < children.size()) {
                    IPageDataNode oneChild = (IPageDataNode)children.get(i);
                    CodeGenNode cgNode = new CodeGenNode(oneChild, model);
                    if (!this.isListType(oneChild)) {
                        if (!oneChild.hasChildren() || this.hasControlForType(model.getPageType(), CodeGenUtil.getRuntime(oneChild), vc) && this.getChildren(oneChild, normalizedSelections).size() == this.getChildren(oneChild).size()) {
                            model.addNode(cgNode);
                        } else {
                            queue.add(cgNode);
                        }
                    } else {
                        ICodeGenModel childModel = this.createModel((ICodeGenNode)cgNode, model.getTarget(), model.getPageType());
                        childModel.setDepth(model.getDepth());
                        model.addNode(childModel.getRoot());
                        ArrayList<ICodeGenNode> childQueue = new ArrayList<ICodeGenNode>(1);
                        childQueue.add(childModel.getRoot());
                        this.iterateChildren(childQueue, normalizedSelections, childModel);
                    }
                    ++i;
                }
                continue;
            }
            model.addCustomProperty(ICodeGenModel.DEPTH_LIMITED_KEY, Boolean.TRUE);
        }
        this.removeEmptyListNodes(model);
    }

    protected List getChildren(IPageDataNode pdNode, SelectionEntryList normalizedSelections) {
        List children = this.getChildren(pdNode);
        if (children != null) {
            List nodesOfNextLevel;
            int dist = normalizedSelections.distanceOf(pdNode);
            ArrayList pickedChildren = null;
            if (dist >= 0 && (nodesOfNextLevel = normalizedSelections.getNodesOfDistance(dist + 1)) != null) {
                int i = 0;
                while (i < nodesOfNextLevel.size()) {
                    if (children.contains(nodesOfNextLevel.get(i))) {
                        if (pickedChildren == null) {
                            pickedChildren = new ArrayList(1);
                        }
                        pickedChildren.add(nodesOfNextLevel.get(i));
                    }
                    ++i;
                }
            }
            if (pickedChildren != null) {
                children = pickedChildren;
            }
        }
        return children;
    }

    protected List getChildren(IPageDataNode pdNode) {
        return pdNode.getChildren();
    }

    protected boolean hasControlForType(String pageType, String runtimeType, IVirtualComponent vc) {
        return false;
    }

    protected void removeEmptyListNodes(ICodeGenModel model) {
        List cgNodes;
        if (model != null && (cgNodes = model.getCodeGenNodes()) != null && !cgNodes.isEmpty()) {
            ArrayList<ICodeGenNode> removeList = new ArrayList<ICodeGenNode>();
            for (ICodeGenNode cgNode : cgNodes) {
                if (!cgNode.isListNode()) continue;
                ICodeGenModel childModel = cgNode.getChildCodeGenModel();
                if (model != childModel) {
                    this.removeEmptyListNodes(childModel);
                }
                if (childModel != null && childModel.getCodeGenNodes() != null && childModel.getCodeGenNodes().size() >= 1) continue;
                removeList.add(cgNode);
            }
            cgNodes.removeAll(removeList);
        }
    }

    @Override
    public void initializeNodes(ICodeGenModel model) {
        if (model != null) {
            List nodes;
            ICodeGenNode cgRoot = model.getRoot();
            if (cgRoot != null) {
                List controls;
                if (cgRoot.isListNode() && (controls = this.getAvailableControls(cgRoot, (short)1)) != null && controls.size() > 0) {
                    model.setControlType(1);
                }
                cgRoot.setLabel(this.getLabel(cgRoot, cgRoot.getCodeGenModel().isUseColon(), cgRoot.getCodeGenModel().isCapitalizeLabel()));
                this.initializeControlType(cgRoot, model);
            }
            if ((nodes = model.getCodeGenNodes()) != null) {
                for (ICodeGenNode cgNode : nodes) {
                    cgNode.setFieldNameLabel(this.getFieldNameLabel(cgNode.getEnclosedNode(), model));
                    cgNode.setLabel(this.getLabel(cgNode, model.isUseColon(), model.isCapitalizeLabel()));
                    this.initializeControlType(cgNode, model);
                    ICodeGenModel childModel = cgNode.getChildCodeGenModel();
                    if (childModel == null || cgNode.getCodeGenModel() == childModel) continue;
                    this.initializeNodes(childModel);
                }
                this.makeLabelsUnique(nodes);
            }
        }
    }

    protected void makeLabelsUnique(List nodes) {
        Object[] nodeArray = nodes.toArray();
        ArrayList<ICodeGenNode> targetNodes = null;
        int i = 0;
        while (i < nodeArray.length) {
            targetNodes = new ArrayList<ICodeGenNode>();
            ICodeGenNode node = (ICodeGenNode)nodeArray[i];
            int j = i + 1;
            while (j < nodeArray.length) {
                ICodeGenNode nodeJ = (ICodeGenNode)nodeArray[j];
                if (node.getLabel().equals(nodeJ.getLabel())) {
                    targetNodes.add(nodeJ);
                }
                ++j;
            }
            if (targetNodes.size() > 0) {
                targetNodes.add(node);
                for (ICodeGenNode targetNode : targetNodes) {
                    targetNode.setLabel(this.getUniqueLabel(targetNode));
                }
            }
            ++i;
        }
    }

    protected String getUniqueLabel(ICodeGenNode node) {
        String newLabel = node.getFieldNameLabel();
        if (newLabel != null) {
            int index = newLabel.indexOf(" (");
            if (index > 0) {
                newLabel = newLabel.substring(0, index);
            }
        } else {
            newLabel = node.getLabel();
        }
        return this.applyColon(node.getCodeGenModel().isUseColon(), CodeGenUtil.applyCapitalize(node.getCodeGenModel().isCapitalizeLabel(), newLabel));
    }

    @Override
    public String getLabel(ICodeGenNode cgNode, boolean useColon, boolean capitalize) {
        IPageDataNode parentPageNode;
        IBindingAttribute parentAttrib;
        String parentLabel;
        IPageDataNode pdNode = cgNode.getEnclosedNode();
        IBindingAttribute attrib = (IBindingAttribute)pdNode.getAdapter(IBindingAttribute.ADAPTER_KEY);
        String label = attrib.getName(pdNode);
        ICodeGenNode rootNode = cgNode.getCodeGenModel().getRoot();
        if (rootNode != null && this.isListType(cgNode) && label.startsWith(parentLabel = (parentAttrib = (IBindingAttribute)(parentPageNode = rootNode.getEnclosedNode()).getAdapter(IBindingAttribute.ADAPTER_KEY)).getName(parentPageNode)) && label.length() - 2 > parentLabel.length() && label.endsWith(")")) {
            label = label.substring(parentLabel.length() + 1, label.length() - 1);
        }
        return this.applyColon(useColon, CodeGenUtil.applyCapitalize(capitalize, label));
    }

    protected String applyColon(boolean colon, String label) {
        if (label != null) {
            if (colon && !label.endsWith(":")) {
                label = String.valueOf(label) + ":";
            } else if (!colon && label.endsWith(":")) {
                label = label.substring(0, label.length() - 1);
            }
        }
        return label;
    }

    @Override
    public String getFieldNameLabel(IPageDataNode pdNode, ICodeGenModel model) {
        String label = EMBEDDED_FORM_CONTROL_LABEL;
        if (pdNode != null) {
            label = this.getSegments(pdNode, model);
            IBindingAttribute attrib = (IBindingAttribute)pdNode.getAdapter(IBindingAttribute.ADAPTER_KEY);
            label = String.valueOf(label) + " (" + attrib.getRuntimeType(pdNode) + ")";
        }
        return label;
    }

    protected String getSegments(IPageDataNode pdNode, ICodeGenModel model) {
        String label = EMBEDDED_FORM_CONTROL_LABEL;
        IBindingAttribute attrib = (IBindingAttribute)pdNode.getAdapter(IBindingAttribute.ADAPTER_KEY);
        if (attrib != null) {
            String segments;
            label = attrib.getName(pdNode);
            if (model.getRoot().getEnclosedNode() != pdNode.getParent() && (segments = this.getSegments(pdNode.getParent(), model)) != null && segments != EMBEDDED_FORM_CONTROL_LABEL) {
                label = String.valueOf(segments) + "." + label;
            }
        }
        return label;
    }

    @Override
    public void initializeControlType(ICodeGenNode node, ICodeGenModel model) {
        List childNodes;
        ICodeGenModel childModel;
        List controls = CodeGenModelFactory.getControls(node, model.getControlType() == 0 || CodeGenUtil.isModelContainedInList(model) ? (short)2 : 1);
        if (controls != null && controls.size() > 0) {
            node.setControlId((String)controls.get(0));
        } else if (node.getControlId() == null) {
            node.setControlId(CodeGenerationManager.getDefaultControlId(model.getPageType()));
        }
        if (!node.isListNode() && (childModel = node.getChildCodeGenModel()) != null && (childNodes = childModel.getCodeGenNodes()) != null && childNodes.size() > 0) {
            node.addCustomControl(EMBEDDED_FORM_CONTROL_ID, (short)0);
            node.setControlId(EMBEDDED_FORM_CONTROL_ID);
        }
    }

    protected void initDialogSettings(ICodeGenModel model) {
        IDialogSettings settings = PageDataModelPlugin.getDefault().getDialogSettings();
        if (settings.get("ALIGNMENT") != null) {
            model.setAlignment(settings.getInt("ALIGNMENT"));
        }
        if (settings.get("CAPITALIZE") != null) {
            model.setCapitalizeLabel(settings.getBoolean("CAPITALIZE"));
        }
        if (settings.get("add_label_component") != null) {
            model.addCustomProperty("add_label_component", settings.getBoolean("add_label_component") ? Boolean.TRUE : Boolean.FALSE);
        }
        boolean isResultModel = model.getCustomProperty("result") != null || CodeGenUtil.hasPreviousModel(model);
        boolean isList = CodeGenUtil.isModelContainedInList(model);
        if (isList) {
            model.setCreateDeleteButton(false);
            model.setCreateSubmitButton(false);
            model.setUseColon(false);
        } else {
            if (settings.get("COLON") != null) {
                model.setUseColon(settings.getBoolean("COLON"));
            }
            if (isResultModel) {
                model.setControlType(0);
                model.setCreateDeleteButton(false);
                model.setCreateSubmitButton(false);
            } else {
                if (settings.get("CONTROL_TYPE") != null) {
                    model.setControlType(settings.getInt("CONTROL_TYPE"));
                }
                if (settings.get("CONTROL_ID") != null) {
                    model.setControlId(settings.get("CONTROL_ID"));
                }
                model.setCreateSubmitButton(model.getControlType() != 0 && (settings.get("SUBMIT_BUTTON_CREATE") == null || settings.getBoolean("SUBMIT_BUTTON_CREATE")));
                if (this.isValidSetting("DELETE_BUTTON_CREATE")) {
                    model.setCreateDeleteButton(model.getControlType() == 1 && (settings.get("DELETE_BUTTON_CREATE") == null || settings.getBoolean("DELETE_BUTTON_CREATE")));
                    if (settings.get("DELETE_BUTTON_LABEL") != null) {
                        model.setDeleteButtonLabel(settings.get("DELETE_BUTTON_LABEL"));
                    }
                }
                if (settings.get("SUBMIT_BUTTON_LABEL") != null) {
                    model.setSubmitButtonLabel(settings.get("SUBMIT_BUTTON_LABEL"));
                }
            }
        }
    }

    protected boolean isValidSetting(String setting) {
        return true;
    }

    protected ICodeGenModel createModel(ICodeGenNode cgRoot, IProject project, String pageType) throws CoreException {
        IFile file = cgRoot.getEnclosedNode().getPageDataModel().getResource();
        JSP jsp = null;
        try {
            jsp = ModelManager.getModel((IResource)file).getJSP(file);
        }
        catch (WebModelCreationException e) {
            e.printStackTrace();
        }
        return this.createModel(cgRoot, jsp, pageType);
    }

    protected ICodeGenModel createModel(ICodeGenNode cgRoot, JSP jsp, String pageType) throws CoreException {
        IBindingAttribute binding = (IBindingAttribute)cgRoot.getEnclosedNode().getAdapter(IBindingAttribute.ADAPTER_KEY);
        if (binding == null) {
            throw new NoBindingAttributeFoundException(cgRoot.getEnclosedNode().toString());
        }
        CodeGenModel model = new CodeGenModel(jsp, pageType, cgRoot);
        IDialogSettings settings = PageDataModelPlugin.getDefault().getDialogSettings();
        if (settings.get("DEPTH") != null) {
            model.setDepth(settings.getInt("DEPTH"));
        }
        if (cgRoot.getCodeGenModel() == null) {
            cgRoot.setCodeGenModel(model);
        }
        boolean rootIsList = this.isListType(cgRoot);
        cgRoot.setIsListNode(rootIsList);
        model.setIsList(rootIsList);
        model.setUseColon(!rootIsList);
        if (rootIsList) {
            cgRoot.setChildCodeGenModel(model);
        }
        return model;
    }

    public static void initializeModel(ICodeGenModel model, boolean initSettings) throws CoreException, ClassNotFoundException {
        model.getRoot().getEnclosedNode().getCodeGenModelFactory().init(model, initSettings);
    }

    @Override
    public void init(ICodeGenModel model, boolean initSettings) throws CoreException, ClassNotFoundException {
        SelectionEntryList normalizedSelections = this.normalizeSelection(new IPageDataNode[]{model.getRoot().getEnclosedNode()});
        model.addLocalProperty(NORMALIZED_SELECTIONS, normalizedSelections);
        model.setIsList(this.isListType(model.getRoot()));
        if (model.isList()) {
            model.getRoot().setChildCodeGenModel(model);
        }
        ArrayList<ICodeGenNode> queue = new ArrayList<ICodeGenNode>(1);
        IPageDataNode firstNode = ((SelectionEntry)normalizedSelections.get((int)0)).selectedNode;
        if (model.getRoot().getEnclosedNode() != firstNode) {
            queue.add(this.createCodeGenNode(firstNode, model));
        } else {
            queue.add(model.getRoot());
        }
        if (initSettings) {
            this.initDialogSettings(model);
        }
        this.iterateChildren2(queue, normalizedSelections, model);
        this.initializeNodes(model);
    }

    protected boolean isListType(IPageDataNode pdNode) {
        IBindingAttribute attr = (IBindingAttribute)pdNode.getAdapter(IBindingAttribute.ADAPTER_KEY);
        return attr.isArrayType(pdNode) || attr.getCollectionType(pdNode) == 1;
    }

    protected boolean isListType(ICodeGenNode cgNode) {
        return this.isListType(cgNode.getEnclosedNode());
    }

    @Override
    public OptionsDialog getOptionsDialog(Shell shell, ICodeGenModel model) {
        return new OptionsDialog(shell, model);
    }
}

