/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.model.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class ProjectUtil {
    public static final String FACET_DYNAMIC_WEB = "jst.web";
    public static final String FACET_JSF = "jst.jsf";
    public static final String FACET_JSF_BASE = "jsf.base";

    public static boolean isDynamicWebProject(IProject project) {
        boolean isDynamicWeb = false;
        try {
            isDynamicWeb = ProjectUtil.projectHasFacet(project, FACET_DYNAMIC_WEB, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return isDynamicWeb;
    }

    public static boolean projectHasFacet(IProject project, String facetID, String facetVersion) throws CoreException {
        IProjectFacet requiredFacet;
        IFacetedProject facetedProject;
        boolean hasFacet = false;
        if (ProjectFacetsManager.isProjectFacetDefined((String)facetID) && (facetedProject = ProjectFacetsManager.create((IProject)project)) != null && (requiredFacet = ProjectFacetsManager.getProjectFacet((String)facetID)) != null) {
            if (facetVersion != null) {
                IProjectFacetVersion requiredFacetVersion = requiredFacet.getVersion(facetVersion);
                if (requiredFacetVersion != null) {
                    hasFacet = facetedProject.hasProjectFacet(requiredFacetVersion);
                }
            } else {
                hasFacet = facetedProject.hasProjectFacet(requiredFacet);
            }
        }
        return hasFacet;
    }

    public static List<IProject> getProjectsWithFacets(String[] facetIDs) {
        IProject[] projects = ProjectUtil.getAllProjects();
        ArrayList<IProject> facetedProjects = new ArrayList<IProject>(projects.length);
        if (projects.length > 0 && facetIDs != null && facetIDs.length > 0) {
            boolean failed = false;
            IProjectFacet[] facets = new IProjectFacet[facetIDs.length];
            try {
                int i = 0;
                while (i < facets.length) {
                    facets[i] = ProjectFacetsManager.getProjectFacet((String)facetIDs[i]);
                    if (facets[i] == null) {
                        failed = true;
                        break;
                    }
                    ++i;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                failed = true;
            }
            if (!failed) {
                IFacetedProject facetedProject = null;
                int i = 0;
                while (i < projects.length) {
                    try {
                        facetedProject = ProjectFacetsManager.create((IProject)projects[i]);
                        if (facetedProject != null) {
                            int j = 0;
                            while (j < facets.length) {
                                if (!facetedProject.hasProjectFacet(facets[j])) {
                                    failed = true;
                                    break;
                                }
                                ++j;
                            }
                            if (!failed) {
                                facetedProjects.add(projects[i]);
                            }
                            failed = false;
                        }
                    }
                    catch (CoreException coreException) {}
                    ++i;
                }
            }
        }
        return facetedProjects;
    }

    public static List getDynamicWebProjects() {
        ArrayList<IProject> dynamicWebProjects = null;
        IProject[] projects = ProjectUtil.getAllProjects();
        dynamicWebProjects = new ArrayList<IProject>(projects.length);
        int i = 0;
        while (i < projects.length) {
            IProject p = projects[i];
            if (p.isOpen() && ProjectUtil.isDynamicWebProject(p)) {
                dynamicWebProjects.add(p);
            }
            ++i;
        }
        return dynamicWebProjects;
    }

    public static List<IProject> getFacesWebProjects() {
        String[] facetIDs = new String[]{FACET_DYNAMIC_WEB, FACET_JSF, FACET_JSF_BASE};
        List<IProject> facesWebProjects = ProjectUtil.getProjectsWithFacets(facetIDs);
        return facesWebProjects;
    }

    private static IProject[] getAllProjects() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] projects = workspace.getRoot().getProjects();
        if (projects == null) {
            projects = new IProject[]{};
        }
        return projects;
    }
}

