/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.web.css.internal.providers.detectors;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.ReferenceElementFactory;
import com.ibm.etools.references.services.providers.SharedModel;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.CreateLinkParameter;
import com.ibm.etools.references.web.internal.providers.detectors.WebLinkDetector;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.common.utils.DocumentStyleHTML;
import com.ibm.etools.webtools.model.WebModelCreationException;
import com.ibm.etools.webtools.model.util.ModelUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelector;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelectorList;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleSheet;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.stylesheets.StyleSheet;
import org.w3c.dom.stylesheets.StyleSheetList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class CSSClassLinkDetector
extends WebLinkDetector {
    private HTMLEditDomain editDomain = null;
    private HashMap<ICSSStyleSheet, ArrayList<ICSSStyleRule>> styleSheetAndRules = null;

    private void addLinkParameters(ReferenceElementFactory factory, Node n, String nName, String linkType, ILink desc, IDOMModel model) {
        String cssUri;
        if ("wst.css.class.link" == linkType && (cssUri = this.getCSSURIForClass(n, model)) != null) {
            factory.addParam(desc, "css.uri", cssUri);
        }
    }

    public List<ILink> detectLinks(ReferenceElementFactory factory, SharedModel sharedModel, Set<IResolvedReference> incomingReferences) {
        ArrayList<ILink> links = new ArrayList<ILink>();
        if (sharedModel.getSharedModel() instanceof IDOMModel) {
            IDOMModel model = (IDOMModel)sharedModel.getSharedModel();
            IDOMDocument document = model.getDocument();
            this.styleSheetAndRules = null;
            try {
                IFile file = ModelUtil.getFileFor(model);
                if (file != null) {
                    this.editDomain = ModelUtil.getEditDomain(file);
                }
            }
            catch (WebModelCreationException webModelCreationException) {}
            if (this.editDomain == null) {
                return links;
            }
            NodeIterator iter = ((DocumentTraversal)document).createNodeIterator((Node)document, 1, null, false);
            Node n = iter.nextNode();
            while (n != null) {
                String domNodeName = n.getNodeName();
                if (domNodeName != null && domNodeName.indexOf(":") == -1) {
                    IDOMElement domElement = (IDOMElement)n;
                    NamedNodeMap domAttributeNodes = n.getAttributes();
                    int length = domAttributeNodes.getLength();
                    int i = 0;
                    while (i < length) {
                        Node domAttributeItem = domAttributeNodes.item(i);
                        String linkName = null;
                        String domAttName = domAttributeItem.getNodeName();
                        if (domAttName.compareToIgnoreCase("class") == 0) {
                            String linkType = this.getLinkType(domNodeName, domAttName);
                            IDOMAttr attr = (IDOMAttr)domAttributeItem;
                            ILink webLink = AbstractWebProvider.createLink((CreateLinkParameter)new CreateLinkParameter(factory, domElement, (IDOMNode)attr, linkType, linkName, false));
                            this.addLinkParameters(factory, n, domNodeName, linkType, webLink, model);
                            links.add(webLink);
                            break;
                        }
                        ++i;
                    }
                }
                n = iter.nextNode();
            }
        }
        try {
            ModelUtil.releaseAndSaveIfNecessaryEditDomain(this.editDomain);
        }
        catch (Exception exception) {}
        return links;
    }

    private String getLinkType(String nodeName, String attName) {
        String linkType = "web.commonlink";
        if (attName.equalsIgnoreCase("class")) {
            linkType = "wst.css.class.link";
        }
        return linkType;
    }

    private String getCSSURIForClass(Node node, IDOMModel model) {
        this.getAllStyleRules(model);
        if (this.styleSheetAndRules == null || !(node instanceof Element)) {
            return null;
        }
        int specificity = 0;
        String styleSheetHref = "";
        Set<ICSSStyleSheet> sheetSet = this.styleSheetAndRules.keySet();
        for (ICSSStyleSheet sheet : sheetSet) {
            ArrayList<ICSSStyleRule> rules = this.styleSheetAndRules.get(sheet);
            if (rules == null || rules.isEmpty()) {
                return styleSheetHref;
            }
            int j = 0;
            while (j < rules.size()) {
                ICSSSelectorList selectors = rules.get(j).getSelectors();
                int k = 0;
                while (k < selectors.getLength()) {
                    int selectorSpecifity;
                    ICSSSelector selector = selectors.getSelector(k);
                    boolean match = selector.match((Element)node, null);
                    if (match && (selectorSpecifity = selector.getSpecificity()) > specificity) {
                        specificity = selectorSpecifity;
                        String href = sheet.getHref();
                        styleSheetHref = href != null ? href : model.getBaseLocation();
                    }
                    ++k;
                }
                ++j;
            }
        }
        return styleSheetHref;
    }

    private void getAllStyleRules(IDOMModel model) {
        if (this.styleSheetAndRules != null) {
            return;
        }
        if (this.editDomain == null) {
            return;
        }
        DocumentStyleHTML docstyle = this.editDomain.getStyleContainerProvider().getStyleContainer(model);
        StyleSheetList sheets = docstyle.getStyleSheets();
        ArrayList<ICSSStyleRule> rulesList = null;
        if (sheets == null) {
            return;
        }
        int i = 0;
        while (i < sheets.getLength()) {
            StyleSheet sh = sheets.item(i);
            if (sh != null) {
                rulesList = new ArrayList<ICSSStyleRule>();
                ICSSStyleSheet sheet = (ICSSStyleSheet)sh;
                CSSRuleList cssRules = sheet.getCssRules();
                int j = 0;
                while (j < cssRules.getLength()) {
                    CSSRule rule = cssRules.item(j);
                    if (rule instanceof ICSSStyleRule) {
                        ICSSStyleRule styleRule = (ICSSStyleRule)rule;
                        rulesList.add(styleRule);
                    }
                    ++j;
                }
                if (this.styleSheetAndRules == null) {
                    this.styleSheetAndRules = new HashMap();
                }
                this.styleSheetAndRules.put(sheet, rulesList);
            }
            ++i;
        }
    }
}

