/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.wizard.ui.taskPages.dialogs;

import com.ibm.etools.webtools.javamodel.api.JavaCodeUtil;
import com.ibm.etools.webtools.jpa.JpaPlugin;
import com.ibm.etools.webtools.jpa.filters.BinaryValueQueryColumn;
import com.ibm.etools.webtools.jpa.filters.IBinaryValueQueryColumn;
import com.ibm.etools.webtools.jpa.filters.IMultiValueQueryColumn;
import com.ibm.etools.webtools.jpa.filters.IQueryVariableValue;
import com.ibm.etools.webtools.jpa.filters.ISingleColumnConditionData;
import com.ibm.etools.webtools.jpa.filters.ISingleQueryColumn;
import com.ibm.etools.webtools.jpa.filters.ISingleValueQueryColumn;
import com.ibm.etools.webtools.jpa.filters.MultiValueQueryColumn;
import com.ibm.etools.webtools.jpa.filters.QueryVariableValue;
import com.ibm.etools.webtools.jpa.filters.SingleValueQueryColumn;
import com.ibm.etools.webtools.jpa.models.JpaAttributeInfo;
import com.ibm.etools.webtools.jpa.models.JpaEntityInfo;
import com.ibm.etools.webtools.jpa.models.JpaFilterInfo;
import com.ibm.etools.webtools.jpa.models.JpaFilterParameterInfo;
import com.ibm.etools.webtools.jpa.nls.JpaUI;
import com.ibm.etools.webtools.jpa.util.JpaUtil;
import com.ibm.etools.webtools.jpa.wizard.ui.SingleTableColumnMaximizer;
import com.ibm.etools.webtools.jpa.wizard.ui.UIPartsUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.core.context.java.JavaManyToOneMapping;
import org.eclipse.jpt.core.context.java.JavaOneToOneMapping;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class SingleColumnConditionPart
implements Listener {
    private Composite root;
    protected Composite wtAttributeConditionComposite;
    protected BinaryOperatorPart binaryOperatorPart;
    protected BetweenOperatorPart betweenOperatorPart;
    protected InOperatorPart inOperatorPart;
    protected Combo wtAttributeNameCombo;
    protected Combo wtAttributeOperatorCombo;
    protected Composite wtConditionDetailsComposite;
    protected StackLayout stackLayout;
    protected ISingleColumnConditionData attributeConditionData;
    protected OperatorPart topPart;
    private UnaryOperatorPart unaryOperatorPart;
    private Composite parent;
    protected ObservableClass fObservable;
    private final boolean isEdit;

    public SingleColumnConditionPart(Composite parent, boolean isEdit) {
        this.parent = parent;
        this.isEdit = isEdit;
    }

    protected void createAttributeCondtionControl(Composite composite) {
        this.wtAttributeConditionComposite = UIPartsUtil.createComposite(composite, 3, 1);
        GridData data = (GridData)this.wtAttributeConditionComposite.getLayoutData();
        data.widthHint = 350;
        UIPartsUtil.createLabel(this.wtAttributeConditionComposite, JpaUI._UI_Select_An_Attribute, 1);
        this.wtAttributeNameCombo = UIPartsUtil.createCombo(this.wtAttributeConditionComposite, 8, 2);
        UIPartsUtil.createLabel(this.wtAttributeConditionComposite, JpaUI._UI_Select_An_Operator, 1);
        this.wtAttributeOperatorCombo = UIPartsUtil.createCombo(this.wtAttributeConditionComposite, 8, 2);
        this.createConditionDetailsComposite(this.wtAttributeConditionComposite);
        this.wtAttributeNameCombo.addListener(13, (Listener)this);
        this.wtAttributeOperatorCombo.addListener(13, (Listener)this);
    }

    private void createBetweenOperatorComposite(Composite parent) {
        this.betweenOperatorPart = new BetweenOperatorPart();
        this.betweenOperatorPart.createControl(parent);
    }

    private void createBinaryOperatorComposite(Composite parent) {
        this.binaryOperatorPart = this.getNewBinaryOperatorPart(null);
        this.binaryOperatorPart.createControl(parent);
    }

    protected void createConditionDetailsComposite(Composite parent) {
        this.wtConditionDetailsComposite = UIPartsUtil.createComposite(parent, 1, 3);
        this.stackLayout = new StackLayout();
        this.wtConditionDetailsComposite.setLayout((Layout)this.stackLayout);
        this.createVariableDetailsComposite(this.wtConditionDetailsComposite);
    }

    public void createControls() {
        this.createRoot(1);
        this.createAttributeCondtionControl(this.getComposite());
    }

    private void createInOperatorComposite(Composite parent) {
        this.inOperatorPart = new InOperatorPart();
        this.inOperatorPart.createControl(parent);
    }

    protected void createRoot(int numColumns) {
        if (this.root != null) {
            this.root.dispose();
        }
        this.root = UIPartsUtil.createComposite(this.getParent(), numColumns, 1);
    }

    private void createUnaryOperatorComposite(Composite parent) {
        this.unaryOperatorPart = new UnaryOperatorPart();
        this.unaryOperatorPart.createControl(parent);
    }

    protected void createVariableDetailsComposite(Composite parent) {
        this.createUnaryOperatorComposite(parent);
        this.createBetweenOperatorComposite(parent);
        this.createInOperatorComposite(parent);
        this.createBinaryOperatorComposite(parent);
    }

    public ISingleColumnConditionData getAttributeCondition() {
        if (this.attributeConditionData != null) {
            if (this.wtAttributeNameCombo.getSelectionIndex() != -1) {
                SingleValueQueryColumn svqc = new SingleValueQueryColumn();
                svqc.setVariableValue(new QueryVariableValue());
                svqc.getVariableValue().setColumnName(this.wtAttributeNameCombo.getItem(this.wtAttributeNameCombo.getSelectionIndex()));
                this.attributeConditionData.setLHSQueryColumn(svqc);
            }
            this.attributeConditionData.setOperator(this.attributeConditionData.getOperatorList().getValue(this.wtAttributeOperatorCombo.getSelectionIndex()));
            if (Arrays.asList(ISingleColumnConditionData.UNARY_OPERATOR_LIST.getValues()).contains(this.attributeConditionData.getOperator())) {
                this.attributeConditionData.setRHSQueryColumn(null);
            } else if (Arrays.asList(ISingleColumnConditionData.BETWEEN_OPERATOR_LIST.getValues()).contains(this.attributeConditionData.getOperator())) {
                this.betweenOperatorPart.createRHSQueryColumn(this.attributeConditionData);
            } else if (Arrays.asList(ISingleColumnConditionData.IN_OPERATOR_LIST.getValues()).contains(this.attributeConditionData.getOperator())) {
                this.inOperatorPart.createRHSQueryColumn(this.attributeConditionData);
            } else if (this.binaryOperatorPart != null) {
                this.binaryOperatorPart.createRHSQueryColumn(this.attributeConditionData);
            }
        }
        return this.attributeConditionData;
    }

    private List<String> getAttributeNamesForFilter(List<JpaAttributeInfo> attributeList) {
        ArrayList<String> attributeNameList = new ArrayList<String>();
        for (JpaAttributeInfo attribute : attributeList) {
            String entity;
            JpaEntityInfo targetEntity = null;
            if (attribute.getMappingKey() != null && attribute.getMappingKey().equals("oneToOne")) {
                entity = ((JavaOneToOneMapping)attribute.getAttribute().getMapping()).getTargetEntity();
                targetEntity = JpaUtil.getEntityByName(attribute.getAttribute().getJpaProject(), entity);
            } else if (attribute.getMappingKey() != null && attribute.getMappingKey().equals("manyToOne")) {
                entity = ((JavaManyToOneMapping)attribute.getAttribute().getMapping()).getTargetEntity();
                targetEntity = JpaUtil.getEntityByName(attribute.getAttribute().getJpaProject(), entity);
            }
            if (targetEntity != null) {
                List<JpaAttributeInfo> primaryKeys = targetEntity.getPrimaryKeyAttributes();
                for (JpaAttributeInfo key : primaryKeys) {
                    attributeNameList.add(String.valueOf(attribute.getAttributeName()) + "." + key.getAttributeName());
                }
                continue;
            }
            attributeNameList.add(attribute.getAttributeName());
        }
        Collections.sort(attributeNameList);
        return attributeNameList;
    }

    public Composite getComposite() {
        return this.root;
    }

    private BinaryOperatorPart getNewBinaryOperatorPart(String groupText) {
        return new BinaryOperatorPart(groupText);
    }

    public Observable getObservable() {
        return this.getObservableInstance();
    }

    private ObservableClass getObservableInstance() {
        if (this.fObservable == null) {
            this.fObservable = new ObservableClass();
        }
        return this.fObservable;
    }

    private Composite getParent() {
        return this.parent;
    }

    public void handleEvent(Event event) {
        if (event.widget == this.wtAttributeOperatorCombo) {
            this.updateConditionValuesStates();
        } else if (event.widget == this.wtAttributeNameCombo) {
            this.binaryOperatorPart.updateVariableNameTextForComboChange();
        }
        this.getObservableInstance().setChanged();
        this.getObservable().notifyObservers(this.validateWholePart());
    }

    public void update(ISingleColumnConditionData attributeConditionData) {
        this.attributeConditionData = attributeConditionData;
        this.updateAttributeNameCombo(attributeConditionData);
        this.wtAttributeOperatorCombo.setItems(attributeConditionData.getOperatorList().getValues());
        if (attributeConditionData.getOperator() != null) {
            int itemIndexByValue = attributeConditionData.getOperatorList().getItemIndexByValue(attributeConditionData.getOperator());
            this.wtAttributeOperatorCombo.select(itemIndexByValue);
        }
        if (attributeConditionData.getRHSQueryColumn() instanceof ISingleValueQueryColumn) {
            this.binaryOperatorPart.updateWidgets(attributeConditionData.getRHSQueryColumn());
        } else if (attributeConditionData.getRHSQueryColumn() instanceof IBinaryValueQueryColumn) {
            this.betweenOperatorPart.updateWidgets(attributeConditionData.getRHSQueryColumn());
        } else if (attributeConditionData.getRHSQueryColumn() instanceof IMultiValueQueryColumn) {
            this.inOperatorPart.updateWidgets(attributeConditionData.getRHSQueryColumn());
        }
        this.updateConditionValuesStates();
        this.getObservableInstance().setChanged();
        this.getObservable().notifyObservers(this.validateWholePart());
    }

    protected void updateAttributeNameCombo(ISingleColumnConditionData attributeConditionData) {
        this.wtAttributeNameCombo.removeAll();
        List<String> stringAttributeList = this.getAttributeNamesForFilter(attributeConditionData.getColumnList());
        this.wtAttributeNameCombo.setItems(stringAttributeList.toArray(new String[stringAttributeList.size()]));
        if (attributeConditionData.getColumnName() != null) {
            this.wtAttributeNameCombo.select(stringAttributeList.indexOf(attributeConditionData.getColumnName()));
        }
    }

    protected void updateConditionValuesStates() {
        if (this.wtAttributeOperatorCombo != null && this.wtAttributeNameCombo != null) {
            String attributeOperatorText = this.wtAttributeOperatorCombo.getText();
            if (attributeOperatorText != null) {
                if (Arrays.asList(ISingleColumnConditionData.UNARY_OPERATOR_LIST.getValues()).contains(attributeOperatorText)) {
                    this.stackLayout.topControl = this.unaryOperatorPart.getComposite();
                    this.topPart = this.unaryOperatorPart;
                } else if (Arrays.asList(ISingleColumnConditionData.BETWEEN_OPERATOR_LIST.getValues()).contains(attributeOperatorText)) {
                    this.betweenOperatorPart.highValuePart.updateConstantValueCombo();
                    this.betweenOperatorPart.lowValuePart.updateConstantValueCombo();
                    this.stackLayout.topControl = this.betweenOperatorPart.getComposite();
                    this.topPart = this.betweenOperatorPart;
                } else if (Arrays.asList(ISingleColumnConditionData.IN_OPERATOR_LIST.getValues()).contains(attributeOperatorText)) {
                    this.stackLayout.topControl = this.inOperatorPart.getComposite();
                    this.topPart = this.inOperatorPart;
                } else {
                    this.binaryOperatorPart.updateConstantValueCombo();
                    this.stackLayout.topControl = this.binaryOperatorPart.getComposite();
                    this.topPart = this.binaryOperatorPart;
                }
            }
            this.wtConditionDetailsComposite.layout();
        }
    }

    private IStatus validateWholePart() {
        Status status = new Status(0, "com.ibm.etools.webtools.jpa", "");
        if (this.wtAttributeNameCombo.getSelectionIndex() == -1) {
            status = new Status(4, "com.ibm.etools.webtools.jpa", JpaUI._UI_You_Must_Select_Attribute);
        } else if (this.wtAttributeOperatorCombo.getSelectionIndex() == -1) {
            status = new Status(4, "com.ibm.etools.webtools.jpa", JpaUI._UI_You_Must_Select_Operator);
        } else if (this.topPart != null) {
            status = this.topPart.validatePart();
        }
        return status;
    }

    protected class BetweenOperatorPart
    implements OperatorPart {
        protected Composite betweenOperatorComposite;
        protected BinaryOperatorPart lowValuePart;
        protected BinaryOperatorPart highValuePart;

        protected BetweenOperatorPart() {
        }

        @Override
        public void createControl(Composite parent) {
            this.betweenOperatorComposite = UIPartsUtil.createComposite(parent, 1, 1);
            this.lowValuePart = SingleColumnConditionPart.this.getNewBinaryOperatorPart(JpaUI._UI_Select_Low_Value);
            this.lowValuePart.createControl(this.betweenOperatorComposite);
            this.highValuePart = SingleColumnConditionPart.this.getNewBinaryOperatorPart(JpaUI._UI_Select_High_Value);
            this.highValuePart.createControl(this.betweenOperatorComposite);
        }

        public void createRHSQueryColumn(ISingleColumnConditionData columnConditionData) {
            BinaryValueQueryColumn svqc = new BinaryValueQueryColumn();
            IQueryVariableValue qvv = this.lowValuePart.createQueryVariableValue();
            svqc.setLowValue(qvv);
            qvv = this.highValuePart.createQueryVariableValue();
            svqc.setHighValue(qvv);
            columnConditionData.setRHSQueryColumn(svqc);
        }

        @Override
        public String getColumnNameText() {
            return SingleColumnConditionPart.this.wtAttributeNameCombo.getText();
        }

        @Override
        public Composite getComposite() {
            return this.betweenOperatorComposite;
        }

        public void updateWidgets(ISingleQueryColumn column) {
            this.lowValuePart.updateWidgets(((IBinaryValueQueryColumn)((Object)column)).getLowValue());
            this.highValuePart.updateWidgets(((IBinaryValueQueryColumn)((Object)column)).getHighValue());
        }

        @Override
        public IStatus validatePart() {
            Status status = new Status(0, "com.ibm.etools.webtools.jpa", "");
            status = this.lowValuePart.validatePart();
            if (status.isOK()) {
                status = this.highValuePart.validatePart();
            }
            return status;
        }
    }

    public class BinaryOperatorPart
    implements OperatorPart,
    Listener,
    FocusListener {
        protected Composite binaryOperatorComposite;
        protected Button fIsConstantButton;
        protected Button fIsVariableButton;
        protected Combo wtConstantValueComboText;
        protected Text wtVariableValueText;
        protected IQueryVariableValue queryVariableValue = new QueryVariableValue();
        protected boolean isVariableName = true;
        protected boolean variableValueModified = false;
        protected String groupText = JpaUI._UI_Select_Parameter;

        public BinaryOperatorPart(String groupText) {
            if (groupText != null && groupText.length() > 0) {
                this.groupText = groupText;
            }
        }

        @Override
        public void createControl(Composite parent) {
            this.binaryOperatorComposite = UIPartsUtil.createComposite(parent, 1, 1);
            Group binaryGroup = UIPartsUtil.createGroup(this.binaryOperatorComposite, 3, 1, this.groupText);
            this.fIsVariableButton = UIPartsUtil.createRadioButton((Composite)binaryGroup, JpaUI._UI_Variable_Name, 1, true);
            UIPartsUtil.createLabel((Composite)binaryGroup, ":", 1);
            this.wtVariableValueText = UIPartsUtil.createTextField((Composite)binaryGroup, 1);
            this.wtVariableValueText.setEnabled(true);
            this.wtVariableValueText.addListener(24, (Listener)this);
            this.wtVariableValueText.addFocusListener((FocusListener)this);
            this.fIsConstantButton = UIPartsUtil.createRadioButton((Composite)binaryGroup, JpaUI._UI_Constant, 1, false);
            UIPartsUtil.createLabel((Composite)binaryGroup, "", 1);
            this.wtConstantValueComboText = UIPartsUtil.createCombo((Composite)binaryGroup, 2048, 1);
            this.wtConstantValueComboText.setEnabled(false);
            this.wtConstantValueComboText.addListener(24, (Listener)this);
            this.fIsConstantButton.addListener(13, (Listener)this);
            this.fIsVariableButton.addListener(13, (Listener)this);
        }

        protected IQueryVariableValue createQueryVariableValue() {
            QueryVariableValue qvv = new QueryVariableValue();
            String value = "";
            if (this.isVariableName) {
                value = this.wtVariableValueText.getText();
                if (value.indexOf(":") != 0) {
                    value = ":" + value;
                }
                qvv.setVariableName(value);
                qvv.setVariableValue(null);
            } else {
                value = this.wtConstantValueComboText.getText();
                String column = this.getColumnNameText();
                String type = "";
                List attributes = SingleColumnConditionPart.this.attributeConditionData.getColumnList();
                boolean found = false;
                for (JpaAttributeInfo attribute : attributes) {
                    if (value.equals(attribute.getAttributeName())) {
                        found = true;
                        break;
                    }
                    if (!column.equals(attribute.getAttributeName())) continue;
                    type = attribute.getAttributeType();
                }
                if (!found && value.charAt(0) != '\'' && value.charAt(value.length() - 1) != '\'' && type.equals("java.lang.String")) {
                    value = "'" + value + "'";
                }
                qvv.setVariableValue(value);
                qvv.setVariableName(null);
            }
            return qvv;
        }

        public void createRHSQueryColumn(ISingleColumnConditionData columnConditionData) {
            SingleValueQueryColumn svqc = new SingleValueQueryColumn();
            IQueryVariableValue qvv = this.createQueryVariableValue();
            svqc.setVariableValue(qvv);
            columnConditionData.setRHSQueryColumn(svqc);
        }

        public void focusGained(FocusEvent e) {
            this.variableValueModified = true;
        }

        public void focusLost(FocusEvent e) {
        }

        @Override
        public String getColumnNameText() {
            return SingleColumnConditionPart.this.wtAttributeNameCombo != null ? SingleColumnConditionPart.this.wtAttributeNameCombo.getText() : null;
        }

        @Override
        public Composite getComposite() {
            return this.binaryOperatorComposite;
        }

        private String getUniqueVariableName(String suggestedName, JpaFilterInfo jpaFilterData) {
            String varName = suggestedName;
            try {
                if (jpaFilterData != null) {
                    for (JpaFilterParameterInfo filter : jpaFilterData.getParameters()) {
                        if (!varName.equals(filter.getParameterName())) continue;
                        varName = JavaCodeUtil.increment((String)varName);
                    }
                }
            }
            catch (RuntimeException runtimeException) {}
            return varName;
        }

        public void handleEvent(Event event) {
            if (event.widget == this.fIsConstantButton || event.widget == this.fIsVariableButton) {
                if (this.fIsConstantButton.getSelection()) {
                    this.isVariableName = false;
                    this.wtConstantValueComboText.setEnabled(true);
                    this.wtVariableValueText.setEnabled(false);
                } else {
                    this.isVariableName = true;
                    this.wtConstantValueComboText.setEnabled(false);
                    this.wtVariableValueText.setEnabled(true);
                }
            }
            SingleColumnConditionPart.this.getObservableInstance().setChanged();
            SingleColumnConditionPart.this.getObservable().notifyObservers(SingleColumnConditionPart.this.validateWholePart());
        }

        protected void updateConstantValueCombo() {
            this.wtConstantValueComboText.removeAll();
            List columnList = SingleColumnConditionPart.this.attributeConditionData.getColumnList();
            List stringColumnList = SingleColumnConditionPart.this.getAttributeNamesForFilter(columnList);
            if (stringColumnList != null) {
                Collections.sort(stringColumnList);
                this.wtConstantValueComboText.setItems(stringColumnList.toArray(new String[stringColumnList.size()]));
            }
        }

        protected void updateVariableNameText() {
            String columnName = this.getColumnNameText();
            String variableName = JavaCodeUtil.legalizeJavaIdentifier((String)columnName.replace('.', '_'));
            this.wtVariableValueText.setText(this.getUniqueVariableName(variableName, SingleColumnConditionPart.this.attributeConditionData.getJpaFilterData()));
        }

        public void updateVariableNameTextForComboChange() {
            if (!this.variableValueModified) {
                this.updateVariableNameText();
            }
        }

        public void updateWidgets(IQueryVariableValue singlevalue) {
            this.queryVariableValue = (IQueryVariableValue)((QueryVariableValue)singlevalue).clone();
            this.updateConstantValueCombo();
            this.updateVariableNameText();
            if (this.queryVariableValue.getVariableName() == null && this.queryVariableValue.getVariableValue() != null) {
                this.fIsConstantButton.setSelection(true);
                this.fIsVariableButton.setSelection(false);
                this.wtConstantValueComboText.setEnabled(true);
                this.wtVariableValueText.setEnabled(false);
                this.isVariableName = false;
                this.wtConstantValueComboText.setText(this.queryVariableValue.getVariableValue());
            } else {
                this.fIsVariableButton.setSelection(true);
                this.fIsConstantButton.setSelection(false);
                this.wtConstantValueComboText.setEnabled(false);
                this.wtVariableValueText.setEnabled(true);
                this.isVariableName = true;
                if (this.queryVariableValue.getVariableName() != null) {
                    String text = this.queryVariableValue.getVariableName();
                    if (text.indexOf(":") == 0) {
                        text = text.substring(1);
                    }
                    this.wtVariableValueText.setText(text);
                }
            }
        }

        public void updateWidgets(ISingleQueryColumn singleValue) {
            this.updateWidgets(((ISingleValueQueryColumn)((Object)singleValue)).getVariableValue());
        }

        @Override
        public IStatus validatePart() {
            if (this.fIsConstantButton.getSelection() && (this.wtConstantValueComboText.getText() == null || this.wtConstantValueComboText.getText().trim().equals(""))) {
                return new Status(4, "com.ibm.etools.webtools.jpa", JpaUI._UI_You_Must_Enter_Constant);
            }
            if (this.fIsVariableButton.getSelection() && (this.wtVariableValueText.getText() == null || this.wtVariableValueText.getText().trim().equals(""))) {
                return new Status(4, "com.ibm.etools.webtools.jpa", JpaUI._UI_You_Must_Enter_Variable);
            }
            if (this.fIsVariableButton.getSelection() && !SingleColumnConditionPart.this.isEdit) {
                JpaFilterInfo jpaFilterData = SingleColumnConditionPart.this.attributeConditionData.getJpaFilterData();
                String currentFilter = this.wtVariableValueText.getText();
                if (jpaFilterData != null) {
                    for (JpaFilterParameterInfo filter : jpaFilterData.getParameters()) {
                        if (!currentFilter.equals(filter.getParameterName())) continue;
                        return new Status(4, "com.ibm.etools.webtools.jpa", String.valueOf(JpaUI.variableNameAlreadyExists) + ":" + " " + currentFilter + ".  " + JpaUI.SingleColumnConditionPart_12);
                    }
                }
            }
            return new Status(0, "com.ibm.etools.webtools.jpa", "");
        }
    }

    protected class InOperatorPart
    implements OperatorPart,
    Listener,
    ISelectionChangedListener {
        protected List multiQueryVariableValues = new ArrayList();
        protected Composite inOperatorComposite;
        private TableViewer fAllValuesViewer;
        private Button fAddButton;
        private Button fEditButton;
        private Button fRemoveButton;
        private Button fUpButton;
        private Button fDownButton;
        private ILabelProvider fAllAttributesLabelProvider;
        private IStructuredContentProvider fAllAttributesContentProvider;

        protected InOperatorPart() {
        }

        @Override
        public void createControl(Composite parent) {
            this.inOperatorComposite = UIPartsUtil.createComposite(parent, 2, 1);
            this.fAllValuesViewer = new TableViewer(this.inOperatorComposite, 67586);
            this.fAllValuesViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            TableColumn tc = new TableColumn(this.fAllValuesViewer.getTable(), 0);
            tc.setText(JpaUI._UI_Values);
            this.fAllValuesViewer.setColumnProperties(new String[]{"Values"});
            this.fAllValuesViewer.setContentProvider(this.getAllColsContentProvider());
            this.fAllValuesViewer.setLabelProvider(this.getAllColsLabelProvider());
            this.fAllValuesViewer.getTable().setHeaderVisible(true);
            new SingleTableColumnMaximizer(this.fAllValuesViewer.getTable());
            GridData data = new GridData(1808);
            this.fAllValuesViewer.getTable().setLayoutData((Object)data);
            Composite buttonComposite = UIPartsUtil.createComposite(this.inOperatorComposite, 1, 1);
            data = new GridData();
            buttonComposite.setLayoutData((Object)data);
            ((GridLayout)buttonComposite.getLayout()).horizontalSpacing = 1;
            ((GridLayout)buttonComposite.getLayout()).marginWidth = 1;
            this.fAddButton = UIPartsUtil.createPushButton(buttonComposite, "", 1, false);
            this.fAddButton.setImage(JpaPlugin.getImage("icons/obj16/common/add.gif"));
            this.fEditButton = UIPartsUtil.createPushButton(buttonComposite, "", 1, false);
            this.fEditButton.setImage(JpaPlugin.getImage("icons/obj16/common/edit.gif"));
            this.fRemoveButton = UIPartsUtil.createPushButton(buttonComposite, "", 1, false);
            this.fRemoveButton.setImage(JpaPlugin.getImage("icons/obj16/common/remove.gif"));
            this.fUpButton = UIPartsUtil.createPushButton(buttonComposite, "", 1, false);
            this.fUpButton.setImage(JpaPlugin.getImage("icons/size16/up.gif"));
            this.fDownButton = UIPartsUtil.createPushButton(buttonComposite, "", 1, false);
            this.fDownButton.setImage(JpaPlugin.getImage("icons/size16/down.gif"));
            this.fAddButton.addListener(13, (Listener)this);
            this.fEditButton.addListener(13, (Listener)this);
            this.fRemoveButton.addListener(13, (Listener)this);
            this.fUpButton.addListener(13, (Listener)this);
            this.fDownButton.addListener(13, (Listener)this);
        }

        public void createRHSQueryColumn(ISingleColumnConditionData columnConditionData) {
            MultiValueQueryColumn mvqc = new MultiValueQueryColumn();
            mvqc.getMultiValues().clear();
            mvqc.getMultiValues().addAll(this.multiQueryVariableValues);
            columnConditionData.setRHSQueryColumn(mvqc);
        }

        private IContentProvider getAllColsContentProvider() {
            if (this.fAllAttributesContentProvider == null) {
                this.fAllAttributesContentProvider = new IStructuredContentProvider(){

                    public void dispose() {
                    }

                    public Object[] getElements(Object inputElement) {
                        Object[] ret = new Object[]{};
                        if (inputElement instanceof List) {
                            List allValuesList = (List)inputElement;
                            ret = allValuesList.toArray(new Object[allValuesList.size()]);
                        }
                        return ret;
                    }

                    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                    }
                };
            }
            return this.fAllAttributesContentProvider;
        }

        private IBaseLabelProvider getAllColsLabelProvider() {
            if (this.fAllAttributesLabelProvider == null) {
                this.fAllAttributesLabelProvider = new ILabelProvider(){

                    public void addListener(ILabelProviderListener listener) {
                    }

                    public void dispose() {
                    }

                    public Image getImage(Object element) {
                        return null;
                    }

                    public String getText(Object element) {
                        IQueryVariableValue value = (IQueryVariableValue)element;
                        if (value.getVariableName() != null) {
                            return value.getVariableName();
                        }
                        return value.getVariableValue();
                    }

                    public boolean isLabelProperty(Object element, String property) {
                        return false;
                    }

                    public void removeListener(ILabelProviderListener listener) {
                    }
                };
            }
            return this.fAllAttributesLabelProvider;
        }

        @Override
        public String getColumnNameText() {
            return SingleColumnConditionPart.this.wtAttributeNameCombo.getText();
        }

        @Override
        public Composite getComposite() {
            return this.inOperatorComposite;
        }

        private void handleAddButtonPressed() {
            QueryVariableValue qvv = new QueryVariableValue();
            VariableValueDialog dialog = new VariableValueDialog(this.getComposite().getShell(), qvv, false);
            if (dialog.open() == 0) {
                this.multiQueryVariableValues.add(dialog.getFirstResult());
                this.fAllValuesViewer.setInput((Object)this.multiQueryVariableValues);
                this.fAllValuesViewer.refresh();
            }
            SingleColumnConditionPart.this.getObservableInstance().setChanged();
            SingleColumnConditionPart.this.getObservable().notifyObservers(SingleColumnConditionPart.this.validateWholePart());
        }

        private void handleEditButtonPressed() {
            QueryVariableValue qvv = (QueryVariableValue)((IStructuredSelection)this.fAllValuesViewer.getSelection()).getFirstElement();
            VariableValueDialog dialog = new VariableValueDialog(this.getComposite().getShell(), (QueryVariableValue)qvv.clone(), true);
            if (dialog.open() == 0) {
                this.multiQueryVariableValues.set(this.multiQueryVariableValues.indexOf(qvv), dialog.getFirstResult());
                this.fAllValuesViewer.refresh();
            }
            SingleColumnConditionPart.this.getObservableInstance().setChanged();
            SingleColumnConditionPart.this.getObservable().notifyObservers(SingleColumnConditionPart.this.validateWholePart());
        }

        public void handleEvent(Event event) {
            Widget w = event.widget;
            if (w == this.fAddButton) {
                this.handleAddButtonPressed();
            } else if (w == this.fEditButton) {
                this.handleEditButtonPressed();
            } else if (w == this.fRemoveButton) {
                this.handleRemoveButtonPressed();
            } else if (w == this.fUpButton || w == this.fDownButton) {
                boolean moveUp = w == this.fUpButton;
                this.handleUpDownButtonPressed(moveUp);
            }
            this.updateWidgetStates();
        }

        private void handleRemoveButtonPressed() {
            this.multiQueryVariableValues.removeAll(((IStructuredSelection)this.fAllValuesViewer.getSelection()).toList());
            this.fAllValuesViewer.refresh();
            SingleColumnConditionPart.this.getObservableInstance().setChanged();
            SingleColumnConditionPart.this.getObservable().notifyObservers(SingleColumnConditionPart.this.validateWholePart());
        }

        private void handleUpDownButtonPressed(boolean moveUp) {
            Object source = ((IStructuredSelection)this.fAllValuesViewer.getSelection()).getFirstElement();
            int currentIndex = this.multiQueryVariableValues.indexOf(source);
            int toMoveIndex = moveUp ? currentIndex - 1 : currentIndex + 1;
            Object destination = this.multiQueryVariableValues.get(toMoveIndex);
            this.multiQueryVariableValues.set(toMoveIndex, source);
            this.multiQueryVariableValues.set(currentIndex, destination);
            this.fAllValuesViewer.refresh();
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.updateWidgetStates();
        }

        public void updateWidgets(ISingleQueryColumn attribute) {
            List origMultiValues = ((IMultiValueQueryColumn)((Object)attribute)).getMultiValues();
            this.multiQueryVariableValues.clear();
            for (QueryVariableValue origValue : origMultiValues) {
                QueryVariableValue newValue = (QueryVariableValue)origValue.clone();
                this.multiQueryVariableValues.add(newValue);
            }
            this.fAllValuesViewer.setInput((Object)this.multiQueryVariableValues);
            this.fAllValuesViewer.refresh();
            this.updateWidgetStates();
        }

        public void updateWidgetStates() {
            boolean isValuesEmpty = this.fAllValuesViewer.getSelection().isEmpty();
            this.fEditButton.setEnabled(!isValuesEmpty);
            this.fRemoveButton.setEnabled(!isValuesEmpty);
            this.fUpButton.setEnabled(!isValuesEmpty);
            this.fDownButton.setEnabled(!isValuesEmpty);
            if (!isValuesEmpty) {
                Object conditionData = ((StructuredSelection)this.fAllValuesViewer.getSelection()).getFirstElement();
                this.fUpButton.setEnabled(this.fAllValuesViewer.getElementAt(0) != conditionData);
                this.fDownButton.setEnabled(this.fAllValuesViewer.getElementAt(this.fAllValuesViewer.getTable().getItemCount() - 1) != conditionData);
            }
        }

        @Override
        public IStatus validatePart() {
            Status status = new Status(0, "com.ibm.etools.webtools.jpa", "");
            if (this.multiQueryVariableValues.size() == 0) {
                status = new Status(4, "com.ibm.etools.webtools.jpa", JpaUI._UI_You_Must_Enter_Value);
            }
            return status;
        }
    }

    protected class ObservableClass
    extends Observable {
        protected ObservableClass() {
        }

        @Override
        public synchronized void setChanged() {
            super.setChanged();
        }
    }

    protected static interface OperatorPart {
        public void createControl(Composite var1);

        public String getColumnNameText();

        public Composite getComposite();

        public IStatus validatePart();
    }

    protected class UnaryOperatorPart
    implements OperatorPart {
        protected Composite unaryOperatorComposite;

        protected UnaryOperatorPart() {
        }

        @Override
        public void createControl(Composite parent) {
            this.unaryOperatorComposite = UIPartsUtil.createComposite(parent, 1, 1);
        }

        @Override
        public String getColumnNameText() {
            return SingleColumnConditionPart.this.wtAttributeNameCombo.getText();
        }

        @Override
        public Composite getComposite() {
            return this.unaryOperatorComposite;
        }

        @Override
        public IStatus validatePart() {
            return new Status(0, "com.ibm.etools.webtools.jpa", "");
        }
    }

    protected class VariableValueDialog
    extends SelectionStatusDialog {
        private QueryVariableValue queryVariableValue;
        private BinaryOperatorPart binaryOperatorPart;
        protected Observer fStatusObserver;

        public VariableValueDialog(Shell parent, QueryVariableValue queryVariableValue, boolean isEdit) {
            super(parent);
            this.queryVariableValue = queryVariableValue;
            this.setShellStyle(this.getShellStyle() | 0x10);
            if (isEdit) {
                this.setTitle(JpaUI._UI_Edit_Value);
            } else {
                this.setTitle(JpaUI._UI_Add_Value);
            }
            this.setStatusLineAboveButtons(true);
        }

        protected void computeResult() {
            this.queryVariableValue = (QueryVariableValue)this.binaryOperatorPart.createQueryVariableValue();
            this.setResult(Arrays.asList(this.queryVariableValue));
        }

        protected Control createDialogArea(Composite parent) {
            Composite child = UIPartsUtil.createComposite(parent, 1, 1);
            GridData data = (GridData)child.getLayoutData();
            data.widthHint = 300;
            this.binaryOperatorPart = SingleColumnConditionPart.this.getNewBinaryOperatorPart(null);
            this.binaryOperatorPart.createControl(child);
            if (this.queryVariableValue != null) {
                this.binaryOperatorPart.updateWidgets(this.queryVariableValue);
            }
            return this.binaryOperatorPart.getComposite();
        }

        protected Observer getStatusObserver() {
            if (this.fStatusObserver == null) {
                this.fStatusObserver = new Observer(){

                    @Override
                    public void update(Observable o, Object arg) {
                        if (arg instanceof IStatus) {
                            VariableValueDialog.this.updateStatus((IStatus)arg);
                        }
                    }
                };
            }
            return this.fStatusObserver;
        }
    }
}

