/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.wizard.ui.taskPages.dialogs;

import com.ibm.etools.webtools.jpa.models.JpaQueryMethodInfo;
import com.ibm.etools.webtools.jpa.nls.JpaUI;
import com.ibm.etools.webtools.jpa.wizard.ui.QueryMethodContentProvider;
import com.ibm.etools.webtools.jpa.wizard.ui.QueryMethodLabelProvider;
import com.ibm.etools.webtools.jpa.wizard.ui.UIPartsUtil;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class SelectQueryDialog
extends TitleAreaDialog {
    private Table queryListTable;
    private TableViewer queryListTableViewer;
    private Text queryValueText;
    private List<JpaQueryMethodInfo> queryMethodInfos;
    private String selectedQueryName;
    private String selectedQueryValue;

    public SelectQueryDialog(Shell parentShell, List<JpaQueryMethodInfo> queryMethodInfos) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x20);
        this.queryMethodInfos = queryMethodInfos;
        Collections.sort(this.queryMethodInfos);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(JpaUI._UI_Select_Existing_Query);
        this.setTitle(JpaUI._UI_Select_Existing_Query);
        this.setMessage(JpaUI._UI_Select_Existing_Query_Message);
        Composite area = UIPartsUtil.createComposite(parent, 1, 1);
        GridLayout layout = (GridLayout)area.getLayout();
        layout.marginWidth = 2;
        UIPartsUtil.createSeparator(area, 256, 1);
        this.queryListTable = UIPartsUtil.createTable(area, 4, 1, false, false);
        GridData data = (GridData)this.queryListTable.getLayoutData();
        data.heightHint = 150;
        data.widthHint = 250;
        this.queryListTableViewer = new TableViewer(this.queryListTable);
        TableLayout tableLayout = new TableLayout();
        new TableColumn(this.queryListTable, 0);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        this.queryListTableViewer.setLabelProvider((IBaseLabelProvider)new QueryMethodLabelProvider(true));
        this.queryListTableViewer.setContentProvider((IContentProvider)new QueryMethodContentProvider());
        this.queryListTableViewer.setInput(this.queryMethodInfos);
        this.queryListTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object source = event.getSource();
                if (source.equals(SelectQueryDialog.this.queryListTableViewer)) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    JpaQueryMethodInfo selectedMethod = (JpaQueryMethodInfo)selection.getFirstElement();
                    if (selectedMethod == null) {
                        SelectQueryDialog.this.queryValueText.setText("");
                    } else if (selectedMethod.getQueryValue() != null) {
                        SelectQueryDialog.this.queryValueText.setText(selectedMethod.getQueryValue());
                        SelectQueryDialog.this.selectedQueryName = selectedMethod.getQueryName();
                        SelectQueryDialog.this.selectedQueryValue = selectedMethod.getQueryValue();
                    } else {
                        SelectQueryDialog.this.queryValueText.setText("");
                    }
                }
            }
        });
        this.queryListTable.setLayout((Layout)tableLayout);
        this.queryListTable.layout(true);
        this.queryValueText = UIPartsUtil.createMultiTextField(area, 1, 8, 35);
        return area;
    }

    public String getSelectedQueryName() {
        return this.selectedQueryName;
    }

    public String getSelectedQueryValue() {
        return this.selectedQueryValue;
    }
}

