/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.wizard.ui.taskPages.dialogs;

import com.ibm.etools.webtools.jpa.models.JpaAttributeInfo;
import com.ibm.etools.webtools.jpa.models.JpaManagerBeanInfo;
import com.ibm.etools.webtools.jpa.nls.JpaUI;
import com.ibm.etools.webtools.jpa.util.JpaUtil;
import com.ibm.etools.webtools.jpa.util.NamedQueriesUtil;
import com.ibm.etools.webtools.jpa.util.NamedQuerySelectParts;
import com.ibm.etools.webtools.jpa.wizard.ui.UIPartsUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class ResultBeanDialog
extends TitleAreaDialog {
    private JpaManagerBeanInfo managerBean;
    private NamedQuerySelectParts selectParts;
    private List<JpaAttributeInfo> allAttributes;
    private IType javaType;
    private Text beanNameText;
    private Button browseButton;
    private Combo constructorCombo;
    private Table mappingTable;
    private TableViewer mappingViewer;
    private TableColumn constructorColumn;
    private TableColumn attributeColumn;
    private ComboBoxCellEditor cellEditor;
    private List<IMethod> constructorList;
    private IMethod selectedConstructor;
    private List<MappingInfo> mappingInfos;
    private HashMap<String, List<String>> attributesByTableMap;
    private static String ALL_ATTRIBUTES = "ALL_ATTRIBUTES";

    public ResultBeanDialog(Shell parentShell, IDataModel model) {
        super(parentShell);
        this.managerBean = (JpaManagerBeanInfo)model.getProperty("IJpaDataModelProperties.userSelection");
        this.allAttributes = this.managerBean.getEntity().getAttributes();
        if (this.attributesByTableMap == null) {
            this.attributesByTableMap = new HashMap();
            ArrayList<String> allAttributeStrings = new ArrayList<String>();
            this.attributesByTableMap.put(ALL_ATTRIBUTES, allAttributeStrings);
            for (JpaAttributeInfo jpaAttributeInfo : this.allAttributes) {
                List<String> attributeStrings;
                String name = jpaAttributeInfo.getAttributeName();
                String type = jpaAttributeInfo.getAttributeType();
                if (type.indexOf(46) > 0) {
                    type = type.substring(type.lastIndexOf(46) + 1);
                }
                if ((attributeStrings = this.attributesByTableMap.get(type)) == null) {
                    attributeStrings = new ArrayList<String>();
                    this.attributesByTableMap.put(type, attributeStrings);
                }
                String entry = String.valueOf(name) + " : " + type;
                attributeStrings.add(entry);
                allAttributeStrings.add(entry);
            }
            for (List list : this.attributesByTableMap.values()) {
                Collections.sort(list);
            }
        }
        this.selectParts = new NamedQuerySelectParts("");
        this.selectParts.setQueryType(NamedQuerySelectParts.QUERY_TYPE.BEAN);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(JpaUI._UI_Select_Result_Bean);
        this.setTitle(JpaUI._UI_Select_Result_Bean);
        this.setMessage(JpaUI._UI_Select_Result_Bean_Message);
        Composite area = UIPartsUtil.createComposite(parent, 3, 1);
        GridLayout layout = (GridLayout)area.getLayout();
        layout.marginWidth = 5;
        UIPartsUtil.createSeparator(area, 256, 3);
        UIPartsUtil.createLabel(area, JpaUI._UI_Result_Bean_Class, 1);
        this.beanNameText = UIPartsUtil.createTextField(area, 1);
        this.beanNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ResultBeanDialog.this.javaType = JpaUtil.getType(ResultBeanDialog.this.managerBean.getProject(), ResultBeanDialog.this.beanNameText.getText());
                ResultBeanDialog.this.selectParts.setBeanName(ResultBeanDialog.this.beanNameText.getText());
                ResultBeanDialog.this.updateConstructorCombo();
                ResultBeanDialog.this.validate();
            }
        });
        this.browseButton = UIPartsUtil.createPushButton(area, JpaUI._UI_Browse, 1, false);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int result;
                SelectionDialog dialog = null;
                try {
                    dialog = JavaUI.createTypeDialog((Shell)ResultBeanDialog.this.getShell(), null, (IProject)ResultBeanDialog.this.managerBean.getProject(), (int)2, (boolean)false);
                    dialog.setTitle(JpaUI._UI_Select_Result_Bean);
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
                if (dialog != null && (result = dialog.open()) == 0) {
                    ResultBeanDialog.this.javaType = (IType)dialog.getResult()[0];
                    ResultBeanDialog.this.beanNameText.setText(ResultBeanDialog.this.javaType.getFullyQualifiedName());
                    ResultBeanDialog.this.updateConstructorCombo();
                    ResultBeanDialog.this.validate();
                }
            }
        });
        UIPartsUtil.createLabel(area, JpaUI._UI_Result_Bean_Constructor, 1);
        this.constructorCombo = UIPartsUtil.createCombo(area, 8, 1);
        this.constructorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = ResultBeanDialog.this.constructorCombo.getSelectionIndex();
                ResultBeanDialog.this.selectedConstructor = (IMethod)ResultBeanDialog.this.constructorList.get(index);
                ResultBeanDialog.this.updateMappingTable();
            }
        });
        UIPartsUtil.createLabel(area, "", 1);
        UIPartsUtil.createSeparator(area, 256, 3);
        this.createTablesComposite(area);
        this.setInitialState();
        return area;
    }

    private void createTablesComposite(Composite parent) {
        Composite tableComposite = UIPartsUtil.createComposite(parent, 1, 3);
        this.mappingTable = UIPartsUtil.createTable(tableComposite, 4, 1, true, true);
        GridData data = (GridData)this.mappingTable.getLayoutData();
        data.heightHint = 150;
        data.widthHint = 265;
        this.mappingViewer = new TableViewer(this.mappingTable);
        TableLayout layout = new TableLayout();
        this.constructorColumn = new TableColumn(this.mappingTable, 0);
        this.constructorColumn.setText("Constructor Parameters");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        this.attributeColumn = new TableColumn(this.mappingTable, 0);
        this.attributeColumn.setText("Entity Attributes");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        this.mappingViewer.setLabelProvider((IBaseLabelProvider)new ResultBeanLableProvider());
        this.mappingViewer.setContentProvider((IContentProvider)new ResultBeanContentProvider());
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = this.getCellEditor();
        this.mappingViewer.setCellEditors(cellEditorArray);
        this.mappingViewer.setColumnProperties(new String[]{"Constructor", "Attribute"});
        this.mappingViewer.setCellModifier((ICellModifier)new ResultBeanCellModifier());
        this.mappingTable.setLayout((Layout)layout);
        this.mappingTable.layout(true);
        this.mappingTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection s = (StructuredSelection)ResultBeanDialog.this.mappingViewer.getSelection();
                MappingInfo info = (MappingInfo)s.getFirstElement();
                String type = info.getTypeSig();
                type = Signature.getSignatureSimpleName((String)type);
                ResultBeanDialog.this.updateComboBoxCellEditorFilter(type);
            }
        });
    }

    private ComboBoxCellEditor getCellEditor() {
        if (this.cellEditor == null) {
            this.cellEditor = new ComboBoxCellEditor((Composite)this.mappingTable, new String[0], 8);
        }
        return this.cellEditor;
    }

    public NamedQuerySelectParts getSelectParts() {
        if (this.selectParts != null) {
            List<NamedQuerySelectParts.SelectParamType> paramTypes = this.selectParts.getParameterTypes();
            int count = 0;
            for (NamedQuerySelectParts.SelectParamType paramType : paramTypes) {
                String attributeName;
                paramType.attributeName = attributeName = String.valueOf(NamedQueriesUtil.getEntityVariable(this.managerBean.getEntity().getEntityName())) + "." + this.mappingInfos.get(count).getAttribute().getAttributeName();
                ++count;
            }
            return this.selectParts;
        }
        return null;
    }

    private void setInitialState() {
    }

    private void updateComboBoxCellEditorFilter(String filterType) {
        List<String> attributes = this.attributesByTableMap.get(filterType);
        if (attributes == null) {
            attributes = this.attributesByTableMap.get(ALL_ATTRIBUTES);
        }
        this.getCellEditor().setItems(attributes.toArray(new String[attributes.size()]));
    }

    private void updateConstructorCombo() {
        this.constructorList = new ArrayList<IMethod>();
        if (this.javaType != null) {
            try {
                IMethod[] methods = this.javaType.getMethods();
                int i = 0;
                while (i < methods.length) {
                    if (methods[i].isConstructor() && methods[i].getNumberOfParameters() > 0) {
                        this.constructorList.add(methods[i]);
                    }
                    ++i;
                }
                String[] constructorNames = new String[this.constructorList.size()];
                int count = 0;
                for (IMethod method : this.constructorList) {
                    String constructorName = String.valueOf(method.getElementName()) + "(";
                    int numParms = method.getNumberOfParameters();
                    String[] paramNames = method.getParameterNames();
                    String[] paramTypes = method.getParameterTypes();
                    int i2 = 0;
                    while (i2 < numParms) {
                        constructorName = String.valueOf(constructorName) + Signature.getSignatureSimpleName((String)paramTypes[i2]);
                        constructorName = String.valueOf(constructorName) + " " + paramNames[i2];
                        if (i2 != numParms - 1) {
                            constructorName = String.valueOf(constructorName) + ", ";
                        }
                        ++i2;
                    }
                    constructorNames[count] = String.valueOf(constructorName) + ")";
                    ++count;
                }
                this.constructorCombo.setItems(constructorNames);
                this.constructorCombo.select(0);
                this.selectedConstructor = this.constructorList.get(0);
                this.updateMappingTable();
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        } else {
            this.constructorCombo.setItems(new String[0]);
            this.selectedConstructor = null;
            this.updateMappingTable();
        }
    }

    private void updateMappingTable() {
        this.mappingInfos = new ArrayList<MappingInfo>();
        ArrayList<NamedQuerySelectParts.SelectParamType> paramTypesList = new ArrayList<NamedQuerySelectParts.SelectParamType>();
        if (this.selectedConstructor != null) {
            try {
                int numParams = this.selectedConstructor.getNumberOfParameters();
                String[] paramNames = this.selectedConstructor.getParameterNames();
                String[] paramTypes = this.selectedConstructor.getParameterTypes();
                int i = 0;
                while (i < numParams) {
                    this.mappingInfos.add(new MappingInfo(paramNames[i], null, paramTypes[i]));
                    NamedQuerySelectParts namedQuerySelectParts = this.selectParts;
                    namedQuerySelectParts.getClass();
                    paramTypesList.add(namedQuerySelectParts.new NamedQuerySelectParts.SelectParamType(null, null, null, NamedQuerySelectParts.PARAM_TYPE.PARAM));
                    ++i;
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        this.mappingViewer.setInput(this.mappingInfos);
        this.mappingViewer.refresh();
        this.selectParts.setParameterTypes(paramTypesList);
        this.validate();
    }

    private void validate() {
        if (this.getButton(0) != null) {
            if (this.javaType == null) {
                this.setErrorMessage(NLS.bind((String)JpaUI._UI_Not_Valid_Class, (Object)this.beanNameText.getText()));
                this.getButton(0).setEnabled(false);
            } else if (this.constructorList == null || this.constructorList.size() == 0) {
                this.setErrorMessage(NLS.bind((String)JpaUI._UI_Not_Valid_Constructor, (Object)this.beanNameText.getText()));
                this.getButton(0).setEnabled(false);
            } else {
                boolean isMappingOK = true;
                for (MappingInfo mapping : this.mappingInfos) {
                    if (mapping.getAttribute() != null) continue;
                    this.setErrorMessage(NLS.bind((String)"The constructor parameter {0} has not been mapped to an entity attribute.", (Object)mapping.getConstructor()));
                    this.getButton(0).setEnabled(false);
                    isMappingOK = false;
                }
                if (isMappingOK) {
                    this.getButton(0).setEnabled(true);
                    this.setErrorMessage(null);
                    this.setMessage(JpaUI._UI_Select_Result_Bean_Message);
                }
            }
        }
    }

    private class MappingInfo {
        private String constructor;
        private JpaAttributeInfo attribute;
        private String typeSig;

        public MappingInfo(String constructor, JpaAttributeInfo attriubte, String typeSig) {
            this.constructor = constructor;
            this.attribute = attriubte;
            this.typeSig = typeSig;
        }

        public JpaAttributeInfo getAttribute() {
            return this.attribute;
        }

        public String getConstructor() {
            return this.constructor;
        }

        public String getTypeSig() {
            return this.typeSig;
        }

        public void setAttribute(JpaAttributeInfo attribute) {
            this.attribute = attribute;
        }
    }

    private class ResultBeanCellModifier
    implements ICellModifier {
        private ResultBeanCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            if (property.equals("Attribute")) {
                return true;
            }
            return true;
        }

        public Object getValue(Object element, String property) {
            MappingInfo mapping;
            if (property.equals("Attribute") && (mapping = (MappingInfo)element).getAttribute() != null) {
                return ResultBeanDialog.this.allAttributes.indexOf(mapping.getAttribute());
            }
            return -1;
        }

        public void modify(Object element, String property, Object value) {
            TableItem item = (TableItem)element;
            MappingInfo mapping = (MappingInfo)item.getData();
            Integer val = (Integer)value;
            if (property.equals("Attribute") && val >= 0) {
                mapping.setAttribute((JpaAttributeInfo)ResultBeanDialog.this.allAttributes.get(val));
            }
            ResultBeanDialog.this.mappingViewer.refresh();
            ResultBeanDialog.this.validate();
        }
    }

    private class ResultBeanContentProvider
    implements IStructuredContentProvider {
        private ResultBeanContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object input) {
            if (input != null) {
                List mappingInfoInput = (List)input;
                return mappingInfoInput.toArray();
            }
            return new MappingInfo[0];
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }
    }

    private class ResultBeanLableProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ResultBeanLableProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Image ret = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
            if (columnIndex == 1 && element instanceof MappingInfo && ((MappingInfo)element).getAttribute() == null) {
                return ret;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof MappingInfo) {
                MappingInfo mapping = (MappingInfo)element;
                if (columnIndex == 0) {
                    return String.valueOf(mapping.getConstructor()) + " : " + Signature.getSignatureSimpleName((String)mapping.getTypeSig());
                }
                if (columnIndex == 1) {
                    if (mapping.getAttribute() != null) {
                        return String.valueOf(mapping.getAttribute().getAttributeName()) + " : " + mapping.getAttribute().getAttributeType();
                    }
                    return "Select an attribute...";
                }
            }
            return null;
        }
    }
}

