/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.wizard.ui.taskPages.dialogs;

import com.ibm.etools.webtools.jpa.JpaPlugin;
import com.ibm.etools.webtools.jpa.models.JpaAttributeInfo;
import com.ibm.etools.webtools.jpa.models.JpaManagerBeanInfo;
import com.ibm.etools.webtools.jpa.models.JpaQueryMethodInfo;
import com.ibm.etools.webtools.jpa.nls.JpaUI;
import com.ibm.etools.webtools.jpa.util.NamedQueriesUtil;
import com.ibm.etools.webtools.jpa.util.NamedQuerySelectParts;
import com.ibm.etools.webtools.jpa.wizard.ui.AttributeContentProvider;
import com.ibm.etools.webtools.jpa.wizard.ui.AttributeLabelProvider;
import com.ibm.etools.webtools.jpa.wizard.ui.UIPartsUtil;
import com.ibm.etools.webtools.jpa.wizard.ui.taskPages.dialogs.ResultBeanDialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class ResultAttributesPage {
    private Composite parent;
    private IDataModel model;
    private JpaManagerBeanInfo managerBean;
    private JpaQueryMethodInfo queryMethod;
    private List<JpaAttributeInfo> allAttributes;
    private List<JpaAttributeInfo> selectedAttributes;
    private Button attributeButton;
    private Button beanButton;
    private CheckboxTableViewer viewer;
    private Table table;
    private Button selectAllButton;
    private Button deSelectAllButton;
    private Button upButton;
    private Button downButton;
    private Button browseButton;

    public ResultAttributesPage(Composite parent, IDataModel model) {
        this.parent = parent;
        this.model = model;
        this.queryMethod = (JpaQueryMethodInfo)model.getProperty("IJpaDataModelProperties.selectedQueryMethod");
        this.managerBean = (JpaManagerBeanInfo)model.getProperty("IJpaDataModelProperties.userSelection");
        this.allAttributes = this.managerBean.getEntity().getAttributes();
        Collections.sort(this.allAttributes);
    }

    private Composite createAttributeComposite(Composite area) {
        Composite attributeComposite = UIPartsUtil.createComposite(area, 3, 3);
        GridData data = (GridData)attributeComposite.getLayoutData();
        data.horizontalIndent = 15;
        this.table = UIPartsUtil.createTable(attributeComposite, 34, 2, true, true);
        data = (GridData)this.table.getLayoutData();
        data.heightHint = 200;
        TableLayout layout = new TableLayout();
        TableColumn column = new TableColumn(this.table, 0);
        column.setText(JpaUI._UI_Column);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(5, true));
        TableColumn column2 = new TableColumn(this.table, 0);
        column2.setText(JpaUI._UI_Type);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, true));
        this.viewer = new CheckboxTableViewer(this.table);
        this.viewer.setLabelProvider((IBaseLabelProvider)new AttributeLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new AttributeContentProvider());
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ResultAttributesPage.this.handleQueryUpdate();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ResultAttributesPage.this.selectedAttributes = selection.toList();
                int itemCount = ResultAttributesPage.this.table.getItemCount();
                if (itemCount > 1 && ResultAttributesPage.this.selectedAttributes != null && ResultAttributesPage.this.selectedAttributes.size() > 0) {
                    ResultAttributesPage.this.upButton.setEnabled(ResultAttributesPage.this.allAttributes.get(0) != ResultAttributesPage.this.selectedAttributes.get(0));
                    ResultAttributesPage.this.downButton.setEnabled(ResultAttributesPage.this.allAttributes.get(itemCount - 1) != ResultAttributesPage.this.selectedAttributes.get(ResultAttributesPage.this.selectedAttributes.size() - 1));
                } else {
                    ResultAttributesPage.this.upButton.setEnabled(false);
                    ResultAttributesPage.this.downButton.setEnabled(false);
                }
            }
        });
        this.table.setLayout((Layout)layout);
        this.table.layout(true);
        this.createUpDownButtons(attributeComposite);
        this.createButtonsComposite(attributeComposite);
        return attributeComposite;
    }

    private Composite createBeanComposite(Composite area) {
        this.beanButton = UIPartsUtil.createRadioButton(area, JpaUI._UI_Select_Existing_Bean, 1, false);
        this.beanButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResultAttributesPage.this.handleBeanButtonSelected();
                ResultAttributesPage.this.handleQueryUpdate();
            }
        });
        this.browseButton = UIPartsUtil.createPushButton(area, JpaUI._UI_Select_Bean_Button, 1, false);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResultBeanDialog dialog = new ResultBeanDialog(ResultAttributesPage.this.parent.getShell(), ResultAttributesPage.this.model);
                if (dialog.open() == 0) {
                    NamedQuerySelectParts selectParts = dialog.getSelectParts();
                    ResultAttributesPage.this.queryMethod.setSelectParts(selectParts);
                    ResultAttributesPage.this.queryMethod.updateQuery(ResultAttributesPage.this.managerBean.getEntity());
                    ResultAttributesPage.this.model.notifyPropertyChange("IJpaDataModelProperties.selectedQueryMethod", 1);
                }
            }
        });
        Label spacer = UIPartsUtil.createLabel(area, "", 1);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        spacer.setLayoutData((Object)data);
        return area;
    }

    private Composite createButtonsComposite(Composite area) {
        Composite buttonComposite = UIPartsUtil.createComposite(area, 2, 3);
        ((GridLayout)buttonComposite.getLayout()).marginWidth = 0;
        ((GridLayout)buttonComposite.getLayout()).marginHeight = 0;
        this.selectAllButton = UIPartsUtil.createPushButton(buttonComposite, JpaUI._UI_Select_All, 1, false);
        this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResultAttributesPage.this.viewer.setAllChecked(true);
                ResultAttributesPage.this.handleQueryUpdate();
            }
        });
        this.selectAllButton.setFocus();
        this.deSelectAllButton = UIPartsUtil.createPushButton(buttonComposite, JpaUI._UI_Deselect_All, 1, false);
        this.deSelectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResultAttributesPage.this.viewer.setAllChecked(false);
                ResultAttributesPage.this.handleQueryUpdate();
            }
        });
        return buttonComposite;
    }

    private Composite createUpDownButtons(Composite area) {
        Composite updownComposite = UIPartsUtil.createComposite(area, 1, 1);
        ((GridLayout)updownComposite.getLayout()).marginWidth = 0;
        ((GridLayout)updownComposite.getLayout()).marginHeight = 0;
        GridData data = (GridData)updownComposite.getLayoutData();
        data.grabExcessHorizontalSpace = false;
        data.verticalAlignment = 0x1000000;
        this.upButton = UIPartsUtil.createPushButton(updownComposite, "", 1, false);
        this.upButton.setImage(JpaPlugin.getImage("icons/size16/up.gif"));
        this.upButton.setToolTipText(JpaUI._UI_Up);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResultAttributesPage.this.handleUpDownButton(true);
            }
        });
        this.downButton = UIPartsUtil.createPushButton(updownComposite, "", 1, false);
        this.downButton.setImage(JpaPlugin.getImage("icons/size16/down.gif"));
        this.downButton.setToolTipText(JpaUI._UI_Down);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResultAttributesPage.this.handleUpDownButton(false);
            }
        });
        return updownComposite;
    }

    public Composite getContents() {
        Composite area = UIPartsUtil.createComposite(this.parent, 3, 3);
        UIPartsUtil.createLabel(area, "", 3);
        this.attributeButton = UIPartsUtil.createRadioButton(area, JpaUI._UI_Select_Attributes, 3, true);
        this.attributeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResultAttributesPage.this.handleAttributeButtonSelected();
                ResultAttributesPage.this.handleQueryUpdate();
            }
        });
        this.createAttributeComposite(area);
        this.createBeanComposite(area);
        Label spacer = UIPartsUtil.createLabel(area, "", 2);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.horizontalSpan = 2;
        spacer.setLayoutData((Object)data);
        this.setInitialState();
        return area;
    }

    private void handleAttributeButtonSelected() {
        this.selectAllButton.setEnabled(true);
        this.deSelectAllButton.setEnabled(true);
        this.upButton.setEnabled(true);
        this.downButton.setEnabled(true);
        this.table.setEnabled(true);
        this.viewer.setAllGrayed(false);
        this.browseButton.setEnabled(false);
    }

    private void handleBeanButtonSelected() {
        this.selectAllButton.setEnabled(false);
        this.deSelectAllButton.setEnabled(false);
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        this.table.setEnabled(false);
        this.viewer.setAllGrayed(true);
        this.browseButton.setEnabled(true);
    }

    private void handleFunction() {
        this.selectAllButton.setEnabled(false);
        this.deSelectAllButton.setEnabled(false);
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        this.table.setEnabled(false);
        this.viewer.setAllGrayed(true);
        this.browseButton.setEnabled(false);
    }

    private void handleQueryUpdate() {
        NamedQuerySelectParts selectParts = this.queryMethod.getSelectParts();
        if (this.attributeButton.getSelection()) {
            Object[] checkedAttributes = this.viewer.getCheckedElements();
            if (checkedAttributes.length == this.table.getItemCount()) {
                selectParts.setQueryType(NamedQuerySelectParts.QUERY_TYPE.NORMAL);
                ArrayList<NamedQuerySelectParts.SelectParamType> paramTypes = new ArrayList<NamedQuerySelectParts.SelectParamType>();
                NamedQuerySelectParts namedQuerySelectParts = selectParts;
                namedQuerySelectParts.getClass();
                paramTypes.add(namedQuerySelectParts.new NamedQuerySelectParts.SelectParamType(NamedQueriesUtil.getEntityVariable(this.managerBean.getEntity().getEntityName()), null, null, NamedQuerySelectParts.PARAM_TYPE.PARAM));
                selectParts.setParameterTypes(paramTypes);
            } else {
                selectParts.setQueryType(NamedQuerySelectParts.QUERY_TYPE.PARAM);
                ArrayList<NamedQuerySelectParts.SelectParamType> paramTypes = new ArrayList<NamedQuerySelectParts.SelectParamType>();
                int i = 0;
                while (i < checkedAttributes.length) {
                    String attributeName = String.valueOf(NamedQueriesUtil.getEntityVariable(this.managerBean.getEntity().getEntityName())) + "." + ((JpaAttributeInfo)checkedAttributes[i]).getAttributeName();
                    NamedQuerySelectParts namedQuerySelectParts = selectParts;
                    namedQuerySelectParts.getClass();
                    paramTypes.add(namedQuerySelectParts.new NamedQuerySelectParts.SelectParamType(attributeName, null, null, NamedQuerySelectParts.PARAM_TYPE.PARAM));
                    ++i;
                }
                selectParts.setParameterTypes(paramTypes);
            }
        } else {
            selectParts.setBeanAndParse(selectParts.getBeanNameWithParams());
        }
        this.queryMethod.updateQuery(this.managerBean.getEntity());
        this.model.notifyPropertyChange("IJpaDataModelProperties.selectedQueryMethod", 1);
    }

    private void handleUpDownButton(boolean isUp) {
        int itemCount;
        if (!isUp) {
            Collections.reverse(this.selectedAttributes);
        }
        for (JpaAttributeInfo attribute : this.selectedAttributes) {
            int movedIndex = this.allAttributes.indexOf(attribute);
            if (isUp) {
                this.allAttributes.remove(movedIndex);
                this.allAttributes.add(movedIndex - 1, attribute);
                continue;
            }
            this.allAttributes.remove(movedIndex);
            this.allAttributes.add(movedIndex + 1, attribute);
        }
        if (!isUp) {
            Collections.reverse(this.selectedAttributes);
        }
        if ((itemCount = this.table.getItemCount()) > 1 && this.selectedAttributes != null) {
            this.upButton.setEnabled(this.allAttributes.get(0) != this.selectedAttributes.get(0));
            this.downButton.setEnabled(this.allAttributes.get(itemCount - 1) != this.selectedAttributes.get(this.selectedAttributes.size() - 1));
        } else {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
        this.viewer.refresh();
        this.handleQueryUpdate();
    }

    public void refresh() {
        this.setInitialState();
        if (this.viewer != null) {
            this.viewer.refresh();
        }
    }

    private void setInitialState() {
        NamedQuerySelectParts selectParts = this.queryMethod.getSelectParts();
        if (selectParts.getQueryType() == NamedQuerySelectParts.QUERY_TYPE.NORMAL) {
            List<NamedQuerySelectParts.SelectParamType> params = selectParts.getParameterTypes();
            if (params.get((int)0).type == NamedQuerySelectParts.PARAM_TYPE.PARAM) {
                this.viewer.setInput(this.allAttributes);
                this.attributeButton.setSelection(true);
                this.beanButton.setSelection(false);
                this.handleAttributeButtonSelected();
                this.viewer.setAllChecked(true);
            } else {
                this.viewer.setInput(this.allAttributes);
                this.attributeButton.setSelection(false);
                this.beanButton.setSelection(false);
                this.handleFunction();
                this.viewer.setAllChecked(false);
            }
        } else if (selectParts.getQueryType() == NamedQuerySelectParts.QUERY_TYPE.PARAM) {
            this.attributeButton.setSelection(true);
            this.beanButton.setSelection(false);
            this.handleAttributeButtonSelected();
            ArrayList<JpaAttributeInfo> orderedAttributes = new ArrayList<JpaAttributeInfo>();
            List<NamedQuerySelectParts.SelectParamType> params = selectParts.getParameterTypes();
            block0: for (NamedQuerySelectParts.SelectParamType param : params) {
                if (param.type != NamedQuerySelectParts.PARAM_TYPE.PARAM) continue;
                String paramAttribute = param.attributeName;
                int index = paramAttribute.indexOf(46);
                paramAttribute = paramAttribute.substring(index + 1);
                for (JpaAttributeInfo attribute : this.allAttributes) {
                    if (!paramAttribute.equals(attribute.getAttributeName())) continue;
                    orderedAttributes.add(attribute);
                    this.allAttributes.remove(attribute);
                    continue block0;
                }
            }
            this.allAttributes.addAll(0, orderedAttributes);
            this.viewer.setInput(this.allAttributes);
            this.viewer.setAllChecked(false);
            TableItem[] tableAttributes = this.viewer.getTable().getItems();
            block2: for (NamedQuerySelectParts.SelectParamType param : params) {
                if (param.type != NamedQuerySelectParts.PARAM_TYPE.PARAM) continue;
                String paramAttribute = param.attributeName;
                int index = paramAttribute.indexOf(46);
                paramAttribute = paramAttribute.substring(index + 1);
                int i = 0;
                while (i < tableAttributes.length) {
                    TableItem item = tableAttributes[i];
                    if (item.getText().equals(paramAttribute)) {
                        item.setChecked(true);
                        continue block2;
                    }
                    ++i;
                }
            }
        } else if (selectParts.getQueryType() == NamedQuerySelectParts.QUERY_TYPE.BEAN) {
            this.viewer.setInput(this.allAttributes);
            this.attributeButton.setSelection(false);
            this.beanButton.setSelection(true);
            this.handleBeanButtonSelected();
        } else {
            this.attributeButton.setSelection(false);
            this.beanButton.setSelection(false);
        }
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
    }
}

