/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.wizard.ui.taskPages.dialogs;

import com.ibm.etools.webtools.jpa.models.JpaManagerBeanInfo;
import com.ibm.etools.webtools.jpa.models.JpaQueryMethodInfo;
import com.ibm.etools.webtools.jpa.nls.JpaUI;
import com.ibm.etools.webtools.jpa.util.NamedQueriesUtil;
import com.ibm.etools.webtools.jpa.wizard.ui.UIPartsUtil;
import com.ibm.etools.webtools.jpa.wizard.ui.taskPages.dialogs.FilterPage;
import com.ibm.etools.webtools.jpa.wizard.ui.taskPages.dialogs.OrderByPage;
import com.ibm.etools.webtools.jpa.wizard.ui.taskPages.dialogs.ResultAttributesPage;
import com.ibm.etools.webtools.jpa.wizard.ui.taskPages.dialogs.SelectQueryDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;

public class AddEditMethodDialog
extends TitleAreaDialog
implements IDataModelListener {
    private IDataModel model;
    private JpaQueryMethodInfo queryMethod;
    private JpaManagerBeanInfo managerBean;
    private ResultAttributesPage resultAttributes;
    private FilterPage filter;
    private OrderByPage orderBy;
    private Text methodNameText;
    private Text queryNameText;
    private Text queryValueText;
    private Button selectExistingQueryButton;
    private TabItem resultColumnTab;
    private TabItem filterTab;
    private TabItem orderTab;
    private boolean isAdd;
    private boolean isConfigureEntities;
    private boolean hasQueryNameChanged = false;
    private String initialMethodName;
    private String initialQueryName;

    public AddEditMethodDialog(Shell parent, IDataModel model, boolean isAdd) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x20);
        this.model = model;
        this.isAdd = isAdd;
        this.queryMethod = (JpaQueryMethodInfo)this.model.getProperty("IJpaDataModelProperties.selectedQueryMethod");
        this.managerBean = (JpaManagerBeanInfo)this.model.getProperty("IJpaDataModelProperties.userSelection");
        this.isConfigureEntities = this.model.getBooleanProperty("IJpaDataModelProperties.isConfigureEntities");
        if (!isAdd) {
            this.initialQueryName = this.queryMethod.getQueryName();
            if (!this.isConfigureEntities) {
                this.initialMethodName = this.queryMethod.getMethodName();
            }
        }
    }

    protected void cancelPressed() {
        super.cancelPressed();
        this.model.removeListener((IDataModelListener)this);
    }

    protected Control createDialogArea(Composite parent) {
        if (this.isAdd) {
            if (this.isConfigureEntities) {
                this.getShell().setText(JpaUI._UI_Add_Query);
                this.setTitle(JpaUI._UI_Add_Query);
            } else {
                this.getShell().setText(JpaUI._UI_Add_Method);
                this.setTitle(JpaUI._UI_Add_Method);
            }
            this.setMessage(JpaUI._UI_Add_Method_Message);
        } else {
            if (this.isConfigureEntities) {
                this.getShell().setText(JpaUI._UI_Edit_Query);
                this.setTitle(JpaUI._UI_Edit_Query);
            } else {
                this.getShell().setText(JpaUI._UI_Edit_Method);
                this.setTitle(JpaUI._UI_Edit_Method);
            }
            this.setMessage(JpaUI._UI_Edit_Method_Message);
        }
        Composite area = UIPartsUtil.createComposite(parent, 2, 1);
        GridLayout layout = (GridLayout)area.getLayout();
        layout.marginHeight = 1;
        layout.marginWidth = 4;
        UIPartsUtil.createSeparator(area, 256, 2);
        if (!this.isConfigureEntities) {
            UIPartsUtil.createLabel(area, JpaUI._UI_Method_Name, 1);
            this.methodNameText = UIPartsUtil.createTextField(area, 1);
            this.methodNameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Text widget = (Text)e.getSource();
                    if (AddEditMethodDialog.this.queryMethod != null) {
                        AddEditMethodDialog.this.queryMethod.setMethodName(widget.getText());
                        if (!AddEditMethodDialog.this.hasQueryNameChanged && AddEditMethodDialog.this.isAdd) {
                            AddEditMethodDialog.this.queryNameText.setText(widget.getText());
                            AddEditMethodDialog.this.hasQueryNameChanged = false;
                        }
                    }
                    AddEditMethodDialog.this.validate();
                }
            });
            UIPartsUtil.createSeparator(area, 256, 2);
        }
        TabFolder tabFolder = new TabFolder(area, 0);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 350;
        data.horizontalSpan = 2;
        tabFolder.setLayoutData((Object)data);
        this.resultColumnTab = new TabItem(tabFolder, 0);
        this.resultColumnTab.setText(JpaUI._UI_Result_Attributes);
        this.resultColumnTab.setToolTipText(JpaUI._UI_Result_Attributes);
        this.resultColumnTab.setControl((Control)this.getResultColumnComposite((Composite)tabFolder));
        this.filterTab = new TabItem(tabFolder, 0);
        this.filterTab.setText(JpaUI._UI_Filter_Results);
        this.filterTab.setToolTipText(JpaUI._UI_Filter_Results);
        this.filterTab.setControl((Control)this.getFilterComposite((Composite)tabFolder));
        this.orderTab = new TabItem(tabFolder, 0);
        this.orderTab.setText(JpaUI._UI_Order_By_Task);
        this.orderTab.setToolTipText(JpaUI._UI_Order_By_Task);
        this.orderTab.setControl((Control)this.getOrderByComposite((Composite)tabFolder));
        tabFolder.setSelection(0);
        tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddEditMethodDialog.this.queryMethod.setQueryValue(AddEditMethodDialog.this.queryValueText.getText());
                if (event.item == AddEditMethodDialog.this.resultColumnTab) {
                    if (AddEditMethodDialog.this.resultAttributes != null) {
                        AddEditMethodDialog.this.resultAttributes.refresh();
                    }
                } else if (event.item == AddEditMethodDialog.this.filterTab) {
                    if (AddEditMethodDialog.this.filter != null) {
                        AddEditMethodDialog.this.filter.refresh();
                    }
                } else if (event.item == AddEditMethodDialog.this.orderTab && AddEditMethodDialog.this.orderBy != null) {
                    AddEditMethodDialog.this.orderBy.refresh();
                }
                AddEditMethodDialog.this.validate();
            }
        });
        Group queryGroup = UIPartsUtil.createGroup(area, 3, 2, JpaUI._UI_Query_Statement);
        UIPartsUtil.createLabel((Composite)queryGroup, JpaUI._UI_Query_Name, 1);
        int span = 1;
        if (this.isConfigureEntities) {
            span = 2;
        }
        this.queryNameText = UIPartsUtil.createTextField((Composite)queryGroup, span);
        this.queryNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text widget = (Text)e.getSource();
                if (AddEditMethodDialog.this.queryMethod != null) {
                    AddEditMethodDialog.this.queryMethod.setQueryName(widget.getText());
                    AddEditMethodDialog.this.hasQueryNameChanged = true;
                }
                AddEditMethodDialog.this.validate();
            }
        });
        if (!this.isConfigureEntities) {
            this.selectExistingQueryButton = UIPartsUtil.createPushButton((Composite)queryGroup, JpaUI._UI_Select_Query, 1, false);
            this.selectExistingQueryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SelectQueryDialog queryDialog = new SelectQueryDialog(AddEditMethodDialog.this.getShell(), NamedQueriesUtil.getNamedQueryMethods(AddEditMethodDialog.this.managerBean.getEntity(), false));
                    if (queryDialog.open() == 0) {
                        AddEditMethodDialog.this.queryNameText.setText(queryDialog.getSelectedQueryName());
                        AddEditMethodDialog.this.queryValueText.setText(queryDialog.getSelectedQueryValue());
                        AddEditMethodDialog.this.queryMethod.setQueryValue(queryDialog.getSelectedQueryValue());
                        if (AddEditMethodDialog.this.resultAttributes != null) {
                            AddEditMethodDialog.this.resultAttributes.refresh();
                        }
                        if (AddEditMethodDialog.this.filter != null) {
                            AddEditMethodDialog.this.filter.refresh();
                        }
                        if (AddEditMethodDialog.this.orderBy != null) {
                            AddEditMethodDialog.this.orderBy.refresh();
                        }
                    }
                }
            });
        }
        this.queryValueText = UIPartsUtil.createMultiTextField((Composite)queryGroup, 3, 0, 50);
        data = (GridData)this.queryValueText.getLayoutData();
        data.widthHint = 350;
        this.queryValueText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                Text widget = (Text)e.getSource();
                if (AddEditMethodDialog.this.queryMethod != null && !widget.getText().equals(AddEditMethodDialog.this.queryMethod.getQueryValue())) {
                    AddEditMethodDialog.this.queryMethod.setQueryValue(widget.getText());
                    if (AddEditMethodDialog.this.resultAttributes != null) {
                        AddEditMethodDialog.this.resultAttributes.refresh();
                    }
                    if (AddEditMethodDialog.this.filter != null) {
                        AddEditMethodDialog.this.filter.refresh();
                    }
                    if (AddEditMethodDialog.this.orderBy != null) {
                        AddEditMethodDialog.this.orderBy.refresh();
                    }
                }
            }
        });
        this.queryValueText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                Text widget = (Text)e.getSource();
                if (widget != null && e.keyCode == 13 || e.keyCode == 0x1000050) {
                    AddEditMethodDialog.this.queryMethod.setQueryValue(widget.getText());
                    if (AddEditMethodDialog.this.resultAttributes != null) {
                        AddEditMethodDialog.this.resultAttributes.refresh();
                    }
                    if (AddEditMethodDialog.this.filter != null) {
                        AddEditMethodDialog.this.filter.refresh();
                    }
                    if (AddEditMethodDialog.this.orderBy != null) {
                        AddEditMethodDialog.this.orderBy.refresh();
                    }
                }
            }
        });
        this.setInitialValues();
        this.model.addListener((IDataModelListener)this);
        return area;
    }

    private Composite getFilterComposite(Composite parent) {
        if (this.filter == null) {
            this.filter = new FilterPage(parent, this.model);
        }
        return this.filter.getContents();
    }

    private Composite getOrderByComposite(Composite parent) {
        if (this.orderBy == null) {
            this.orderBy = new OrderByPage(parent, this.model);
        }
        return this.orderBy.getContents();
    }

    private Composite getResultColumnComposite(Composite parent) {
        if (this.resultAttributes == null) {
            this.resultAttributes = new ResultAttributesPage(parent, this.model);
        }
        return this.resultAttributes.getContents();
    }

    protected void handleShellCloseEvent() {
        super.handleShellCloseEvent();
        this.model.removeListener((IDataModelListener)this);
    }

    protected void okPressed() {
        super.okPressed();
        this.model.removeListener((IDataModelListener)this);
    }

    public void propertyChanged(DataModelEvent event) {
        if (event.getPropertyName().equals("IJpaDataModelProperties.selectedQueryMethod") && event.getFlag() == 1) {
            this.queryValueText.setText(this.queryMethod.getQueryValue());
        }
    }

    public void setInitialValues() {
        this.hasQueryNameChanged = this.queryMethod.getQueryName() != null && !this.queryMethod.getQueryName().equals(this.queryMethod.getMethodName());
        boolean resetHasMethodQueryNameChanged = this.hasQueryNameChanged;
        if (!this.isConfigureEntities) {
            this.methodNameText.setText(this.queryMethod.getMethodName());
            this.methodNameText.selectAll();
        }
        if (this.queryNameText != null) {
            this.queryNameText.setText(this.queryMethod.getQueryName());
        }
        this.queryValueText.setText(this.queryMethod.getQueryValue());
        this.hasQueryNameChanged = resetHasMethodQueryNameChanged;
        this.validate();
    }

    private boolean validate() {
        if (this.getButton(0) != null) {
            String queryName;
            if (!this.isConfigureEntities) {
                String methodName = this.methodNameText.getText();
                if (methodName == null || methodName.length() < 1) {
                    this.setErrorMessage(JpaUI._UI_Validation_No_Method);
                    this.getButton(0).setEnabled(false);
                    return false;
                }
                for (JpaQueryMethodInfo dupQueryMethod : this.managerBean.getQueryMethods()) {
                    if (!methodName.equals(dupQueryMethod.getMethodName()) || dupQueryMethod.getStatus() == JpaQueryMethodInfo.STATUS.REMOVE || !this.isAdd && this.initialMethodName != null && this.initialMethodName.equals(methodName)) continue;
                    this.setErrorMessage(NLS.bind((String)JpaUI._UI_Validation_Duplicate, (Object)methodName));
                    this.getButton(0).setEnabled(false);
                    return false;
                }
            }
            if ((queryName = this.queryNameText.getText()) == null || queryName.length() < 1) {
                this.setErrorMessage(JpaUI._UI_Valication_No_Query_Name);
                this.getButton(0).setEnabled(false);
                return false;
            }
            for (JpaQueryMethodInfo dupQueryMethod : this.managerBean.getQueryMethods()) {
                if (!queryName.equals(dupQueryMethod.getQueryName()) || dupQueryMethod.getStatus() == JpaQueryMethodInfo.STATUS.REMOVE || !this.isAdd && this.initialQueryName != null && this.initialQueryName.equals(queryName)) continue;
                this.setErrorMessage(NLS.bind((String)JpaUI._UI_validation_Duplicate_Query, (Object)queryName));
                this.getButton(0).setEnabled(false);
                return false;
            }
            String query = this.queryValueText.getText();
            if (query == null || query.length() < 1) {
                this.setErrorMessage(JpaUI.AddEditMethodDialog_0);
                this.getButton(0).setEnabled(false);
                return false;
            }
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
            if (this.isAdd) {
                this.setMessage(JpaUI._UI_Add_Method_Message);
            } else {
                this.setMessage(JpaUI._UI_Edit_Method_Message);
            }
        }
        return true;
    }
}

