/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.wizard.ui.taskPages;

import com.ibm.etools.webtools.jpa.JpaPlugin;
import com.ibm.etools.webtools.jpa.models.JpaEntityInfo;
import com.ibm.etools.webtools.jpa.models.JpaManagerBeanInfo;
import com.ibm.etools.webtools.jpa.models.JpaQueryMethodInfo;
import com.ibm.etools.webtools.jpa.models.JpaRelationshipInfo;
import com.ibm.etools.webtools.jpa.nls.JpaUI;
import com.ibm.etools.webtools.jpa.util.JpaUtil;
import com.ibm.etools.webtools.jpa.wizard.ui.UIPartsUtil;
import com.ibm.etools.webtools.jpa.wizard.ui.taskPages.dialogs.AddRelationshipDialog;
import com.ibm.etools.webtools.slickui.SlickControlProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;

public class AddRelationshipControlProvider
extends SlickControlProvider
implements IDataModelListener {
    private IDataModel dataModel;
    private Button addButton;
    private Button deleteButton;
    private Table relationshipTable;
    private TableViewer relationshipTableViewer;
    private List<JpaRelationshipInfo> relationships;

    public Composite getContents(Composite parent) {
        if (this.dataModel == null) {
            this.dataModel = (IDataModel)this.modelObject;
            this.dataModel.addListener((IDataModelListener)this);
        }
        final Shell shell = parent.getShell();
        Composite area = UIPartsUtil.createComposite(parent, 2, 1);
        Label createLabel = UIPartsUtil.createLabel(area, JpaUI.AddRelationshipControlProvider_0, 2);
        GridData labelData = new GridData(0);
        labelData.horizontalSpan = 2;
        labelData.grabExcessHorizontalSpace = false;
        labelData.widthHint = 300;
        createLabel.setLayoutData((Object)labelData);
        this.relationshipTable = UIPartsUtil.createTable(area, 67586, 1, false, false);
        GridData data = (GridData)this.relationshipTable.getLayoutData();
        data.heightHint = 200;
        this.relationshipTableViewer = new TableViewer(this.relationshipTable);
        TableLayout layout = new TableLayout();
        TableColumn column = new TableColumn(this.relationshipTable, 0);
        column.setText(JpaUI.AddRelationshipControlProvider_1);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        this.relationshipTableViewer.setLabelProvider((IBaseLabelProvider)new RelationshipLabelProvider());
        this.relationshipTableViewer.setContentProvider((IContentProvider)new RelationshipContentProvider());
        this.relationshipTableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                int compareVal = -1;
                try {
                    compareVal = ((JpaRelationshipInfo)e1).getEntity().getEntityName().compareTo(((JpaRelationshipInfo)e2).getEntity().getEntityName());
                }
                catch (Exception exception) {}
                return compareVal;
            }
        });
        this.relationships = ((JpaManagerBeanInfo)this.dataModel.getProperty("IJpaDataModelProperties.userSelection")).getEntity().getRelationships();
        if (this.relationships == null) {
            this.relationships = new ArrayList<JpaRelationshipInfo>();
        }
        this.relationshipTableViewer.setInput(this.relationships);
        this.relationshipTable.setLayout((Layout)layout);
        this.relationshipTable.layout(true);
        Composite buttonComposite = UIPartsUtil.createComposite(area, 1, 1);
        data = (GridData)buttonComposite.getLayoutData();
        data.grabExcessHorizontalSpace = false;
        this.addButton = UIPartsUtil.createPushButton(buttonComposite, JpaUI._UI_Add, 1, false);
        data = (GridData)this.addButton.getLayoutData();
        data.verticalAlignment = 0x1000000;
        data.grabExcessHorizontalSpace = false;
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddRelationshipControlProvider.this.handleAddButton(shell);
            }
        });
        this.deleteButton = UIPartsUtil.createPushButton(buttonComposite, JpaUI._UI_Remove, 1, false);
        data = (GridData)this.deleteButton.getLayoutData();
        data.verticalAlignment = 0x1000000;
        data.grabExcessHorizontalSpace = false;
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddRelationshipControlProvider.this.handleDeleteButton();
            }
        });
        return area;
    }

    public IStatus getValidationState() {
        return new Status(0, "com.ibm.etools.webtools.jpa", "");
    }

    public void handleAddButton(Shell shell) {
        this.dataModel.setProperty("IJpaDataModelProperties.selectedRelationship", (Object)new JpaRelationshipInfo(null, null, JpaRelationshipInfo.STATUS.NEW));
        AddRelationshipDialog addDialog = new AddRelationshipDialog(shell, this.dataModel);
        if (addDialog.open() == 0) {
            JpaManagerBeanInfo thisManagerBean = (JpaManagerBeanInfo)this.dataModel.getProperty("IJpaDataModelProperties.userSelection");
            JpaRelationshipInfo relationship = (JpaRelationshipInfo)this.dataModel.getProperty("IJpaDataModelProperties.selectedRelationship");
            this.relationships.add(relationship);
            JpaEntityInfo relationshipEntity = relationship.getEntity();
            JpaRelationshipInfo.MULTIPLICITY relationshipMultiplicity = relationship.getMultiplicity();
            if (relationship.getDirectional() == JpaRelationshipInfo.DIRECTIONAL.BIDIRECTIONAL) {
                JpaRelationshipInfo otherSideRelationship = new JpaRelationshipInfo(null, null, JpaRelationshipInfo.STATUS.VIRTUAL);
                otherSideRelationship.setEntity(thisManagerBean.getEntity());
                if (relationshipMultiplicity == JpaRelationshipInfo.MULTIPLICITY.ONE_TO_MANY) {
                    relationshipMultiplicity = JpaRelationshipInfo.MULTIPLICITY.MANY_TO_ONE;
                } else if (relationshipMultiplicity == JpaRelationshipInfo.MULTIPLICITY.MANY_TO_ONE) {
                    relationshipMultiplicity = JpaRelationshipInfo.MULTIPLICITY.ONE_TO_MANY;
                }
                otherSideRelationship.setMultiplicity(relationshipMultiplicity);
                List allManagers = (List)this.dataModel.getProperty("IJpaDataModelProperties.availableSelections");
                if (allManagers != null) {
                    for (JpaManagerBeanInfo managerBean : allManagers) {
                        if (!JpaUtil.getJavaResourceFromPersistentType(managerBean.getEntity().getPersistentType()).getFullPath().equals((Object)JpaUtil.getJavaResourceFromPersistentType(relationshipEntity.getPersistentType()).getFullPath())) continue;
                        managerBean.getEntity().initializeIfNeeded();
                        List<JpaRelationshipInfo> otherRelationships = managerBean.getEntity().getRelationships();
                        otherRelationships.add(otherSideRelationship);
                        managerBean.setRelationshipAdded(true);
                        if (relationshipMultiplicity == JpaRelationshipInfo.MULTIPLICITY.MANY_TO_ONE) {
                            managerBean.initializeMethodsIfNeeded(false);
                            for (JpaQueryMethodInfo queryMethod : managerBean.getQueryMethods()) {
                                queryMethod.updateQueryForRelationship(relationship.getAttributeMappings().get(0).getForeignKey().getAttributeName(), thisManagerBean.getEntity());
                            }
                            continue;
                        }
                        if (relationshipMultiplicity != JpaRelationshipInfo.MULTIPLICITY.ONE_TO_MANY && relationshipMultiplicity != JpaRelationshipInfo.MULTIPLICITY.ONE_TO_ONE) continue;
                        thisManagerBean.initializeMethodsIfNeeded(false);
                        for (JpaQueryMethodInfo queryMethod : thisManagerBean.getQueryMethods()) {
                            queryMethod.updateQueryForRelationship(relationship.getAttributeMappings().get(0).getForeignKey().getAttributeName(), managerBean.getEntity());
                        }
                    }
                }
            } else {
                thisManagerBean.initializeMethodsIfNeeded(false);
                if (relationshipMultiplicity == JpaRelationshipInfo.MULTIPLICITY.MANY_TO_ONE || relationshipMultiplicity == JpaRelationshipInfo.MULTIPLICITY.ONE_TO_ONE) {
                    thisManagerBean.initializeMethodsIfNeeded(false);
                    for (JpaQueryMethodInfo queryMethod : thisManagerBean.getQueryMethods()) {
                        queryMethod.updateQueryForRelationship(relationship.getAttributeMappings().get(0).getForeignKey().getAttributeName(), relationshipEntity);
                    }
                }
            }
            thisManagerBean.getEntity().setRelationships(this.relationships);
            this.relationshipTableViewer.refresh();
        }
    }

    public void handleDeleteButton() {
        IStructuredSelection selection = (IStructuredSelection)this.relationshipTableViewer.getSelection();
        List selections = selection.toList();
        for (JpaRelationshipInfo relationship : selections) {
            if (relationship.getStatus() == JpaRelationshipInfo.STATUS.NEW || relationship.getStatus() == JpaRelationshipInfo.STATUS.VIRTUAL) {
                this.relationships.remove(relationship);
            } else if (relationship.getStatus() == JpaRelationshipInfo.STATUS.EXISTING) {
                relationship.setStatus(JpaRelationshipInfo.STATUS.REMOVED);
            }
            JpaManagerBeanInfo thisManagerBean = (JpaManagerBeanInfo)this.dataModel.getProperty("IJpaDataModelProperties.userSelection");
            JpaEntityInfo relationshipEntity = relationship.getEntity();
            JpaRelationshipInfo.MULTIPLICITY multiplicity = relationship.getMultiplicity();
            if (multiplicity == JpaRelationshipInfo.MULTIPLICITY.ONE_TO_MANY) {
                multiplicity = JpaRelationshipInfo.MULTIPLICITY.MANY_TO_ONE;
            } else if (multiplicity == JpaRelationshipInfo.MULTIPLICITY.MANY_TO_ONE) {
                multiplicity = JpaRelationshipInfo.MULTIPLICITY.ONE_TO_MANY;
            }
            List allManagers = (List)this.dataModel.getProperty("IJpaDataModelProperties.availableSelections");
            if (allManagers == null) continue;
            block1: for (JpaManagerBeanInfo managerBean : allManagers) {
                if (!JpaUtil.getJavaResourceFromPersistentType(managerBean.getEntity().getPersistentType()).getFullPath().equals((Object)JpaUtil.getJavaResourceFromPersistentType(relationshipEntity.getPersistentType()).getFullPath())) continue;
                managerBean.getEntity().initializeIfNeeded();
                List<JpaRelationshipInfo> otherRelationships = managerBean.getEntity().getRelationships();
                for (JpaRelationshipInfo otherRelationship : otherRelationships) {
                    if (otherRelationship.getMultiplicity() != multiplicity || !otherRelationship.getEntity().getFullyQualifiedEntityName().equals(thisManagerBean.getEntity().getFullyQualifiedEntityName())) continue;
                    if (otherRelationship.getStatus() == JpaRelationshipInfo.STATUS.NEW || otherRelationship.getStatus() == JpaRelationshipInfo.STATUS.VIRTUAL) {
                        otherRelationships.remove(otherRelationship);
                        continue block1;
                    }
                    if (managerBean.getEntity().getFullyQualifiedEntityName().equals(thisManagerBean.getEntity().getFullyQualifiedEntityName()) && otherRelationship.getStatus() != JpaRelationshipInfo.STATUS.REMOVED) {
                        otherRelationships.remove(otherRelationship);
                        continue block1;
                    }
                    if (otherRelationship.getStatus() != JpaRelationshipInfo.STATUS.EXISTING) continue block1;
                    otherRelationship.setStatus(JpaRelationshipInfo.STATUS.REMOVED);
                    continue block1;
                }
            }
        }
        this.relationshipTableViewer.refresh();
    }

    public void propertyChanged(DataModelEvent event) {
        JpaManagerBeanInfo managerBean;
        if (event.getPropertyName().equals("IJpaDataModelProperties.userSelection") && event.getFlag() == 1 && this.relationshipTableViewer != null && (managerBean = (JpaManagerBeanInfo)this.dataModel.getProperty("IJpaDataModelProperties.userSelection")) != null) {
            this.relationships = managerBean.getEntity().getRelationships();
            if (this.relationships == null) {
                this.relationships = new ArrayList<JpaRelationshipInfo>();
            }
            this.relationshipTableViewer.setInput(this.relationships);
            this.relationshipTableViewer.refresh();
        }
    }

    public boolean shouldShow(Object model) {
        return true;
    }

    private class RelationshipContentProvider
    implements IStructuredContentProvider {
        private RelationshipContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                List relationships = (List)inputElement;
                ArrayList<JpaRelationshipInfo> validRelationships = new ArrayList<JpaRelationshipInfo>();
                for (JpaRelationshipInfo relationship : relationships) {
                    if (relationship.getStatus() == JpaRelationshipInfo.STATUS.REMOVED) continue;
                    validRelationships.add(relationship);
                }
                if (validRelationships != null) {
                    return validRelationships.toArray();
                }
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class RelationshipLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private RelationshipLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex != 0) {
                return null;
            }
            if (element instanceof JpaRelationshipInfo) {
                JpaRelationshipInfo relationship = (JpaRelationshipInfo)element;
                JpaRelationshipInfo.MULTIPLICITY multiplicity = relationship.getMultiplicity();
                if (multiplicity == JpaRelationshipInfo.MULTIPLICITY.ONE_TO_ONE) {
                    return JpaPlugin.getImage("icons/size16/one-to-one.gif");
                }
                if (multiplicity == JpaRelationshipInfo.MULTIPLICITY.ONE_TO_MANY) {
                    return JpaPlugin.getImage("icons/size16/one-to-many.gif");
                }
                if (multiplicity == JpaRelationshipInfo.MULTIPLICITY.MANY_TO_ONE) {
                    return JpaPlugin.getImage("icons/size16/many-to-one.gif");
                }
                if (multiplicity == JpaRelationshipInfo.MULTIPLICITY.MANY_TO_MANY) {
                    return JpaPlugin.getImage("icons/size16/many-to-many.gif");
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof JpaRelationshipInfo) {
                JpaRelationshipInfo relationship = (JpaRelationshipInfo)element;
                if (columnIndex == 0) {
                    JpaEntityInfo entity = relationship.getEntity();
                    if (entity != null) {
                        return entity.getEntityName();
                    }
                    return JpaUI.AddRelationshipControlProvider_6;
                }
            }
            return "";
        }
    }
}

