/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.wizard.ui.pages;

import com.ibm.etools.webtools.jpa.JpaPlugin;
import com.ibm.etools.webtools.jpa.commands.JpaManagerBeanCommand;
import com.ibm.etools.webtools.jpa.models.JpaManagerBeanInfo;
import com.ibm.etools.webtools.jpa.nls.JpaUI;
import com.ibm.etools.webtools.jpa.util.JpaUtil;
import com.ibm.etools.webtools.jpa.wizard.ui.EntityLabelProvider;
import com.ibm.etools.webtools.jpa.wizard.ui.JpaManagerContentProvider;
import com.ibm.etools.webtools.jpa.wizard.ui.SingleTableColumnMaximizer;
import com.ibm.etools.webtools.jpa.wizard.ui.UIPartsUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;

public class PageLevelManagerBeanSelectionPage
extends DataModelWizardPage
implements ISelectionChangedListener,
SelectionListener {
    private TableViewer viewer;
    private Button newEntityButton;
    private Button list;
    private Button create;
    private Button display;
    private Button update;
    private MenuItem showFullPath;
    private List<JpaManagerBeanInfo> jpaManagerBeanInfos;

    public PageLevelManagerBeanSelectionPage(IDataModel model, String pageName) {
        super(model, pageName, JpaUI.PageLevelManagerBeanSelectionPage_0, JpaPlugin.getImageDescriptor("icons/wizban/jpa_data_wiz.gif"));
        this.setDescription(JpaUI.PageLevelManagerBeanSelectionPage_1);
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite area = UIPartsUtil.createComposite(parent, 2, 1);
        UIPartsUtil.createLabel(area, JpaUI.PageLevelManagerBeanSelectionPage_2, 2);
        Table table = UIPartsUtil.createTable(area, 67588, 1, false, false);
        GridData data = (GridData)table.getLayoutData();
        data.widthHint = 225;
        data.heightHint = 250;
        table.setLayoutData((Object)data);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        this.viewer = new TableViewer(table);
        this.viewer.setLabelProvider((IBaseLabelProvider)new EntityLabelProvider(false, true, false, false));
        this.viewer.setContentProvider((IContentProvider)new JpaManagerContentProvider(null, true, true));
        this.viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((JpaManagerBeanInfo)e1).getExistingManagerBeanType().getElementName().compareTo(((JpaManagerBeanInfo)e2).getExistingManagerBeanType().getElementName());
            }
        });
        JpaManagerBeanInfo existingInfo = (JpaManagerBeanInfo)this.model.getProperty("IJpaDataModelProperties.userSelection");
        if (existingInfo != null) {
            this.jpaManagerBeanInfos = new ArrayList<JpaManagerBeanInfo>();
            this.jpaManagerBeanInfos.add(existingInfo);
        } else {
            boolean showAllProjects = this.model.getBooleanProperty("IJpaDataModelProperties.showAllInClasspath");
            this.jpaManagerBeanInfos = JpaUtil.createExistingManagerBeanModels((IProject)this.model.getProperty("IJpaDataModelProperties.selectedProject"), showAllProjects);
        }
        this.viewer.setInput(this.jpaManagerBeanInfos);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        new SingleTableColumnMaximizer(table);
        Menu menu = new Menu((Control)area);
        table.setMenu(menu);
        this.showFullPath = new MenuItem(menu, 32);
        this.showFullPath.setText(JpaUI._UI_Fully_Qualified);
        this.showFullPath.setSelection(this.model.getBooleanProperty("IJpaDataModelProperties.showFullPath"));
        this.showFullPath.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                boolean existingSelection = PageLevelManagerBeanSelectionPage.this.model.getBooleanProperty("IJpaDataModelProperties.showFullPath");
                boolean newSelection = ((MenuItem)event.widget).getSelection();
                if (newSelection != existingSelection) {
                    PageLevelManagerBeanSelectionPage.this.model.setBooleanProperty("IJpaDataModelProperties.showFullPath", newSelection);
                }
            }
        });
        MenuItem showAll = new MenuItem(menu, 32);
        showAll.setText(JpaUI._UI_All_Managers);
        showAll.setSelection(this.model.getBooleanProperty("IJpaDataModelProperties.showAllInClasspath"));
        showAll.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                boolean existingSelection = PageLevelManagerBeanSelectionPage.this.model.getBooleanProperty("IJpaDataModelProperties.showAllInClasspath");
                boolean newSelection = ((MenuItem)event.widget).getSelection();
                if (newSelection != existingSelection) {
                    IProject currentProject = null;
                    if (!newSelection) {
                        currentProject = (IProject)PageLevelManagerBeanSelectionPage.this.model.getProperty("IJpaDataModelProperties.selectedProject");
                    }
                    PageLevelManagerBeanSelectionPage.this.model.setBooleanProperty("IJpaDataModelProperties.showAllInClasspath", newSelection);
                    PageLevelManagerBeanSelectionPage.this.viewer.setContentProvider((IContentProvider)new JpaManagerContentProvider(currentProject, newSelection, true));
                    PageLevelManagerBeanSelectionPage.this.viewer.refresh();
                }
            }
        });
        table.setLayout((Layout)layout);
        table.layout(true);
        this.newEntityButton = UIPartsUtil.createPushButton(area, JpaUI.PageLevelManagerBeanSelectionPage_3, 1, false);
        this.newEntityButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PageLevelManagerBeanSelectionPage.this.handleNewManagerButton();
            }
        });
        Group buttonGroup = UIPartsUtil.createGroup(area, 2, 2, JpaUI._UI_Select_Generation_Type_Label);
        this.list = UIPartsUtil.createRadioButton((Composite)buttonGroup, JpaUI._UI_List, 2, true);
        this.synchHelper.synchRadio(this.list, "IJpaDataModelProperties.generationTypeList", null);
        this.list.addSelectionListener((SelectionListener)this);
        this.display = UIPartsUtil.createRadioButton((Composite)buttonGroup, JpaUI._UI_Display, 2, false);
        this.synchHelper.synchRadio(this.display, "IJpaDataModelProperties.generationTypeDisplay", null);
        this.display.addSelectionListener((SelectionListener)this);
        this.create = UIPartsUtil.createRadioButton((Composite)buttonGroup, JpaUI._UI_Create, 2, false);
        this.synchHelper.synchRadio(this.create, "IJpaDataModelProperties.generationTypeCreate", null);
        this.create.addSelectionListener((SelectionListener)this);
        this.update = UIPartsUtil.createRadioButton((Composite)buttonGroup, JpaUI._UI_Update, 2, false);
        this.synchHelper.synchRadio(this.update, "IJpaDataModelProperties.generationTypeUpdate", null);
        this.update.addSelectionListener((SelectionListener)this);
        this.setInitialSelection();
        return area;
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"IJpaDataModelProperties.userSelection", "IJpaDataModelProperties.generateUI", "IJpaDataModelProperties.generationTypeList", "IJpaDataModelProperties.generationTypeDisplay", "IJpaDataModelProperties.generationTypeUpdate", "IJpaDataModelProperties.generationTypeCreate"};
    }

    private void handleNewManagerButton() {
        Object firstMethod;
        String generationType = this.model.getStringProperty("IJpaDataModelProperties.generationType");
        IProject project = (IProject)this.model.getProperty("IJpaDataModelProperties.selectedProject");
        JpaManagerBeanCommand cmd = new JpaManagerBeanCommand(project, this.getShell(), generationType, false, false);
        cmd.execute();
        boolean showAllProjects = this.model.getBooleanProperty("IJpaDataModelProperties.showAllInClasspath");
        this.jpaManagerBeanInfos = JpaUtil.createExistingManagerBeanModels(project, showAllProjects);
        this.viewer.setInput(this.jpaManagerBeanInfos);
        this.viewer.refresh();
        if (this.viewer != null && (firstMethod = this.viewer.getElementAt(0)) != null) {
            StructuredSelection selection = new StructuredSelection(firstMethod);
            this.viewer.setSelection((ISelection)selection);
        }
    }

    public void propertyChanged(DataModelEvent event) {
        if (event.getPropertyName().equals("IJpaDataModelProperties.showFullPath") && this.viewer != null) {
            boolean newValue = this.model.getBooleanProperty("IJpaDataModelProperties.showFullPath");
            this.showFullPath.setSelection(newValue);
            this.viewer.setLabelProvider((IBaseLabelProvider)new EntityLabelProvider(false, true, false, newValue));
            this.viewer.refresh();
        }
        super.propertyChanged(event);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object source = event.getSource();
        if (source.equals(this.viewer)) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            JpaManagerBeanInfo jpaManagerBean = (JpaManagerBeanInfo)selection.getFirstElement();
            this.model.setProperty("IJpaDataModelProperties.userSelection", (Object)jpaManagerBean);
        }
    }

    private void setInitialSelection() {
        Object firstMethod;
        if (this.viewer != null && (firstMethod = this.viewer.getElementAt(0)) != null) {
            StructuredSelection selection = new StructuredSelection(firstMethod);
            this.viewer.setSelection((ISelection)selection);
            if (firstMethod != null) {
                this.model.setProperty("IJpaDataModelProperties.userSelection", firstMethod);
            }
        }
        this.list.setSelection(true);
        this.model.setBooleanProperty("IJpaDataModelProperties.generationTypeList", true);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
    }
}

