/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.wizard.ui.pages;

import com.ibm.etools.webtools.jpa.JpaPlugin;
import com.ibm.etools.webtools.jpa.models.JpaEntityInfo;
import com.ibm.etools.webtools.jpa.models.JpaFilterInfo;
import com.ibm.etools.webtools.jpa.models.JpaFilterParameterInfo;
import com.ibm.etools.webtools.jpa.models.JpaManagerBeanInfo;
import com.ibm.etools.webtools.jpa.models.JpaQueryMethodInfo;
import com.ibm.etools.webtools.jpa.nls.JpaUI;
import com.ibm.etools.webtools.jpa.wizard.ui.UIPartsUtil;
import com.ibm.etools.webtools.jpa.wizard.ui.pages.BeanValueCellEditor;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataModelAdapter;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class PageLevelFilterValuesPage
extends DataModelWizardPage
implements IDataModelListener {
    private Table filtersTable;
    private TableViewer filtersViewer;
    private Button list;
    private Button display;
    private Button update;
    private TableColumn filterVariableCol;
    private TableColumn filterValueCol;
    private ICellModifier fFilterCellModifier;
    private BeanValueCellEditor beanValueCellEditor;
    private Text queryText;

    public PageLevelFilterValuesPage(IDataModel model, String pageName) {
        super(model, pageName, JpaUI.PageLevelFilterValuesPage_0, JpaPlugin.getImageDescriptor("icons/wizban/jpa_data_wiz.gif"));
        this.setDescription(JpaUI.PageLevelFilterValuesPage_1);
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite area = UIPartsUtil.createComposite(parent, 2, 1);
        JpaQueryMethodInfo queryMethod = (JpaQueryMethodInfo)this.model.getProperty("IJpaDataModelProperties.selectedQueryMethod");
        JpaManagerBeanInfo jpaManagerBean = (JpaManagerBeanInfo)this.model.getProperty("IJpaDataModelProperties.userSelection");
        JpaEntityInfo entity = jpaManagerBean.getEntity();
        JpaFilterInfo filterInfo = null;
        if (queryMethod != null) {
            filterInfo = queryMethod.getFilter(entity);
        }
        List<JpaFilterParameterInfo> parameters = null;
        if (filterInfo != null) {
            parameters = filterInfo.getParameters();
        }
        boolean showFilters = true;
        if (this.model.getBooleanProperty("IJpaDataModelProperties.isMethodPreselected") && (parameters == null || parameters.isEmpty())) {
            showFilters = false;
        }
        if (showFilters) {
            UIPartsUtil.createLabel(area, JpaUI._UI_Query_Statement, 2);
            this.queryText = UIPartsUtil.createMultiTextField(area, 2, 8, 30);
            ((GridData)this.queryText.getLayoutData()).grabExcessHorizontalSpace = false;
            ((GridData)this.queryText.getLayoutData()).widthHint = 225;
            Composite filtersComposite = UIPartsUtil.createComposite(area, 1, 1);
            ((GridLayout)filtersComposite.getLayout()).marginWidth = 1;
            ((GridLayout)filtersComposite.getLayout()).marginHeight = 1;
            this.filtersTable = UIPartsUtil.createTable(filtersComposite, 2, 1, true, true);
            this.filtersViewer = new TableViewer(this.filtersTable);
            TableLayout layout = new TableLayout();
            this.filterVariableCol = new TableColumn(this.filtersTable, 0);
            this.filterVariableCol.setText(JpaUI.PageLevelFilterValuesPage_2);
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, true));
            this.filterValueCol = new TableColumn(this.filtersTable, 0);
            this.filterValueCol.setText(JpaUI.PageLevelFilterValuesPage_3);
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(6, true));
            this.filtersViewer.setLabelProvider((IBaseLabelProvider)new FilterVariableLabelProvider());
            this.filtersViewer.setContentProvider((IContentProvider)new FilterVariableContentProvider());
            this.beanValueCellEditor = new BeanValueCellEditor((Composite)this.filtersTable, this.getPageDataModel(), this.filtersViewer, this.model);
            String elPrefix = this.model.getStringProperty("IJpaDataModelProperties.elPrefix");
            this.beanValueCellEditor.setELValuePrefix(elPrefix);
            this.filtersViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this.filtersTable), this.beanValueCellEditor});
            this.filtersViewer.setColumnProperties(new String[]{"Filter Variable", "Filter Value"});
            this.filtersViewer.setCellModifier(this.getFilterTableCellModifier());
            this.filtersViewer.setInput(parameters);
            this.filtersTable.setLayout((Layout)layout);
            this.filtersTable.layout(true);
            GridData data = new GridData(1808);
            this.filtersViewer.getTable().setLayoutData((Object)data);
            if (queryMethod != null) {
                if (queryMethod.getMethodType() == JpaQueryMethodInfo.METHOD_TYPE.QUERY) {
                    this.queryText.setText(queryMethod.getQueryValue());
                    this.filterVariableCol.setText(JpaUI.PageLevelFilterValuesPage_2);
                    this.filterValueCol.setText(JpaUI.PageLevelFilterValuesPage_3);
                } else {
                    this.queryText.setText(JpaUI.PageLevelFilterValuesPage_6);
                    this.filterVariableCol.setText(JpaUI.PageLevelFilterValuesPage_7);
                    this.filterValueCol.setText(JpaUI.PageLevelFilterValuesPage_8);
                }
            }
        } else {
            this.setTitle(JpaUI.PageLevelFilterValuesPage_5);
            this.setDescription(JpaUI.PageLevelFilterValuesPage_9);
        }
        if (this.model.getBooleanProperty("IJpaDataModelProperties.isMethodPreselected")) {
            Group buttonGroup;
            if (this.model.getBooleanProperty("IJpaDataModelProperties.generationTypeList")) {
                buttonGroup = UIPartsUtil.createGroup(area, 2, 2, JpaUI._UI_Select_Generation_Type_Label);
                this.list = UIPartsUtil.createRadioButton((Composite)buttonGroup, JpaUI._UI_List, 2, true);
                this.synchHelper.synchRadio(this.list, "IJpaDataModelProperties.generationTypeList", null);
                this.display = UIPartsUtil.createRadioButton((Composite)buttonGroup, JpaUI._UI_Display, 2, false);
                this.synchHelper.synchRadio(this.display, "IJpaDataModelProperties.generationTypeDisplay", null);
                this.update = UIPartsUtil.createRadioButton((Composite)buttonGroup, JpaUI._UI_Update, 2, false);
                this.synchHelper.synchRadio(this.update, "IJpaDataModelProperties.generationTypeUpdate", null);
            } else if (this.model.getBooleanProperty("IJpaDataModelProperties.generationTypeDisplay")) {
                buttonGroup = UIPartsUtil.createGroup(area, 2, 2, JpaUI._UI_Select_Generation_Type_Label);
                this.display = UIPartsUtil.createRadioButton((Composite)buttonGroup, JpaUI._UI_Display, 2, false);
                this.synchHelper.synchRadio(this.display, "IJpaDataModelProperties.generationTypeDisplay", null);
                this.update = UIPartsUtil.createRadioButton((Composite)buttonGroup, JpaUI._UI_Update, 2, false);
                this.synchHelper.synchRadio(this.update, "IJpaDataModelProperties.generationTypeUpdate", null);
            }
        }
        return area;
    }

    protected ICellModifier getFilterTableCellModifier() {
        if (this.fFilterCellModifier == null) {
            this.fFilterCellModifier = new ICellModifier(){

                public boolean canModify(Object element, String property) {
                    if (property.equals("Filter Value") || property.equals("Filter Variable")) {
                        this.highlightSelectedVariableInQuery(element);
                    }
                    return property.equals("Filter Value");
                }

                private void checkFiltersFilledIn() {
                    JpaEntityInfo entity;
                    JpaFilterInfo filterInfo;
                    List<JpaFilterParameterInfo> parameters;
                    JpaQueryMethodInfo queryMethod;
                    JpaManagerBeanInfo jpaManagerBean = (JpaManagerBeanInfo)PageLevelFilterValuesPage.this.getDataModel().getProperty("IJpaDataModelProperties.userSelection");
                    boolean filtersFilled = true;
                    if (jpaManagerBean != null && (queryMethod = (JpaQueryMethodInfo)PageLevelFilterValuesPage.this.getDataModel().getProperty("IJpaDataModelProperties.selectedQueryMethod")) != null && (parameters = (filterInfo = queryMethod.getFilter(entity = jpaManagerBean.getEntity())).getParameters()) != null && !parameters.isEmpty()) {
                        for (JpaFilterParameterInfo jpaFilterParameterInfo : parameters) {
                            if (jpaFilterParameterInfo.getParameterValue() != null && jpaFilterParameterInfo.getParameterValue().length() != 0) continue;
                            filtersFilled = false;
                            break;
                        }
                    }
                    PageLevelFilterValuesPage.this.model.setBooleanProperty("IJpaDataModelProperties.filterValuesFilled", filtersFilled);
                }

                public Object getValue(Object element, String property) {
                    String result = "";
                    if (property.equals("Filter Value")) {
                        JpaFilterParameterInfo jpaFilterParamInfo = (JpaFilterParameterInfo)element;
                        result = jpaFilterParamInfo.getParameterValue();
                    }
                    return result;
                }

                private void highlightSelectedVariableInQuery(Object element) {
                    if (element instanceof JpaFilterParameterInfo) {
                        boolean found = false;
                        JpaFilterParameterInfo paramInfo = (JpaFilterParameterInfo)element;
                        String paramName = paramInfo.getParameterName();
                        if (paramName != null && paramName.length() > 0) {
                            paramName = String.valueOf(':') + paramName;
                            String query = PageLevelFilterValuesPage.this.queryText.getText();
                            int paramIndex = query.indexOf(String.valueOf(paramName) + ' ');
                            if (paramIndex == -1) {
                                paramIndex = query.indexOf(paramName);
                                if (paramIndex != -1 && paramIndex + paramName.length() == query.length()) {
                                    found = true;
                                }
                            } else {
                                found = true;
                            }
                            if (found) {
                                PageLevelFilterValuesPage.this.queryText.setSelection(paramIndex, paramIndex + paramName.length());
                            }
                        }
                        if (!found) {
                            PageLevelFilterValuesPage.this.queryText.clearSelection();
                        }
                    }
                }

                public void modify(Object element, String property, Object value) {
                    TableItem item = (TableItem)element;
                    String input = (String)value;
                    if (input == null) {
                        input = "";
                    }
                    if (property.equals("Filter Value")) {
                        JpaFilterParameterInfo jpaFilterParamInfo = (JpaFilterParameterInfo)item.getData();
                        jpaFilterParamInfo.setParameterValue(input);
                        this.checkFiltersFilledIn();
                        PageLevelFilterValuesPage.this.filtersViewer.refresh();
                        PageLevelFilterValuesPage.this.beanValueCellEditor.setJpaFilterParamInfo(jpaFilterParamInfo);
                    }
                }
            };
        }
        return this.fFilterCellModifier;
    }

    private IPageDataModel getPageDataModel() {
        IDOMModel selectedJSPModel = (IDOMModel)this.model.getProperty("IJpaDataModelProperties.selectedJsp");
        IDOMDocument document = selectedJSPModel.getDocument();
        PageDataModelAdapter adapter = (PageDataModelAdapter)document.getAdapterFor((Object)PageDataModelAdapter.ADAPTER_KEY);
        IPageDataModel pModel = adapter.getPageDataModel();
        return pModel;
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"IJpaDataModelProperties.filterValuesFilled"};
    }

    public void propertyChanged(DataModelEvent event) {
        super.propertyChanged(event);
        if (event.getPropertyName().equals("IJpaDataModelProperties.selectedQueryMethod") && this.filtersViewer != null) {
            JpaFilterInfo filterInfo;
            JpaManagerBeanInfo jpaManagerBean = (JpaManagerBeanInfo)this.model.getProperty("IJpaDataModelProperties.userSelection");
            JpaQueryMethodInfo queryMethod = (JpaQueryMethodInfo)this.model.getProperty("IJpaDataModelProperties.selectedQueryMethod");
            JpaEntityInfo entity = jpaManagerBean.getEntity();
            if (queryMethod != null && (filterInfo = queryMethod.getFilter(entity)) != null) {
                List<JpaFilterParameterInfo> parameters = filterInfo.getParameters();
                if (queryMethod.getMethodType() == JpaQueryMethodInfo.METHOD_TYPE.QUERY) {
                    this.queryText.setText(queryMethod.getQueryValue());
                    this.filterVariableCol.setText(JpaUI.PageLevelFilterValuesPage_2);
                    this.filterValueCol.setText(JpaUI.PageLevelFilterValuesPage_3);
                } else {
                    this.queryText.setText(JpaUI.PageLevelFilterValuesPage_12);
                    this.filterVariableCol.setText(JpaUI.PageLevelFilterValuesPage_7);
                    this.filterValueCol.setText(JpaUI.PageLevelFilterValuesPage_8);
                }
                this.filtersViewer.setInput(parameters);
                this.filtersViewer.refresh();
            }
        }
    }

    protected boolean showValidationErrorsOnEnter() {
        return true;
    }

    private class FilterVariableContentProvider
    implements IStructuredContentProvider {
        private FilterVariableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                List parameters = (List)inputElement;
                return parameters.toArray();
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class FilterVariableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private FilterVariableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof JpaFilterParameterInfo) {
                JpaFilterParameterInfo filter = (JpaFilterParameterInfo)element;
                if (columnIndex == 0) {
                    return filter.getParameterName();
                }
                if (columnIndex == 1 && filter.getParameterValue() != null) {
                    return filter.getParameterValue();
                }
            }
            return "";
        }
    }
}

