/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.wizard.ui.pages;

import com.ibm.etools.webtools.jpa.JpaPlugin;
import com.ibm.etools.webtools.jpa.dali.GenerateEntitiesActionExt;
import com.ibm.etools.webtools.jpa.models.JpaManagerBeanInfo;
import com.ibm.etools.webtools.jpa.nls.JpaUI;
import com.ibm.etools.webtools.jpa.util.FacetUtil;
import com.ibm.etools.webtools.jpa.util.JpaUtil;
import com.ibm.etools.webtools.jpa.wizard.ui.EntityLabelProvider;
import com.ibm.etools.webtools.jpa.wizard.ui.JpaManagerContentProvider;
import com.ibm.etools.webtools.jpa.wizard.ui.SingleTableColumnMaximizer;
import com.ibm.etools.webtools.jpa.wizard.ui.UIPartsUtil;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.internal.JpaModelManager;
import org.eclipse.jpt.core.internal.SynchronousJpaProjectUpdater;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;

public class EntitySelectionPage
extends DataModelWizardPage
implements IHyperlinkListener {
    private static final String DEFAULT_ENTITIES_GEN_PACKAGE = "entities";
    public static final String JPA_MANAGER_BEANS_DESCRIPTION_HELP_ID = "com.ibm.etools.webtools.jpa.webjpa003";
    private CheckboxTableViewer viewer;
    private Button newEntityButton;
    private Button selectAllButton;
    private Button deSelectAllButton;
    private MenuItem showFullPath;
    private List<JpaManagerBeanInfo> availableEntities;

    public EntitySelectionPage(IDataModel model, String pageName) {
        super(model, pageName, JpaUI._UI_New_JPA_Manager_Control_Wizard_Title, JpaPlugin.getImageDescriptor("icons/wizban/gen_beans_wiz.gif"));
        if (model.getBooleanProperty("IJpaDataModelProperties.isConfigureEntities")) {
            this.setTitle(JpaUI._UI_Configure_Entities_Title);
            this.setDescription(JpaUI._UI_Configure_Entities_Description);
        } else {
            this.setTitle(JpaUI._UI_New_JPA_Manager_Control_Wizard_Title);
            this.setDescription(JpaUI._UI_New_JPA_Data_Control_Wizard_Desc);
        }
    }

    private static IPackageFragmentRoot getPackageFragmentRoot(IProject project) {
        IPackageFragmentRoot[] sourceFolders;
        IPackageFragmentRoot packageFragmentRoot = null;
        if (project != null && (sourceFolders = J2EEProjectUtilities.getSourceContainers((IProject)project)).length > 0) {
            packageFragmentRoot = sourceFolders[0];
        }
        return packageFragmentRoot;
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite area = UIPartsUtil.createComposite(parent, 2, 1);
        if (!this.model.getBooleanProperty("IJpaDataModelProperties.isConfigureEntities") && !this.model.getBooleanProperty("IJpaManagerBeanDataModelProperties.isConfigureAll")) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)area, JPA_MANAGER_BEANS_DESCRIPTION_HELP_ID);
        }
        UIPartsUtil.createLabel(area, JpaUI._UI_Create_New_Entity_Label, 2);
        Table table = UIPartsUtil.createTable(area, 34, 1, false, true);
        GridData data = (GridData)table.getLayoutData();
        data.widthHint = 300;
        data.heightHint = 250;
        TableLayout layout = new TableLayout();
        TableColumn column = new TableColumn(table, 0);
        column.setText(JpaUI._UI_Entity_Name);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        this.viewer = new CheckboxTableViewer(table);
        this.viewer.setLabelProvider((IBaseLabelProvider)new EntityLabelProvider());
        boolean showAllInClasspath = this.model.getBooleanProperty("IJpaDataModelProperties.showAllInClasspath");
        IProject currentProject = (IProject)this.model.getProperty("IJpaDataModelProperties.selectedProject");
        this.viewer.setContentProvider((IContentProvider)new JpaManagerContentProvider(currentProject, showAllInClasspath, false));
        this.viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((JpaManagerBeanInfo)e1).getEntity().getName().compareTo(((JpaManagerBeanInfo)e2).getEntity().getName());
            }
        });
        this.availableEntities = (List)this.model.getProperty("IJpaDataModelProperties.availableSelections");
        this.viewer.setInput(this.availableEntities);
        this.synchHelper.synchCheckBoxTableViewer(this.viewer, "IJpaDataModelProperties.userSelections", null);
        new SingleTableColumnMaximizer(table);
        Menu menu = new Menu((Control)area);
        table.setMenu(menu);
        this.showFullPath = new MenuItem(menu, 32);
        this.showFullPath.setText(JpaUI._UI_Fully_Qualified);
        this.showFullPath.setSelection(this.model.getBooleanProperty("IJpaDataModelProperties.showFullPath"));
        this.showFullPath.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                boolean existingSelection = EntitySelectionPage.this.model.getBooleanProperty("IJpaDataModelProperties.showFullPath");
                boolean newSelection = ((MenuItem)event.widget).getSelection();
                if (newSelection != existingSelection) {
                    EntitySelectionPage.this.model.setBooleanProperty("IJpaDataModelProperties.showFullPath", newSelection);
                }
            }
        });
        MenuItem showAll = new MenuItem(menu, 32);
        showAll.setText(JpaUI._UI_All_Entities);
        showAll.setSelection(this.model.getBooleanProperty("IJpaDataModelProperties.showAllInClasspath"));
        showAll.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                boolean existingSelection = EntitySelectionPage.this.model.getBooleanProperty("IJpaDataModelProperties.showAllInClasspath");
                boolean newSelection = ((MenuItem)event.widget).getSelection();
                if (newSelection != existingSelection) {
                    IProject currentProject = null;
                    if (!newSelection) {
                        currentProject = (IProject)EntitySelectionPage.this.model.getProperty("IJpaDataModelProperties.selectedProject");
                    }
                    EntitySelectionPage.this.model.setBooleanProperty("IJpaDataModelProperties.showAllInClasspath", newSelection);
                    EntitySelectionPage.this.viewer.setContentProvider((IContentProvider)new JpaManagerContentProvider(currentProject, newSelection, false));
                    EntitySelectionPage.this.viewer.refresh();
                }
            }
        });
        table.setLayout((Layout)layout);
        table.layout(true);
        this.newEntityButton = UIPartsUtil.createPushButton(area, JpaUI._UI_New_Entity, 1, false);
        this.newEntityButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EntitySelectionPage.this.handleNewEntityButton();
            }
        });
        Composite buttonComposite = UIPartsUtil.createComposite(area, 2, 1);
        ((GridLayout)buttonComposite.getLayout()).marginWidth = 0;
        ((GridLayout)buttonComposite.getLayout()).marginHeight = 0;
        this.selectAllButton = UIPartsUtil.createPushButton(buttonComposite, JpaUI._UI_Select_All, 1, false);
        this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EntitySelectionPage.this.handleSelectAllButton();
            }
        });
        this.selectAllButton.setFocus();
        this.deSelectAllButton = UIPartsUtil.createPushButton(buttonComposite, JpaUI._UI_Deselect_All, 1, false);
        this.deSelectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EntitySelectionPage.this.handleDeselectAllButton();
            }
        });
        if (!this.model.getBooleanProperty("IJpaDataModelProperties.isConfigureEntities") && !this.model.getBooleanProperty("IJpaManagerBeanDataModelProperties.isConfigureAll")) {
            Hyperlink linkToHelp = UIPartsUtil.createHyperLink(area, JpaUI.JpaManagerBeanWizardHelp);
            GridData data2 = new GridData(32);
            linkToHelp.setLayoutData((Object)data2);
            linkToHelp.addHyperlinkListener((IHyperlinkListener)this);
        }
        return area;
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"IJpaDataModelProperties.userSelections"};
    }

    private void handleDeselectAllButton() {
        this.viewer.setAllChecked(false);
        this.model.setProperty("IJpaDataModelProperties.userSelections", (Object)new Object[0]);
    }

    private void handleNewEntityButton() {
        IProject project = (IProject)this.model.getProperty("IJpaDataModelProperties.selectedProject");
        if (FacetUtil.installJpaFacetIfNeeded(project, (IProgressMonitor)new NullProgressMonitor())) {
            JpaProject jpaProject = null;
            try {
                jpaProject = JpaModelManager.instance().getJpaProject(project);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            IPackageFragment packageFragment = null;
            for (JpaManagerBeanInfo info : this.availableEntities) {
                IResource resource;
                ICompilationUnit compilationUnit;
                IType findPrimaryType;
                if (info.getEntity().getPersistentType() != null && (findPrimaryType = (compilationUnit = JavaCore.createCompilationUnitFrom((IFile)((IFile)(resource = JpaUtil.getJavaResourceFromPersistentType(info.getEntity().getPersistentType()))))).findPrimaryType()) != null && (packageFragment = findPrimaryType.getPackageFragment()) != null) break;
            }
            if (packageFragment == null) {
                IPackageFragmentRoot root = EntitySelectionPage.getPackageFragmentRoot(jpaProject.getProject());
                packageFragment = root.getPackageFragment(DEFAULT_ENTITIES_GEN_PACKAGE);
            }
            GenerateEntitiesActionExt action = new GenerateEntitiesActionExt();
            action.launchWizard(jpaProject, (IWorkbenchPart)this.model.getProperty("IJpaManagerBeanDataModelProperties.targetPart"), packageFragment);
            CreateManagersRunnable runnable = new CreateManagersRunnable(this.model, this.availableEntities, this.viewer);
            runnable.schedule();
        }
    }

    private void handleSelectAllButton() {
        this.viewer.setAllChecked(true);
        Object[] checkedItems = this.viewer.getCheckedElements();
        this.model.setProperty("IJpaDataModelProperties.userSelections", (Object)checkedItems);
    }

    public void linkActivated(HyperlinkEvent e) {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp(JPA_MANAGER_BEANS_DESCRIPTION_HELP_ID);
    }

    public void linkEntered(HyperlinkEvent e) {
    }

    public void linkExited(HyperlinkEvent e) {
    }

    public void propertyChanged(DataModelEvent event) {
        if (event.getPropertyName().equals("IJpaDataModelProperties.showFullPath") && this.viewer != null) {
            boolean newValue = this.model.getBooleanProperty("IJpaDataModelProperties.showFullPath");
            this.showFullPath.setSelection(newValue);
            this.viewer.setLabelProvider((IBaseLabelProvider)new EntityLabelProvider(false, false, false, newValue));
            this.viewer.refresh();
        }
        super.propertyChanged(event);
    }

    static class CreateManagersRunnable
    extends WorkspaceJob {
        private static IDataModel model;
        private static List<JpaManagerBeanInfo> availableEntities;
        private static CheckboxTableViewer viewer;

        CreateManagersRunnable(IDataModel model, List<JpaManagerBeanInfo> availableEntities, CheckboxTableViewer viewer) {
            super("Generating Entities");
            CreateManagersRunnable.model = model;
            CreateManagersRunnable.availableEntities = availableEntities;
            CreateManagersRunnable.viewer = viewer;
            IProject project = (IProject)model.getProperty("IJpaDataModelProperties.selectedProject");
            this.setRule((ISchedulingRule)project);
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            Display display = Display.getDefault();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    IProject project = (IProject)model.getProperty("IJpaDataModelProperties.selectedProject");
                    JpaProject jpaProject = null;
                    try {
                        jpaProject = JpaModelManager.instance().getJpaProject(project);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    JpaProject.Updater originalUpdater = jpaProject.getUpdater();
                    SynchronousJpaProjectUpdater syncUpdater = new SynchronousJpaProjectUpdater(jpaProject);
                    jpaProject.setUpdater((JpaProject.Updater)syncUpdater);
                    boolean showAllProjects = model.getBooleanProperty("IJpaDataModelProperties.showAllInClasspath");
                    List<JpaManagerBeanInfo> currentEntities = JpaUtil.createManagerBeanModels(project, showAllProjects);
                    for (JpaManagerBeanInfo info : currentEntities) {
                        if (JpaUtil.contains(availableEntities, info.getEntity().getName())) continue;
                        availableEntities.add(info);
                    }
                    model.setProperty("IJpaDataModelProperties.availableSelections", (Object)availableEntities);
                    viewer.refresh();
                    jpaProject.setUpdater(originalUpdater);
                }
            });
            return Status.OK_STATUS;
        }
    }
}

