/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.wizard.ui.pages;

import com.ibm.etools.webtools.jpa.JpaPlugin;
import com.ibm.etools.webtools.jpa.models.JpaEntityInfo;
import com.ibm.etools.webtools.jpa.models.JpaFilterInfo;
import com.ibm.etools.webtools.jpa.models.JpaFilterParameterInfo;
import com.ibm.etools.webtools.jpa.models.JpaManagerBeanInfo;
import com.ibm.etools.webtools.jpa.models.JpaQueryMethodInfo;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedataview.ui.SelectPageDataDialog;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class BeanValueCellEditor
extends DialogCellEditor {
    private Text text;
    private Button result;
    private IPageDataModel model = null;
    private Composite parent = null;
    private String fELValuePrefix;
    private JpaFilterParameterInfo jpaFilterParamInfo;
    private final TableViewer filtersViewer;
    private final IDataModel datamodel;
    private Composite editorComposite;
    private MouseListener mouseListener;

    public BeanValueCellEditor(Composite parent, IPageDataModel model, TableViewer filtersViewer, IDataModel datamodel) {
        super(parent);
        this.parent = parent;
        this.model = model;
        this.filtersViewer = filtersViewer;
        this.datamodel = datamodel;
    }

    private void checkFiltersFilledIn() {
        JpaEntityInfo entity;
        JpaFilterInfo filterInfo;
        List<JpaFilterParameterInfo> parameters;
        JpaQueryMethodInfo queryMethod;
        JpaManagerBeanInfo jpaManagerBean = (JpaManagerBeanInfo)this.datamodel.getProperty("IJpaDataModelProperties.userSelection");
        boolean filtersFilled = true;
        if (jpaManagerBean != null && (queryMethod = (JpaQueryMethodInfo)this.datamodel.getProperty("IJpaDataModelProperties.selectedQueryMethod")) != null && (parameters = (filterInfo = queryMethod.getFilter(entity = jpaManagerBean.getEntity())).getParameters()) != null && !parameters.isEmpty()) {
            for (JpaFilterParameterInfo jpaFilterParameterInfo : parameters) {
                if (jpaFilterParameterInfo.getParameterValue() != null && jpaFilterParameterInfo.getParameterValue().length() != 0) continue;
                filtersFilled = false;
                break;
            }
        }
        this.datamodel.setBooleanProperty("IJpaDataModelProperties.filterValuesFilled", filtersFilled);
    }

    protected Button createButton(Composite parent) {
        this.editorComposite = parent;
        this.result = new Button(parent, 0x800400);
        this.result.setText("...");
        Image img = JpaPlugin.getImage("icons/size16/compute.gif");
        this.result.setImage(img);
        this.result.addMouseListener(this.getMouseListener());
        this.result.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    BeanValueCellEditor.this.handleCancelEditor();
                    e.doit = false;
                }
                if (e.detail == 16) {
                    Event event = new Event();
                    event.detail = e.detail;
                    BeanValueCellEditor.this.getControl().notifyListeners(31, event);
                    e.doit = false;
                }
                if (e.detail == 8) {
                    BeanValueCellEditor.this.text.setFocus();
                    e.doit = false;
                }
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (!SWT.getPlatform().equalsIgnoreCase("win32")) {
                    BeanValueCellEditor.this.handleFocusGained(e);
                }
            }

            public void focusLost(FocusEvent e) {
                BeanValueCellEditor.this.handleFocusLost(e);
            }
        });
        return this.result;
    }

    protected Control createContents(Composite cell) {
        this.text = new Text(cell, 4);
        this.text.setFont(cell.getFont());
        this.text.setBackground(cell.getBackground());
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    BeanValueCellEditor.this.handleCancelEditor();
                    e.doit = false;
                }
                if (e.detail == 4) {
                    BeanValueCellEditor.this.handleApplyEditorValue();
                    e.doit = false;
                }
                if (e.detail == 16) {
                    BeanValueCellEditor.this.result.setFocus();
                    e.doit = false;
                }
                if (e.detail == 8) {
                    Event event = new Event();
                    event.detail = e.detail;
                    BeanValueCellEditor.this.getControl().notifyListeners(31, event);
                    e.doit = false;
                }
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (!SWT.getPlatform().equalsIgnoreCase("win32")) {
                    BeanValueCellEditor.this.handleFocusGained(e);
                }
            }

            public void focusLost(FocusEvent e) {
                BeanValueCellEditor.this.handleFocusLost(e);
            }
        });
        return this.text;
    }

    protected Object doGetValue() {
        return this.text.getText();
    }

    protected void doSetFocus() {
        if (this.text != null) {
            this.text.selectAll();
            this.text.setFocus();
        }
    }

    private String getELValuePrefix() {
        return this.fELValuePrefix;
    }

    private MouseListener getMouseListener() {
        if (this.mouseListener == null) {
            this.mouseListener = new MouseListener(){

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                    if (BeanValueCellEditor.this.editorComposite == null) {
                        return;
                    }
                    Object newValue = BeanValueCellEditor.this.openDialogBox((Control)BeanValueCellEditor.this.editorComposite);
                    if (newValue != null) {
                        boolean newValidState = BeanValueCellEditor.this.isCorrect(newValue);
                        if (newValidState) {
                            BeanValueCellEditor.this.markDirty();
                            BeanValueCellEditor.this.doSetValue(newValue);
                        } else {
                            BeanValueCellEditor.this.setErrorMessage(MessageFormat.format(BeanValueCellEditor.this.getErrorMessage(), newValue.toString()));
                        }
                        BeanValueCellEditor.this.fireApplyEditorValue();
                    }
                }

                public void mouseUp(MouseEvent e) {
                }
            };
        }
        return this.mouseListener;
    }

    public Text getTextControl() {
        return this.text;
    }

    private void handleApplyEditorValue() {
        this.fireApplyEditorValue();
    }

    private void handleCancelEditor() {
        this.fireCancelEditor();
    }

    private void handleFocusGained(FocusEvent e) {
        Widget cfr_ignored_0 = e.widget;
    }

    private void handleFocusLost(FocusEvent e) {
        if (e.widget == this.text && this.result.isFocusControl() || e.widget == this.result) {
            return;
        }
        this.focusLost();
    }

    boolean openBeanPropertyDialog() {
        String modelreference;
        SelectPageDataDialog dialog = new SelectPageDataDialog(this.parent.getShell(), this.model);
        dialog.setELValuePrefix(this.getELValuePrefix());
        if (dialog.open() == 0 && (modelreference = dialog.getReferenceString()) != null && modelreference.length() > 0) {
            this.text.setText(modelreference);
            this.jpaFilterParamInfo.setParameterValue(modelreference);
            this.filtersViewer.refresh();
            this.checkFiltersFilledIn();
        }
        return true;
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        Object ret = this.getValue();
        if (this.openBeanPropertyDialog()) {
            this.fireApplyEditorValue();
            ret = this.getValue();
        }
        return ret;
    }

    public void setELValuePrefix(String elValuePrefix) {
        this.fELValuePrefix = elValuePrefix;
    }

    public void setJpaFilterParamInfo(JpaFilterParameterInfo jpaFilterParamInfo) {
        this.jpaFilterParamInfo = jpaFilterParamInfo;
    }

    public void setModel(IPageDataModel model) {
        this.model = model;
    }

    protected void updateContents(Object value) {
        if (this.text != null) {
            if (value != null) {
                this.text.setText(value.toString());
            } else {
                this.text.setText("");
            }
        }
    }
}

