/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.wizard.ui;

import com.ibm.etools.webtools.jpa.JpaPlugin;
import com.ibm.etools.webtools.jpa.models.JpaManagerBeanInfo;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class EntityLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private boolean useManagerBeanName;
    private boolean showErrors;
    private boolean isConfigureEntities;
    private boolean showFullPath;

    public EntityLabelProvider() {
        this(false, false, false, false);
    }

    public EntityLabelProvider(boolean showErrors, boolean useManagerBeanName, boolean isConfigureEntities, boolean showFullPath) {
        this.useManagerBeanName = useManagerBeanName;
        this.showErrors = showErrors;
        this.isConfigureEntities = isConfigureEntities;
        this.showFullPath = showFullPath;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        JpaManagerBeanInfo info;
        if (this.showErrors && !(info = (JpaManagerBeanInfo)element).isValid()) {
            if (this.isConfigureEntities) {
                return JFaceResources.getImage((String)"dialog_messasge_warning_image");
            }
            return JFaceResources.getImage((String)"dialog_message_error_image");
        }
        if (this.useManagerBeanName) {
            return JpaPlugin.getImageDescriptor("icons/obj16/jpa_mngbean_obj.gif").createImage();
        }
        return JpaPlugin.getImageDescriptor("icons/obj16/jpa_obj.gif").createImage();
    }

    public String getColumnText(Object element, int columnIndex) {
        JpaManagerBeanInfo info = null;
        if (element instanceof JpaManagerBeanInfo) {
            info = (JpaManagerBeanInfo)element;
            if (this.useManagerBeanName) {
                if (this.showFullPath) {
                    return info.getFullyQualifiedName();
                }
                return info.getManagerBeanName();
            }
            if (this.showFullPath) {
                return info.getEntity().getFullyQualifiedEntityName();
            }
            return info.getEntity().getName();
        }
        return null;
    }
}

