/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.wizard.operations;

import com.ibm.etools.webtools.jpa.JpaPlugin;
import com.ibm.etools.webtools.jpa.nls.JpaUI;
import com.ibm.etools.webtools.jpa.util.JPAClassPathVariableInitializer;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.osgi.framework.Bundle;

public class JpaPageOperation
extends AbstractDataModelOperation {
    private static final String WEB_JPA_JAR = "web-jpa.jar";
    private static final String LIB_PATH = "/WEB-INF/lib";
    private static final String LIB = "lib";

    public JpaPageOperation(IDataModel model) {
        super(model);
    }

    private static String getSourceLocation(String jarName) {
        try {
            return FileLocator.toFileURL((URL)FileLocator.find((Bundle)JpaPlugin.getDefault().getBundle(), (IPath)new Path("lib/" + jarName), null)).getPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static IFile getTargetFile(IProject project, String jarName) {
        IVirtualComponent module = ComponentCore.createComponent((IProject)project);
        IContainer rootFolder = module.getRootFolder().getUnderlyingFolder();
        IFolder libFolder = rootFolder.getFolder((IPath)new Path(LIB_PATH));
        return libFolder.getFile(jarName);
    }

    public static void importWebJpaJar(IProject project, IProgressMonitor monitor) throws ExecutionException {
        IFile webJpaJar = JpaPageOperation.getTargetFile(project, WEB_JPA_JAR);
        if (!webJpaJar.exists()) {
            String source = JpaPageOperation.getSourceLocation(WEB_JPA_JAR);
            try {
                FileInputStream input = new FileInputStream(source);
                webJpaJar.create((InputStream)input, true, monitor);
            }
            catch (FileNotFoundException e) {
                throw new ExecutionException(JpaUI._Error_During_WEB_JPA_Import, (Throwable)e);
            }
            catch (CoreException e) {
                throw new ExecutionException(JpaUI._Error_During_WEB_JPA_Import, (Throwable)e);
            }
        }
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IProject project = (IProject)this.model.getProperty("IJpaDataModelProperties.selectedProject");
        JpaPageOperation.importWebJpaJar(project, monitor);
        try {
            JPAClassPathVariableInitializer.addJPADevResources(project, monitor);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return null;
    }
}

