/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.wizard.operations;

import com.ibm.etools.webtools.jpa.codegen.CodeGenOperation;
import com.ibm.etools.webtools.jpa.connection.AutoDeployJDBCUIJob;
import com.ibm.etools.webtools.jpa.models.JpaEntityInfo;
import com.ibm.etools.webtools.jpa.models.JpaManagerBeanInfo;
import com.ibm.etools.webtools.jpa.util.JPAClassPathVariableInitializer;
import com.ibm.etools.webtools.jpa.wizard.model.IJpaPageDataModelProperties;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.internal.JpaModelManager;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class JpaOperation
extends AbstractDataModelOperation
implements IJpaPageDataModelProperties {
    public JpaOperation(IDataModel model) {
        super(model);
    }

    public static JpaProject getPersistenceXMLProject(IProject project, List<JpaManagerBeanInfo> selectedEntities) {
        IProject foundProject = null;
        IProject firstProjectContainingEntities = null;
        for (JpaManagerBeanInfo jpaManagerBeanInfo : selectedEntities) {
            IProject currentProject = null;
            JpaEntityInfo entity = jpaManagerBeanInfo.getEntity();
            if (entity != null) {
                PersistentType persistentType = entity.getPersistentType();
                currentProject = persistentType != null ? persistentType.getJpaProject().getProject() : entity.getProject();
            }
            if (firstProjectContainingEntities == null) {
                firstProjectContainingEntities = currentProject;
            }
            if (!currentProject.equals((Object)project)) continue;
            foundProject = currentProject;
            break;
        }
        IProject selectedProject = null;
        selectedProject = foundProject != null ? foundProject : (firstProjectContainingEntities != null ? firstProjectContainingEntities : project);
        JpaProject jpaProject = null;
        try {
            jpaProject = JpaModelManager.instance().getJpaProject(selectedProject);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return jpaProject;
    }

    public static List<JpaManagerBeanInfo> getSelectedEntities(IDataModel model) {
        Object[] selectedManagerBeans = (Object[])model.getProperty("IJpaDataModelProperties.userSelections");
        ArrayList<JpaManagerBeanInfo> managerBeans = new ArrayList<JpaManagerBeanInfo>();
        Object[] objectArray = selectedManagerBeans;
        int n = selectedManagerBeans.length;
        int n2 = 0;
        while (n2 < n) {
            Object i = objectArray[n2];
            JpaManagerBeanInfo managerBean = (JpaManagerBeanInfo)i;
            managerBean.setRelationshipAdded(false);
            managerBeans.add(managerBean);
            ++n2;
        }
        List allManagerBeans = (List)model.getProperty("IJpaDataModelProperties.availableSelections");
        if (allManagerBeans != null) {
            for (JpaManagerBeanInfo managerBean : allManagerBeans) {
                if (!managerBean.getRelationshipAdded() || managerBean.getQueryMethods() == null || managerBean.getQueryMethods().isEmpty()) continue;
                managerBeans.add(managerBean);
            }
        }
        return managerBeans;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        JpaProject jpaProject;
        List<JpaManagerBeanInfo> selectedEntities = JpaOperation.getSelectedEntities(this.model);
        monitor.beginTask("", 100);
        monitor.worked(1);
        IProject project = (IProject)this.model.getProperty("IJpaDataModelProperties.selectedProject");
        boolean isConfigureEntities = this.model.getBooleanProperty("IJpaDataModelProperties.isConfigureEntities");
        if (!isConfigureEntities) {
            try {
                JPAClassPathVariableInitializer.addJPADevResources(project, monitor);
            }
            catch (JavaModelException e1) {
                e1.printStackTrace();
            }
        }
        CodeGenOperation codeGenOp = new CodeGenOperation(selectedEntities, this.model.getStringProperty("IJpaDataModelProperties.generationType"), this.model.getBooleanProperty("IJpaDataModelProperties.runOperationInBackground"), isConfigureEntities, this.model.getBooleanProperty("IJpaDataModelProperties.isConfigure"));
        try {
            codeGenOp.run(monitor);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.model.getBooleanProperty("IJpaManagerBeanDataModelProperties.autoDeploy") && (jpaProject = JpaOperation.getPersistenceXMLProject(project, selectedEntities)) != null) {
            AutoDeployJDBCUIJob job = new AutoDeployJDBCUIJob(jpaProject);
            job.schedule();
        }
        monitor.done();
        return null;
    }
}

