/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.util;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TypeCoercionUtil {
    public static final int BUFFER_SIZE = 1024;
    public static final int OBJECT = 0;
    public static final int BOOLEAN = 1;
    public static final int BYTE = 2;
    public static final int SHORT = 3;
    public static final int STRING = 4;
    public static final int DOUBLE = 5;
    public static final int LONG = 6;
    public static final int FLOAT = 7;
    public static final int INTEGER = 8;
    public static final int BIGDECIMAL = 9;
    public static final int DATE = 10;
    public static final int TIME = 11;
    public static final int TIMESTAMP = 12;
    public static final int BLOB = 13;
    public static final int CLOB = 14;
    public static final int JAVA_UTIL_DATE = 15;
    public static final int INTEGER_PRIMITIVE = 21;
    public static final int BYTE_PRIMITIVE = 22;
    public static final int SHORT_PRIMITIVE = 23;
    public static final int LONG_PRIMITIVE = 24;
    public static final int FLOAT_PRIMITIVE = 25;
    public static final int DOUBLE_PRIMITIVE = 26;
    public static final int CHAR_PRIMITIVE = 27;
    public static final int BOOLEAN_PRIMITIVE = 28;
    public static final int UNKNOWN = -1;
    public static final int DATA_OBJECT_ACCESS_BEAN = 16;
    public static final int DATA_LIST_ACCESS_BEAN = 17;
    public static final int DATA_OBJECT = 18;
    public static final int LIST = 19;
    public static final int BYTE_ARRAY = 20;
    public static final String INTEGER_NAME = "java.lang.Integer";
    public static final String BOOLEAN_NAME = "java.lang.Boolean";
    public static final String BYTE_NAME = "java.lang.Byte";
    public static final String SHORT_NAME = "java.lang.Short";
    public static final String STRING_NAME = "java.lang.String";
    public static final String DOUBLE_NAME = "java.lang.Double";
    public static final String LONG_NAME = "java.lang.Long";
    public static final String FLOAT_NAME = "java.lang.Float";
    public static final String OBJECT_NAME = "java.lang.Object";
    public static final String BIGDECIMAL_NAME = "java.math.BigDecimal";
    public static final String DATE_NAME = "java.sql.Date";
    public static final String TIME_NAME = "java.sql.Time";
    public static final String TIMESTAMP_NAME = "java.sql.Timestamp";
    public static final String BLOB_NAME = "java.sql.Blob";
    public static final String CLOB_NAME = "java.sql.Clob";
    public static final String JAVA_UTIL_DATE_NAME = "java.util.Date";
    public static final String BYTE_ARRAY_NAME = "[B";
    public static final String INTEGER_PRIMITIVE_NAME = "int";
    public static final String BYTE_PRIMITIVE_NAME = "byte";
    public static final String SHORT_PRIMITIVE_NAME = "short";
    public static final String LONG_PRIMITIVE_NAME = "long";
    public static final String FLOAT_PRIMITIVE_NAME = "float";
    public static final String DOUBLE_PRIMITIVE_NAME = "double";
    public static final String CHAR_PRIMITIVE_NAME = "char";
    public static final String BOOLEAN_PRIMITIVE_NAME = "boolean";
    public static final String DATA_OBJECT_ACCESS_BEAN_NAME = "com.ibm.websphere.sdo.DataObjectAccessBean";
    public static final String DATA_LIST_ACCESS_BEAN_NAME = "com.ibm.websphere.sdo.DataListAccessBean";
    public static final String DATA_OBJECT_NAME = "com.ibm.etools. ";
    public static final String LIST_NAME = "java.util.List";
    private static final Object fMutex = "mutex";
    private static Map fNameToIntMap;

    public static BigDecimal coerceToBigDecimal(Object value) throws ClassCastException {
        Object ret = null;
        ret = value instanceof BigDecimal ? (BigDecimal)value : (value instanceof String ? (value.equals("") ? null : new BigDecimal((String)value)) : (value instanceof Double ? new BigDecimal(value.toString()) : (value instanceof Float ? new BigDecimal(value.toString()) : (value instanceof Long ? new BigDecimal((Long)value) : (value instanceof Short ? new BigDecimal(((Short)value).shortValue()) : (value instanceof Integer ? new BigDecimal((Integer)value) : (value instanceof Byte ? new BigDecimal(((Byte)value).doubleValue()) : (value instanceof Boolean ? new BigDecimal((Boolean)value != false ? 1 : 0) : (value instanceof Date ? new BigDecimal(((Date)value).getTime()) : (value instanceof Time ? new BigDecimal(((Time)value).getTime()) : (value instanceof Timestamp ? new BigDecimal(((Timestamp)value).getTime()) : (BigDecimal)value)))))))))));
        return ret;
    }

    public static byte[] coerceToBlob(Object value) throws ClassCastException {
        byte[] ret = null;
        if (value instanceof byte[]) {
            ret = (byte[])value;
        } else if (value instanceof Blob) {
            Blob blob = (Blob)value;
            try {
                ret = blob.getBytes(1L, (int)blob.length());
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else if (value instanceof InputStream) {
            InputStream is = (InputStream)value;
            ret = TypeCoercionUtil.readToByteArray(is);
        }
        return ret;
    }

    public static Boolean coerceToBoolean(Object value) throws ClassCastException {
        Object ret = null;
        ret = value instanceof Boolean ? (Boolean)value : (value instanceof String ? (value.equals("") ? null : new Boolean((String)value)) : (value instanceof Byte ? new Boolean((Byte)value != 0) : (value instanceof Integer ? new Boolean((Integer)value != 0) : (value instanceof Short ? new Boolean((Short)value != 0) : (value instanceof Long ? new Boolean((Long)value != 0L) : (value instanceof Double ? new Boolean((Double)value != 0.0) : (value instanceof Float ? new Boolean(((Float)value).floatValue() != 0.0f) : (value instanceof BigDecimal ? new Boolean(((BigDecimal)value).doubleValue() != 0.0) : new Boolean(value != null)))))))));
        return ret;
    }

    public static Byte coerceToByte(Object value) throws ClassCastException {
        Object ret = null;
        ret = value instanceof Byte ? (Byte)value : (value instanceof String ? (value.equals("") ? null : new Byte((String)value)) : (value instanceof Integer ? new Byte(((Integer)value).byteValue()) : (value instanceof Long ? new Byte(((Long)value).byteValue()) : (value instanceof Short ? new Byte(((Short)value).byteValue()) : (value instanceof Double ? new Byte(((Double)value).byteValue()) : (value instanceof Float ? new Byte(((Float)value).byteValue()) : (value instanceof Boolean ? new Byte((byte)((Boolean)value != false ? 1 : 0)) : (value instanceof BigDecimal ? new Byte(((BigDecimal)value).byteValue()) : (value instanceof Date ? new Byte((byte)((Date)value).getTime()) : (value instanceof Time ? new Byte((byte)((Time)value).getTime()) : (value instanceof Timestamp ? new Byte((byte)((Timestamp)value).getTime()) : (Byte)value)))))))))));
        return ret;
    }

    public static String coerceToClob(Object value) throws ClassCastException {
        String ret = null;
        if (value instanceof Clob) {
            Clob clob = (Clob)value;
            try {
                ret = TypeCoercionUtil.readToString(clob.getAsciiStream());
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            ret = value instanceof InputStream ? TypeCoercionUtil.readToString((InputStream)value) : (value != null ? value.toString() : null);
        }
        return ret;
    }

    public static Date coerceToDate(Object value) throws ClassCastException {
        Object ret = null;
        ret = value instanceof Date ? (Date)value : (value instanceof String ? (value.equals("") ? null : new Date(Long.parseLong((String)value))) : (value instanceof Long ? new Date((Long)value) : (value instanceof Time ? new Date(((Time)value).getTime()) : (value instanceof Timestamp ? new Date(((Timestamp)value).getTime()) : (value instanceof java.util.Date ? new Date(((java.util.Date)value).getTime()) : (value instanceof Integer ? new Date(((Integer)value).longValue()) : (value instanceof Short ? new Date(((Short)value).longValue()) : (value instanceof Double ? new Date(((Double)value).longValue()) : (value instanceof Float ? new Date(((Float)value).longValue()) : (value instanceof Byte ? new Date(((Byte)value).longValue()) : (value instanceof BigDecimal ? new Date(((BigDecimal)value).longValue()) : (Date)value)))))))))));
        return ret;
    }

    public static Double coerceToDouble(Object value) throws ClassCastException {
        Object ret = null;
        ret = value instanceof Double ? (Double)value : (value instanceof String ? (value.equals("") ? null : new Double((String)value)) : (value instanceof Float ? new Double(((Float)value).floatValue()) : (value instanceof Long ? new Double(((Long)value).longValue()) : (value instanceof Short ? new Double(((Short)value).shortValue()) : (value instanceof Integer ? new Double(((Integer)value).intValue()) : (value instanceof Byte ? new Double(((Byte)value).doubleValue()) : (value instanceof Boolean ? new Double((Boolean)value != false ? 1 : 0) : (value instanceof BigDecimal ? new Double(((BigDecimal)value).doubleValue()) : (value instanceof Date ? new Double(((Date)value).getTime()) : (value instanceof Time ? new Double(((Time)value).getTime()) : (value instanceof Timestamp ? new Double(((Timestamp)value).getTime()) : (Double)value)))))))))));
        return ret;
    }

    public static Float coerceToFloat(Object value) throws ClassCastException {
        Object ret = null;
        ret = value instanceof Float ? (Float)value : (value instanceof String ? (value.equals("") ? null : new Float((String)value)) : (value instanceof Double ? new Float(((Double)value).floatValue()) : (value instanceof Long ? new Float(((Long)value).longValue()) : (value instanceof Short ? new Float(((Short)value).shortValue()) : (value instanceof Integer ? new Float(((Integer)value).intValue()) : (value instanceof Byte ? new Float(((Byte)value).floatValue()) : (value instanceof Boolean ? new Float((Boolean)value != false ? 1 : 0) : (value instanceof BigDecimal ? new Float(((BigDecimal)value).floatValue()) : (value instanceof Date ? new Float(((Date)value).getTime()) : (value instanceof Time ? new Float(((Time)value).getTime()) : (value instanceof Timestamp ? new Float(((Timestamp)value).getTime()) : (Float)value)))))))))));
        return ret;
    }

    public static Integer coerceToInteger(Object value) throws ClassCastException {
        Object ret = null;
        ret = value instanceof Integer ? (Integer)value : (value instanceof String ? (value.equals("") ? null : new Integer((String)value)) : (value instanceof Long ? new Integer(((Long)value).intValue()) : (value instanceof Short ? new Integer(((Short)value).intValue()) : (value instanceof Double ? new Integer(((Double)value).intValue()) : (value instanceof Float ? new Integer(((Float)value).intValue()) : (value instanceof Byte ? new Integer(((Byte)value).intValue()) : (value instanceof Boolean ? new Integer((Boolean)value != false ? 1 : 0) : (value instanceof BigDecimal ? new Integer(((BigDecimal)value).intValue()) : (value instanceof Date ? new Integer((int)((Date)value).getTime()) : (value instanceof Time ? new Integer((int)((Time)value).getTime()) : (value instanceof Timestamp ? new Integer((int)((Timestamp)value).getTime()) : (Integer)value)))))))))));
        return ret;
    }

    public static java.util.Date coerceToJavaUtilDate(Object value) throws ClassCastException {
        Object ret = null;
        ret = value instanceof java.util.Date ? (java.util.Date)value : (value instanceof String ? (value.equals("") ? null : new java.util.Date(Long.parseLong((String)value))) : (value instanceof Long ? new java.util.Date((Long)value) : (value instanceof Time ? new java.util.Date(((Time)value).getTime()) : (value instanceof Timestamp ? new java.util.Date(((Timestamp)value).getTime()) : (value instanceof Date ? new java.util.Date(((Date)value).getTime()) : (value instanceof Integer ? new java.util.Date(((Integer)value).longValue()) : (value instanceof Short ? new java.util.Date(((Short)value).longValue()) : (value instanceof Double ? new java.util.Date(((Double)value).longValue()) : (value instanceof Float ? new java.util.Date(((Float)value).longValue()) : (value instanceof Byte ? new java.util.Date(((Byte)value).longValue()) : (value instanceof BigDecimal ? new java.util.Date(((BigDecimal)value).longValue()) : (java.util.Date)value)))))))))));
        return ret;
    }

    public static List coerceToList(Object value) throws ClassCastException {
        List ret = null;
        ret = value instanceof List ? (List)value : (List)value;
        return ret;
    }

    public static Long coerceToLong(Object value) throws ClassCastException {
        Object ret = null;
        ret = value instanceof Long ? (Long)value : (value instanceof String ? (value.equals("") ? null : new Long((String)value)) : (value instanceof Integer ? new Long(((Integer)value).longValue()) : (value instanceof Short ? new Long(((Short)value).longValue()) : (value instanceof Double ? new Long(((Double)value).longValue()) : (value instanceof Float ? new Long(((Float)value).longValue()) : (value instanceof Byte ? new Long(((Byte)value).longValue()) : (value instanceof Boolean ? new Long((Boolean)value != false ? 1 : 0) : (value instanceof BigDecimal ? new Long(((BigDecimal)value).longValue()) : (value instanceof Date ? new Long(((Date)value).getTime()) : (value instanceof Time ? new Long(((Time)value).getTime()) : (value instanceof Timestamp ? new Long(((Timestamp)value).getTime()) : (Long)value)))))))))));
        return ret;
    }

    public static Short coerceToShort(Object value) throws ClassCastException {
        Object ret = null;
        ret = value instanceof Short ? (Short)value : (value instanceof String ? (value.equals("") ? null : new Short((String)value)) : (value instanceof Integer ? new Short(((Integer)value).shortValue()) : (value instanceof Long ? new Short(((Long)value).shortValue()) : (value instanceof Double ? new Short(((Double)value).shortValue()) : (value instanceof Float ? new Short(((Float)value).shortValue()) : (value instanceof Byte ? new Short(((Byte)value).shortValue()) : (value instanceof Boolean ? new Short((short)((Boolean)value != false ? 1 : 0)) : (value instanceof BigDecimal ? new Short(((BigDecimal)value).shortValue()) : (value instanceof Date ? new Short((short)((Date)value).getTime()) : (value instanceof Time ? new Short((short)((Time)value).getTime()) : (value instanceof Timestamp ? new Short((short)((Timestamp)value).getTime()) : (Short)value)))))))))));
        return ret;
    }

    public static String coerceToString(Object value) throws ClassCastException {
        String ret = null;
        ret = value instanceof InputStream ? TypeCoercionUtil.readToString((InputStream)value) : (value != null ? value.toString() : null);
        return ret;
    }

    public static Time coerceToTime(Object value) throws ClassCastException {
        Object ret = null;
        ret = value instanceof Time ? (Time)value : (value instanceof String ? (value.equals("") ? null : new Time(Long.parseLong((String)value))) : (value instanceof Long ? new Time((Long)value) : (value instanceof Date ? new Time(((Date)value).getTime()) : (value instanceof Timestamp ? new Time(((Timestamp)value).getTime()) : (value instanceof java.util.Date ? new Time(((java.util.Date)value).getTime()) : (value instanceof Integer ? new Time(((Integer)value).longValue()) : (value instanceof Short ? new Time(((Short)value).longValue()) : (value instanceof Double ? new Time(((Double)value).longValue()) : (value instanceof Float ? new Time(((Float)value).longValue()) : (value instanceof Byte ? new Time(((Byte)value).longValue()) : (value instanceof BigDecimal ? new Time(((BigDecimal)value).longValue()) : (Time)value)))))))))));
        return ret;
    }

    public static Timestamp coerceToTimeStamp(Object value) throws ClassCastException {
        Object ret = null;
        ret = value instanceof Timestamp ? (Timestamp)value : (value instanceof String ? (value.equals("") ? null : new Timestamp(Long.parseLong((String)value))) : (value instanceof Long ? new Timestamp((Long)value) : (value instanceof Date ? new Timestamp(((Date)value).getTime()) : (value instanceof Time ? new Timestamp(((Time)value).getTime()) : (value instanceof java.util.Date ? new Timestamp(((java.util.Date)value).getTime()) : (value instanceof Integer ? new Timestamp(((Integer)value).longValue()) : (value instanceof Short ? new Timestamp(((Short)value).longValue()) : (value instanceof Double ? new Timestamp(((Double)value).longValue()) : (value instanceof Float ? new Timestamp(((Float)value).longValue()) : (value instanceof Byte ? new Timestamp(((Byte)value).longValue()) : (value instanceof BigDecimal ? new Timestamp(((BigDecimal)value).longValue()) : (Timestamp)value)))))))))));
        return ret;
    }

    public static Object coerceType(int type, Object value) {
        if (value == null) {
            return null;
        }
        Object retValue = null;
        switch (type) {
            case 19: {
                retValue = TypeCoercionUtil.coerceToList(retValue);
                break;
            }
            case 8: 
            case 21: {
                retValue = TypeCoercionUtil.coerceToInteger(retValue);
                break;
            }
            case 1: 
            case 28: {
                retValue = TypeCoercionUtil.coerceToBoolean(retValue);
                break;
            }
            case 2: 
            case 22: {
                retValue = TypeCoercionUtil.coerceToByte(retValue);
                break;
            }
            case 3: 
            case 23: {
                retValue = TypeCoercionUtil.coerceToShort(retValue);
                break;
            }
            case 4: {
                retValue = TypeCoercionUtil.coerceToString(retValue);
                break;
            }
            case 5: 
            case 26: {
                retValue = TypeCoercionUtil.coerceToDouble(retValue);
                break;
            }
            case 6: 
            case 24: {
                retValue = TypeCoercionUtil.coerceToLong(retValue);
                break;
            }
            case 7: 
            case 25: {
                retValue = TypeCoercionUtil.coerceToFloat(retValue);
                break;
            }
            case 9: {
                retValue = TypeCoercionUtil.coerceToBigDecimal(retValue);
                break;
            }
            case 15: {
                retValue = TypeCoercionUtil.coerceToJavaUtilDate(retValue);
                break;
            }
            case 13: 
            case 20: {
                retValue = TypeCoercionUtil.coerceToBlob(retValue);
                break;
            }
            case 14: {
                retValue = TypeCoercionUtil.coerceToClob(retValue);
                break;
            }
            case 10: {
                retValue = TypeCoercionUtil.coerceToDate(retValue);
                break;
            }
            case 11: {
                retValue = TypeCoercionUtil.coerceToTime(retValue);
                break;
            }
            case 12: {
                retValue = TypeCoercionUtil.coerceToTimeStamp(retValue);
            }
        }
        return retValue;
    }

    public static Object coerceType(String type, Object value) throws ClassCastException {
        Object typeAsObject = TypeCoercionUtil.getNameToIntegerMap().get(type);
        int typeAsInt = -1;
        if (typeAsObject instanceof Integer) {
            typeAsInt = (Integer)typeAsObject;
        }
        return TypeCoercionUtil.coerceType(typeAsInt, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Map getNameToIntegerMap() {
        if (fNameToIntMap == null) {
            Object object = fMutex;
            synchronized (object) {
                fNameToIntMap = new HashMap(48);
                fNameToIntMap.put(INTEGER_NAME, new Integer(8));
                fNameToIntMap.put(BOOLEAN_NAME, new Integer(1));
                fNameToIntMap.put(BYTE_NAME, new Integer(2));
                fNameToIntMap.put(SHORT_NAME, new Integer(3));
                fNameToIntMap.put(STRING_NAME, new Integer(4));
                fNameToIntMap.put(DOUBLE_NAME, new Integer(5));
                fNameToIntMap.put(LONG_NAME, new Integer(6));
                fNameToIntMap.put(FLOAT_NAME, new Integer(7));
                fNameToIntMap.put(INTEGER_PRIMITIVE_NAME, new Integer(21));
                fNameToIntMap.put(BOOLEAN_PRIMITIVE_NAME, new Integer(28));
                fNameToIntMap.put(BYTE_PRIMITIVE_NAME, new Integer(22));
                fNameToIntMap.put(SHORT_PRIMITIVE_NAME, new Integer(23));
                fNameToIntMap.put(DOUBLE_PRIMITIVE_NAME, new Integer(26));
                fNameToIntMap.put(LONG_PRIMITIVE_NAME, new Integer(24));
                fNameToIntMap.put(FLOAT_PRIMITIVE_NAME, new Integer(25));
                fNameToIntMap.put(OBJECT_NAME, new Integer(0));
                fNameToIntMap.put(BIGDECIMAL_NAME, new Integer(9));
                fNameToIntMap.put(DATE_NAME, new Integer(10));
                fNameToIntMap.put(TIME_NAME, new Integer(11));
                fNameToIntMap.put(TIMESTAMP_NAME, new Integer(12));
                fNameToIntMap.put(BLOB_NAME, new Integer(13));
                fNameToIntMap.put(CLOB_NAME, new Integer(14));
                fNameToIntMap.put(JAVA_UTIL_DATE_NAME, new Integer(15));
                fNameToIntMap.put(DATA_OBJECT_ACCESS_BEAN_NAME, new Integer(16));
                fNameToIntMap.put(DATA_LIST_ACCESS_BEAN_NAME, new Integer(16));
                fNameToIntMap.put(BYTE_ARRAY_NAME, new Integer(20));
            }
        }
        return fNameToIntMap;
    }

    public static String getObjectTypeNameForPrimitive(String type) {
        if (type.equals(INTEGER_PRIMITIVE_NAME)) {
            return "Integer";
        }
        if (type.equals(BYTE_PRIMITIVE_NAME)) {
            return "Byte";
        }
        if (type.equals(SHORT_PRIMITIVE_NAME)) {
            return "Short";
        }
        if (type.equals(LONG_PRIMITIVE_NAME)) {
            return "Long";
        }
        if (type.equals(FLOAT_PRIMITIVE_NAME)) {
            return "Float";
        }
        if (type.equals(DOUBLE_PRIMITIVE_NAME)) {
            return "Double";
        }
        if (type.equals(CHAR_PRIMITIVE_NAME)) {
            return "Character";
        }
        if (type.equals(BOOLEAN_PRIMITIVE_NAME)) {
            return "Boolean";
        }
        return null;
    }

    private static byte[] readToByteArray(InputStream is) {
        byte[] ret = new byte[]{};
        byte[] buffer = new byte[1024];
        try {
            int count;
            do {
                if ((count = is.read(buffer)) <= 0) continue;
                byte[] new_array = new byte[ret.length + count];
                System.arraycopy(ret, 0, new_array, 0, ret.length);
                System.arraycopy(buffer, 0, new_array, ret.length, count);
                ret = new_array;
            } while (count != -1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private static String readToString(InputStream is) {
        String ret;
        byte[] buffer = new byte[1024];
        StringBuffer stringBuffer = new StringBuffer();
        try {
            try {
                int count;
                do {
                    if ((count = is.read(buffer)) <= 0) continue;
                    stringBuffer.append(buffer);
                } while (count != -1);
            }
            catch (IOException e) {
                e.printStackTrace();
                ret = stringBuffer.toString();
            }
        }
        finally {
            ret = stringBuffer.toString();
        }
        return ret;
    }
}

