/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.datatools.modelbase.sql.query.ResultColumn;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionFunction;
import org.eclipse.emf.common.util.EList;

public class NamedQuerySelectParts {
    private QUERY_TYPE queryType;
    private String beanName;
    private boolean isDistinct;
    private List<SelectParamType> parameterTypes;

    public NamedQuerySelectParts(EList statement, boolean isDistinct) {
        this.isDistinct = isDistinct;
        this.parameterTypes = new ArrayList<SelectParamType>();
        boolean isParam = false;
        for (ResultColumn select : statement) {
            ValueExpressionColumn valueExpression;
            String name = select.getSourceInfo().getSourceSnippet();
            if (select.getValueExpr() instanceof ValueExpressionColumn) {
                if (name.indexOf(46) >= 0) {
                    isParam = true;
                }
                if ((valueExpression = (ValueExpressionColumn)select.getValueExpr()).getTableExpr() == null) continue;
                this.parameterTypes.add(new SelectParamType(name, valueExpression.getTableExpr().getSourceInfo().getSourceSnippet(), null, PARAM_TYPE.PARAM));
                continue;
            }
            if (!(select.getValueExpr() instanceof ValueExpressionFunction)) continue;
            valueExpression = (ValueExpressionFunction)select.getValueExpr();
            ValueExpressionColumn columnExpression = (ValueExpressionColumn)valueExpression.getParameterList().get(0);
            String functionName = valueExpression.getName();
            if (functionName.equalsIgnoreCase("avg")) {
                this.parameterTypes.add(new SelectParamType(columnExpression.getSourceInfo().getSourceSnippet(), columnExpression.getTableExpr().getSourceInfo().getSourceSnippet(), name, PARAM_TYPE.AVG));
                continue;
            }
            if (functionName.equalsIgnoreCase("count")) {
                this.parameterTypes.add(new SelectParamType(columnExpression.getSourceInfo().getSourceSnippet(), columnExpression.getTableExpr().getSourceInfo().getSourceSnippet(), name, PARAM_TYPE.COUNT));
                continue;
            }
            if (functionName.equalsIgnoreCase("min")) {
                this.parameterTypes.add(new SelectParamType(columnExpression.getSourceInfo().getSourceSnippet(), columnExpression.getTableExpr().getSourceInfo().getSourceSnippet(), name, PARAM_TYPE.MIN));
                continue;
            }
            if (functionName.equalsIgnoreCase("max")) {
                this.parameterTypes.add(new SelectParamType(columnExpression.getSourceInfo().getSourceSnippet(), columnExpression.getTableExpr().getSourceInfo().getSourceSnippet(), name, PARAM_TYPE.MAX));
                continue;
            }
            if (!functionName.equalsIgnoreCase("sum")) continue;
            this.parameterTypes.add(new SelectParamType(columnExpression.getSourceInfo().getSourceSnippet(), columnExpression.getTableExpr().getSourceInfo().getSourceSnippet(), name, PARAM_TYPE.AVG));
        }
        this.queryType = this.parameterTypes.size() == 1 && isParam ? QUERY_TYPE.PARAM : (this.parameterTypes.size() > 1 ? QUERY_TYPE.PARAM : QUERY_TYPE.NORMAL);
    }

    public NamedQuerySelectParts(String selectStatement) {
        int newIndex = selectStatement.indexOf(" new ");
        if (newIndex == -1) {
            this.queryType = QUERY_TYPE.UNKNOWN;
        } else {
            int paramStartIndex = selectStatement.indexOf("(");
            int paramEndIndex = selectStatement.indexOf(")");
            if (paramStartIndex == -1) {
                this.queryType = QUERY_TYPE.UNKNOWN;
            } else {
                this.beanName = selectStatement.substring(newIndex + 4, paramStartIndex);
                this.beanName = this.beanName.trim();
                this.parameterTypes = new ArrayList<SelectParamType>();
                String paramString = selectStatement.substring(paramStartIndex + 1, paramEndIndex);
                StringTokenizer tokenizer = new StringTokenizer(paramString, ",");
                while (tokenizer.hasMoreTokens()) {
                    this.parameterTypes.add(new SelectParamType(tokenizer.nextToken(), null, null, PARAM_TYPE.PARAM));
                }
                this.queryType = QUERY_TYPE.BEAN;
            }
        }
    }

    public String getBeanName() {
        return this.beanName;
    }

    public String getBeanNameWithParams() {
        String beanName = this.getBeanName();
        if (this.parameterTypes != null && this.parameterTypes.size() > 0) {
            beanName = String.valueOf(beanName) + "(";
            int size = this.parameterTypes.size();
            for (SelectParamType paramType : this.parameterTypes) {
                beanName = String.valueOf(beanName) + paramType.attributeName;
                if (size > 1) {
                    beanName = String.valueOf(beanName) + ", ";
                }
                --size;
            }
            beanName = String.valueOf(beanName) + ")";
        }
        return beanName;
    }

    public List<SelectParamType> getParameterTypes() {
        return this.parameterTypes;
    }

    public QUERY_TYPE getQueryType() {
        return this.queryType;
    }

    public String getStringValue() {
        String selectStatement = null;
        selectStatement = this.isDistinct ? "DISTINCT " : "";
        if (this.queryType == QUERY_TYPE.PARAM || this.queryType == QUERY_TYPE.NORMAL) {
            int size = this.parameterTypes.size();
            for (SelectParamType paramType : this.parameterTypes) {
                selectStatement = paramType.type == PARAM_TYPE.PARAM ? String.valueOf(selectStatement) + paramType.attributeName : String.valueOf(selectStatement) + paramType.functionValue;
                if (size > 1) {
                    selectStatement = String.valueOf(selectStatement) + ", ";
                }
                --size;
            }
        } else {
            selectStatement = this.queryType == QUERY_TYPE.BEAN ? String.valueOf(selectStatement) + "new " + this.getBeanNameWithParams() : null;
        }
        return selectStatement;
    }

    public void setBeanAndParse(String selectStatement) {
        int paramStartIndex = selectStatement.indexOf("(");
        int paramEndIndex = selectStatement.indexOf(")");
        if (paramStartIndex == -1) {
            this.queryType = QUERY_TYPE.UNKNOWN;
        } else {
            this.beanName = selectStatement.substring(0, paramStartIndex);
            this.beanName = this.beanName.trim();
            this.parameterTypes = new ArrayList<SelectParamType>();
            String paramString = selectStatement.substring(paramStartIndex + 1, paramEndIndex);
            StringTokenizer tokenizer = new StringTokenizer(paramString, ",");
            while (tokenizer.hasMoreTokens()) {
                this.parameterTypes.add(new SelectParamType(tokenizer.nextToken(), null, null, PARAM_TYPE.PARAM));
            }
            this.queryType = QUERY_TYPE.BEAN;
        }
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setParameterTypes(List<SelectParamType> parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    public void setQueryType(QUERY_TYPE queryType) {
        this.queryType = queryType;
    }

    public static enum PARAM_TYPE {
        PARAM,
        AVG,
        COUNT,
        MIN,
        MAX,
        SUM;

    }

    public static enum QUERY_TYPE {
        NORMAL,
        PARAM,
        BEAN,
        UNKNOWN;

    }

    public class SelectParamType {
        public String attributeName;
        public String entityName;
        public PARAM_TYPE type;
        public String functionValue;

        public SelectParamType(String attributeName, String entityName, String functionValue, PARAM_TYPE type) {
            this.attributeName = attributeName;
            this.entityName = entityName;
            this.functionValue = functionValue;
            this.type = type;
        }
    }
}

