/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.util;

import com.ibm.etools.webtools.javamodel.api.JavaCodeUtil;
import com.ibm.etools.webtools.jpa.codegen.ManagerBeanCodeGenOperation;
import com.ibm.etools.webtools.jpa.models.JpaAttributeInfo;
import com.ibm.etools.webtools.jpa.models.JpaEntityInfo;
import com.ibm.etools.webtools.jpa.models.JpaFilterInfo;
import com.ibm.etools.webtools.jpa.models.JpaFilterParameterInfo;
import com.ibm.etools.webtools.jpa.models.JpaManagerBeanInfo;
import com.ibm.etools.webtools.jpa.models.JpaOrderedAttributeInfo;
import com.ibm.etools.webtools.jpa.models.JpaQueryMethodInfo;
import com.ibm.etools.webtools.jpa.util.AnnotationUtil;
import com.ibm.etools.webtools.jpa.util.JpaUtil;
import com.ibm.etools.webtools.jpa.util.ManagerBeanUtil;
import com.ibm.etools.webtools.jpa.util.NamedQueryParameter;
import com.ibm.etools.webtools.jpa.util.NamedQuerySelectParts;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.ColumnMapping;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.ManyToOneMapping;
import org.eclipse.jpt.core.context.NamedQuery;
import org.eclipse.jpt.core.context.OneToOneMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.TemporalType;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;

public class NamedQueriesUtil {
    public static final String QUERY_SELECT = "SELECT";
    public static final String QUERY_FROM = "FROM";
    public static final String QUERY_WHERE = "WHERE";
    public static final String QUERY_ORDERBY = "ORDER BY";
    public static final String QUERY_HAVING = "HAVING";
    public static final String QUERY_GROUPBY = "GROUP BY";
    public static final String QUERY_DESCENDING = "DESC";
    public static final String QUERY_OPERATOR_EQUALS = "=";
    public static final String QUERY_OPERATOR_AND = "AND";
    public static final String QUERY_FILTER_NAMED_IDENTIFIER = ":";
    public static final String QUERY_NAME_ORDERED = "Ordered";
    public static final String QUERY_NAME_FILTERED = "By";
    public static final String GETTER_PREFIX = "get";
    private static final String JPA_NAMED_QUERY_SHORTNAME = "javax.persistence.NamedQueries".substring("javax.persistence.".length());
    private static final String[] IGNORE_TYPES = new String[]{"embedded", "embeddedId", "manyToMany", "oneToMany", "transient"};

    public static boolean addDefaultFilterListQuery(String entityName, String specifiedEntityName, JpaAttributeInfo att, List<JpaQueryMethodInfo> namedQueries) {
        String entity;
        boolean added = false;
        ArrayList<String> attributeNames = new ArrayList<String>();
        JpaEntityInfo targetEntity = null;
        if (att.getMappingKey() != null && att.getMappingKey().equals("oneToOne")) {
            entity = ((OneToOneMapping)att.getAttribute().getMapping()).getTargetEntity();
            targetEntity = JpaUtil.getEntityByName(att.getAttribute().getJpaProject(), entity);
        } else if (att.getMappingKey() != null && att.getMappingKey().equals("manyToOne")) {
            entity = ((ManyToOneMapping)att.getAttribute().getMapping()).getTargetEntity();
            targetEntity = JpaUtil.getEntityByName(att.getAttribute().getJpaProject(), entity);
        }
        if (targetEntity != null) {
            List<JpaAttributeInfo> primaryKeys = targetEntity.getPrimaryKeyAttributes();
            for (JpaAttributeInfo key : primaryKeys) {
                attributeNames.add(String.valueOf(att.getAttributeName()) + "." + key.getAttributeName());
            }
        } else {
            attributeNames.add(att.getAttributeName());
        }
        String getterAttributeName = att.getAttributeName();
        if (getterAttributeName.indexOf(46) != -1) {
            getterAttributeName = getterAttributeName.replace('.', '_');
        }
        String queryName = GETTER_PREFIX + entityName + QUERY_NAME_FILTERED + JavaCodeUtil.capitalizeFirst((String)getterAttributeName);
        String entityVariable = NamedQueriesUtil.getEntityVariable(specifiedEntityName);
        if (!NamedQueriesUtil.doesNamedQueryExist(namedQueries, queryName) && attributeNames.size() > 0) {
            String filter = "";
            int count = 0;
            for (String attribute : attributeNames) {
                if (count > 0) {
                    filter = String.valueOf(filter) + ' ' + QUERY_OPERATOR_AND + ' ';
                }
                filter = String.valueOf(filter) + entityVariable + '.' + attribute + ' ' + QUERY_OPERATOR_EQUALS + ' ' + QUERY_FILTER_NAMED_IDENTIFIER + JavaCodeUtil.legalizeJavaIdentifier((String)attribute.replace('.', '_'));
                ++count;
            }
            String query = NamedQueriesUtil.createQuery(specifiedEntityName, null, filter);
            namedQueries.add(new JpaQueryMethodInfo(queryName, queryName, query, JpaQueryMethodInfo.STATUS.NEW));
            added = true;
        }
        return added;
    }

    public static void addDefaultListQuery(String entityName, String specifiedEntityName, List<JpaQueryMethodInfo> namedQueries) {
        String queryName = GETTER_PREFIX + entityName;
        String query = NamedQueriesUtil.createQuery(specifiedEntityName, null, null);
        namedQueries.add(new JpaQueryMethodInfo(queryName, queryName, query, JpaQueryMethodInfo.STATUS.NEW));
    }

    public static void addDefaultNamedQueriesIfNeeded(List<JpaQueryMethodInfo> existingNamedQueries, JpaEntityInfo entity) {
        if (existingNamedQueries.size() < 1) {
            String entityName = entity.getName();
            String specifiedEntityName = entity.getSpecifiedName();
            NamedQueriesUtil.addDefaultListQuery(entityName, specifiedEntityName, existingNamedQueries);
            List<JpaAttributeInfo> attributesList = entity.getAttributes();
            for (JpaAttributeInfo element : attributesList) {
                JpaAttributeInfo att = element;
                PersistentAttribute jpAtt = att.getAttribute();
                String attributeType = jpAtt.getMappingKey();
                if (NamedQueriesUtil.shouldIgnoreAttribute(attributeType)) continue;
                NamedQueriesUtil.addDefaultFilterListQuery(entityName, specifiedEntityName, att, existingNamedQueries);
            }
        }
    }

    public static boolean addDefaultOrderedListQuery(String entityName, String specifiedEntityName, JpaAttributeInfo att, List<JpaQueryMethodInfo> namedQueries) {
        boolean added = false;
        String queryName = GETTER_PREFIX + entityName + QUERY_NAME_ORDERED;
        if (!NamedQueriesUtil.doesNamedQueryExist(namedQueries, queryName)) {
            ArrayList<JpaOrderedAttributeInfo> orderBys = new ArrayList<JpaOrderedAttributeInfo>(1);
            orderBys.add(new JpaOrderedAttributeInfo(att.getAttributeName()));
            String query = NamedQueriesUtil.createQuery(specifiedEntityName, orderBys, null);
            namedQueries.add(new JpaQueryMethodInfo(queryName, queryName, query, JpaQueryMethodInfo.STATUS.NEW));
            added = true;
        }
        return added;
    }

    public static boolean addDefaultOrderedListQuery(String entityName, String specifiedEntityName, List<JpaAttributeInfo> atts, List<JpaQueryMethodInfo> namedQueries) {
        boolean added = false;
        ArrayList<JpaOrderedAttributeInfo> orderBys = new ArrayList<JpaOrderedAttributeInfo>(atts.size());
        for (JpaAttributeInfo attInfo : atts) {
            orderBys.add(new JpaOrderedAttributeInfo(attInfo.getAttribute().getName()));
        }
        String queryName = GETTER_PREFIX + entityName + QUERY_NAME_ORDERED;
        if (!NamedQueriesUtil.doesNamedQueryExist(namedQueries, queryName)) {
            String query = NamedQueriesUtil.createQuery(specifiedEntityName, orderBys, null);
            namedQueries.add(new JpaQueryMethodInfo(queryName, queryName, query, JpaQueryMethodInfo.STATUS.NEW));
            added = true;
        }
        return added;
    }

    public static boolean addDefaultOrderedListQueryIfNecessary(String entityName, String specifiedEntityName, List<JpaAttributeInfo> atts, List<JpaQueryMethodInfo> namedQueries, boolean force) {
        boolean added = false;
        String queryName = GETTER_PREFIX + entityName + QUERY_NAME_ORDERED;
        boolean foundExisting = false;
        for (JpaQueryMethodInfo queryMethod : namedQueries) {
            if (queryMethod.getStatus() != JpaQueryMethodInfo.STATUS.EXISTING && queryMethod.getStatus() != JpaQueryMethodInfo.STATUS.CHANGED) continue;
            foundExisting = true;
            break;
        }
        if (force || !foundExisting) {
            ArrayList<JpaOrderedAttributeInfo> orderBys = new ArrayList<JpaOrderedAttributeInfo>(atts.size());
            for (JpaAttributeInfo attInfo : atts) {
                orderBys.add(new JpaOrderedAttributeInfo(attInfo.getAttribute().getName()));
            }
            String query = NamedQueriesUtil.createQuery(specifiedEntityName, orderBys, null);
            if (!NamedQueriesUtil.doesNamedQueryExist(namedQueries, queryName)) {
                NamedQueriesUtil.addQueryOrModifyIfExists(namedQueries, queryName, query);
                added = true;
            } else if (force) {
                for (JpaQueryMethodInfo queryMethod : namedQueries) {
                    if (queryMethod.getStatus() != JpaQueryMethodInfo.STATUS.REMOVE || queryMethod.getQueryName() == null || !queryMethod.getQueryName().equals(queryName)) continue;
                    queryMethod.setStatus(JpaQueryMethodInfo.STATUS.EXISTING);
                    queryMethod.setQueryValue(query);
                    added = true;
                    break;
                }
            }
        }
        return added;
    }

    private static String addFiltersToQuery(String query, String entityVariableName, String filter) {
        if (filter == null || filter.length() == 0) {
            return query;
        }
        String updatedQuery = String.valueOf(query) + ' ' + QUERY_WHERE + ' ' + filter;
        return updatedQuery;
    }

    public static void addNamedQueriesOnEntity(PersistentType pType, List<JpaQueryMethodInfo> userQueryMethods, boolean saveCompilationUnit, boolean isConfigureEnties) {
        List<JpaQueryMethodInfo> existingQueries = NamedQueriesUtil.getNamedQueryMethods(pType, false);
        ArrayList<JpaQueryMethodInfo> addedQueries = new ArrayList<JpaQueryMethodInfo>();
        ArrayList<JpaQueryMethodInfo> removedQueries = new ArrayList<JpaQueryMethodInfo>();
        block0: for (JpaQueryMethodInfo newQuery : userQueryMethods) {
            if (newQuery.getStatus() == JpaQueryMethodInfo.STATUS.NEW) {
                boolean found = false;
                for (JpaQueryMethodInfo existingQuery : existingQueries) {
                    if (!newQuery.getQueryName().equals(existingQuery.getQueryName())) continue;
                    found = true;
                    if (newQuery.getQueryValue() == null || newQuery.getQueryValue().equals(existingQuery.getQueryValue())) break;
                    removedQueries.add(existingQuery);
                    addedQueries.add(newQuery);
                    break;
                }
                if (found) continue;
                addedQueries.add(newQuery);
                continue;
            }
            if (newQuery.getStatus() == JpaQueryMethodInfo.STATUS.CHANGED) {
                for (JpaQueryMethodInfo existingQuery : existingQueries) {
                    if (newQuery.getOldQueryName() == null || !newQuery.getOldQueryName().equals(existingQuery.getQueryName())) continue;
                    removedQueries.add(existingQuery);
                    addedQueries.add(newQuery);
                    continue block0;
                }
                continue;
            }
            if (!isConfigureEnties || newQuery.getStatus() != JpaQueryMethodInfo.STATUS.REMOVE) continue;
            for (JpaQueryMethodInfo existingQuery : existingQueries) {
                if (newQuery.getOldQueryName() == null || !newQuery.getOldQueryName().equals(existingQuery.getQueryName())) continue;
                removedQueries.add(existingQuery);
                continue block0;
            }
        }
        TypeMapping mapping = pType.getMapping();
        if (mapping instanceof Entity) {
            Entity entity = (Entity)mapping;
            NamedQueriesUtil.removeNamedQueryFromEntity(entity, removedQueries);
            for (JpaQueryMethodInfo toAddQuery : addedQueries) {
                NamedQuery newNamedQuery = entity.addNamedQuery(entity.namedQueriesSize());
                newNamedQuery.setName(toAddQuery.getQueryName());
                newNamedQuery.setQuery(toAddQuery.getQueryValue());
            }
        }
        if (saveCompilationUnit) {
            AnnotationUtil.saveEntityModel(pType);
        }
    }

    private static String addOrderBysToQuery(String query, String entityVariableName, List<JpaOrderedAttributeInfo> orderBys) {
        if (orderBys == null || orderBys.size() == 0) {
            return query;
        }
        String updatedQuery = String.valueOf(query) + ' ' + QUERY_ORDERBY;
        int i = 0;
        while (i < orderBys.size()) {
            JpaOrderedAttributeInfo attribute = orderBys.get(i);
            String columnName = attribute.getAttributeName();
            String order = null;
            Integer intOrder = attribute.getOrdering();
            if (intOrder.equals(JpaOrderedAttributeInfo.DESCENDING)) {
                order = QUERY_DESCENDING;
            }
            if (i != 0) {
                updatedQuery = String.valueOf(updatedQuery) + ',';
            }
            updatedQuery = String.valueOf(updatedQuery) + ' ' + entityVariableName + '.' + columnName;
            if (order != null) {
                updatedQuery = String.valueOf(updatedQuery) + ' ' + order;
            }
            ++i;
        }
        return updatedQuery;
    }

    private static void addQueryOrModifyIfExists(List<JpaQueryMethodInfo> namedQueries, String queryName, String query) {
        boolean added = false;
        for (JpaQueryMethodInfo queryMethod : namedQueries) {
            if (queryMethod.getStatus() != JpaQueryMethodInfo.STATUS.REMOVE || queryMethod.getQueryName() == null || !queryMethod.getQueryName().equals(queryName)) continue;
            queryMethod.setStatus(JpaQueryMethodInfo.STATUS.EXISTING);
            queryMethod.setQueryValue(query);
            added = true;
            break;
        }
        if (!added) {
            namedQueries.add(new JpaQueryMethodInfo(queryName, queryName, query, JpaQueryMethodInfo.STATUS.NEW));
        }
    }

    protected static BodyDeclaration bodyDeclaration(CompilationUnit astRoot, String name) {
        for (AbstractTypeDeclaration typeDeclaration : astRoot.types()) {
            if (!typeDeclaration.getName().getFullyQualifiedName().equals(name)) continue;
            return typeDeclaration;
        }
        return null;
    }

    private static JpaQueryMethodInfo constructDefaultMethodInfo(JpaManagerBeanInfo jpaManagerBeanInfo, IMethod method, String targetNamedQuery) {
        String defaultQuery = ManagerBeanUtil.constructDefaultPrimaryKeyQuery(method, jpaManagerBeanInfo.getEntity().getEntityName());
        JpaQueryMethodInfo newNamedQuery = new JpaQueryMethodInfo(method.getElementName(), targetNamedQuery, defaultQuery, JpaQueryMethodInfo.STATUS.EXISTING);
        return newNamedQuery;
    }

    public static String createCustomQuery(String entityName, String selectClause, String fromClause, String whereClause, List<JpaOrderedAttributeInfo> orderBys, String groupClause, String havingClause) {
        String entityVariableName = NamedQueriesUtil.getEntityVariable(entityName);
        String query = "";
        if (selectClause != null && selectClause.length() > 0) {
            query = "SELECT " + selectClause;
        }
        if (fromClause != null && fromClause.length() > 0) {
            query = String.valueOf(query) + " " + QUERY_FROM + " " + fromClause;
        }
        if (whereClause != null && whereClause.length() > 0) {
            query = String.valueOf(query) + " " + QUERY_WHERE + " " + whereClause;
        }
        if (groupClause != null && groupClause.length() > 0) {
            query = String.valueOf(query) + " " + QUERY_GROUPBY + " " + groupClause;
        }
        if (havingClause != null && havingClause.length() > 0) {
            query = String.valueOf(query) + " " + QUERY_HAVING + " " + havingClause;
        }
        if (orderBys != null && orderBys.size() > 0) {
            query = String.valueOf(query) + " " + QUERY_ORDERBY;
            int i = 0;
            while (i < orderBys.size()) {
                JpaOrderedAttributeInfo attribute = orderBys.get(i);
                String columnName = attribute.getAttributeName();
                String order = null;
                Integer intOrder = attribute.getOrdering();
                if (intOrder.equals(JpaOrderedAttributeInfo.DESCENDING)) {
                    order = QUERY_DESCENDING;
                }
                if (i != 0) {
                    query = String.valueOf(query) + ',';
                }
                query = String.valueOf(query) + ' ' + entityVariableName + '.' + columnName;
                if (order != null) {
                    query = String.valueOf(query) + ' ' + order;
                }
                ++i;
            }
        }
        return query;
    }

    public static String createQuery(String entityName, List<JpaOrderedAttributeInfo> orderBys, String filters) {
        String entityVariableName = NamedQueriesUtil.getEntityVariable(entityName);
        String query = "SELECT " + entityVariableName + ' ' + QUERY_FROM + ' ' + entityName + ' ' + entityVariableName;
        query = NamedQueriesUtil.addFiltersToQuery(query, entityVariableName, filters);
        query = NamedQueriesUtil.addOrderBysToQuery(query, entityVariableName, orderBys);
        return query;
    }

    public static boolean doesNamedQueryExist(List<JpaQueryMethodInfo> queryMethodList, String newNamedQueryName) {
        for (JpaQueryMethodInfo queryMethod : queryMethodList) {
            if (queryMethod.getStatus() == JpaQueryMethodInfo.STATUS.REMOVE || queryMethod.getQueryName() == null || !queryMethod.getQueryName().equals(newNamedQueryName)) continue;
            return true;
        }
        return false;
    }

    public static String getEntityVariable(String entityName) {
        if (entityName.length() > 0) {
            return entityName.substring(0, 1).toLowerCase();
        }
        return null;
    }

    public static List<JpaQueryMethodInfo> getExistingNamedQueries(JpaManagerBeanInfo managerBean) {
        List<JpaQueryMethodInfo> namedQueries = new ArrayList<JpaQueryMethodInfo>();
        if (managerBean.isUseNamedQueries()) {
            namedQueries = NamedQueriesUtil.getNamedQueryMethods(managerBean.getEntity(), false);
        } else if (managerBean.doesManagerBeanExistForThisEntity()) {
            namedQueries = ManagerBeanCodeGenOperation.getManagerBeanNamedQueries(managerBean.getExistingManagerBeanType());
        }
        return namedQueries;
    }

    public static IMethod getManagerMethodForNamedQuery(IType type, String namedQueryName) {
        IMethod[] methods = null;
        try {
            methods = type.getMethods();
        }
        catch (JavaModelException e1) {
            e1.printStackTrace();
        }
        if (methods != null) {
            IMethod[] iMethodArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                IAnnotation annotation = method.getAnnotation("NamedQueryTarget");
                if (annotation != null && annotation.exists()) {
                    try {
                        IMemberValuePair[] iMemberValuePairArray = annotation.getMemberValuePairs();
                        int n3 = iMemberValuePairArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IMemberValuePair memberValuePair = iMemberValuePairArray[n4];
                            String targetNamedQuery = memberValuePair.getValue().toString();
                            if (namedQueryName.equals(targetNamedQuery)) {
                                return method;
                            }
                            ++n4;
                        }
                    }
                    catch (JavaModelException e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    public static List<JpaQueryMethodInfo> getNamedQueriesFromType(IType javaType) {
        ArrayList<JpaQueryMethodInfo> namedQueries = new ArrayList<JpaQueryMethodInfo>();
        IAnnotation annotation = javaType.getAnnotation("javax.persistence.NamedQueries");
        if (annotation == null || !annotation.exists()) {
            annotation = javaType.getAnnotation(JPA_NAMED_QUERY_SHORTNAME);
        }
        if (annotation != null && annotation.exists()) {
            try {
                IMemberValuePair memberValuePair;
                IMemberValuePair[] memberValuePairs = annotation.getMemberValuePairs();
                if (memberValuePairs.length > 0 && (memberValuePair = memberValuePairs[0]).getValue() instanceof Object[]) {
                    Object[] members;
                    Object[] objectArray = members = (Object[])memberValuePair.getValue();
                    int n = members.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        IAnnotation ann = (IAnnotation)object;
                        IMemberValuePair[] memberValuePairs2 = ann.getMemberValuePairs();
                        String queryName = null;
                        String queryValue = null;
                        IMemberValuePair[] iMemberValuePairArray = memberValuePairs2;
                        int n3 = memberValuePairs2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IMemberValuePair memberValuePair2 = iMemberValuePairArray[n4];
                            if (memberValuePair2.getMemberName().equals("name")) {
                                queryName = memberValuePair2.getValue().toString();
                            } else if (memberValuePair2.getMemberName().equals("query")) {
                                queryValue = memberValuePair2.getValue().toString();
                            }
                            ++n4;
                        }
                        JpaQueryMethodInfo newNamedQuery = new JpaQueryMethodInfo(queryName, queryName, queryValue, JpaQueryMethodInfo.STATUS.EXISTING);
                        namedQueries.add(newNamedQuery);
                        ++n2;
                    }
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return namedQueries;
    }

    public static JpaQueryMethodInfo getNamedQueryForMethod(JpaManagerBeanInfo jpaManagerBeanInfo, IMethod method, IType parentType) {
        block12: {
            IAnnotation annotation = method.getAnnotation("NamedQueryTarget");
            if (annotation != null && annotation.exists()) {
                try {
                    IMemberValuePair[] iMemberValuePairArray = annotation.getMemberValuePairs();
                    if (iMemberValuePairArray.length == 0) break block12;
                    IMemberValuePair memberValuePair = iMemberValuePairArray[0];
                    String targetNamedQuery = memberValuePair.getValue().toString();
                    JpaQueryMethodInfo info = null;
                    if (jpaManagerBeanInfo.isUseNamedQueries()) {
                        if (jpaManagerBeanInfo.getEntity().getPersistentType() != null) {
                            info = NamedQueriesUtil.getNamedQueryValue(jpaManagerBeanInfo.getEntity(), targetNamedQuery);
                        } else {
                            String entity = jpaManagerBeanInfo.getEntity().getFullyQualifiedEntityName();
                            IJavaProject javaProject = JavaCore.create((IProject)jpaManagerBeanInfo.getEntity().getProject());
                            IType managerBeanType = null;
                            if (javaProject != null && entity != null) {
                                try {
                                    managerBeanType = javaProject.findType(entity);
                                }
                                catch (JavaModelException e) {
                                    e.printStackTrace();
                                }
                                if (managerBeanType != null) {
                                    List<JpaQueryMethodInfo> namedQueriesFromType = NamedQueriesUtil.getNamedQueriesFromType(managerBeanType);
                                    for (JpaQueryMethodInfo query : namedQueriesFromType) {
                                        if (!targetNamedQuery.equals(query.getQueryName())) continue;
                                        info = query;
                                        break;
                                    }
                                }
                            }
                        }
                    } else {
                        info = ManagerBeanCodeGenOperation.getManagerBeanNamedQuery(targetNamedQuery, parentType);
                    }
                    JpaQueryMethodInfo methodInfo = null;
                    methodInfo = info != null ? new JpaQueryMethodInfo(method.getElementName(), info.getQueryName(), info.getQueryValue(), JpaQueryMethodInfo.STATUS.EXISTING) : NamedQueriesUtil.constructDefaultMethodInfo(jpaManagerBeanInfo, method, targetNamedQuery);
                    return methodInfo;
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static JpaQueryMethodInfo getNamedQueryForMethod(JpaManagerBeanInfo jpaManagerBeanInfo, IMethod method, IType parentType, List<JpaQueryMethodInfo> existingNamedQueries) {
        IAnnotation annotation = method.getAnnotation("NamedQueryTarget");
        if (annotation != null && annotation.exists()) {
            try {
                IMemberValuePair[] iMemberValuePairArray = annotation.getMemberValuePairs();
                if (iMemberValuePairArray.length != 0) {
                    IMemberValuePair memberValuePair = iMemberValuePairArray[0];
                    String targetNamedQuery = memberValuePair.getValue().toString();
                    for (JpaQueryMethodInfo existingNamedQuery : existingNamedQueries) {
                        if (!targetNamedQuery.equals(existingNamedQuery.getQueryName())) continue;
                        existingNamedQuery.setMethodName(method.getElementName());
                        return existingNamedQuery;
                    }
                    return NamedQueriesUtil.constructDefaultMethodInfo(jpaManagerBeanInfo, method, targetNamedQuery);
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static List<JpaQueryMethodInfo> getNamedQueryMethodInfos(JpaManagerBeanInfo jpaManagerBeanInfo, boolean useDefaultsIfNoQueriesFound) {
        ArrayList<JpaQueryMethodInfo> namedQueryMethods = new ArrayList();
        if (jpaManagerBeanInfo.doesManagerBeanExistForThisEntity()) {
            IMethod[] methods = null;
            IType managerBean = jpaManagerBeanInfo.getExistingManagerBeanType();
            if (managerBean != null) {
                try {
                    List<JpaQueryMethodInfo> namedQueries = null;
                    if (jpaManagerBeanInfo.isUseNamedQueries()) {
                        if (jpaManagerBeanInfo.getEntity().getPersistentType() != null) {
                            namedQueries = NamedQueriesUtil.getNamedQueryMethods(jpaManagerBeanInfo.getEntity(), false);
                        } else {
                            String entity = jpaManagerBeanInfo.getEntity().getFullyQualifiedEntityName();
                            IJavaProject javaProject = JavaCore.create((IProject)jpaManagerBeanInfo.getEntity().getProject());
                            IType managerBeanType = null;
                            if (javaProject != null && entity != null && (managerBeanType = javaProject.findType(entity)) != null) {
                                namedQueries = NamedQueriesUtil.getNamedQueriesFromType(managerBeanType);
                            }
                        }
                    } else {
                        namedQueries = ManagerBeanCodeGenOperation.getManagerBeanNamedQueries(jpaManagerBeanInfo.getExistingManagerBeanType());
                    }
                    if (namedQueries != null) {
                        IMethod[] iMethodArray = methods = managerBean.getMethods();
                        int n = methods.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMethod method = iMethodArray[n2];
                            JpaQueryMethodInfo methodInfo = NamedQueriesUtil.getNamedQueryForMethod(jpaManagerBeanInfo, method, managerBean, namedQueries);
                            if (methodInfo != null) {
                                namedQueryMethods.add(methodInfo);
                            }
                            ++n2;
                        }
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
        } else {
            namedQueryMethods = NamedQueriesUtil.getNamedQueryMethods(jpaManagerBeanInfo.getEntity(), false);
            if (useDefaultsIfNoQueriesFound) {
                NamedQueriesUtil.addDefaultNamedQueriesIfNeeded(namedQueryMethods, jpaManagerBeanInfo.getEntity());
            }
        }
        return namedQueryMethods;
    }

    public static List<JpaQueryMethodInfo> getNamedQueryMethods(JpaEntityInfo entity, boolean isNew) {
        if (entity == null) {
            return new ArrayList<JpaQueryMethodInfo>(0);
        }
        PersistentType jpType = entity.getPersistentType();
        return NamedQueriesUtil.getNamedQueryMethods(jpType, isNew);
    }

    public static List<JpaQueryMethodInfo> getNamedQueryMethods(PersistentType jpType, boolean isNew) {
        TypeMapping mapping;
        ArrayList<JpaQueryMethodInfo> namedQueries = new ArrayList<JpaQueryMethodInfo>();
        if (jpType != null && (mapping = jpType.getMapping()) instanceof Entity) {
            Entity currentEntity = (Entity)mapping;
            ListIterator queries = currentEntity.namedQueries();
            while (queries.hasNext()) {
                NamedQuery query = (NamedQuery)queries.next();
                JpaQueryMethodInfo.STATUS queryStatus = isNew ? JpaQueryMethodInfo.STATUS.NEW : JpaQueryMethodInfo.STATUS.EXISTING;
                if (query.getName() == null) continue;
                JpaQueryMethodInfo newNamedQuery = new JpaQueryMethodInfo(query.getName(), query.getName(), query.getQuery(), queryStatus);
                namedQueries.add(newNamedQuery);
            }
        }
        return namedQueries;
    }

    public static List<NamedQueryParameter> getNamedQueryParameters(JpaEntityInfo entityInfo, String namedQueryString) {
        return NamedQueriesUtil.parseNamedQueryParameters(entityInfo, namedQueryString);
    }

    public static JpaQueryMethodInfo getNamedQueryValue(JpaEntityInfo entity, String namedQueryName) {
        PersistentType jpType = entity.getPersistentType();
        TypeMapping mapping = jpType.getMapping();
        if (mapping instanceof Entity) {
            Entity currentEntity = (Entity)mapping;
            ListIterator queries = currentEntity.namedQueries();
            while (queries.hasNext()) {
                NamedQuery query = (NamedQuery)queries.next();
                if (!namedQueryName.equals(query.getName())) continue;
                JpaQueryMethodInfo newNamedQuery = new JpaQueryMethodInfo("", query.getName(), query.getQuery(), JpaQueryMethodInfo.STATUS.EXISTING);
                return newNamedQuery;
            }
        }
        return null;
    }

    public static NamedQueryParameter.TemporalType getTemporalTypeForAttribute(JpaEntityInfo enityInfo, String attributeName) {
        List<JpaAttributeInfo> attributes = enityInfo.getAttributes();
        for (JpaAttributeInfo jpaAttributeInfo : attributes) {
            if (!jpaAttributeInfo.getAttributeName().equals(attributeName)) continue;
            return jpaAttributeInfo.getTemporalType();
        }
        return NamedQueryParameter.TemporalType.NONE;
    }

    public static NamedQueryParameter.TemporalType getTemporalTypeForAttribute(PersistentAttribute jpAtt) {
        AttributeMapping mapping = jpAtt.getMapping();
        if (mapping instanceof ColumnMapping) {
            TemporalType temporalType = ((ColumnMapping)mapping).getTemporal();
            if (temporalType == TemporalType.DATE) {
                return NamedQueryParameter.TemporalType.DATE;
            }
            if (temporalType == TemporalType.TIME) {
                return NamedQueryParameter.TemporalType.TIME;
            }
            if (temporalType == TemporalType.TIMESTAMP) {
                return NamedQueryParameter.TemporalType.TIMESTAMP;
            }
            return NamedQueryParameter.TemporalType.NONE;
        }
        return NamedQueryParameter.TemporalType.NONE;
    }

    public static String getTypeForComplexAttribute(JpaProject project, String fullyQualifiedEmbeddedAttirbuteName, PersistentType entity) {
        ArrayList<String> propertyList = new ArrayList<String>();
        StringTokenizer toker = new StringTokenizer(fullyQualifiedEmbeddedAttirbuteName, ".");
        while (toker.hasMoreElements()) {
            propertyList.add(toker.nextToken());
        }
        if (propertyList.size() > 2) {
            String embeddedId = (String)propertyList.get(1);
            String embeddedPropertyName = (String)propertyList.get(propertyList.size() - 1);
            Iterator attributes = entity.allAttributes();
            while (attributes.hasNext()) {
                PersistentAttribute jpAtt = (PersistentAttribute)attributes.next();
                String attName = jpAtt.getName();
                if (!embeddedId.equals(attName)) continue;
                String mappingKey = jpAtt.getMappingKey();
                if (mappingKey == MappingKeys.NULL_TYPE_MAPPING_KEY || !mappingKey.equals("embeddedId") && !mappingKey.equals("embedded") && !mappingKey.equals("oneToOne") && !mappingKey.equals("oneToMany") && !mappingKey.equals("manyToOne") && !mappingKey.equals("manyToMany")) break;
                List<JpaAttributeInfo> embeddedAttributes = JpaEntityInfo.getEmbeddedAttributes(project, jpAtt.getMapping(), new JpaAttributeInfo(jpAtt), false);
                for (JpaAttributeInfo jpaAttributeInfo : embeddedAttributes) {
                    String attributeName = jpaAttributeInfo.getAttributeName();
                    if (attributeName == null || !(attributeName = Signature.getSimpleName((String)attributeName)).equals(embeddedPropertyName)) continue;
                    String attributeType = jpaAttributeInfo.getAttributeType();
                    return attributeType;
                }
            }
            return null;
        }
        return null;
    }

    public static String getTypeForEntityProperty(String propertyName, PersistentType entity) {
        Iterator attributes = entity.allAttributes();
        while (attributes.hasNext()) {
            PersistentAttribute jpAtt = (PersistentAttribute)attributes.next();
            String attName = jpAtt.getName();
            if (!propertyName.equals(attName)) continue;
            if (jpAtt instanceof JavaPersistentAttribute) {
                return ((JavaPersistentAttribute)jpAtt).getResourcePersistentAttribute().getQualifiedTypeName();
            }
            if (!(jpAtt instanceof OrmPersistentAttribute)) continue;
            return ((OrmPersistentAttribute)jpAtt).getMapping().getJavaPersistentAttribute().getResourcePersistentAttribute().getQualifiedTypeName();
        }
        return null;
    }

    public static String getTypeForFunction(NamedQuerySelectParts.PARAM_TYPE functionType, String propertyName, PersistentType entity) {
        if (functionType == NamedQuerySelectParts.PARAM_TYPE.AVG) {
            return "java.lang.Double";
        }
        if (functionType == NamedQuerySelectParts.PARAM_TYPE.COUNT) {
            return "java.lang.Long";
        }
        if (functionType == NamedQuerySelectParts.PARAM_TYPE.MAX || functionType == NamedQuerySelectParts.PARAM_TYPE.MIN) {
            return NamedQueriesUtil.getTypeForEntityProperty(propertyName, entity);
        }
        if (functionType == NamedQuerySelectParts.PARAM_TYPE.SUM) {
            String type = NamedQueriesUtil.getTypeForEntityProperty(propertyName, entity);
            if (type == null) {
                type = NamedQueriesUtil.getTypeForComplexAttribute(entity.getJpaProject(), propertyName, entity);
            }
            if (type.equals("int") || type.equals("java.lang.Integer")) {
                return "java.lang.Long";
            }
            if (type.equals("float") || type.equals("double")) {
                return "java.lang.Double";
            }
            if (type.equals("java.math.BigInteger")) {
                return type;
            }
            if (type.equals("java.math.BigDecimal")) {
                return type;
            }
        }
        return null;
    }

    private static List<NamedQueryParameter> parseNamedQueryParameters(JpaEntityInfo entityInfo, String namedQueryString) {
        ArrayList<NamedQueryParameter> namedQueryParams = new ArrayList<NamedQueryParameter>();
        JpaFilterInfo filter = new JpaFilterInfo();
        filter.setPredicate(namedQueryString);
        filter.initializeFilters(entityInfo);
        filter.updateJPAFilterData(entityInfo);
        if (filter != null) {
            for (JpaFilterParameterInfo filterParam : filter.getParameters()) {
                NamedQueryParameter namedQueryParameter = new NamedQueryParameter();
                String filterParamName = filterParam.getParameterName();
                namedQueryParameter.setName(filterParamName);
                String filterParamEntityAttribute = filterParam.getAttributeName();
                String entityPropertyType = "";
                int index = filterParamEntityAttribute.indexOf(46);
                if (index >= 0) {
                    entityPropertyType = NamedQueriesUtil.getTypeForComplexAttribute(entityInfo.getPersistentType().getJpaProject(), "e." + filterParamEntityAttribute, entityInfo.getPersistentType());
                    if (entityPropertyType == null) {
                        entityPropertyType = "java.lang.Object";
                    }
                } else {
                    entityPropertyType = NamedQueriesUtil.getTypeForEntityProperty(filterParamEntityAttribute, entityInfo.getPersistentType());
                }
                namedQueryParameter.setFullyQualifiedType(entityPropertyType);
                namedQueryParameter.setTemporalType(NamedQueriesUtil.getTemporalTypeForAttribute(entityInfo, filterParamEntityAttribute));
                namedQueryParams.add(namedQueryParameter);
            }
        }
        return namedQueryParams;
    }

    private static void removeNamedQueryFromEntity(Entity entity, List<JpaQueryMethodInfo> removedQueries) {
        int index = 0;
        HashMap<Integer, JpaQueryMethodInfo> queryToIndexMap = new HashMap<Integer, JpaQueryMethodInfo>();
        ListIterator i = entity.namedQueries();
        while (i.hasNext()) {
            NamedQuery q = (NamedQuery)i.next();
            for (JpaQueryMethodInfo toBeRemovedQuery : removedQueries) {
                if (!toBeRemovedQuery.getQueryName().equals(q.getName()) || !toBeRemovedQuery.getQueryValue().equals(q.getQuery())) continue;
                queryToIndexMap.put(index, toBeRemovedQuery);
                break;
            }
            ++index;
        }
        ArrayList indexList = new ArrayList(queryToIndexMap.keySet());
        Collections.sort(indexList);
        int numIndexes = indexList.size();
        int i2 = numIndexes - 1;
        while (i2 >= 0) {
            index = (Integer)indexList.get(i2);
            entity.removeNamedQuery(index);
            --i2;
        }
    }

    public static boolean shouldIgnoreAttribute(String attributeType) {
        String[] stringArray = IGNORE_TYPES;
        int n = IGNORE_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String ignoreType = stringArray[n2];
            if (attributeType != null && attributeType.equals(ignoreType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

