/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.util;

import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webtools.javamodel.api.JavaCodeUtil;
import com.ibm.etools.webtools.jpa.models.JpaAttributeInfo;
import com.ibm.etools.webtools.jpa.models.JpaEntityInfo;
import com.ibm.etools.webtools.jpa.models.JpaManagerBeanController;
import com.ibm.etools.webtools.jpa.models.JpaManagerBeanInfo;
import com.ibm.etools.webtools.jpa.models.JpaOrderedAttributeInfo;
import com.ibm.etools.webtools.jpa.models.JpaQueryMethodInfo;
import com.ibm.etools.webtools.jpa.util.NamedQueriesUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.orm.EntityMappings;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmXml;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.core.internal.JpaModelManager;
import org.eclipse.jpt.core.internal.context.GenericRootContextNode;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class JpaUtil {
    private static void addReferences(IProject rootProject, HashMap existingProjects) {
        IVirtualReference[] references;
        IVirtualComponent createComponent;
        if (rootProject != null && existingProjects != null && (createComponent = ComponentCore.createComponent((IProject)rootProject)) != null && (references = createComponent.getReferences()) != null) {
            IVirtualReference[] iVirtualReferenceArray = references;
            int n = references.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project;
                IVirtualReference virtualReference = iVirtualReferenceArray[n2];
                IVirtualComponent referencedComponent = virtualReference.getReferencedComponent();
                if (referencedComponent != null && !referencedComponent.isBinary() && (project = referencedComponent.getProject()) != null && project.exists() && !existingProjects.containsKey(project.getName())) {
                    existingProjects.put(project.getName(), project);
                    JpaUtil.addReferences(project, existingProjects);
                }
                ++n2;
            }
        }
    }

    public static boolean compareStrings(String value, String value2) {
        if (value == null && value2 == null) {
            return true;
        }
        if (value != null && value2 != null) {
            return value.equals(value2);
        }
        return false;
    }

    public static boolean compareStringsIgnoreCase(String value, String value2) {
        if (value == null && value2 == null) {
            return true;
        }
        if (value != null && value2 != null) {
            return value.equalsIgnoreCase(value2);
        }
        return false;
    }

    public static boolean contains(List<JpaManagerBeanInfo> managerBeans, String entityName) {
        boolean retVal = false;
        for (JpaManagerBeanInfo managerBean : managerBeans) {
            if (!managerBean.getEntity().getName().equals(entityName)) continue;
            return true;
        }
        return retVal;
    }

    public static final List<JpaManagerBeanInfo> createExistingManagerBeanModels(IProject project, boolean lookInDependentProjects) {
        IProject[] allProjects;
        ArrayList<JpaManagerBeanInfo> managerBeans = new ArrayList<JpaManagerBeanInfo>();
        IProject[] iProjectArray = allProjects = JpaUtil.getProjectAndDependentProjects(project, lookInDependentProjects);
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject allProject = iProjectArray[n2];
            List<ManagerBeanInfoContainer> managerBeansByAnnotationList = JpaManagerBeanController.getInstance().getAllManagerBeans(allProject);
            for (ManagerBeanInfoContainer managerBeanInfo : managerBeansByAnnotationList) {
                IProject managerBeanProject = JpaUtil.getManagerBeanProject(managerBeanInfo.getMangerBeanType(), project);
                IProject targetEntityProject = JpaUtil.getTargetEntityProject(managerBeanProject, managerBeanInfo.getTargetEntity());
                managerBeans.add(new JpaManagerBeanInfo(new JpaEntityInfo(null, managerBeanInfo.getTargetEntity(), targetEntityProject), managerBeanInfo.getMangerBeanType(), false));
            }
            ++n2;
        }
        return managerBeans;
    }

    public static final List<JpaManagerBeanInfo> createExistingManagerBeanModelsWithEntities(IProject project, boolean lookInDependentProjects) {
        IProject[] dependentProjects;
        ArrayList<JpaManagerBeanInfo> managerBeans = new ArrayList<JpaManagerBeanInfo>();
        ArrayList<ManagerBeanInfoContainer> managerBeansByAnnotationList = null;
        managerBeansByAnnotationList = new ArrayList<ManagerBeanInfoContainer>();
        IProject[] iProjectArray = dependentProjects = JpaUtil.getProjectAndDependentProjects(project, lookInDependentProjects);
        int n = dependentProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject dependentProject = iProjectArray[n2];
            managerBeansByAnnotationList.addAll(JpaManagerBeanController.getInstance().getAllManagerBeans(dependentProject));
            ++n2;
        }
        HashMap<String, PersistentType> existingEntitiesMap = JpaUtil.getExistingEntitiesMap(project, true);
        for (ManagerBeanInfoContainer managerBeanInfo : managerBeansByAnnotationList) {
            PersistentType persistentType = existingEntitiesMap.get(managerBeanInfo.getTargetEntity());
            IProject targetEntityProject = null;
            IProject managerBeanProject = JpaUtil.getManagerBeanProject(managerBeanInfo.getMangerBeanType(), project);
            targetEntityProject = persistentType != null ? persistentType.getResource().getProject() : JpaUtil.getTargetEntityProject(managerBeanProject, managerBeanInfo.getTargetEntity());
            managerBeans.add(new JpaManagerBeanInfo(new JpaEntityInfo(persistentType, managerBeanInfo.getTargetEntity(), targetEntityProject), managerBeanInfo.getMangerBeanType(), false));
        }
        return managerBeans;
    }

    public static final List<JpaManagerBeanInfo> createManagerBeanModels(IProject project, boolean lookInDependentProjects) {
        JpaProject[] jpaProjects = JpaUtil.getAllJpaProjects(project, lookInDependentProjects);
        ArrayList<JpaManagerBeanInfo> managerBeans = new ArrayList<JpaManagerBeanInfo>();
        JpaProject[] jpaProjectArray = jpaProjects;
        int n = jpaProjects.length;
        int n2 = 0;
        while (n2 < n) {
            JpaProject jpaProject = jpaProjectArray[n2];
            List<ManagerBeanInfoContainer> managerBeansByAnnotationList = JpaManagerBeanController.getInstance().getAllManagerBeans(project);
            List<PersistentType> entitiesFromProject = JpaUtil.getEntities(jpaProject);
            for (PersistentType persistentType : entitiesFromProject) {
                JpaManagerBeanInfo jpaManagerBeanInfo = new JpaManagerBeanInfo(new JpaEntityInfo(persistentType, false), project, false);
                managerBeans.add(jpaManagerBeanInfo);
                String name = jpaManagerBeanInfo.getManagerBeanName();
                while (!JpaUtil.isManagerBeanNameUnique(name, managerBeansByAnnotationList)) {
                    name = JavaCodeUtil.increment((String)name);
                }
                if (name.equals(jpaManagerBeanInfo.getManagerBeanName())) continue;
                jpaManagerBeanInfo.setManagerBeanName(name);
            }
            ++n2;
        }
        return managerBeans;
    }

    public static final void fillManagerBeanWithEntityType(IProject project, JpaManagerBeanInfo managerBeanInfo) {
        JpaProject[] jpaProjects;
        JpaProject[] jpaProjectArray = jpaProjects = JpaUtil.getAllJpaProjects(project, true);
        int n = jpaProjects.length;
        int n2 = 0;
        while (n2 < n) {
            JpaProject jpaProject = jpaProjectArray[n2];
            List<PersistentType> entitiesFromProject = JpaUtil.getEntities(jpaProject);
            for (PersistentType persistentType : entitiesFromProject) {
                String entityName = persistentType.getName();
                if (entityName == null || !entityName.equals(managerBeanInfo.getEntity().getFullyQualifiedEntityName())) continue;
                managerBeanInfo.getEntity().setPersistentType(persistentType);
                return;
            }
            ++n2;
        }
    }

    private static JpaProject[] getAllJpaProjects(IProject project, boolean lookInDependentProjects) {
        ArrayList<JpaProject> jpaProjects = new ArrayList<JpaProject>();
        if (project != null) {
            IProject[] dependentProjects;
            JpaProject jpaProject = null;
            IProject[] iProjectArray = dependentProjects = JpaUtil.getProjectAndDependentProjects(project, lookInDependentProjects);
            int n = dependentProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject dependentProject = iProjectArray[n2];
                try {
                    jpaProject = JpaModelManager.instance().getJpaProject(dependentProject);
                }
                catch (CoreException ex) {
                    ex.printStackTrace();
                }
                if (jpaProject != null) {
                    jpaProjects.add(jpaProject);
                }
                ++n2;
            }
        }
        return jpaProjects.toArray(new JpaProject[0]);
    }

    public static List<JpaOrderedAttributeInfo> getAvailableAttributes(JpaEntityInfo entity, JpaQueryMethodInfo queryMethod) {
        ArrayList<JpaOrderedAttributeInfo> availableAttributes = new ArrayList<JpaOrderedAttributeInfo>();
        List<JpaOrderedAttributeInfo> orderedAttributes = queryMethod.getOrderedAttributes();
        boolean found = false;
        for (JpaAttributeInfo attribute : entity.getAttributes()) {
            found = false;
            if (orderedAttributes != null) {
                for (JpaOrderedAttributeInfo next : orderedAttributes) {
                    if (!attribute.getAttributeName().equals(next.getAttributeName())) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            availableAttributes.add(new JpaOrderedAttributeInfo(attribute.getAttributeName()));
        }
        return availableAttributes;
    }

    public static final String getBaseLocation(HTMLEditDomain domain) {
        String fileLocation = domain.getActiveModel().getBaseLocation();
        if (fileLocation != null) {
            IPath location;
            IFile file;
            Path filePath = new Path(fileLocation);
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            if (root != null && (file = filePath.toFile().exists() ? root.getFileForLocation((IPath)filePath) : root.getFile((IPath)filePath)) != null && (location = file.getLocation()) != null) {
                fileLocation = location.toString();
            }
        }
        return fileLocation;
    }

    public static final List<JpaQueryMethodInfo> getDefaultQueryMethods(JpaManagerBeanInfo managerBean) {
        if (managerBean == null) {
            return null;
        }
        ArrayList<JpaQueryMethodInfo> namedQueryMethods = new ArrayList<JpaQueryMethodInfo>();
        NamedQueriesUtil.addDefaultNamedQueriesIfNeeded(namedQueryMethods, managerBean.getEntity());
        return namedQueryMethods;
    }

    private static List<PersistentType> getEntities(JpaProject jpaProject) {
        PersistenceUnit persistenceUnit;
        ListIterator persistenceUnits;
        ArrayList<PersistentType> entities = new ArrayList<PersistentType>();
        GenericRootContextNode rootContext = (GenericRootContextNode)jpaProject.getRootContext();
        PersistenceXml persistenceXml = rootContext.getPersistenceXml();
        if (persistenceXml != null && (persistenceUnits = persistenceXml.getPersistence().persistenceUnits()).hasNext() && (persistenceUnit = (PersistenceUnit)persistenceUnits.next()) != null) {
            ListIterator classRefs = persistenceUnit.classRefs();
            while (classRefs.hasNext()) {
                ClassRef classRef = (ClassRef)classRefs.next();
                if (classRef.getJavaPersistentType() == null || classRef.getJavaPersistentType().getMappingKey() != "entity") continue;
                entities.add((PersistentType)classRef.getJavaPersistentType());
            }
            ListIterator mappingFiles = persistenceUnit.mappingFileRefs();
            while (mappingFiles.hasNext()) {
                EntityMappings entityMappings;
                MappingFileRef mappingFileRef = (MappingFileRef)mappingFiles.next();
                OrmXml ormXml = mappingFileRef.getOrmXml();
                if (ormXml == null || (entityMappings = ormXml.getEntityMappings()) == null) continue;
                ListIterator persistentTypes = entityMappings.ormPersistentTypes();
                while (persistentTypes.hasNext()) {
                    OrmPersistentType ormPersistentType = (OrmPersistentType)persistentTypes.next();
                    if (ormPersistentType.getMappingKey() != "entity") continue;
                    entities.add((PersistentType)ormPersistentType);
                }
            }
        }
        return entities;
    }

    public static List<JpaEntityInfo> getEntitiesInProject(IProject project, boolean lookInDependentProjects) {
        ArrayList<JpaEntityInfo> entities = new ArrayList<JpaEntityInfo>();
        if (project != null) {
            JpaProject[] jpaProjects;
            JpaProject[] jpaProjectArray = jpaProjects = JpaUtil.getAllJpaProjects(project, lookInDependentProjects);
            int n = jpaProjects.length;
            int n2 = 0;
            while (n2 < n) {
                JpaProject jpaProject = jpaProjectArray[n2];
                List<PersistentType> entitiesFromProject = JpaUtil.getEntities(jpaProject);
                for (PersistentType persistentType : entitiesFromProject) {
                    entities.add(new JpaEntityInfo(persistentType));
                }
                ++n2;
            }
        }
        return entities;
    }

    public static JpaEntityInfo getEntityByName(JpaProject jpaProj, String entityName) {
        String simpleEntityName = Signature.getSimpleName((String)entityName);
        JpaEntityInfo entity = null;
        List<JpaEntityInfo> entities = JpaUtil.getEntitiesInProject(jpaProj.getProject(), false);
        for (JpaEntityInfo entityFromList : entities) {
            if (!entityFromList.getEntityName().equals(simpleEntityName)) continue;
            entity = entityFromList;
            break;
        }
        return entity;
    }

    public static String getEntityNameFromType(IType managerBeanType) {
        String entityName = null;
        IAnnotation annotation = managerBeanType.getAnnotation("JPAManager");
        if (annotation != null && annotation.exists()) {
            try {
                IMemberValuePair[] iMemberValuePairArray = annotation.getMemberValuePairs();
                int n = iMemberValuePairArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemberValuePair memberValuePair = iMemberValuePairArray[n2];
                    if (memberValuePair.getMemberName().equals("targetEntity")) {
                        entityName = memberValuePair.getValue().toString();
                        break;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return entityName;
    }

    private static HashMap<String, PersistentType> getExistingEntitiesMap(IProject rootProject, boolean lookInDependentProj) {
        JpaProject[] jpaProjects;
        HashMap<String, PersistentType> jpTypes = new HashMap<String, PersistentType>();
        JpaProject[] jpaProjectArray = jpaProjects = JpaUtil.getAllJpaProjects(rootProject, lookInDependentProj);
        int n = jpaProjects.length;
        int n2 = 0;
        while (n2 < n) {
            JpaProject jpaProject = jpaProjectArray[n2];
            List<PersistentType> entitiesFromProject = JpaUtil.getEntities(jpaProject);
            for (PersistentType persistentType : entitiesFromProject) {
                String entityName = persistentType.getName();
                if (entityName == null) continue;
                jpTypes.put(entityName, persistentType);
            }
            ++n2;
        }
        return jpTypes;
    }

    public static IResource getJavaResourceFromPersistentType(PersistentType type) {
        if (type instanceof JavaPersistentType) {
            return type.getResource();
        }
        if (type instanceof OrmPersistentType) {
            return type.getOrmPersistentType().getJavaPersistentType().getResource();
        }
        return null;
    }

    public static final JpaEntityInfo getJpaEntityInfoFromName(String entityName, List<JpaManagerBeanInfo> managerBeans) {
        for (JpaManagerBeanInfo managerBean : managerBeans) {
            if (!managerBean.getEntity().getEntityName().equals(entityName)) continue;
            return managerBean.getEntity();
        }
        return null;
    }

    public static IProject getManagerBeanProject(IType managerBeanType, IProject rootProject) {
        IProject managerBeanProject = null;
        if (managerBeanType != null && managerBeanType.getResource() != null) {
            managerBeanProject = managerBeanType.getResource().getProject();
        }
        if (managerBeanProject == null) {
            managerBeanProject = rootProject;
        }
        return managerBeanProject;
    }

    public static String getMethodName(String fieldName, boolean isGetter) {
        String methodName = "";
        methodName = isGetter ? "get" : "set";
        methodName = String.valueOf(methodName) + fieldName.substring(0, 1).toUpperCase();
        methodName = String.valueOf(methodName) + fieldName.substring(1);
        return methodName;
    }

    public static final String getPersistenceUnitName(JpaProject project) {
        PersistenceUnit persistenceUnit;
        ListIterator persistenceUnits;
        String puName = null;
        if (project == null) {
            return puName;
        }
        GenericRootContextNode rootContext = (GenericRootContextNode)project.getRootContext();
        PersistenceXml persistenceXml = rootContext.getPersistenceXml();
        if (persistenceXml != null && (persistenceUnits = persistenceXml.getPersistence().persistenceUnits()).hasNext() && (persistenceUnit = (PersistenceUnit)persistenceUnits.next()) != null && (puName = persistenceUnit.getName()) == null) {
            puName = project.getProject().getName();
        }
        return puName;
    }

    public static IProject[] getProjectAndDependentProjects(IProject rootProject, boolean lookInDependentProjects) {
        HashMap<String, IProject> allProjects = new HashMap<String, IProject>(1);
        if (rootProject != null) {
            allProjects.put(rootProject.getName(), rootProject);
            if (lookInDependentProjects) {
                JpaUtil.addReferences(rootProject, allProjects);
            }
        }
        return allProjects.values().toArray(new IProject[0]);
    }

    public static final List<JpaQueryMethodInfo> getQueryMethods(JpaManagerBeanInfo managerBean) {
        if (managerBean == null) {
            return null;
        }
        return managerBean.getQueryMethods();
    }

    public static final IResource getResource(HTMLEditDomain actionTarget) {
        return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(JpaUtil.getBaseLocation(actionTarget)));
    }

    public static final IFolder getSourceFolder(IProject project) {
        IPackageFragmentRoot[] sources = J2EEProjectUtilities.getSourceContainers((IProject)project);
        if (sources == null || sources.length == 0) {
            return null;
        }
        IPackageFragmentRoot root = sources[0];
        IResource res = root.getResource();
        return (IFolder)res;
    }

    public static IProject getTargetEntityProject(IProject managerBeanProject, String fullyQualifiedTargetEntity) {
        IProject project = null;
        if (managerBeanProject != null) {
            if (fullyQualifiedTargetEntity != null) {
                IJavaProject jProj = JavaCore.create((IProject)managerBeanProject);
                IType type = null;
                if (jProj != null) {
                    try {
                        type = jProj.findType(fullyQualifiedTargetEntity);
                        if (type != null) {
                            project = type.getResource().getProject();
                        }
                    }
                    catch (JavaModelException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (project == null) {
                project = managerBeanProject;
            }
        }
        return project;
    }

    public static IType getType(IProject project, String fullyQualifiedName) {
        IType result = null;
        IJavaProject jProj = JavaCore.create((IProject)project);
        try {
            result = jProj.findType(fullyQualifiedName);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getUniqueDataName(String suggestedDataName, IField[] fields) {
        String[] attributeNames = new String[fields.length];
        int i = 0;
        while (i < attributeNames.length) {
            attributeNames[i] = fields[i].getElementName();
            ++i;
        }
        return JpaUtil.getUniqueDataName(suggestedDataName, attributeNames);
    }

    public static String getUniqueDataName(String suggestedDataName, String[] existingNames) {
        String dataName = suggestedDataName;
        while (JpaUtil.nameExistsInList(dataName, existingNames)) {
            dataName = JavaCodeUtil.increment((String)dataName);
        }
        return dataName;
    }

    public static String getValidMethodName(String methodName) {
        return methodName.replace('.', '_');
    }

    public static boolean isJPAEntity(IType type) {
        if (type != null) {
            IAnnotation annotation = type.getAnnotation("Entity");
            return annotation != null && annotation.exists();
        }
        return false;
    }

    public static boolean isJPAManagerBean(IType type) {
        if (type != null) {
            IAnnotation annotation = type.getAnnotation("JPAManager");
            return annotation != null && annotation.exists();
        }
        return false;
    }

    private static boolean isManagerBeanNameUnique(String name, List<ManagerBeanInfoContainer> managerBeansByAnnotationList) {
        for (ManagerBeanInfoContainer managerBeanInfoContainer : managerBeansByAnnotationList) {
            if (!name.equals(managerBeanInfoContainer.getMangerBeanType().getElementName())) continue;
            return false;
        }
        return true;
    }

    private static boolean nameExistsInList(String suggestedDataName, String[] existingNames) {
        String[] stringArray = existingNames;
        int n = existingNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.equalsIgnoreCase(suggestedDataName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static class ManagerBeanInfoContainer {
        private String targetEntity;
        private IType mangerBeanType;

        public ManagerBeanInfoContainer(IType mangerBeanType) {
            this.mangerBeanType = mangerBeanType;
        }

        public IType getMangerBeanType() {
            return this.mangerBeanType;
        }

        public String getTargetEntity() {
            if (this.targetEntity == null) {
                this.targetEntity = JpaUtil.getEntityNameFromType(this.mangerBeanType);
            }
            return this.targetEntity;
        }

        public void setMangerBeanType(IType mangerBeanType) {
            this.mangerBeanType = mangerBeanType;
        }

        public void setTargetEntity(String targetEntity) {
            this.targetEntity = targetEntity;
        }
    }
}

