/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.util;

import com.ibm.etools.common.internal.migration.plugin.MigrationPlugin;
import com.ibm.etools.webtools.customtag.lib.ClasspathVariableUtil;
import com.ibm.etools.webtools.customtag.lib.TaglibFeaturePlugin;
import com.ibm.etools.webtools.jpa.wizard.operations.JpaPageOperation;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ClasspathVariableInitializer;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClasspathAttribute;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.osgi.framework.Bundle;

public class JPAClassPathVariableInitializer
extends ClasspathVariableInitializer {
    public static final String JPA_WEB_DEV = "JPA_WEB_DEV";
    public static final String JPA_WEB_JAR = "web-jpa-dev.jar";
    public static final String JPA_WEB_JAR_PATH = "jars/jpa";

    public static void addJPAClassPathEntry(IProject project, IProgressMonitor spm2) throws JavaModelException {
        IPath thisClassPathVariablePath = ClasspathVariableUtil.getClassPathVariable((String)JPA_WEB_DEV, (boolean)false, null, (IProgressMonitor)spm2);
        if (thisClassPathVariablePath != null) {
            IClasspathEntry entry = JavaCore.newVariableEntry((IPath)new Path(JPA_WEB_DEV), null, null, (IAccessRule[])ClasspathEntry.NO_ACCESS_RULES, (IClasspathAttribute[])new IClasspathAttribute[]{new ClasspathAttribute("org.eclipse.jst.component.nondependency", "")}, (boolean)false);
            ClasspathVariableUtil.addClasspathEntry((IClasspathEntry)entry, (IProject)project, (IProgressMonitor)spm2);
        }
    }

    public static void addJPADevResources(IProject project, IProgressMonitor spm2) throws JavaModelException {
        if (MigrationPlugin.getDefault().getPluginPreferences().getBoolean("backward_compatible")) {
            JPAClassPathVariableInitializer.importJPAWebDevJar(project, spm2);
        } else {
            JPAClassPathVariableInitializer.addJPAClassPathEntry(project, spm2);
        }
    }

    private static Path getJarPluginPath() {
        String sdoRuntimeLocation = TaglibFeaturePlugin.getInstallLocation().toString();
        Path wdoRuntimePath = new Path(sdoRuntimeLocation);
        return wdoRuntimePath;
    }

    private static String getSourceLocation(String jarName) {
        try {
            return FileLocator.toFileURL((URL)FileLocator.find((Bundle)TaglibFeaturePlugin.getDefault().getBundle(), (IPath)new Path("jars/jpa/" + jarName), null)).getPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static void importJPAWebDevJar(IProject project, IProgressMonitor monitor) {
        boolean added = false;
        IFile webJpaJar = JpaPageOperation.getTargetFile(project, JPA_WEB_JAR);
        if (!webJpaJar.exists()) {
            String source = JPAClassPathVariableInitializer.getSourceLocation(JPA_WEB_JAR);
            try {
                FileInputStream input = new FileInputStream(source);
                webJpaJar.create((InputStream)input, true, monitor);
                added = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (CoreException coreException) {}
        }
        if (!added) {
            try {
                JPAClassPathVariableInitializer.addJPAClassPathEntry(project, monitor);
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
    }

    public void initialize(String variable) {
        try {
            IPath path = null;
            if (variable.equalsIgnoreCase(JPA_WEB_DEV)) {
                path = JPAClassPathVariableInitializer.getJarPluginPath().append(JPA_WEB_JAR_PATH).append(JPA_WEB_JAR);
            }
            if (path != null) {
                JavaCore.setClasspathVariable((String)variable, (IPath)path, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }
}

