/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.util;

import com.ibm.etools.webtools.jpa.nls.JpaUI;
import com.ibm.etools.webtools.jpa.util.JpaUtil;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.internal.JpaModelManager;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class FacetUtil {
    public static boolean installFacet(IProject project, String facetName, String version, IProgressMonitor monitor) {
        boolean isDefined = ProjectFacetsManager.isProjectFacetDefined((String)facetName);
        if (isDefined) {
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project, (boolean)true, (IProgressMonitor)monitor);
                IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)facetName);
                if (facetedProject == null || facet == null) {
                    isDefined = false;
                } else {
                    isDefined = facet.hasVersion(version);
                    IProjectFacetVersion javafacetversion = facet.getVersion(version);
                    HashSet<IFacetedProject.Action> actions = new HashSet<IFacetedProject.Action>();
                    actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, javafacetversion, null));
                    facetedProject.modify(actions, monitor);
                }
            }
            catch (CoreException e) {
                Display display = Display.getCurrent();
                if (display == null) {
                    display = Display.getDefault();
                }
                MessageDialog.openError((Shell)display.getActiveShell(), (String)JpaUI._Error_JPA_Facet, (String)JpaUI._Error_JPA_Facet_Desc);
                e.printStackTrace();
                isDefined = false;
            }
        }
        return isDefined;
    }

    public static boolean installJpaFacetIfNeeded(IProject project, IProgressMonitor monitor) {
        if (!FacetUtil.isFacetDefinedOnProject(project, "jpt.jpa")) {
            boolean facetInstalled = FacetUtil.installFacet(project, "jpt.jpa", "1.0", monitor);
            if (facetInstalled) {
                try {
                    if (Platform.getBundle((String)"com.ibm.jee.jpa.ddlgeneration") != null) {
                        JpaProject jpaProject = JpaModelManager.instance().getJpaProject(project);
                        jpaProject.getJpaPlatform().setId("webSpherePlatform");
                    }
                }
                catch (CoreException coreException) {}
            }
            return facetInstalled;
        }
        return true;
    }

    public static boolean isFacetDefinedOnProject(IProject project, String facetName) {
        boolean isDefined = ProjectFacetsManager.isProjectFacetDefined((String)facetName);
        if (isDefined) {
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)facetName);
                isDefined = facetedProject == null || facet == null ? false : facetedProject.hasProjectFacet(facet);
            }
            catch (CoreException e) {
                e.printStackTrace();
                isDefined = false;
            }
        }
        return isDefined;
    }

    public static boolean isFacetDefinedOnProjectWithMinVersion(IProject project, String facetName, String version) {
        boolean isDefined;
        block7: {
            isDefined = ProjectFacetsManager.isProjectFacetDefined((String)facetName);
            if (isDefined) {
                try {
                    IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                    IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)facetName);
                    if (facetedProject == null || facet == null) {
                        isDefined = false;
                        break block7;
                    }
                    isDefined = facetedProject.hasProjectFacet(facet);
                    Set versions = facet.getVersions();
                    HashSet<String> validVersions = new HashSet<String>();
                    double v = Double.parseDouble(version);
                    for (IProjectFacetVersion fv : versions) {
                        double newv = Double.parseDouble(fv.getVersionString());
                        if (!(newv >= v)) continue;
                        validVersions.add(fv.getVersionString());
                    }
                    if (!isDefined) break block7;
                    isDefined = false;
                    for (String vString : validVersions) {
                        isDefined = facetedProject.hasProjectFacet(facet.getVersion(vString));
                        if (!isDefined) {
                            continue;
                        }
                        break;
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    isDefined = false;
                }
            }
        }
        return isDefined;
    }

    public static boolean isJpaFacetDefinedOnProjectClasspath(IProject rootProject) {
        IProject[] referencingModuleProjects;
        IProject[] referencingEARProjects;
        if (rootProject.exists() && FacetUtil.isFacetDefinedOnProject(rootProject, "jpt.jpa")) {
            return true;
        }
        IProject[] iProjectArray = referencingEARProjects = EarUtilities.getReferencingEARProjects((IProject)rootProject);
        int n = referencingEARProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            IVirtualComponent referencingComponent = ComponentCore.createComponent((IProject)project);
            IVirtualReference[] componentReferences = EarUtilities.getComponentReferences((IVirtualComponent)referencingComponent);
            int i = 0;
            while (i < componentReferences.length) {
                IVirtualComponent referencedComponent = componentReferences[i].getReferencedComponent();
                IProject dependentProject = referencedComponent.getProject();
                if (dependentProject.exists() && FacetUtil.isFacetDefinedOnProject(dependentProject, "jpt.jpa")) {
                    return true;
                }
                ++i;
            }
            ++n2;
        }
        IProject[] iProjectArray2 = referencingModuleProjects = JpaUtil.getProjectAndDependentProjects(rootProject, true);
        int n3 = referencingModuleProjects.length;
        n = 0;
        while (n < n3) {
            IProject project = iProjectArray2[n];
            if (project.exists() && FacetUtil.isFacetDefinedOnProject(project, "jpt.jpa")) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean isJpaFacetDefinedOnProjectClasspath(IProject[] allProjects) {
        IProject[] iProjectArray = allProjects;
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject allProject = iProjectArray[n2];
            if (FacetUtil.isFacetDefinedOnProject(allProject, "jpt.jpa")) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

