/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.pdm;

import com.ibm.etools.webtools.jpa.models.IJpaManagerBeanListener;
import com.ibm.etools.webtools.jpa.models.JpaManagerBeanController;
import com.ibm.etools.webtools.jpa.pdm.JPAManagedBeanPageDataNode;
import com.ibm.etools.webtools.jpa.util.FacetUtil;
import com.ibm.etools.webtools.jpa.util.JpaUtil;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModelLifeCycleListener;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataNode;
import com.ibm.etools.webtools.pagedataview.javabean.IJavaBeanPageDataNode;
import com.ibm.etools.webtools.pagedataview.javabean.ui.internal.JavaModelSynchronizer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.widgets.Display;

public class JpaManagerListener
implements IPageDataModelLifeCycleListener,
IJpaManagerBeanListener {
    private List<IPageDataNode> pageDataRootNodes = new ArrayList<IPageDataNode>();

    protected JPAManagedBeanPageDataNode addJpaManagerBeanNode(IPageDataModel pmodel, JpaUtil.ManagerBeanInfoContainer managerBeanInfoContainer) {
        IType type = managerBeanInfoContainer.getMangerBeanType();
        IProject rootProject = null;
        IResource resource = type.getResource();
        if (resource != null) {
            rootProject = resource.getProject();
        }
        JPAManagedBeanPageDataNode pdnode = new JPAManagedBeanPageDataNode(pmodel, type.getFullyQualifiedName(), type.getFullyQualifiedName(), rootProject);
        IPageDataNode root = pmodel.getRoot();
        ((PageDataNode)root).addChildWithoutNotification((IPageDataNode)pdnode);
        JavaModelSynchronizer.connect((IJavaBeanPageDataNode)pdnode);
        return pdnode;
    }

    @Override
    public void jpaManagerBeanAdded(final JpaUtil.ManagerBeanInfoContainer managerBeanContainer) {
        IType mangerBeanType = managerBeanContainer.getMangerBeanType();
        if (mangerBeanType != null) {
            IResource correspondingResource = null;
            try {
                correspondingResource = mangerBeanType.getUnderlyingResource();
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            if (correspondingResource != null) {
                IProject managerBeanProject = correspondingResource.getProject();
                String managerBeanProjectName = managerBeanProject.getName();
                int i = 0;
                while (i < this.pageDataRootNodes.size()) {
                    final IPageDataNode root = this.pageDataRootNodes.get(i);
                    IProject pageDataProject = root.getPageDataModel().getResource().getProject();
                    if (pageDataProject != null) {
                        IProject[] allProjects;
                        IProject[] iProjectArray = allProjects = JpaUtil.getProjectAndDependentProjects(pageDataProject, true);
                        int n = allProjects.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProject dependentProject = iProjectArray[n2];
                            if (dependentProject.getName() != null && dependentProject.getName().equals(managerBeanProjectName)) {
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        JPAManagedBeanPageDataNode jpaManagerNode = JpaManagerListener.this.addJpaManagerBeanNode(root.getPageDataModel(), managerBeanContainer);
                                        root.getPageDataModel().getPageDataNotifier().firePageNodeAdded(root, (IPageDataNode)jpaManagerNode);
                                    }
                                });
                                break;
                            }
                            ++n2;
                        }
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public void jpaManagerBeanRemoved(final JpaUtil.ManagerBeanInfoContainer managerBeanContainer) {
        int i = 0;
        while (i < this.pageDataRootNodes.size()) {
            final IPageDataNode root = this.pageDataRootNodes.get(i);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IPageDataNode removedNode = JpaManagerListener.this.removeJpaManagerBeanNode(root.getPageDataModel(), managerBeanContainer);
                    root.getPageDataModel().getPageDataNotifier().firePageNodeRemoved(root, removedNode);
                }
            });
            ++i;
        }
    }

    public void pageDataModelInitialized(IPageDataModel pmodel) {
        IProject project = pmodel.getResource().getProject();
        if (project != null) {
            if (FacetUtil.isJpaFacetDefinedOnProjectClasspath(project)) {
                IProject[] allProjects;
                IProject[] iProjectArray = allProjects = JpaUtil.getProjectAndDependentProjects(project, true);
                int n = allProjects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project2 = iProjectArray[n2];
                    List<JpaUtil.ManagerBeanInfoContainer> allManagerBeans = JpaManagerBeanController.getInstance().getAllManagerBeans(project2);
                    for (JpaUtil.ManagerBeanInfoContainer managerBeanInfoContainer : allManagerBeans) {
                        this.addJpaManagerBeanNode(pmodel, managerBeanInfoContainer);
                    }
                    ++n2;
                }
            }
            this.pageDataRootNodes.add(pmodel.getRoot());
            JpaManagerBeanController.getInstance().addJpaManagerBeanListener(this);
        }
    }

    public void pageDataModelReleased() {
    }

    public void pageDataModelToBeInitialized(IPageDataModel model) {
    }

    public void pageDataModelToBeReleased(IPageDataModel model) {
        int i = 0;
        while (i < this.pageDataRootNodes.size()) {
            IPageDataNode root = this.pageDataRootNodes.get(i);
            if (root.getPageDataModel() == model) {
                this.pageDataRootNodes.remove(i);
                break;
            }
            ++i;
        }
        if (this.pageDataRootNodes.isEmpty()) {
            JpaManagerBeanController.getInstance().removeJpaManagerBeanListener();
        }
    }

    protected IPageDataNode removeJpaManagerBeanNode(IPageDataModel pageDataModel, JpaUtil.ManagerBeanInfoContainer managerBeanContainer) {
        IPageDataNode root = pageDataModel.getRoot();
        IPageDataNode removedNode = null;
        EList allChildren = root.getChildren();
        for (Object object : allChildren) {
            JPAManagedBeanPageDataNode jpaManagerNode;
            IPageDataNode node = (IPageDataNode)object;
            if (!"JpaManagedBean".equals(node.getCategory()) || !(jpaManagerNode = (JPAManagedBeanPageDataNode)node).getClassName().equals(managerBeanContainer.getMangerBeanType().getFullyQualifiedName())) continue;
            ((PageDataNode)root).removeChildWithoutNotification(node);
            removedNode = node;
            JavaModelSynchronizer.disconnect((IJavaBeanPageDataNode)((IJavaBeanPageDataNode)node));
            break;
        }
        return removedNode;
    }
}

