/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.models;

import com.ibm.etools.webtools.jpa.models.JpaAttributeInfo;
import com.ibm.etools.webtools.jpa.models.JpaEntityInfo;
import com.ibm.etools.webtools.jpa.models.JpaRelationshipMappingInfo;
import com.ibm.etools.webtools.jpa.util.JpaUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jpt.core.context.ManyToManyMapping;
import org.eclipse.jpt.core.context.ManyToOneMapping;
import org.eclipse.jpt.core.context.OneToManyMapping;
import org.eclipse.jpt.core.context.OneToOneMapping;
import org.eclipse.jpt.core.context.RelationshipMapping;

public class JpaRelationshipInfo {
    private RelationshipMapping relationshipMapping;
    private JpaEntityInfo entity;
    private List<JpaRelationshipMappingInfo> attributeMappings;
    private MULTIPLICITY multiplicity;
    private DIRECTIONAL directional;
    private STATUS status;

    public JpaRelationshipInfo(RelationshipMapping relationshipMapping, List<JpaRelationshipMappingInfo> attributeMappings, STATUS status) {
        this.relationshipMapping = relationshipMapping;
        this.attributeMappings = attributeMappings;
        this.status = status;
    }

    public void addAttributeMapping(JpaRelationshipMappingInfo mapping) {
        if (this.attributeMappings == null) {
            this.attributeMappings = new ArrayList<JpaRelationshipMappingInfo>();
        }
        this.attributeMappings.add(mapping);
    }

    public void clearAttributeMappings() {
        this.attributeMappings = new ArrayList<JpaRelationshipMappingInfo>();
    }

    public List<JpaRelationshipMappingInfo> getAttributeMappings() {
        if ((this.attributeMappings == null || this.attributeMappings.size() < 1) && this.relationshipMapping != null) {
            this.attributeMappings = new ArrayList<JpaRelationshipMappingInfo>();
            JpaEntityInfo entity = this.getEntity();
            String mappedBy = null;
            if (this.relationshipMapping instanceof OneToOneMapping) {
                mappedBy = ((OneToOneMapping)this.relationshipMapping).getMappedBy();
            } else if (this.relationshipMapping instanceof OneToManyMapping) {
                mappedBy = ((OneToManyMapping)this.relationshipMapping).getMappedBy();
            } else if (this.relationshipMapping instanceof ManyToManyMapping) {
                mappedBy = ((ManyToManyMapping)this.relationshipMapping).getMappedBy();
            }
            for (JpaAttributeInfo attribute : entity.getAttributes()) {
                if (!attribute.getAttributeName().equals(mappedBy)) continue;
                this.attributeMappings.add(new JpaRelationshipMappingInfo(null, attribute));
                break;
            }
        }
        return this.attributeMappings;
    }

    public DIRECTIONAL getDirectional() {
        return this.directional;
    }

    public JpaEntityInfo getEntity() {
        if (this.entity == null && this.relationshipMapping != null) {
            List<JpaEntityInfo> entities = JpaUtil.getEntitiesInProject(this.relationshipMapping.getJpaProject().getJpaProject().getProject(), true);
            String entityName = this.relationshipMapping.getTargetEntity();
            if (entityName != null) {
                entityName = Signature.getSimpleName((String)entityName);
                for (JpaEntityInfo entityFromList : entities) {
                    if (!entityFromList.getEntityName().equals(entityName)) continue;
                    this.entity = entityFromList;
                    break;
                }
            }
        }
        return this.entity;
    }

    public MULTIPLICITY getMultiplicity() {
        if (this.multiplicity == null && this.relationshipMapping != null) {
            if (this.relationshipMapping instanceof OneToOneMapping) {
                this.multiplicity = MULTIPLICITY.ONE_TO_ONE;
            } else if (this.relationshipMapping instanceof OneToManyMapping) {
                this.multiplicity = MULTIPLICITY.ONE_TO_MANY;
            } else if (this.relationshipMapping instanceof ManyToOneMapping) {
                this.multiplicity = MULTIPLICITY.MANY_TO_ONE;
            } else if (this.relationshipMapping instanceof ManyToManyMapping) {
                this.multiplicity = MULTIPLICITY.MANY_TO_MANY;
            }
        }
        return this.multiplicity;
    }

    public RelationshipMapping getRelationshipMapping() {
        return this.relationshipMapping;
    }

    public STATUS getStatus() {
        return this.status;
    }

    public void setAttributeMappings(List<JpaRelationshipMappingInfo> attributeMappings) {
        this.attributeMappings = attributeMappings;
    }

    public void setDirectional(DIRECTIONAL directional) {
        this.directional = directional;
    }

    public void setEntity(JpaEntityInfo entity) {
        this.entity = entity;
    }

    public void setMultiplicity(MULTIPLICITY multiplicity) {
        this.multiplicity = multiplicity;
    }

    public void setRelationshipMapping(RelationshipMapping relationshipMapping) {
        this.relationshipMapping = relationshipMapping;
    }

    public void setStatus(STATUS status) {
        this.status = status;
    }

    public static enum DIRECTIONAL {
        UNIDIRECTION,
        BIDIRECTIONAL;

    }

    public static enum MULTIPLICITY {
        ONE_TO_ONE,
        ONE_TO_MANY,
        MANY_TO_ONE,
        MANY_TO_MANY;

    }

    public static enum STATUS {
        NEW,
        EXISTING,
        CHANGED,
        REMOVED,
        VIRTUAL;

    }
}

