/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.models;

import com.ibm.etools.webtools.jpa.models.JpaAttributeInfo;
import com.ibm.etools.webtools.jpa.models.JpaEntityInfo;
import com.ibm.etools.webtools.jpa.models.JpaFilterInfo;
import com.ibm.etools.webtools.jpa.models.JpaFilterParameterInfo;
import com.ibm.etools.webtools.jpa.models.JpaOrderedAttributeInfo;
import com.ibm.etools.webtools.jpa.util.NamedQueriesUtil;
import com.ibm.etools.webtools.jpa.util.NamedQuerySelectParts;
import com.ibm.etools.webtools.jpa.util.QueryParsingUtil;
import java.util.ArrayList;
import java.util.List;

public class JpaQueryMethodInfo
implements Comparable {
    private STATUS status;
    private METHOD_TYPE methodType = METHOD_TYPE.QUERY;
    private String fMethodName;
    private String fQueryName;
    private String fQueryValue;
    private String fOldMethodName;
    private String fOldQueryName;
    private String fOldQueryValue;
    private String fromStatement;
    private String groupStatement;
    private String havingStatement;
    private NamedQuerySelectParts selectParts;
    private JpaFilterInfo fFilterInfo;
    private List<JpaOrderedAttributeInfo> fOrderedAttributes;
    private boolean inNeedOfInitialization = false;
    private boolean inNeedOfFilterUpdate = false;
    private boolean badParse = false;

    public JpaQueryMethodInfo(String methodName, String queryName, String queryValue, STATUS status) {
        this.fMethodName = methodName;
        this.fQueryName = queryName;
        this.fQueryValue = queryValue;
        this.status = status;
        this.inNeedOfInitialization = true;
        this.inNeedOfFilterUpdate = true;
    }

    public int compareTo(Object o) {
        return this.getQueryName().compareTo(((JpaQueryMethodInfo)o).getQueryName());
    }

    public JpaFilterInfo getFilter(JpaEntityInfo info) {
        if (this.inNeedOfInitialization || this.inNeedOfFilterUpdate) {
            this.initialize();
            this.updateFilter(info);
            this.setDefaultFilterValues();
        }
        return this.fFilterInfo;
    }

    public String getFromStatement() {
        if (this.inNeedOfInitialization) {
            this.initialize();
        }
        return this.fromStatement;
    }

    public String getGroupStatement() {
        if (this.inNeedOfInitialization) {
            this.initialize();
        }
        return this.groupStatement;
    }

    public String getHavingStatement() {
        if (this.inNeedOfInitialization) {
            this.initialize();
        }
        return this.havingStatement;
    }

    public String getMethodName() {
        return this.fMethodName;
    }

    public METHOD_TYPE getMethodType() {
        return this.methodType;
    }

    public String getOldMethodName() {
        return this.fOldMethodName;
    }

    public String getOldQueryName() {
        return this.fOldQueryName;
    }

    public String getOldQueryValue() {
        return this.fOldQueryValue;
    }

    public List<JpaOrderedAttributeInfo> getOrderedAttributes() {
        if (this.inNeedOfInitialization) {
            this.initialize();
        }
        return this.fOrderedAttributes;
    }

    public String getQueryName() {
        return this.fQueryName;
    }

    public String getQueryValue() {
        return this.fQueryValue;
    }

    public NamedQuerySelectParts getSelectParts() {
        if (this.inNeedOfInitialization) {
            this.initialize();
        }
        return this.selectParts;
    }

    public STATUS getStatus() {
        return this.status;
    }

    public void initialize() {
        QueryParsingUtil.initializeStatementParts(this);
        this.inNeedOfInitialization = false;
    }

    public boolean isBadParse() {
        return this.badParse;
    }

    public void setBadParse(boolean badParse) {
        this.badParse = badParse;
    }

    public void setDefaultFilterValues() {
        if (this.fFilterInfo != null) {
            List<JpaFilterParameterInfo> parameters = this.fFilterInfo.getParameters();
            for (JpaFilterParameterInfo jpaFilterParameterInfo : parameters) {
                if (jpaFilterParameterInfo.getParameterValue() != null && jpaFilterParameterInfo.getParameterValue().length() != 0) continue;
                jpaFilterParameterInfo.setParameterValue("#{param." + jpaFilterParameterInfo.getParameterName() + "}");
            }
        }
    }

    public void setFilter(JpaFilterInfo filter) {
        this.fFilterInfo = filter;
    }

    public void setFromStatement(String fromStatement) {
        this.fromStatement = fromStatement;
    }

    public void setGroupStatement(String groupStatement) {
        this.groupStatement = groupStatement;
    }

    public void setHavingStatement(String havingStatement) {
        this.havingStatement = havingStatement;
    }

    public void setMethodName(String methodName) {
        this.fMethodName = methodName;
    }

    public void setMethodType(METHOD_TYPE methodType) {
        this.methodType = methodType;
    }

    public void setOldMethodName(String oldMethodName) {
        if (this.fOldMethodName == null) {
            this.fOldMethodName = oldMethodName;
        }
    }

    public void setOldQueryName(String oldQueryName) {
        if (this.fOldQueryName == null) {
            this.fOldQueryName = oldQueryName;
        }
    }

    public void setOldQueryValue(String oldQueryValue) {
        if (this.fOldQueryValue == null) {
            this.fOldQueryValue = oldQueryValue;
        }
    }

    public void setOrderedAttributes(List<JpaOrderedAttributeInfo> orderedAttributes) {
        this.fOrderedAttributes = orderedAttributes;
    }

    public void setQueryName(String queryName) {
        this.fQueryName = queryName;
    }

    public void setQueryValue(String queryValue) {
        this.fQueryValue = queryValue;
        this.inNeedOfInitialization = true;
        this.inNeedOfFilterUpdate = true;
    }

    public void setSelectParts(NamedQuerySelectParts selectParts) {
        this.selectParts = selectParts;
    }

    public void setStatus(STATUS status) {
        this.status = status;
    }

    public void updateFilter(JpaEntityInfo entity) {
        if (this.fFilterInfo != null) {
            this.fFilterInfo.initializeFilters(entity);
            this.fFilterInfo.updateJPAFilterData(entity);
            this.inNeedOfFilterUpdate = false;
        }
    }

    public void updateQuery(JpaEntityInfo entity) {
        if (this.inNeedOfInitialization) {
            this.initialize();
        }
        if (!this.badParse) {
            this.fQueryValue = NamedQueriesUtil.createCustomQuery(entity.getName(), this.getSelectParts().getStringValue(), this.getFromStatement(), this.fFilterInfo.getPredicate(), this.getOrderedAttributes(), this.getGroupStatement(), this.getHavingStatement());
        }
    }

    public void updateQueryForRelationship(String foreignKey, JpaEntityInfo relationshipEntity) {
        if (this.status == STATUS.REMOVE) {
            return;
        }
        ArrayList<String> attributeNames = new ArrayList<String>();
        if (relationshipEntity != null) {
            List<JpaAttributeInfo> primaryKeys = relationshipEntity.getPrimaryKeyAttributes();
            for (JpaAttributeInfo key : primaryKeys) {
                attributeNames.add(String.valueOf(foreignKey) + "." + key.getAttributeName());
            }
        }
        if (attributeNames.size() == 1) {
            this.setOldQueryName(this.getQueryName());
            this.setOldQueryValue(this.getQueryValue());
            this.setOldMethodName(this.getMethodName());
            this.setQueryValue(this.fQueryValue.replace(new StringBuffer("." + foreignKey + " "), new StringBuffer("." + (String)attributeNames.get(0) + " ")));
            if (this.status == STATUS.EXISTING) {
                this.status = STATUS.CHANGED;
            }
        }
    }

    public static enum METHOD_TYPE {
        QUERY,
        FIND;

    }

    public static enum STATUS {
        EXISTING,
        NEW,
        CHANGED,
        REMOVE;

    }
}

