/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.models;

import com.ibm.etools.sdo.jdbc.ui.internal.util.RuntimeUtil;
import com.ibm.etools.webtools.jpa.models.JpaAttributeInfo;
import com.ibm.etools.webtools.jpa.models.JpaEntityInfo;
import com.ibm.etools.webtools.jpa.models.JpaQueryMethodInfo;
import com.ibm.etools.webtools.jpa.util.FacetUtil;
import com.ibm.etools.webtools.jpa.util.ManagerBeanUtil;
import com.ibm.etools.webtools.jpa.util.NamedQueriesUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class JpaManagerBeanInfo {
    private String managerBeanName;
    private IType existingManagerBeanType;
    private JpaEntityInfo fEntityInfo;
    private List<JpaQueryMethodInfo> fQueryMethodInfos;
    private IProject rootProject;
    private Boolean useNamedQueries;
    private Boolean useInjection;
    private Boolean useResourceTransactions;
    private Integer updateRelationshipFetchType;
    private Boolean updateForJsf;
    private Boolean generateEntityConverter;
    private Boolean relationshipAdded;
    private boolean regenSelectListMethod = false;
    private int primaryKeyPropertySetCount = 0;

    public JpaManagerBeanInfo(JpaEntityInfo entity, IProject rootProject, boolean initializeMethods) {
        this.fEntityInfo = entity;
        this.rootProject = rootProject;
        this.managerBeanName = this.existingManagerBeanType == null ? String.valueOf(entity.getName()) + "Manager" : this.existingManagerBeanType.getElementName();
        if (initializeMethods) {
            this.initializeMethods(true);
        }
    }

    public JpaManagerBeanInfo(JpaEntityInfo entity, IType existingManagerBeanType, boolean initializeMethods) {
        this.fEntityInfo = entity;
        this.existingManagerBeanType = existingManagerBeanType;
        this.managerBeanName = existingManagerBeanType == null ? String.valueOf(entity.getName()) + "Manager" : existingManagerBeanType.getElementName();
        if (initializeMethods) {
            this.initializeMethods(true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean currentInjectionStatus() {
        if (this.existingManagerBeanType != null) {
            IAnnotation annotation;
            IField field = this.existingManagerBeanType.getField("emf");
            if (field == null || !field.exists() || (annotation = field.getAnnotation("PersistenceUnit")) == null || !annotation.exists()) return false;
            return true;
        }
        if (FacetUtil.isFacetDefinedOnProject(this.getProject(), "jst.jsf")) {
            IProject project = this.getProject();
            if (project == null) return false;
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                IRuntime runtime = facetedProject.getPrimaryRuntime();
                if (runtime == null || !RuntimeUtil.isTargetedAtWASV70((IRuntime)runtime) && RuntimeUtil.isTargetedAtSupportedRuntime((IRuntime)runtime)) return false;
                return true;
            }
            catch (CoreException e) {
                e.printStackTrace();
                return false;
            }
        } else {
            IProject project;
            if (!FacetUtil.isFacetDefinedOnProjectWithMinVersion(this.getProject(), "jst.ejb", "3.0") || (project = this.getProject()) == null) return false;
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                IRuntime runtime = facetedProject.getPrimaryRuntime();
                if (runtime == null || !RuntimeUtil.isTargetedAtWASV70((IRuntime)runtime) && RuntimeUtil.isTargetedAtSupportedRuntime((IRuntime)runtime)) return false;
                return true;
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean currentNamedQueryStatus() {
        if (this.existingManagerBeanType != null) {
            IType namedQueries = this.existingManagerBeanType.getType("NamedQueries");
            return namedQueries == null || !namedQueries.exists();
        }
        return true;
    }

    public boolean doesManagerBeanExistForThisEntity() {
        return this.existingManagerBeanType != null;
    }

    public JpaEntityInfo getEntity() {
        return this.fEntityInfo;
    }

    public IType getExistingManagerBeanType() {
        return this.existingManagerBeanType;
    }

    public String getFullyQualifiedName() {
        if (this.getExistingManagerBeanType() != null) {
            return this.getExistingManagerBeanType().getFullyQualifiedName();
        }
        return null;
    }

    public boolean getGenerateEntityConverter() {
        if (this.generateEntityConverter == null) {
            this.generateEntityConverter = new Boolean(false);
        }
        return this.generateEntityConverter;
    }

    public String getManagerBeanName() {
        return this.managerBeanName;
    }

    public IPath getManagerBeanPath() {
        return ManagerBeanUtil.getJPAManagerFilePath(this);
    }

    public int getPrimaryKeyPropertySetCount() {
        return this.primaryKeyPropertySetCount;
    }

    public IProject getProject() {
        if (this.existingManagerBeanType != null) {
            return this.existingManagerBeanType.getJavaProject().getProject();
        }
        if (this.rootProject != null) {
            return this.rootProject;
        }
        if (this.fEntityInfo != null) {
            PersistentType persistentType = this.fEntityInfo.getPersistentType();
            if (persistentType != null) {
                return persistentType.getJpaProject().getProject();
            }
            return this.fEntityInfo.getProject();
        }
        return null;
    }

    public List<JpaQueryMethodInfo> getQueryMethods() {
        if (this.fQueryMethodInfos == null) {
            return new ArrayList<JpaQueryMethodInfo>(0);
        }
        return this.fQueryMethodInfos;
    }

    public boolean getRelationshipAdded() {
        if (this.relationshipAdded == null) {
            this.relationshipAdded = new Boolean(false);
        }
        return this.relationshipAdded;
    }

    public Integer getUpdateRelationshipFetchType() {
        if (this.updateRelationshipFetchType == null) {
            this.updateRelationshipFetchType = 0;
        }
        return this.updateRelationshipFetchType;
    }

    public void initializeMethods(boolean useDefaultsIfNoQueriesFound) {
        this.fQueryMethodInfos = NamedQueriesUtil.getNamedQueryMethodInfos(this, useDefaultsIfNoQueriesFound);
    }

    public void initializeMethodsIfNeeded() {
        this.initializeMethodsIfNeeded(true);
    }

    public void initializeMethodsIfNeeded(boolean useDefaultsIfNoQueriesFound) {
        if (this.fQueryMethodInfos == null) {
            this.initializeMethods(useDefaultsIfNoQueriesFound);
        }
    }

    public boolean isRegenSelectListMethod() {
        return this.regenSelectListMethod;
    }

    public boolean isUpdateForJsf() {
        if (this.updateForJsf == null) {
            this.updateForJsf = new Boolean(true);
            if (this.getProject() != null && !FacetUtil.isFacetDefinedOnProject(this.getProject(), "jst.jsf")) {
                this.updateForJsf = new Boolean(false);
            }
        }
        return this.updateForJsf;
    }

    public boolean isUpdateRelationshipFetchTypeDefaultSet() {
        return this.updateRelationshipFetchType != null;
    }

    public boolean isUseInjection() {
        if (this.useInjection == null) {
            this.useInjection = new Boolean(this.currentInjectionStatus());
        }
        return this.useInjection;
    }

    public boolean isUseNamedQueries() {
        if (this.useNamedQueries == null) {
            this.useNamedQueries = new Boolean(this.currentNamedQueryStatus());
        }
        return this.useNamedQueries;
    }

    public boolean isUseResourceTransactions() {
        if (this.useResourceTransactions == null) {
            this.useResourceTransactions = new Boolean(true);
            if (this.getProject() != null && FacetUtil.isFacetDefinedOnProject(this.getProject(), "jst.ejb")) {
                this.useResourceTransactions = new Boolean(false);
            }
        }
        return this.useResourceTransactions;
    }

    public boolean isValid() {
        if (this.fEntityInfo == null) {
            return false;
        }
        if (this.managerBeanName == null || this.managerBeanName.length() < 1) {
            return false;
        }
        List<JpaAttributeInfo> keys = this.fEntityInfo.getPrimaryKeyAttributes();
        return keys != null && keys.size() >= 1;
    }

    public void setEntity(JpaEntityInfo entity) {
        this.fEntityInfo = entity;
    }

    public void setExistingManagerBeanType(IType existingManagerBeanType) {
        this.existingManagerBeanType = existingManagerBeanType;
    }

    public void setGenerateEntityConverter(boolean generateEntityConverter) {
        this.generateEntityConverter = new Boolean(generateEntityConverter);
    }

    public void setManagerBeanName(String managerBeanName) {
        this.managerBeanName = managerBeanName;
    }

    public void setQueryMethods(List<JpaQueryMethodInfo> queryMethods) {
        this.fQueryMethodInfos = queryMethods;
    }

    public void setRegenSelectListMethod(boolean regenSelectListMethod) {
        this.regenSelectListMethod = regenSelectListMethod;
    }

    public void setRelationshipAdded(boolean relationshipAdded) {
        this.relationshipAdded = new Boolean(relationshipAdded);
    }

    public void setRootProject(IProject rootProject) {
        this.rootProject = rootProject;
    }

    public void setUpdateForJsf(boolean updateForJsf) {
        this.updateForJsf = new Boolean(updateForJsf);
    }

    public void setUpdateRelationshipFetchType(Integer updateRelationshipFetchType) {
        this.updateRelationshipFetchType = updateRelationshipFetchType;
    }

    public void setUseInjection(boolean useInjection) {
        this.useInjection = new Boolean(useInjection);
    }

    public void setUseNamedQueries(boolean useNamedQueries) {
        this.useNamedQueries = new Boolean(useNamedQueries);
    }

    public void setUseResourceTransactions(Boolean useResourceTransactions) {
        this.useResourceTransactions = useResourceTransactions;
    }
}

