/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.models;

import com.ibm.etools.webtools.jpa.filters.ConditionExpressionData;
import com.ibm.etools.webtools.jpa.filters.IConditionData;
import com.ibm.etools.webtools.jpa.filters.RelationalMultiConditionData;
import com.ibm.etools.webtools.jpa.filters.SimpleFilterParser;
import com.ibm.etools.webtools.jpa.models.JpaEntityInfo;
import com.ibm.etools.webtools.jpa.models.JpaFilterParameterInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class JpaFilterInfo
extends ConditionExpressionData {
    public static final int IS_AND = 0;
    public static final int IS_OR = 1;
    private RelationalMultiConditionData fMultiCondData;
    private String fPredicate;
    private List<JpaFilterParameterInfo> fParameters = new ArrayList<JpaFilterParameterInfo>();

    public void addConditionsList(JpaEntityInfo entity, IConditionData conditionData) {
        this.getMultiConditionData().addPredicate(entity, conditionData, true);
    }

    public void addParameter(JpaFilterParameterInfo parameter) {
        if (this.fParameters == null) {
            this.fParameters = new ArrayList<JpaFilterParameterInfo>();
        }
        this.fParameters.add(parameter);
    }

    public void clearParameters() {
        this.fParameters = new ArrayList<JpaFilterParameterInfo>();
    }

    public void editConditionsList(JpaEntityInfo entity, IConditionData conditionData) {
        this.updateJPAFilterData(entity);
    }

    public List getConditionsList() {
        return Arrays.asList(this.getMultiConditionData().getPredicates());
    }

    public RelationalMultiConditionData getMultiConditionData() {
        if (this.conditionsList.size() > 0) {
            this.fMultiCondData = (RelationalMultiConditionData)this.conditionsList.get(0);
        } else {
            if (this.fMultiCondData == null) {
                this.fMultiCondData = new RelationalMultiConditionData(this);
            }
            this.conditionsList.add(this.fMultiCondData);
        }
        return this.fMultiCondData;
    }

    public List<JpaFilterParameterInfo> getParameters() {
        if (this.fParameters == null) {
            this.fParameters = new ArrayList<JpaFilterParameterInfo>();
        }
        return this.fParameters;
    }

    public String getPredicate() {
        if (this.fPredicate == null) {
            return "";
        }
        return this.fPredicate;
    }

    public void initializeFilters(JpaEntityInfo entity) {
        SimpleFilterParser fp = new SimpleFilterParser(this);
        fp.parseQueries(entity);
    }

    public void moveConditionsList(JpaEntityInfo entity, boolean moveUp, IConditionData conditionData) {
        this.getMultiConditionData().moveConditionsList(entity, moveUp, conditionData);
    }

    public void removeConditionsList(JpaEntityInfo entity, IConditionData conditionData) {
        this.getMultiConditionData().removePredicate(entity, conditionData, true);
    }

    public void setMultiCondData(RelationalMultiConditionData data) {
        this.fMultiCondData = data;
    }

    public void setPredicate(String predicate) {
        this.fPredicate = predicate;
    }

    public void updateJPAFilterData(JpaEntityInfo entity) {
        this.setPredicate("");
        this.clearParameters();
        StringBuffer predicate = new StringBuffer();
        this.getMultiConditionData().updateMetadata(entity, predicate);
        if (predicate.toString() != null && !predicate.toString().trim().equalsIgnoreCase("")) {
            String predicateString = predicate.toString().trim();
            if (predicateString.indexOf("(") == 0 && predicateString.lastIndexOf(")") == predicateString.length() - 1) {
                predicateString = predicateString.substring(1);
                predicateString = predicateString.substring(0, predicateString.length() - 1);
            }
            this.setPredicate(predicateString.trim());
        }
    }
}

