/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.models;

import com.ibm.etools.webtools.jpa.util.NamedQueriesUtil;
import com.ibm.etools.webtools.jpa.util.NamedQueryParameter;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.ColumnMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;

public class JpaAttributeInfo
implements Comparable {
    private PersistentAttribute attribute;
    private String mappingKey;
    private JpaAttributeInfo parentAttribute = null;
    private NamedQueryParameter.TemporalType temporalType;

    public JpaAttributeInfo(PersistentAttribute attribute) {
        this.attribute = attribute;
        AttributeMapping specifiedMapping = attribute.getSpecifiedMapping();
        if (specifiedMapping != null) {
            this.mappingKey = specifiedMapping.getKey();
        }
    }

    public JpaAttributeInfo(PersistentAttribute attribute, JpaAttributeInfo jpaAttributeInfo) {
        this(attribute);
        this.parentAttribute = jpaAttributeInfo;
    }

    public int compareTo(Object o) {
        return this.getAttributeName().compareTo(((JpaAttributeInfo)o).getAttributeName());
    }

    public PersistentAttribute getAttribute() {
        return this.attribute;
    }

    public String getAttributeName() {
        String name = this.parentAttribute != null ? String.valueOf(this.parentAttribute.getAttributeName()) + "." + this.attribute.getName() : this.attribute.getName();
        return name;
    }

    public String getAttributeType() {
        JavaPersistentAttribute javaAttribute = null;
        if (this.attribute instanceof JavaPersistentAttribute) {
            javaAttribute = (JavaPersistentAttribute)this.attribute;
        } else if (this.attribute instanceof OrmPersistentAttribute) {
            javaAttribute = ((OrmPersistentAttribute)this.attribute).getMapping().getJavaPersistentAttribute();
        }
        return javaAttribute.getResourcePersistentAttribute().getQualifiedTypeName();
    }

    public String getColumnName() {
        String name = null;
        AttributeMapping mapping = this.attribute.getMapping();
        if (mapping instanceof ColumnMapping) {
            name = ((ColumnMapping)mapping).getColumn().getSpecifiedName();
        }
        if (name == null || name.length() < 1) {
            name = this.attribute.getName();
        }
        return name;
    }

    public String getMappingKey() {
        return this.mappingKey;
    }

    public JpaAttributeInfo getParentAttribute() {
        return this.parentAttribute;
    }

    public NamedQueryParameter.TemporalType getTemporalType() {
        if (this.temporalType == null && this.attribute != null) {
            this.temporalType = NamedQueriesUtil.getTemporalTypeForAttribute(this.attribute);
        }
        return this.temporalType;
    }

    public boolean isOCC() {
        return this.mappingKey != null && this.mappingKey.equals("version");
    }

    public boolean isPartOfCompositePrimaryKey() {
        return this.parentAttribute != null && (this.parentAttribute.getMappingKey().equals("id") || this.parentAttribute.getMappingKey().equals("embeddedId"));
    }

    public boolean isPrimaryKey() {
        if (this.mappingKey != null && this.mappingKey.equals("id")) {
            return true;
        }
        return this.parentAttribute != null && (this.parentAttribute.getMappingKey().equals("id") || this.parentAttribute.getMappingKey().equals("embeddedId"));
    }

    public void setAttribute(PersistentAttribute attribute) {
        this.attribute = attribute;
    }

    public void setMappingKey(String mappingKey) {
        this.mappingKey = mappingKey;
    }

    public void setParentAttribute(JpaAttributeInfo parentAttribute) {
        this.parentAttribute = parentAttribute;
    }

    public void setTemporalType(NamedQueryParameter.TemporalType date) {
        this.temporalType = date;
    }
}

