/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.filters;

import com.ibm.etools.webtools.jpa.filters.ConditionData;
import com.ibm.etools.webtools.jpa.filters.ISingleColumnConditionData;
import com.ibm.etools.webtools.jpa.filters.ISingleQueryColumn;
import com.ibm.etools.webtools.jpa.models.JpaFilterInfo;
import com.ibm.etools.webtools.jpa.wizard.ui.taskPages.dialogs.SelectionTable;
import java.util.List;

public class SingleColumnConditionData
extends ConditionData
implements ISingleColumnConditionData {
    private static String fELValuePrefix = "";
    protected List columnsList;
    protected SelectionTable operatorList;
    protected String columnName;
    protected String operator;
    protected String variableValueString;
    protected boolean isUnary = false;
    private ISingleQueryColumn lhsQueryColumn;
    private ISingleQueryColumn rhsQueryColumn;

    public SingleColumnConditionData() {
        this.setOperatorList(OPERATOR_LIST);
    }

    @Override
    public List getColumnList() {
        return this.columnsList;
    }

    @Override
    public String getColumnName() {
        return this.getLHSQueryColumn().getColumn();
    }

    @Override
    public String getCondition() {
        StringBuffer buf = new StringBuffer();
        if (this.getLHSQueryColumn() != null) {
            buf.append(this.getLHSQueryColumn().getValue());
        }
        buf.append(" ");
        buf.append(this.getOperator());
        buf.append(" ");
        if (this.getRHSQueryColumn() != null) {
            buf.append(this.getRHSQueryColumn().getValue());
        }
        return buf.toString();
    }

    @Override
    public String getELValuePrefix() {
        return fELValuePrefix;
    }

    @Override
    public JpaFilterInfo getJpaFilterData() {
        return null;
    }

    @Override
    public ISingleQueryColumn getLHSQueryColumn() {
        return this.lhsQueryColumn;
    }

    @Override
    public String getOperator() {
        return this.operator;
    }

    @Override
    public SelectionTable getOperatorList() {
        return this.operatorList;
    }

    @Override
    public ISingleQueryColumn getRHSQueryColumn() {
        return this.rhsQueryColumn;
    }

    public boolean isUnary() {
        return this.isUnary;
    }

    @Override
    public void setColumnList(List columnList) {
        this.columnsList = columnList;
        if (columnList.size() > 0 && columnList.get(0) instanceof String) {
            this.columnName = (String)columnList.get(0);
        }
    }

    @Override
    public void setCondition(String condition) {
    }

    @Override
    public void setELValuePrefix(String elValuePrefix) {
        fELValuePrefix = elValuePrefix;
    }

    @Override
    public void setLHSQueryColumn(ISingleQueryColumn lhs) {
        this.lhsQueryColumn = lhs;
    }

    @Override
    public void setOperator(String operator) {
        this.operator = operator;
    }

    protected void setOperatorList(SelectionTable table) {
        this.operatorList = table;
        if (table != null && table.getItemCount() > 0) {
            this.operator = table.getValue(0);
        }
    }

    @Override
    public void setRHSQueryColumn(ISingleQueryColumn bvqc) {
        this.rhsQueryColumn = bvqc;
    }
}

