/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.filters;

import com.ibm.etools.webtools.jpa.filters.IConditionData;
import com.ibm.etools.webtools.jpa.filters.RelationalMultiConditionData;
import com.ibm.etools.webtools.jpa.filters.RelationalSingleColumnConditionData;
import com.ibm.etools.webtools.jpa.models.JpaEntityInfo;
import com.ibm.etools.webtools.jpa.models.JpaFilterInfo;
import com.ibm.etools.webtools.jpa.models.JpaFilterParameterInfo;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.query.Predicate;
import org.eclipse.datatools.modelbase.sql.query.PredicateBasic;
import org.eclipse.datatools.modelbase.sql.query.PredicateBetween;
import org.eclipse.datatools.modelbase.sql.query.PredicateExists;
import org.eclipse.datatools.modelbase.sql.query.PredicateIn;
import org.eclipse.datatools.modelbase.sql.query.PredicateIsNull;
import org.eclipse.datatools.modelbase.sql.query.PredicateLike;
import org.eclipse.datatools.modelbase.sql.query.QuerySearchCondition;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.SearchConditionCombined;
import org.eclipse.datatools.modelbase.sql.query.SearchConditionNested;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserException;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserInternalException;
import org.eclipse.datatools.sqltools.parsers.sql.query.SQLQueryParseResult;
import org.eclipse.datatools.sqltools.parsers.sql.query.SQLQueryParserManager;
import org.eclipse.datatools.sqltools.parsers.sql.query.SQLQueryParserManagerProvider;

public class SimpleFilterParser {
    private JpaFilterInfo fJpaFilterData;
    private int filterIndex = 0;

    public SimpleFilterParser(JpaFilterInfo jpaFilterData) {
        this.fJpaFilterData = jpaFilterData;
    }

    public static QueryStatement getParseResult(String statement) throws SQLParserException, SQLParserInternalException {
        SQLQueryParserManager parserManager = SQLQueryParserManagerProvider.getInstance().getParserManager(null, null);
        QueryStatement resultObject = null;
        try {
            SQLQueryParseResult parseResult = parserManager.parseQuery(statement);
            resultObject = parseResult.getQueryStatement();
        }
        catch (SQLParserException e) {
            e.printStackTrace();
        }
        return resultObject;
    }

    public static boolean isSimpleQuery(String selectStmt) {
        return true;
    }

    RelationalMultiConditionData parseConditions(JpaEntityInfo entity, QuerySearchCondition qSC, int operator) {
        int currentOperator = 0;
        if (operator == 1) {
            currentOperator = 1;
        }
        RelationalMultiConditionData searchCondition = new RelationalMultiConditionData(this.fJpaFilterData);
        QuerySearchCondition tempCond = qSC;
        while (tempCond instanceof SearchConditionNested) {
            SearchConditionNested nested = (SearchConditionNested)tempCond;
            tempCond = nested.getNestedCondition();
        }
        if (tempCond instanceof SearchConditionCombined) {
            int n;
            SearchConditionCombined combined = (SearchConditionCombined)tempCond;
            RelationalMultiConditionData childSearchCondition = this.parseConditions(entity, combined.getLeftCondition(), combined.getCombinedOperator().getValue());
            childSearchCondition.setOperand(combined.getCombinedOperator().getValue());
            if (combined.getLeftCondition() instanceof Predicate) {
                IConditionData[] conditions;
                IConditionData[] iConditionDataArray = conditions = childSearchCondition.getPredicates();
                n = conditions.length;
                int n2 = 0;
                while (n2 < n) {
                    IConditionData element = iConditionDataArray[n2];
                    searchCondition.addPredicate(entity, element, false);
                    ++n2;
                }
            } else {
                searchCondition.addPredicate(entity, childSearchCondition, false);
            }
            RelationalMultiConditionData childSearchCondition2 = this.parseConditions(entity, combined.getRightCondition(), combined.getCombinedOperator().getValue());
            childSearchCondition2.setOperand(combined.getCombinedOperator().getValue());
            if (combined.getRightCondition() instanceof Predicate) {
                IConditionData[] conditions;
                IConditionData[] iConditionDataArray = conditions = childSearchCondition2.getPredicates();
                int n3 = conditions.length;
                n = 0;
                while (n < n3) {
                    IConditionData element = iConditionDataArray[n];
                    searchCondition.addPredicate(entity, element, false);
                    ++n;
                }
            } else {
                searchCondition.addPredicate(entity, childSearchCondition2, false);
            }
        } else if (tempCond instanceof Predicate) {
            List<JpaFilterParameterInfo> parameters = this.fJpaFilterData.getParameters();
            StringBuffer filt = new StringBuffer(Integer.toString(this.filterIndex));
            if (tempCond instanceof PredicateBasic) {
                PredicateBasic basic = (PredicateBasic)tempCond;
                RelationalSingleColumnConditionData conditionData = RelationalSingleColumnConditionData.parseQuery((Predicate)basic, entity, this.fJpaFilterData, parameters, filt, currentOperator);
                this.filterIndex = Integer.parseInt(filt.toString());
                searchCondition.addPredicate(entity, conditionData, false);
            } else if (tempCond instanceof PredicateLike) {
                PredicateLike like = (PredicateLike)tempCond;
                RelationalSingleColumnConditionData conditionData = RelationalSingleColumnConditionData.parseQuery((Predicate)like, entity, this.fJpaFilterData, parameters, filt, currentOperator);
                this.filterIndex = Integer.parseInt(filt.toString());
                searchCondition.addPredicate(entity, conditionData, false);
            } else if (tempCond instanceof PredicateBetween) {
                PredicateBetween between = (PredicateBetween)tempCond;
                RelationalSingleColumnConditionData conditionData = RelationalSingleColumnConditionData.parseQuery((Predicate)between, entity, this.fJpaFilterData, parameters, filt, currentOperator);
                this.filterIndex = Integer.parseInt(filt.toString());
                searchCondition.addPredicate(entity, conditionData, false);
            } else if (tempCond instanceof PredicateIn) {
                PredicateIn in = (PredicateIn)tempCond;
                RelationalSingleColumnConditionData conditionData = RelationalSingleColumnConditionData.parseQuery((Predicate)in, entity, this.fJpaFilterData, parameters, filt, currentOperator);
                this.filterIndex = Integer.parseInt(filt.toString());
                searchCondition.addPredicate(entity, conditionData, false);
            } else if (tempCond instanceof PredicateIsNull) {
                PredicateIsNull isNull = (PredicateIsNull)tempCond;
                RelationalSingleColumnConditionData conditionData = RelationalSingleColumnConditionData.parseQuery((Predicate)isNull, entity, this.fJpaFilterData, parameters, filt, currentOperator);
                this.filterIndex = Integer.parseInt(filt.toString());
                searchCondition.addPredicate(entity, conditionData, false);
            } else if (tempCond instanceof PredicateExists) {
                PredicateExists exists = (PredicateExists)tempCond;
                RelationalSingleColumnConditionData conditionData = RelationalSingleColumnConditionData.parseQuery((Predicate)exists, entity, this.fJpaFilterData, parameters, filt, currentOperator);
                this.filterIndex = Integer.parseInt(filt.toString());
                searchCondition.addPredicate(entity, conditionData, false);
            }
        }
        return searchCondition;
    }

    public void parseQueries(JpaEntityInfo entity) {
        if (entity == null) {
            return;
        }
        this.filterIndex = 0;
        try {
            QuerySelectStatement select;
            QuerySelect selectQuery;
            if (this.fJpaFilterData == null) {
                return;
            }
            if (this.fJpaFilterData.getPredicate() == null || this.fJpaFilterData.getPredicate().length() < 1) {
                return;
            }
            String selectStmt = "SELECT * FROM table WHERE " + this.fJpaFilterData.getPredicate();
            QueryStatement queryStatement = SimpleFilterParser.getParseResult(selectStmt);
            if (queryStatement != null && queryStatement instanceof QuerySelectStatement && (selectQuery = (QuerySelect)(select = (QuerySelectStatement)queryStatement).getQueryExpr().getQuery()).getWhereClause() != null) {
                this.fJpaFilterData.addConditionsList(0, (IConditionData)this.parseConditions(entity, selectQuery.getWhereClause(), 0));
            }
        }
        catch (SQLParserException e1) {
            e1.printStackTrace();
        }
        catch (SQLParserInternalException e2) {
            e2.printStackTrace();
        }
    }
}

