/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.filters;

import com.ibm.etools.webtools.jpa.filters.BinaryValueQueryColumn;
import com.ibm.etools.webtools.jpa.filters.ConditionData;
import com.ibm.etools.webtools.jpa.filters.IBinaryValueQueryColumn;
import com.ibm.etools.webtools.jpa.filters.IMultiValueQueryColumn;
import com.ibm.etools.webtools.jpa.filters.ISingleQueryColumn;
import com.ibm.etools.webtools.jpa.filters.ISingleValueQueryColumn;
import com.ibm.etools.webtools.jpa.filters.MultiValueQueryColumn;
import com.ibm.etools.webtools.jpa.filters.QueryVariableValue;
import com.ibm.etools.webtools.jpa.filters.RelationalMultiConditionData;
import com.ibm.etools.webtools.jpa.filters.SingleColumnConditionData;
import com.ibm.etools.webtools.jpa.filters.SingleValueQueryColumn;
import com.ibm.etools.webtools.jpa.models.JpaAttributeInfo;
import com.ibm.etools.webtools.jpa.models.JpaEntityInfo;
import com.ibm.etools.webtools.jpa.models.JpaFilterInfo;
import com.ibm.etools.webtools.jpa.models.JpaFilterParameterInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.query.Predicate;
import org.eclipse.datatools.modelbase.sql.query.PredicateBasic;
import org.eclipse.datatools.modelbase.sql.query.PredicateBetween;
import org.eclipse.datatools.modelbase.sql.query.PredicateExists;
import org.eclipse.datatools.modelbase.sql.query.PredicateIn;
import org.eclipse.datatools.modelbase.sql.query.PredicateInValueList;
import org.eclipse.datatools.modelbase.sql.query.PredicateInValueRowSelect;
import org.eclipse.datatools.modelbase.sql.query.PredicateInValueSelect;
import org.eclipse.datatools.modelbase.sql.query.PredicateIsNull;
import org.eclipse.datatools.modelbase.sql.query.PredicateLike;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.emf.common.util.EList;

public class RelationalSingleColumnConditionData
extends SingleColumnConditionData {
    private JpaFilterInfo fJpaFilterData;
    private RelationalMultiConditionData fMultiCondData;
    private int operand = 0;

    public RelationalSingleColumnConditionData(JpaFilterInfo simpleFilterData, List<JpaAttributeInfo> attributesList) {
        this.fJpaFilterData = simpleFilterData;
        this.setColumnList(attributesList);
    }

    public static RelationalSingleColumnConditionData createRelationalSingleColumnConditionData(JpaFilterInfo jpaFilterData, List<JpaAttributeInfo> attributeList, String attributeName, String operatorValue, String varName, String variableValue, String elValuePrefix) {
        RelationalSingleColumnConditionData conditionData = new RelationalSingleColumnConditionData(jpaFilterData, attributeList);
        conditionData.setELValuePrefix(elValuePrefix);
        SingleValueQueryColumn svqc = new SingleValueQueryColumn();
        svqc.setVariableValue(new QueryVariableValue());
        if (attributeName != null) {
            svqc.getVariableValue().setColumnName(attributeName);
        } else if (!attributeList.isEmpty()) {
            svqc.getVariableValue().setColumnName(attributeList.get(0).getAttributeName());
        }
        conditionData.setLHSQueryColumn(svqc);
        if (operatorValue != null) {
            conditionData.setOperator(operatorValue);
        }
        SingleValueQueryColumn svqc1 = new SingleValueQueryColumn();
        svqc1.setVariableValue(new QueryVariableValue());
        if (varName != null) {
            ((QueryVariableValue)svqc1.getVariableValue()).setVariableName(varName);
        }
        if (variableValue != null) {
            ((QueryVariableValue)svqc1.getVariableValue()).setVariableValue(variableValue);
        }
        conditionData.setRHSQueryColumn(svqc1);
        return conditionData;
    }

    static String getOperator(int qOperator) {
        switch (qOperator) {
            case 0: {
                return "=";
            }
            case 1: {
                return "<>";
            }
            case 3: {
                return ">";
            }
            case 2: {
                return "<";
            }
            case 5: {
                return ">=";
            }
            case 4: {
                return "<=";
            }
        }
        return "";
    }

    public static RelationalSingleColumnConditionData parseQuery(Predicate predicate, JpaEntityInfo entity, JpaFilterInfo filterInfo, List<JpaFilterParameterInfo> parameters, StringBuffer filterVal, int currentOperator) {
        int filterIndex = Integer.parseInt(filterVal.toString());
        RelationalSingleColumnConditionData conditionData = new RelationalSingleColumnConditionData(filterInfo, entity.getAttributes());
        String leftColumnName = "";
        if (predicate instanceof PredicateBasic) {
            PredicateBasic basic = (PredicateBasic)predicate;
            leftColumnName = basic.getLeftValueExpr().getSourceInfo().getSourceSnippet();
            if (leftColumnName.indexOf(46) >= 0) {
                leftColumnName = leftColumnName.substring(leftColumnName.indexOf(46) + 1);
            }
            String rightValue = basic.getRightValueExpr().getSourceInfo().getSourceSnippet();
            SingleValueQueryColumn svqc = new SingleValueQueryColumn();
            if (rightValue.charAt(0) == ':') {
                QueryVariableValue qvv = new QueryVariableValue();
                qvv.setColumnName(leftColumnName);
                svqc.setVariableValue(qvv);
                if (parameters != null && parameters.size() > filterIndex) {
                    JpaFilterParameterInfo param = parameters.get(filterIndex);
                    qvv.setVariableName(param.getParameterName());
                    qvv.setVariableValue(param.getParameterValue());
                } else {
                    qvv.setVariableName(rightValue);
                }
                ++filterIndex;
            } else {
                QueryVariableValue qvv = new QueryVariableValue();
                svqc.setVariableValue(qvv);
                qvv.setVariableValue(rightValue);
            }
            conditionData.setRHSQueryColumn(svqc);
            conditionData.setOperator(RelationalSingleColumnConditionData.getOperator(basic.getComparisonOperator().getValue()));
        } else if (predicate instanceof PredicateLike) {
            PredicateLike like = (PredicateLike)predicate;
            leftColumnName = like.getMatchingValueExpr().getSourceInfo().getSourceSnippet();
            if (leftColumnName.indexOf(46) >= 0) {
                leftColumnName = leftColumnName.substring(leftColumnName.indexOf(46) + 1);
            }
            String rightValue = like.getPatternValueExpr().getSourceInfo().getSourceSnippet();
            SingleValueQueryColumn svqc = new SingleValueQueryColumn();
            if (rightValue.charAt(0) == ':') {
                QueryVariableValue qvv = new QueryVariableValue();
                qvv.setColumnName(leftColumnName);
                svqc.setVariableValue(qvv);
                if (parameters != null && parameters.size() > filterIndex) {
                    JpaFilterParameterInfo param = parameters.get(filterIndex);
                    qvv.setVariableName(param.getParameterName());
                    qvv.setVariableValue(param.getParameterValue());
                } else {
                    qvv.setVariableName(rightValue);
                }
            } else {
                QueryVariableValue qvv = new QueryVariableValue();
                svqc.setVariableValue(qvv);
                qvv.setVariableValue(rightValue);
            }
            conditionData.setRHSQueryColumn(svqc);
            if (like.isNotLike()) {
                conditionData.setOperator("NOT LIKE");
            } else {
                conditionData.setOperator("LIKE");
            }
        } else if (predicate instanceof PredicateBetween) {
            JpaFilterParameterInfo param;
            QueryVariableValue qvv;
            PredicateBetween between = (PredicateBetween)predicate;
            leftColumnName = between.getLeftValueExpr().getSourceInfo().getSourceSnippet();
            if (leftColumnName.indexOf(46) >= 0) {
                leftColumnName = leftColumnName.substring(leftColumnName.indexOf(46) + 1);
            }
            String rightValue1 = between.getRightValueExpr1().getSourceInfo().getSourceSnippet();
            String rightValue2 = between.getRightValueExpr2().getSourceInfo().getSourceSnippet();
            BinaryValueQueryColumn bvqc = new BinaryValueQueryColumn();
            if (rightValue1.charAt(0) == ':') {
                qvv = new QueryVariableValue();
                qvv.setColumnName(leftColumnName);
                bvqc.setLowValue(qvv);
                if (parameters != null && parameters.size() > filterIndex) {
                    param = parameters.get(filterIndex);
                    qvv.setVariableName(param.getParameterName());
                    qvv.setVariableValue(param.getParameterValue());
                } else {
                    qvv.setVariableName(rightValue1);
                }
                ++filterIndex;
            } else {
                qvv = new QueryVariableValue();
                bvqc.setLowValue(qvv);
                qvv.setVariableValue(rightValue1);
            }
            if (rightValue2.charAt(0) == ':') {
                qvv = new QueryVariableValue();
                qvv.setColumnName(leftColumnName);
                bvqc.setHighValue(qvv);
                if (parameters != null && parameters.size() > filterIndex) {
                    param = parameters.get(filterIndex);
                    qvv.setVariableName(param.getParameterName());
                    qvv.setVariableValue(param.getParameterValue());
                } else {
                    qvv.setVariableName(rightValue2);
                }
            } else {
                qvv = new QueryVariableValue();
                bvqc.setHighValue(qvv);
                qvv.setVariableValue(rightValue2);
            }
            conditionData.setRHSQueryColumn(bvqc);
            if (between.isNotBetween()) {
                conditionData.setOperator("NOT BETWEEN");
            } else {
                conditionData.setOperator("BETWEEN");
            }
        } else if (predicate instanceof PredicateIn) {
            PredicateInValueSelect valueSelect;
            PredicateIn in = (PredicateIn)predicate;
            EList rightValues = null;
            if (in instanceof PredicateInValueList) {
                PredicateInValueList valueList = (PredicateInValueList)in;
                leftColumnName = valueList.getValueExpr().getSourceInfo().getSourceSnippet();
                if (leftColumnName.indexOf(46) >= 0) {
                    leftColumnName = leftColumnName.substring(leftColumnName.indexOf(46) + 1);
                }
                rightValues = valueList.getValueExprList();
            } else if (in instanceof PredicateInValueRowSelect) {
                PredicateInValueRowSelect rowSelect = (PredicateInValueRowSelect)in;
                leftColumnName = rowSelect.getSourceInfo().getSourceSnippet();
                if (leftColumnName.indexOf(46) >= 0) {
                    leftColumnName = leftColumnName.substring(leftColumnName.indexOf(46) + 1);
                }
                rightValues = rowSelect.getValueExprList();
            } else if (in instanceof PredicateInValueSelect && (leftColumnName = (valueSelect = (PredicateInValueSelect)in).getValueExpr().getSourceInfo().getSourceSnippet()).indexOf(46) >= 0) {
                leftColumnName = leftColumnName.substring(leftColumnName.indexOf(46) + 1);
            }
            MultiValueQueryColumn mvqc = new MultiValueQueryColumn();
            for (QueryValueExpression nextValue : rightValues) {
                QueryVariableValue qvv;
                if (nextValue.getSourceInfo().getSourceSnippet().charAt(0) == ':') {
                    qvv = new QueryVariableValue();
                    qvv.setColumnName(leftColumnName);
                    mvqc.getMultiValues().add(qvv);
                    if (parameters != null && parameters.size() > filterIndex) {
                        JpaFilterParameterInfo param = parameters.get(filterIndex);
                        qvv.setVariableName(param.getParameterName());
                        qvv.setVariableValue(param.getParameterValue());
                        continue;
                    }
                    qvv.setVariableName(nextValue.getSourceInfo().getSourceSnippet());
                    continue;
                }
                qvv = new QueryVariableValue();
                mvqc.getMultiValues().add(qvv);
                qvv.setVariableValue(nextValue.getSourceInfo().getSourceSnippet());
            }
            conditionData.setRHSQueryColumn(mvqc);
            if (in.isNotIn()) {
                conditionData.setOperator("NOT IN");
            } else {
                conditionData.setOperator("IN");
            }
        } else if (predicate instanceof PredicateIsNull) {
            PredicateIsNull isNull = (PredicateIsNull)predicate;
            leftColumnName = isNull.getValueExpr().getSourceInfo().getSourceSnippet();
            if (leftColumnName.indexOf(46) >= 0) {
                leftColumnName = leftColumnName.substring(leftColumnName.indexOf(46) + 1);
            }
            if (isNull.isNotNull()) {
                conditionData.setOperator("IS NOT NULL");
            } else {
                conditionData.setOperator("IS NULL");
            }
        } else if (predicate instanceof PredicateExists) {
            PredicateExists exists = (PredicateExists)predicate;
            leftColumnName = exists.getValueExprCaseSearchContent().getSourceInfo().getSourceSnippet();
            if (leftColumnName.indexOf(46) >= 0) {
                leftColumnName = leftColumnName.substring(leftColumnName.indexOf(46) + 1);
            }
            String rightValue = exists.getValueExprCaseSearchContent().getSQL();
            SingleValueQueryColumn svqc = new SingleValueQueryColumn();
            if (rightValue.charAt(0) == ':') {
                QueryVariableValue qvv = new QueryVariableValue();
                svqc.setVariableValue(qvv);
                if (parameters != null && parameters.size() > filterIndex) {
                    JpaFilterParameterInfo param = parameters.get(filterIndex);
                    qvv.setVariableName(param.getParameterName());
                    qvv.setVariableValue(param.getParameterValue());
                } else {
                    qvv.setVariableName(rightValue);
                }
            } else {
                QueryVariableValue qvv = new QueryVariableValue();
                svqc.setVariableValue(qvv);
                qvv.setVariableValue(rightValue);
            }
            conditionData.setRHSQueryColumn(svqc);
            conditionData.setOperator("EXISTS");
        }
        SingleValueQueryColumn svqc = new SingleValueQueryColumn();
        svqc.setVariableValue(new QueryVariableValue());
        svqc.getVariableValue().setColumnName(leftColumnName);
        conditionData.setLHSQueryColumn(svqc);
        conditionData.setOperand(entity, currentOperator == 1 ? 1 : 0, false);
        filterVal.delete(0, filterVal.toString().length());
        filterVal.append(filterIndex);
        return conditionData;
    }

    private void constructFilterArg(JpaEntityInfo entity, StringBuffer singleFilter, ISingleQueryColumn queryColumn, List list) {
        if (queryColumn instanceof ISingleValueQueryColumn) {
            ISingleValueQueryColumn singleValueQueryColumn = (ISingleValueQueryColumn)((Object)queryColumn);
            this.constructSingleFilterArg(entity, singleFilter, list, (QueryVariableValue)singleValueQueryColumn.getVariableValue());
        } else if (queryColumn instanceof IBinaryValueQueryColumn) {
            IBinaryValueQueryColumn binaryValueQueryColumn = (IBinaryValueQueryColumn)((Object)queryColumn);
            this.constructSingleFilterArg(entity, singleFilter, list, (QueryVariableValue)binaryValueQueryColumn.getLowValue());
            singleFilter.append(" AND ");
            this.constructSingleFilterArg(entity, singleFilter, list, (QueryVariableValue)binaryValueQueryColumn.getHighValue());
        } else if (queryColumn instanceof IMultiValueQueryColumn) {
            IMultiValueQueryColumn multiValueQueryColumn = (IMultiValueQueryColumn)((Object)queryColumn);
            singleFilter.append("( ");
            Iterator iter = multiValueQueryColumn.getMultiValues().iterator();
            while (iter.hasNext()) {
                QueryVariableValue multiValue = (QueryVariableValue)iter.next();
                this.constructSingleFilterArg(entity, singleFilter, list, multiValue);
                if (!iter.hasNext()) continue;
                singleFilter.append(", ");
            }
            singleFilter.append(") ");
        }
        this.isUnary();
    }

    private void constructSingleFilterArg(JpaEntityInfo entity, StringBuffer singleFilter, List list, QueryVariableValue variableValue) {
        if (variableValue.getVariableName() != null) {
            singleFilter.append(variableValue.getVariableName());
            JpaFilterParameterInfo filterArg = new JpaFilterParameterInfo(variableValue.getVariableName().substring(1), "", variableValue.getColumnName());
            list.add(filterArg);
            if (variableValue.getVariableValue() == null) {
                this.setFilterValue(filterArg, "");
            } else {
                this.setFilterValue(filterArg, "'" + variableValue.getVariableValue() + "'");
            }
        } else if (variableValue.getColumnName() != null) {
            String entityName = entity.getName();
            String first = entityName.substring(0, 1);
            first = first.toLowerCase();
            singleFilter.append(String.valueOf(first) + "." + variableValue.getColumnName());
        } else {
            String variableValue2 = variableValue.getVariableValue();
            singleFilter.append(variableValue2);
        }
    }

    public JpaFilterParameterInfo[] constructSingleQueryAndOperand(JpaEntityInfo entity, StringBuffer filter, boolean insertOperand) {
        StringBuffer singleFilter = new StringBuffer();
        ArrayList list = new ArrayList();
        singleFilter.append(" ");
        this.constructFilterArg(entity, singleFilter, this.getLHSQueryColumn(), list);
        singleFilter.append(" ");
        singleFilter.append(String.valueOf(this.getOperator()) + " ");
        this.constructFilterArg(entity, singleFilter, this.getRHSQueryColumn(), list);
        if (insertOperand) {
            String operand = this.getOperand() == 0 ? "AND" : "OR";
            singleFilter.append(" " + operand);
        }
        singleFilter.append(" ");
        filter.append(singleFilter);
        return list.toArray(new JpaFilterParameterInfo[list.size()]);
    }

    @Override
    public String getCondition() {
        StringBuffer buf = new StringBuffer();
        RelationalMultiConditionData searchConditionData = this.getMultiConditionData();
        ConditionData child = this;
        while (searchConditionData != null) {
            if (searchConditionData.predicatesList.indexOf(child) != 0) break;
            buf.append("(");
            child = searchConditionData;
            searchConditionData = searchConditionData.getMultiCondData();
        }
        buf.append(super.getCondition());
        searchConditionData = this.getMultiConditionData();
        child = this;
        while (searchConditionData != null) {
            if (searchConditionData.predicatesList.indexOf(child) != searchConditionData.predicatesList.size() - 1) break;
            buf.append(")");
            child = searchConditionData;
            searchConditionData = searchConditionData.getMultiCondData();
        }
        return buf.toString();
    }

    @Override
    public JpaFilterInfo getJpaFilterData() {
        return this.fJpaFilterData;
    }

    public RelationalMultiConditionData getMultiConditionData() {
        return this.fMultiCondData;
    }

    public int getOperand() {
        RelationalMultiConditionData searchConditionData = this.getMultiConditionData();
        ConditionData child = this;
        int operand = this.operand;
        while (searchConditionData != null) {
            if (searchConditionData.predicatesList.indexOf(child) != searchConditionData.predicatesList.size() - 1) break;
            operand = searchConditionData.getOperand();
            child = searchConditionData;
            searchConditionData = searchConditionData.getMultiCondData();
        }
        return operand;
    }

    private void setFilterValue(JpaFilterParameterInfo filterArg, String filterValue) {
        filterArg.setParameterValue(filterValue);
    }

    public void setMultiCondData(RelationalMultiConditionData data) {
        this.fMultiCondData = data;
    }

    public void setOperand(JpaEntityInfo entity, int code) {
        RelationalMultiConditionData searchConditionData = this.getMultiConditionData();
        ConditionData child = this;
        int operand = code;
        while (searchConditionData != null) {
            if (searchConditionData.predicatesList.indexOf(child) != searchConditionData.predicatesList.size() - 1) break;
            searchConditionData.setOperand(operand);
            child = searchConditionData;
            searchConditionData = searchConditionData.getMultiCondData();
        }
        this.setOperand(entity, code, true);
    }

    public void setOperand(JpaEntityInfo entity, int code, boolean updateMetadata) {
        if (this.operand != code) {
            this.operand = code;
            if (updateMetadata) {
                this.getJpaFilterData().updateJPAFilterData(entity);
            }
        }
    }
}

