/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.connection;

import com.ibm.etools.sdo.jdbc.ui.internal.data.ConnectionData;
import com.ibm.etools.sdo.jdbc.ui.internal.util.ConnectionProfileUtil;
import com.ibm.etools.sdo.jdbc.ui.internal.util.ConnectionsHelper;
import com.ibm.etools.sdo.jdbc.ui.internal.util.ConnectionsUIUtil;
import com.ibm.etools.sdo.jdbc.ui.internal.util.RSCConnectionsHelper;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.Connection;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.DatasourceConnection;
import com.ibm.etools.webtools.deploy.jdbc.internal.nls.ResourceHandler;
import com.ibm.etools.webtools.jpa.connection.AutoDeployJDBCUIJob;
import com.ibm.etools.webtools.jpa.connection.JDBCConnectionModel;
import com.ibm.etools.webtools.jpa.nls.JpaUI;
import com.ibm.etools.webtools.jpa.wizard.ui.UIPartsUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.core.context.persistence.Property;
import org.eclipse.jpt.core.internal.context.GenericRootContextNode;
import org.eclipse.jpt.db.ConnectionProfile;
import org.eclipse.jpt.db.JptDbPlugin;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class DeployJDBCConnectionDialog
extends Dialog {
    public static final String DEPLOY_CONN_PAGE_HELP_ID = "com.ibm.etools.webtools.jpa. webjpacon001";
    public static final String RESOURCE_REF_PREFIX = "java:comp/env/";
    public static final String DATASOURCE_JNDI_PREFIX = "jdbc/";
    private static final String NON_JTA = "Non-JTA";
    private static final String JTA = "JTA";
    private String connectionProfileName = null;
    private JpaProject jpaProject;
    private Combo connectionCombo;
    private Button schemaCheckbox;
    private Combo schemaCombo;
    private Link addConnectionLink;
    private Button dataSourceRadioButton;
    private Button driverManagedRadioButton;
    private Button persistenceXmlCheckbox;
    private Button deployJDBCCheckbox;
    private JDBCConnectionModel model;
    private Combo dataSourceJTATypeCombo;
    private Link fConfigureConnections;
    private Label dataSourceNameLabel;
    private Text datasourceNameTextField;
    private Label datasourceJtaTypeLabel;
    private Text details1;
    private Text details2;

    public DeployJDBCConnectionDialog(Shell parentShell, JpaProject jpaProject) {
        super(parentShell);
        this.jpaProject = jpaProject;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button okButton;
        super.createButtonsForButtonBar(parent);
        IConnectionProfile[] profilesByCategory = ProfileManager.getInstance().getProfilesByCategory("org.eclipse.datatools.connectivity.db.category");
        if (profilesByCategory.length == 0 && (okButton = this.getButton(0)) != null) {
            okButton.setEnabled(false);
        }
    }

    private Combo createCombo(Composite container, boolean fillHorizontal) {
        Combo combo = new Combo(container, 2060);
        if (fillHorizontal) {
            combo.setLayoutData((Object)new GridData(768));
        } else {
            combo.setLayoutData((Object)new GridData());
        }
        return combo;
    }

    private void createDeployComposite(Composite composite) {
        this.deployJDBCCheckbox = new Button(composite, 16416);
        this.deployJDBCCheckbox.setText(JpaUI.DeployJDBCConnectionDialog_13);
        GridData data3 = new GridData(768);
        data3.horizontalSpan = 2;
        this.deployJDBCCheckbox.setLayoutData((Object)data3);
        this.deployJDBCCheckbox.setSelection(true);
        Label detailsLabel = this.createLabel(composite, 2, JpaUI.DeployJDBCConnectionDialog_14);
        GridData data = (GridData)detailsLabel.getLayoutData();
        data.horizontalIndent = 20;
        this.details1 = new Text(composite, 8);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        this.details1.setLayoutData((Object)data);
        data = (GridData)this.details1.getLayoutData();
        data.horizontalIndent = 40;
        this.details2 = new Text(composite, 8);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        this.details2.setLayoutData((Object)data);
        data = (GridData)this.details2.getLayoutData();
        data.horizontalIndent = 40;
        this.fConfigureConnections = new Link(composite, 0);
        data = new GridData(3, 2, false, false);
        data.horizontalSpan = 2;
        this.fConfigureConnections.setLayoutData((Object)data);
        this.fConfigureConnections.setText("<A>" + ResourceHandler.ConnectionControl_1 + "</A>");
        this.fConfigureConnections.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionsUIUtil.openJDBCConnectionsPreferencePageForProject((IProject)DeployJDBCConnectionDialog.this.jpaProject.getProject(), (Shell)DeployJDBCConnectionDialog.this.fConfigureConnections.getShell());
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, DEPLOY_CONN_PAGE_HELP_ID);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData maindata = new GridData();
        maindata.widthHint = 400;
        composite.setLayoutData((Object)maindata);
        this.getShell().setText(JpaUI.DeployJDBCConnectionDialog_11);
        GridData data = null;
        Label header = new Label(composite, 64);
        header.setText(JpaUI.DeployJDBCConnectionDialog_12);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(250, -1).applyTo((Control)header);
        data = (GridData)header.getLayoutData();
        data.horizontalSpan = 2;
        Label spacer = new Label(composite, 0);
        data = new GridData();
        data.horizontalSpan = 2;
        spacer.setLayoutData((Object)data);
        this.createLabel(composite, 1, JpaUI.DatabaseReconnectWizardPage_connection);
        this.connectionCombo = this.createCombo(composite, true);
        this.connectionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                DeployJDBCConnectionDialog.this.handleConnectionChange();
            }
        });
        data = (GridData)this.connectionCombo.getLayoutData();
        data.horizontalSpan = 1;
        this.addConnectionLink = new Link(composite, 0);
        data = new GridData(3, 2, false, false);
        data.horizontalSpan = 2;
        this.addConnectionLink.setLayoutData((Object)data);
        this.addConnectionLink.setText("<a>" + JpaUI.DatabaseReconnectWizardPage_addConnectionLink + "</a>");
        this.addConnectionLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeployJDBCConnectionDialog.this.openNewConnectionWizard();
            }
        });
        Group group = new Group(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        ((GridData)group.getLayoutData()).horizontalSpan = 2;
        this.createPersistenceXMLComposite((Composite)group);
        group = new Group(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        ((GridData)group.getLayoutData()).horizontalSpan = 2;
        this.createDeployComposite((Composite)group);
        this.populateConnectionCombo();
        boolean defaultSchemaFound = this.populateSchemaCombo();
        this.setInitialDefaults(defaultSchemaFound);
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    private Label createLabel(Composite container, int span, String text) {
        Label label = new Label(container, 0);
        label.setText(text);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        label.setLayoutData((Object)gd);
        return label;
    }

    private void createPersistenceXMLComposite(Composite composite) {
        this.persistenceXmlCheckbox = UIPartsUtil.createCheckBox(composite, JpaUI.DeployJDBCConnectionDialog_17, null, 2);
        ((GridData)this.persistenceXmlCheckbox.getLayoutData()).horizontalSpan = 2;
        this.persistenceXmlCheckbox.setSelection(true);
        this.persistenceXmlCheckbox.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (DeployJDBCConnectionDialog.this.persistenceXmlCheckbox.getSelection()) {
                    DeployJDBCConnectionDialog.this.dataSourceRadioButton.setEnabled(true);
                    DeployJDBCConnectionDialog.this.driverManagedRadioButton.setEnabled(true);
                    DeployJDBCConnectionDialog.this.datasourceJtaTypeLabel.setEnabled(true);
                    DeployJDBCConnectionDialog.this.dataSourceNameLabel.setEnabled(true);
                    DeployJDBCConnectionDialog.this.datasourceNameTextField.setEnabled(true);
                    DeployJDBCConnectionDialog.this.schemaCheckbox.setEnabled(true);
                } else {
                    DeployJDBCConnectionDialog.this.dataSourceRadioButton.setEnabled(false);
                    DeployJDBCConnectionDialog.this.driverManagedRadioButton.setEnabled(false);
                    DeployJDBCConnectionDialog.this.datasourceJtaTypeLabel.setEnabled(false);
                    DeployJDBCConnectionDialog.this.dataSourceNameLabel.setEnabled(false);
                    DeployJDBCConnectionDialog.this.datasourceNameTextField.setEnabled(false);
                    DeployJDBCConnectionDialog.this.schemaCheckbox.setEnabled(false);
                }
                DeployJDBCConnectionDialog.this.handleSchemaCheckbox();
                DeployJDBCConnectionDialog.this.handleDataSourceCombo();
            }
        });
        Composite dataSourceComposite = UIPartsUtil.createComposite(composite, 2, 2);
        this.dataSourceRadioButton = UIPartsUtil.createRadioButton(dataSourceComposite, JpaUI.DeployJDBCConnectionDialog_18, 2, true);
        ((GridData)this.dataSourceRadioButton.getLayoutData()).horizontalIndent = 20;
        this.dataSourceRadioButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DeployJDBCConnectionDialog.this.handleConnectionStyle();
            }
        });
        this.dataSourceNameLabel = this.createLabel(dataSourceComposite, 1, JpaUI.DeployJDBCConnectionDialog_19);
        ((GridData)this.dataSourceNameLabel.getLayoutData()).horizontalIndent = 40;
        this.datasourceNameTextField = UIPartsUtil.createTextField(dataSourceComposite, 1);
        this.datasourceJtaTypeLabel = this.createLabel(dataSourceComposite, 1, JpaUI.DeployJDBCConnectionDialog_20);
        ((GridData)this.datasourceJtaTypeLabel.getLayoutData()).horizontalIndent = 40;
        this.dataSourceJTATypeCombo = new Combo(dataSourceComposite, 2060);
        this.dataSourceJTATypeCombo.add(JTA);
        this.dataSourceJTATypeCombo.add(NON_JTA);
        this.dataSourceJTATypeCombo.select(0);
        this.driverManagedRadioButton = UIPartsUtil.createRadioButton(dataSourceComposite, JpaUI.DeployJDBCConnectionDialog_21, 2, false);
        ((GridData)this.driverManagedRadioButton.getLayoutData()).horizontalIndent = 20;
        this.schemaCheckbox = UIPartsUtil.createCheckBox(composite, JpaUI.DeployJDBCConnectionDialog_22, null, 1);
        this.schemaCheckbox.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DeployJDBCConnectionDialog.this.handleSchemaCheckbox();
                DeployJDBCConnectionDialog.this.handlePopulatingSchemaCheckbox();
            }
        });
        this.schemaCheckbox.setSelection(true);
        ((GridData)this.schemaCheckbox.getLayoutData()).horizontalIndent = 20;
        this.schemaCombo = new Combo(composite, 2052);
        this.schemaCombo.setLayoutData((Object)new GridData(768));
    }

    private String getConnectionProfileName() {
        return this.connectionCombo.getText();
    }

    private ConnectionProfile getConnectionProfileNamed(String profileName) {
        return JptDbPlugin.instance().getConnectionProfileRepository().connectionProfileNamed(profileName);
    }

    private String getDatasourceName() {
        PersistenceUnit unit;
        ListIterator persistenceUnits;
        String datasource = null;
        GenericRootContextNode rootContext = (GenericRootContextNode)this.jpaProject.getRootContext();
        PersistenceXml persistenceXml = rootContext.getPersistenceXml();
        if (persistenceXml != null && (persistenceUnits = persistenceXml.getPersistence().persistenceUnits()).hasNext() && (unit = (PersistenceUnit)persistenceUnits.next()) != null && (datasource = unit.getJtaDataSource()) == null) {
            datasource = unit.getNonJtaDataSource();
        }
        return datasource;
    }

    private Schema getDefaultSchema(ConnectionProfile profile) {
        Schema defaultSchema = profile.getDefaultSchema();
        return defaultSchema;
    }

    private String getExistingSchemaName() {
        Property schema;
        PersistenceUnit unit;
        ListIterator persistenceUnits;
        GenericRootContextNode rootContext;
        PersistenceXml persistenceXml;
        if (this.jpaProject != null && (persistenceXml = (rootContext = (GenericRootContextNode)this.jpaProject.getRootContext()).getPersistenceXml()) != null && (persistenceUnits = persistenceXml.getPersistence().persistenceUnits()).hasNext() && (unit = (PersistenceUnit)persistenceUnits.next()) != null && (schema = unit.getProperty("openjpa.jdbc.Schema")) != null) {
            return schema.getValue();
        }
        return null;
    }

    public JDBCConnectionModel getModel() {
        return this.model;
    }

    ConnectionProfile getProjectConnectionProfile() {
        String profileName = this.jpaProject.getDataSource().getConnectionProfileName();
        return JptDbPlugin.instance().getConnectionProfileRepository().connectionProfileNamed(profileName);
    }

    private String getProjectConnectionProfileName() {
        return this.jpaProject.getDataSource().getConnectionProfileName();
    }

    private String getSchemaName() {
        return this.schemaCombo.getText();
    }

    private void handleConnectionChange() {
        this.populateSchemaCombo();
        this.updateDatasourceName();
        this.updateDeployDetails();
    }

    private void handleConnectionStyle() {
        this.handleDataSourceCombo();
        this.updateDeployDetails();
    }

    private void handleDataSourceCombo() {
        if (!this.persistenceXmlCheckbox.getSelection()) {
            this.dataSourceJTATypeCombo.setEnabled(false);
            this.datasourceNameTextField.setEnabled(false);
        } else if (!this.dataSourceRadioButton.getSelection()) {
            this.dataSourceJTATypeCombo.setEnabled(false);
            this.datasourceNameTextField.setEnabled(false);
        } else {
            this.dataSourceJTATypeCombo.setEnabled(true);
            this.datasourceNameTextField.setEnabled(true);
        }
    }

    protected void handlePopulatingSchemaCheckbox() {
        if (this.schemaCheckbox.getSelection()) {
            this.populateSchemaCombo();
        }
    }

    private void handleSchemaCheckbox() {
        if (!this.persistenceXmlCheckbox.getSelection()) {
            this.schemaCombo.setEnabled(false);
        } else if (this.schemaCheckbox.getSelection()) {
            this.schemaCombo.setEnabled(true);
        } else {
            this.schemaCombo.setEnabled(false);
        }
    }

    protected GridLayout initGridLayout(GridLayout layout, boolean margins) {
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        if (margins) {
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        } else {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        return layout;
    }

    private boolean isUsingDirectConnection() {
        Property url;
        PersistenceUnit unit;
        ListIterator persistenceUnits;
        GenericRootContextNode rootContext;
        PersistenceXml persistenceXml;
        boolean propertyFound = false;
        if (this.jpaProject != null && (persistenceXml = (rootContext = (GenericRootContextNode)this.jpaProject.getRootContext()).getPersistenceXml()) != null && (persistenceUnits = persistenceXml.getPersistence().persistenceUnits()).hasNext() && (unit = (PersistenceUnit)persistenceUnits.next()) != null && (url = unit.getProperty("openjpa.ConnectionURL")) != null) {
            propertyFound = true;
        }
        return propertyFound;
    }

    protected void okPressed() {
        String selectedItem;
        int selectionIndex = this.connectionCombo.getSelectionIndex();
        this.connectionProfileName = selectedItem = this.connectionCombo.getItem(selectionIndex);
        this.model = new JDBCConnectionModel();
        this.model.setConnectionProfileName(this.connectionProfileName);
        this.model.setUpdatePersistenceXML(this.persistenceXmlCheckbox.getSelection());
        if (this.persistenceXmlCheckbox.getSelection()) {
            if (this.dataSourceRadioButton.getSelection()) {
                String jtaType = this.dataSourceJTATypeCombo.getItem(this.dataSourceJTATypeCombo.getSelectionIndex());
                if (jtaType.equals(NON_JTA)) {
                    this.model.setDataSourceType(JDBCConnectionModel.DATA_SOURCE_TYPE.NON_JTA);
                } else {
                    this.model.setDataSourceType(JDBCConnectionModel.DATA_SOURCE_TYPE.JTA);
                }
                this.model.setUseDirectConnectionProperties(false);
                this.model.setDataSourceName(this.datasourceNameTextField.getText());
            } else {
                this.model.setDataSourceType(JDBCConnectionModel.DATA_SOURCE_TYPE.NONE);
                this.model.setUseDirectConnectionProperties(true);
            }
            if (this.schemaCheckbox.getSelection()) {
                this.model.setSchemaName(this.getSchemaName());
            } else {
                this.model.setSchemaName(null);
            }
        } else {
            this.model.setDataSourceType(JDBCConnectionModel.DATA_SOURCE_TYPE.NONE);
            this.model.setUseDirectConnectionProperties(false);
            this.model.setSchemaName(null);
        }
        this.model.setDeployJDBCConnection(this.deployJDBCCheckbox.getSelection());
        super.okPressed();
    }

    private void openNewConnectionWizard() {
        IConnectionProfile newProfile = ConnectionProfileUtil.createNewProfile();
        if (newProfile != null) {
            this.populateConnectionCombo();
            this.connectionCombo.select(this.connectionCombo.indexOf(newProfile.getName()));
            this.handleConnectionChange();
            Button okButton = this.getButton(0);
            if (okButton != null) {
                okButton.setEnabled(true);
            }
        }
    }

    private void populateConnectionCombo() {
        int itemCount;
        String selectedProfileName;
        IConnectionProfile[] profilesByCategory;
        this.connectionCombo.removeAll();
        ArrayList<String> profileNames = new ArrayList<String>();
        IConnectionProfile[] iConnectionProfileArray = profilesByCategory = ProfileManager.getInstance().getProfilesByCategory("org.eclipse.datatools.connectivity.db.category");
        int n = profilesByCategory.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionProfile connectionProfile = iConnectionProfileArray[n2];
            profileNames.add(connectionProfile.getName());
            ++n2;
        }
        List sortedProfileNames = CollectionTools.sort(profileNames);
        for (String sortedProfileName : sortedProfileNames) {
            this.connectionCombo.add(sortedProfileName);
        }
        String connectionName = this.getProjectConnectionProfileName();
        if (!StringTools.stringIsEmpty((String)connectionName)) {
            this.connectionCombo.select(this.connectionCombo.indexOf(connectionName));
        }
        if (((selectedProfileName = this.getConnectionProfileName()) == null || selectedProfileName.length() == 0) && (itemCount = this.connectionCombo.getItemCount()) > 0) {
            int i;
            boolean found = false;
            String datasourceName = this.getDatasourceName();
            if (datasourceName != null) {
                i = 0;
                while (i < itemCount && !found) {
                    selectedProfileName = this.connectionCombo.getItem(i);
                    if (datasourceName.contains(selectedProfileName)) {
                        found = true;
                        this.connectionCombo.select(i);
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < itemCount && !found) {
                selectedProfileName = this.connectionCombo.getItem(i);
                ConnectionProfile connectionProfile = this.getConnectionProfileNamed(selectedProfileName);
                try {
                    if (connectionProfile.isConnected()) {
                        found = true;
                        this.connectionCombo.select(i);
                    }
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            if (!found) {
                this.connectionCombo.select(0);
                selectedProfileName = this.connectionCombo.getItem(0);
            }
        }
        this.updateDatasourceName();
        this.updateDeployDetails();
    }

    private boolean populateSchemaCombo() {
        boolean defaultSchemaFound = false;
        this.schemaCombo.removeAll();
        if (this.schemaCheckbox.getSelection()) {
            ConnectionProfile connectionProfile = this.getConnectionProfileNamed(this.getConnectionProfileName());
            try {
                String userDefinedSchema;
                if (!connectionProfile.isConnected()) {
                    try {
                        IConnectionProfile profile = ProfileManager.getInstance().getProfileByName(this.getConnectionProfileName());
                        RSCConnectionsHelper.connectWithPromptIfNeeded((IConnectionProfile)profile, (boolean)true, (Shell)this.getShell());
                    }
                    catch (RuntimeException runtimeException) {}
                }
                Iterator stream = CollectionTools.sort((Iterator)connectionProfile.getDatabase().schemaNames());
                while (stream.hasNext()) {
                    this.schemaCombo.add((String)stream.next());
                }
                Schema schema = this.getDefaultSchema(connectionProfile);
                if (schema != null && schema.getName() != null && (schema = connectionProfile.getDatabase().schemaNamed(schema.getName())) != null) {
                    this.schemaCombo.select(this.schemaCombo.indexOf(schema.getName()));
                    defaultSchemaFound = true;
                }
                if (!defaultSchemaFound && (userDefinedSchema = this.jpaProject.getUserOverrideDefaultSchemaName()) != null && (schema = connectionProfile.getDatabase().schemaNamed(userDefinedSchema)) != null) {
                    this.schemaCombo.select(this.schemaCombo.indexOf(userDefinedSchema));
                }
                if (this.schemaCombo.getItemCount() > 0 && this.schemaCombo.getSelectionIndex() < 0) {
                    this.schemaCombo.select(0);
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        return defaultSchemaFound;
    }

    private void setInitialDefaults(boolean defaultSchemaFound) {
        String existingSchemaName = this.getExistingSchemaName();
        boolean schemaSet = false;
        if (existingSchemaName != null && existingSchemaName.length() > 0) {
            this.schemaCombo.select(this.schemaCombo.indexOf(existingSchemaName));
            schemaSet = true;
        }
        if (!schemaSet && defaultSchemaFound) {
            this.schemaCheckbox.setSelection(false);
            this.handleSchemaCheckbox();
        }
        if (this.isUsingDirectConnection()) {
            this.driverManagedRadioButton.setSelection(true);
            this.dataSourceRadioButton.setSelection(false);
            this.handleConnectionStyle();
        }
    }

    public void setModel(JDBCConnectionModel model) {
        this.model = model;
    }

    private void updateDatasourceName() {
        String selectedProfileName = this.getConnectionProfileName();
        if (selectedProfileName != null && selectedProfileName.length() > 0) {
            boolean existingDatasourceWithoutResourceRef = false;
            String datasourceName = this.getDatasourceName();
            if (datasourceName != null && !datasourceName.startsWith(RESOURCE_REF_PREFIX)) {
                existingDatasourceWithoutResourceRef = true;
            }
            if (!existingDatasourceWithoutResourceRef && AutoDeployJDBCUIJob.isResourceRefDefinedForConnection(this.jpaProject.getProject())) {
                String resourceRefName = null;
                Connection connection = null;
                try {
                    connection = ConnectionsHelper.getConnection((IProject)this.jpaProject.getProject(), (String)this.getConnectionProfileName());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (connection != null && connection.getRuntime() instanceof DatasourceConnection) {
                    DatasourceConnection dsCon = (DatasourceConnection)connection.getRuntime();
                    resourceRefName = dsCon.getResourceReferenceName();
                }
                if (resourceRefName == null || resourceRefName.length() == 0) {
                    resourceRefName = selectedProfileName;
                }
                this.datasourceNameTextField.setText(RESOURCE_REF_PREFIX + resourceRefName);
            } else {
                String jndiName = null;
                Connection connection = null;
                try {
                    connection = ConnectionsHelper.getConnection((IProject)this.jpaProject.getProject(), (String)this.getConnectionProfileName());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (connection != null && connection.getRuntime() instanceof DatasourceConnection) {
                    DatasourceConnection dsCon = (DatasourceConnection)connection.getRuntime();
                    jndiName = dsCon.getJndiName();
                }
                if (jndiName == null || jndiName.length() == 0) {
                    jndiName = DATASOURCE_JNDI_PREFIX + selectedProfileName;
                }
                this.datasourceNameTextField.setText(jndiName);
            }
        } else {
            this.datasourceNameTextField.setText("");
        }
    }

    private void updateDeployDetails() {
        if (!this.deployJDBCCheckbox.getSelection()) {
            this.details1.setText("");
            this.details2.setText("");
            return;
        }
        if (!this.persistenceXmlCheckbox.getSelection() || this.dataSourceRadioButton.getSelection()) {
            String currentId = this.getConnectionProfileName();
            if (currentId != null && currentId.length() > 0) {
                List connections = ConnectionData.getConnections((IProject)this.jpaProject.getProject());
                int size = connections.size();
                boolean found = false;
                int j = 0;
                while (j < size) {
                    Connection con = (Connection)connections.get(j);
                    if (currentId.equals(con.getId())) {
                        if (con.getRuntime() instanceof DatasourceConnection) {
                            DatasourceConnection dsCon = (DatasourceConnection)con.getRuntime();
                            this.details1.setText(String.valueOf(JpaUI.DeployJDBCConnectionDialog_5) + dsCon.getResourceReferenceName());
                            this.details2.setText(String.valueOf(JpaUI.DeployJDBCConnectionDialog_6) + dsCon.getJndiName());
                        } else {
                            this.details1.setText(String.valueOf(JpaUI.DeployJDBCConnectionDialog_5) + currentId);
                            this.details2.setText(String.valueOf(JpaUI.DeployJDBCConnectionDialog_6) + DATASOURCE_JNDI_PREFIX + currentId);
                        }
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    this.details1.setText(String.valueOf(JpaUI.DeployJDBCConnectionDialog_5) + currentId);
                    this.details2.setText(String.valueOf(JpaUI.DeployJDBCConnectionDialog_6) + DATASOURCE_JNDI_PREFIX + currentId);
                }
            }
        } else {
            this.details1.setText(JpaUI.DeployJDBCConnectionDialog_9);
            this.details2.setText("");
        }
    }
}

