/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.commands;

import com.ibm.etools.webtools.jpa.JpaPlugin;
import com.ibm.etools.webtools.jpa.models.JpaManagerBeanInfo;
import com.ibm.etools.webtools.jpa.nls.JpaMsg;
import com.ibm.etools.webtools.jpa.util.JpaUtil;
import com.ibm.etools.webtools.jpa.wizard.JpaManagerBeanWizard;
import com.ibm.etools.webtools.jpa.wizard.model.JpaManagerBeanDataModelProvider;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class JpaManagerBeanCommand
extends Command {
    IDataModel model;
    private IProject project;
    private String fGenerationType;
    private boolean fIsConfigure;
    private final Shell shell;
    private JpaManagerBeanInfo jpaManagerBeanToConfigure;
    boolean runInBackground = true;

    public JpaManagerBeanCommand(IProject project, Shell shell, String generationType, boolean isConfigure, boolean runInBackground) {
        this.project = project;
        this.shell = shell;
        this.fGenerationType = generationType;
        this.fIsConfigure = isConfigure;
        this.runInBackground = runInBackground;
    }

    public JpaManagerBeanCommand(IProject project, Shell shell, String generationType, JpaManagerBeanInfo jpaManagerBeanToConfigure) {
        this.project = project;
        this.shell = shell;
        this.fGenerationType = generationType;
        this.jpaManagerBeanToConfigure = jpaManagerBeanToConfigure;
        this.fIsConfigure = true;
    }

    public void execute() {
        try {
            this.primeDataModel();
            if (this.model != null) {
                JpaManagerBeanWizard wizard = new JpaManagerBeanWizard(this.model);
                WizardDialog dialog = new WizardDialog(this.shell, (IWizard)wizard);
                dialog.open();
            }
            this.project = null;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected IRunnableWithProgress getPrimeDataModelOperation() {
        PrimeDataModelOperation runnable = new PrimeDataModelOperation();
        return runnable;
    }

    protected void primeDataModel() throws InvocationTargetException, InterruptedException {
        IRunnableWithProgress primeDataModelOp = this.getPrimeDataModelOperation();
        if (primeDataModelOp != null) {
            ProgressMonitorDialog pmDlg = new ProgressMonitorDialog(this.shell);
            pmDlg.run(false, false, primeDataModelOp);
        }
    }

    protected class PrimeDataModelOperation
    implements IRunnableWithProgress {
        protected PrimeDataModelOperation() {
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                try {
                    monitor.beginTask(JpaMsg._Message_Loading_Entities, 5);
                    monitor.worked(1);
                    JpaManagerBeanDataModelProvider provider = new JpaManagerBeanDataModelProvider();
                    JpaManagerBeanCommand.this.model = DataModelFactory.createDataModel((IDataModelProvider)provider);
                    JpaManagerBeanCommand.this.model.setBooleanProperty("IJpaDataModelProperties.runOperationInBackground", JpaManagerBeanCommand.this.runInBackground);
                    JpaManagerBeanCommand.this.model.setProperty("IJpaDataModelProperties.selectedProject", (Object)JpaManagerBeanCommand.this.project);
                    monitor.worked(2);
                    IWorkbench workbench = JpaPlugin.getDefault().getWorkbench();
                    if (workbench != null) {
                        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                        JpaManagerBeanCommand.this.model.setProperty("IJpaManagerBeanDataModelProperties.targetPart", (Object)window.getActivePage().getActivePart());
                    }
                    if (JpaManagerBeanCommand.this.fIsConfigure) {
                        JpaManagerBeanCommand.this.model.setBooleanProperty("IJpaDataModelProperties.isConfigure", JpaManagerBeanCommand.this.fIsConfigure);
                        if (JpaManagerBeanCommand.this.jpaManagerBeanToConfigure != null) {
                            JpaManagerBeanCommand.this.model.setProperty("IJpaDataModelProperties.userSelections", (Object)new Object[]{JpaManagerBeanCommand.this.jpaManagerBeanToConfigure});
                        }
                    } else {
                        IProject project = (IProject)JpaManagerBeanCommand.this.model.getProperty("IJpaDataModelProperties.selectedProject");
                        boolean showAllProjects = JpaManagerBeanCommand.this.model.getBooleanProperty("IJpaDataModelProperties.showAllInClasspath");
                        JpaManagerBeanCommand.this.model.setProperty("IJpaDataModelProperties.availableSelections", JpaUtil.createManagerBeanModels(project, showAllProjects));
                    }
                    JpaManagerBeanCommand.this.model.setStringProperty("IJpaDataModelProperties.generationType", JpaManagerBeanCommand.this.fGenerationType);
                    monitor.worked(1);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
    }
}

