/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.codegen;

import com.ibm.etools.webtools.javamodel.api.JavaModel;
import com.ibm.etools.webtools.javamodel.api.JavaModelManager;
import com.ibm.etools.webtools.javamodel.commands.DeleteImportConditionallyCommand;
import com.ibm.etools.webtools.jpa.codegen.EntityAnnotationOperation;
import com.ibm.etools.webtools.jpa.codegen.ManagerBeanCodeGenOperation;
import com.ibm.etools.webtools.jpa.models.JpaManagerBeanInfo;
import com.ibm.etools.webtools.jpa.nls.JpaUI;
import com.ibm.etools.webtools.jpa.util.JpaUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;

public class CodeGenOperation
implements IRunnableWithProgress {
    private List<JpaManagerBeanInfo> managerBeans;
    private String generationType;
    private final boolean runInBackground;
    private final boolean isConfigureEntities;
    private final boolean isConfigure;

    public CodeGenOperation(List<JpaManagerBeanInfo> managerBeans, String generateType, boolean runInBackground, boolean isConfigureEntities, boolean isConfigure) {
        this.managerBeans = managerBeans;
        this.generationType = generateType;
        this.runInBackground = runInBackground;
        this.isConfigureEntities = isConfigureEntities;
        this.isConfigure = isConfigure;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        int num = 100;
        if (this.managerBeans.isEmpty()) {
            monitor.worked(num);
        } else {
            num = 100 / this.managerBeans.size();
        }
        int units = 2;
        for (JpaManagerBeanInfo managerBean : this.managerBeans) {
            EntityAnnotationOperation entityAnnotationOp = new EntityAnnotationOperation(managerBean);
            entityAnnotationOp.execute((IProgressMonitor)new SubProgressMonitor(monitor, num / units, 4));
            if (!this.generationType.equals("JSP")) continue;
            ManagerBeanCodeGenOperation managerBeanCodeGenOp = new ManagerBeanCodeGenOperation(managerBean, this.runInBackground, this.isConfigureEntities, this.isConfigure);
            managerBeanCodeGenOp.execute((IProgressMonitor)new SubProgressMonitor(monitor, num / units, 4));
        }
        RemoveUnusedImportsJob task = new RemoveUnusedImportsJob(JpaUI.CodeGenOperation_RemoveUnusedImportsMsg);
        task.setPriority(30);
        task.schedule(5000L);
    }

    private class RemoveUnusedImportsJob
    extends Job {
        public RemoveUnusedImportsJob(String name) {
            super(name);
        }

        private void removeUnusedImportsForJavaModel(JavaModel javaModel, IProgressMonitor monitor) {
            if (javaModel == null) {
                return;
            }
            try {
                IType javaType = javaModel.getType();
                IImportDeclaration[] imports = javaType.getCompilationUnit().getImports();
                DeleteImportConditionallyCommand deleteCmd = new DeleteImportConditionallyCommand();
                IImportDeclaration[] iImportDeclarationArray = imports;
                int n = imports.length;
                int n2 = 0;
                while (n2 < n) {
                    IImportDeclaration i = iImportDeclarationArray[n2];
                    String type = i.getElementName();
                    String signature = Signature.createTypeSignature((String)type, (boolean)false);
                    deleteCmd.setTypeSignature(signature);
                    deleteCmd.execute(javaModel, monitor);
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {}
        }

        public IStatus run(IProgressMonitor monitor) {
            String javaFile;
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            IStatus status = Status.OK_STATUS;
            ArrayList<JavaModel> models = new ArrayList<JavaModel>();
            for (JpaManagerBeanInfo managerBean : CodeGenOperation.this.managerBeans) {
                JavaModel entityJavaModel = JavaModelManager.getInstance().getModel("defaultjavamodel", managerBean.getProject(), JpaUtil.getJavaResourceFromPersistentType(managerBean.getEntity().getPersistentType()).getProjectRelativePath());
                entityJavaModel.prepareCompilationUnit(monitor);
                if (entityJavaModel != null) {
                    models.add(entityJavaModel);
                }
                if (CodeGenOperation.this.isConfigureEntities) continue;
                JavaModel beanJavaModel = JavaModelManager.getInstance().getModel("defaultjavamodel", managerBean.getProject(), managerBean.getManagerBeanPath());
                beanJavaModel.prepareCompilationUnit(monitor);
                if (beanJavaModel == null) continue;
                models.add(beanJavaModel);
            }
            int numModels = models.size();
            monitor.beginTask(JpaUI.CodeGenOperation_RemoveUnusedImportsMsg, numModels * 2);
            for (JavaModel m : models) {
                javaFile = m.getQualifiedTypeName();
                monitor.setTaskName(NLS.bind((String)JpaUI.CodeGenOperation_Updating, (Object)javaFile));
                this.removeUnusedImportsForJavaModel(m, null);
                monitor.worked(1);
            }
            monitor.setTaskName(JpaUI.CodeGenOperation_SaveChangesMsg);
            for (JavaModel m : models) {
                javaFile = m.getQualifiedTypeName();
                monitor.setTaskName(NLS.bind((String)JpaUI.CodeGenOperation_Saving, (Object)javaFile));
                m.save();
                m.release();
                monitor.worked(1);
            }
            return status;
        }
    }
}

