/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.annotation.quickfix.internal;

import com.ibm.etools.webtools.jpa.annotation.quickfix.internal.GenerateNamedQueryMethodProposal;
import com.ibm.etools.webtools.jpa.annotation.quickfix.internal.ModifyTargetNamedQueryProposal;
import com.ibm.etools.webtools.jpa.models.JpaEntityInfo;
import com.ibm.etools.webtools.jpa.models.JpaManagerBeanInfo;
import com.ibm.etools.webtools.jpa.models.JpaQueryMethodInfo;
import com.ibm.etools.webtools.jpa.util.JpaUtil;
import com.ibm.etools.webtools.jpa.util.NamedQueriesUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickFixProcessor;

public class JPAManagerQFP
implements IQuickFixProcessor {
    public static void addTargetNamedQueryCorrection(IType managerBeanType, IProject project, ArrayList<IJavaCompletionProposal> corrections, IInvocationContext context, ASTNode parent, String errorId, String targetQueryName) {
        String targetName = null;
        IMethod managerMethodForNamedQuery = NamedQueriesUtil.getManagerMethodForNamedQuery(managerBeanType, targetQueryName);
        if (managerMethodForNamedQuery != null && managerMethodForNamedQuery.exists()) {
            int lastIndex;
            String string = "";
            try {
                string = managerMethodForNamedQuery.getSource().toString();
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            int index = string.indexOf("createNamedQuery");
            if (index != -1) {
                if ((index = string.indexOf(34, index)) != -1 && (lastIndex = string.indexOf(34, index + 1)) != -1) {
                    targetName = string.substring(index + 1, lastIndex);
                }
            } else {
                index = string.indexOf("createQuery");
                if (index != -1 && (index = string.indexOf("NamedQueries.", index)) != -1 && (lastIndex = string.indexOf(")", index + 1)) != -1) {
                    targetName = string.substring(index + "NamedQueries.".length(), lastIndex).trim();
                }
            }
        }
        if (targetName != null) {
            String targetEntityName = JpaUtil.getEntityNameFromType(managerBeanType);
            IProject managerBeanProject = JpaUtil.getManagerBeanProject(managerBeanType, project);
            IProject targetEntityProject = JpaUtil.getTargetEntityProject(managerBeanProject, targetEntityName);
            JpaManagerBeanInfo managerBeanInfo = new JpaManagerBeanInfo(new JpaEntityInfo(null, targetEntityName, targetEntityProject), managerBeanType, false);
            JpaUtil.fillManagerBeanWithEntityType(project, managerBeanInfo);
            List<JpaQueryMethodInfo> existingNamedQueries = NamedQueriesUtil.getExistingNamedQueries(managerBeanInfo);
            for (JpaQueryMethodInfo jpaQueryMethodInfo : existingNamedQueries) {
                String queryName = jpaQueryMethodInfo.getQueryName();
                if (!queryName.equals(targetName)) continue;
                String queryValue = jpaQueryMethodInfo.getQueryValue();
                corrections.add(new ModifyTargetNamedQueryProposal(context, parent, 100, "style", errorId, queryName, queryValue));
                break;
            }
        }
    }

    public static void addTargetNamedQueryCorrections(IType managerBeanType, IProject project, ArrayList<IJavaCompletionProposal> corrections, IInvocationContext context, ASTNode parent, String errorId) {
        String targetEntityName = JpaUtil.getEntityNameFromType(managerBeanType);
        IProject managerBeanProject = JpaUtil.getManagerBeanProject(managerBeanType, project);
        IProject targetEntityProject = JpaUtil.getTargetEntityProject(managerBeanProject, targetEntityName);
        JpaManagerBeanInfo managerBeanInfo = new JpaManagerBeanInfo(new JpaEntityInfo(null, targetEntityName, targetEntityProject), managerBeanType, false);
        JpaUtil.fillManagerBeanWithEntityType(project, managerBeanInfo);
        List<JpaQueryMethodInfo> existingNamedQueries = NamedQueriesUtil.getExistingNamedQueries(managerBeanInfo);
        for (JpaQueryMethodInfo jpaQueryMethodInfo : existingNamedQueries) {
            String queryName = jpaQueryMethodInfo.getQueryName();
            String queryValue = jpaQueryMethodInfo.getQueryValue();
            corrections.add(new ModifyTargetNamedQueryProposal(context, parent, 100, "style", errorId, queryName, queryValue));
        }
    }

    public static void addTargetNamedQueryMethodCorrections(IType managerBeanType, IProject project, ArrayList<IJavaCompletionProposal> corrections, IInvocationContext context, ASTNode parent, String errorId) {
        IMethod[] methods = null;
        try {
            methods = managerBeanType.getMethods();
        }
        catch (JavaModelException e1) {
            e1.printStackTrace();
        }
        if (methods != null) {
            IMethod[] iMethodArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                IAnnotation annotation = method.getAnnotation("NamedQueryTarget");
                if (annotation != null && annotation.exists()) {
                    try {
                        IMemberValuePair[] iMemberValuePairArray = annotation.getMemberValuePairs();
                        int n3 = iMemberValuePairArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IMemberValuePair memberValuePair = iMemberValuePairArray[n4];
                            String queryName = memberValuePair.getValue().toString();
                            String queryValue = "";
                            corrections.add(new ModifyTargetNamedQueryProposal(context, parent, 100, "targetNamedQuery", errorId, queryName, queryValue));
                            ++n4;
                        }
                    }
                    catch (JavaModelException e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
    }

    public static boolean hasQuotes(String string) {
        String s = string.trim();
        char[] chars = s.toCharArray();
        return chars.length >= 2 && (chars[0] == '\'' && chars[chars.length - 1] == '\'' || chars[0] == '\"' && chars[chars.length - 1] == '\"');
    }

    public static String trimQuotes(String string) {
        if (string == null) {
            return null;
        }
        String result = null;
        result = string.trim();
        result = JPAManagerQFP.hasQuotes(result) ? string.substring(1, string.length() - 1) : string;
        return result;
    }

    public IJavaCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        ArrayList<IJavaCompletionProposal> corrections = new ArrayList<IJavaCompletionProposal>();
        IProblemLocation[] iProblemLocationArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            IProblemLocation problemLocation = iProblemLocationArray[n2];
            String[] arguments = problemLocation.getProblemArguments();
            if (arguments != null && arguments.length >= 2) {
                ASTNode parent;
                String pluginId = arguments[0];
                String errorId = arguments[1];
                if (pluginId.equals("com.ibm.etools.webtools.jpa") && errorId.equals("ERROR_TARGET_NAMED_QUERY_NOT_FOUND")) {
                    parent = null;
                    if (context.getCoveredNode() != null) {
                        parent = context.getCoveredNode().getParent();
                    } else if (context.getCoveringNode() != null) {
                        parent = context.getCoveringNode().getParent();
                    }
                    IType findPrimaryType = context.getCompilationUnit().findPrimaryType();
                    JPAManagerQFP.addTargetNamedQueryCorrections(findPrimaryType, findPrimaryType.getJavaProject().getProject(), corrections, context, parent, errorId);
                } else if (pluginId.equals("com.ibm.etools.webtools.jpa") && errorId.equals("ERROR_TARGET_NAMED_QUERY_INCONSISTENT")) {
                    String targetNamedQuery;
                    parent = null;
                    if (context.getCoveredNode() != null) {
                        parent = context.getCoveredNode().getParent();
                    } else if (context.getCoveringNode() != null) {
                        parent = context.getCoveringNode().getParent();
                    }
                    if (parent instanceof SingleMemberAnnotation && (targetNamedQuery = ((SingleMemberAnnotation)parent).getValue().toString()) != null && targetNamedQuery.length() > 0 && (targetNamedQuery = JPAManagerQFP.trimQuotes(targetNamedQuery)).length() > 0) {
                        IType findPrimaryType = context.getCompilationUnit().findPrimaryType();
                        JPAManagerQFP.addTargetNamedQueryCorrection(findPrimaryType, findPrimaryType.getJavaProject().getProject(), corrections, context, parent, errorId, targetNamedQuery);
                        corrections.add(new GenerateNamedQueryMethodProposal(context, findPrimaryType, targetNamedQuery, parent, 100, "style", errorId, "", ""));
                    }
                } else if (pluginId.equals("com.ibm.etools.webtools.jpa") && errorId.equals("ERROR_TARGET_NAMED_QUERY_METHOD_NOT_FOUND")) {
                    parent = null;
                    if (context.getCoveredNode() != null) {
                        parent = context.getCoveredNode().getParent();
                    } else if (context.getCoveringNode() != null) {
                        parent = context.getCoveringNode().getParent();
                    }
                    ASTNode parent2 = parent.getParent();
                    IType managerBeanType = null;
                    if (parent2 instanceof NormalAnnotation) {
                        List annotationMembers = ((NormalAnnotation)parent2).values();
                        int i = 0;
                        while (i < annotationMembers.size()) {
                            MemberValuePair valPair = (MemberValuePair)annotationMembers.get(i);
                            try {
                                if (valPair.getName().getFullyQualifiedName().equals("targetEntityManager")) {
                                    Expression expr = valPair.getValue();
                                    TypeLiteral typeLiteral = (TypeLiteral)expr;
                                    Type type = typeLiteral.getType();
                                    IProject project = context.getCompilationUnit().getResource().getProject();
                                    String entity = type.toString();
                                    IJavaProject javaProject = JavaCore.create((IProject)project);
                                    if (javaProject == null || entity == null) break;
                                    managerBeanType = javaProject.findType(entity);
                                    break;
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace(System.err);
                            }
                            ++i;
                        }
                    }
                    if (managerBeanType != null) {
                        JPAManagerQFP.addTargetNamedQueryMethodCorrections(managerBeanType, managerBeanType.getJavaProject().getProject(), corrections, context, parent, errorId);
                    }
                }
            }
            ++n2;
        }
        if (corrections.isEmpty()) {
            return null;
        }
        return corrections.toArray(new IJavaCompletionProposal[corrections.size()]);
    }

    public boolean hasCorrections(ICompilationUnit unit, int problemId) {
        return problemId == 900;
    }
}

