/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.annotation.marker.internal;

import com.ibm.etools.webtools.jpa.annotation.marker.internal.SelectTargetQueryDialog;
import com.ibm.etools.webtools.jpa.annotation.quickfix.internal.ModifyTargetNamedQueryProposal;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.texteditor.ITextEditor;

public class TargetNamedQueryMarkerResolution
implements IMarkerResolution {
    private ICompilationUnit icu_;
    private ModifyTargetNamedQueryProposal proposal_;
    private int startOffset_;
    private int length_;
    private final IProject project;
    private final String errorId;
    private final String annotationMemberName;

    public TargetNamedQueryMarkerResolution(ICompilationUnit icu, IMarker marker, IProject project, String annotationMemberName, String errorId, String queryName, String queryValue) throws CoreException {
        this.icu_ = icu;
        this.project = project;
        this.annotationMemberName = annotationMemberName;
        this.errorId = errorId;
    }

    public String getLabel() {
        return "Select existing named query";
    }

    public void run(IMarker marker) {
        String selectedQueryName;
        SelectTargetQueryDialog dlg = new SelectTargetQueryDialog(Display.getDefault().getActiveShell(), this.icu_.findPrimaryType(), this.project, marker, this.errorId);
        dlg.open();
        if (dlg.getReturnCode() == 0 && (selectedQueryName = dlg.getSelectedQueryName()) != null) {
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setSource(this.icu_);
            parser.setResolveBindings(true);
            CompilationUnit cu = (CompilationUnit)parser.createAST(null);
            try {
                this.startOffset_ = (Integer)marker.getAttribute("charStart");
                int end = (Integer)marker.getAttribute("charEnd");
                this.length_ = end - this.startOffset_;
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            String selectedQueryValue = dlg.getSelectedQueryValue();
            ASTNode annotationNode = NodeFinder.perform((ASTNode)cu, (int)this.startOffset_, (int)this.length_).getParent();
            this.proposal_ = new ModifyTargetNamedQueryProposal(cu, annotationNode, 99, this.annotationMemberName, this.errorId, selectedQueryName, selectedQueryValue);
            IEditorPart part = EditorUtility.isOpenInEditor((Object)this.icu_);
            if (part == null) {
                try {
                    part = JavaUI.openInEditor((IJavaElement)this.icu_, (boolean)true, (boolean)false);
                    if (part instanceof ITextEditor) {
                        ((ITextEditor)part).selectAndReveal(this.startOffset_, this.length_);
                    }
                }
                catch (CoreException coreException) {}
            }
            if (part != null) {
                IEditorInput input = part.getEditorInput();
                IDocument doc = JavaUI.getDocumentProvider().getDocument((Object)input);
                this.proposal_.apply(doc);
            }
        }
    }
}

