/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.annotation.marker.internal;

import com.ibm.etools.webtools.jpa.nls.JpaUI;
import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class SelectTargetQueryMethodDialog
extends Dialog {
    private final IType managerBeanType;
    private final IProject project;
    private final IMarker marker;
    private final String errorId;
    private ArrayList<String> queryNames = new ArrayList();
    private String selectedQueryName = null;
    private List list;

    public SelectTargetQueryMethodDialog(Shell parentShell, IType managerBeanType, IProject project, IMarker marker, String errorId) {
        super(parentShell);
        this.managerBeanType = managerBeanType;
        this.project = project;
        this.marker = marker;
        this.errorId = errorId;
    }

    private void addTargetNamedQueryCorrections(IType managerBeanType, IProject project, IMarker marker, String errorId) {
        IMethod[] methods = null;
        try {
            methods = managerBeanType.getMethods();
        }
        catch (JavaModelException e1) {
            e1.printStackTrace();
        }
        if (methods != null) {
            IMethod[] iMethodArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                IAnnotation annotation = method.getAnnotation("NamedQueryTarget");
                if (annotation != null && annotation.exists()) {
                    try {
                        IMemberValuePair[] iMemberValuePairArray = annotation.getMemberValuePairs();
                        int n3 = iMemberValuePairArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IMemberValuePair memberValuePair = iMemberValuePairArray[n4];
                            String queryName = memberValuePair.getValue().toString();
                            this.queryNames.add(queryName);
                            ++n4;
                        }
                    }
                    catch (JavaModelException e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        new Label(parent, 0);
        this.addTargetNamedQueryCorrections(this.managerBeanType, this.project, this.marker, this.errorId);
        this.list = new List(parent, 2560);
        int i = 0;
        while (i < this.queryNames.size()) {
            this.list.add(this.queryNames.get(i));
            ++i;
        }
        GridData data = new GridData();
        data.widthHint = 250;
        data.heightHint = 200;
        this.list.setLayoutData((Object)data);
        this.getShell().setText(JpaUI.SelectTargetQueryMethodDialog_0);
        if (!this.queryNames.isEmpty()) {
            this.list.select(0);
        }
        Dialog.applyDialogFont((Control)parent);
        return parent;
    }

    public String getSelectedQueryName() {
        return this.selectedQueryName;
    }

    protected GridLayout initGridLayout(GridLayout layout, boolean margins) {
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        if (margins) {
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        } else {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        return layout;
    }

    protected void okPressed() {
        int selection = this.list.getSelectionIndex();
        if (selection > -1) {
            this.selectedQueryName = this.queryNames.get(selection);
        }
        super.okPressed();
    }
}

