/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.annotation.marker.internal;

import com.ibm.etools.webtools.jpa.models.JpaEntityInfo;
import com.ibm.etools.webtools.jpa.models.JpaManagerBeanInfo;
import com.ibm.etools.webtools.jpa.models.JpaQueryMethodInfo;
import com.ibm.etools.webtools.jpa.nls.JpaUI;
import com.ibm.etools.webtools.jpa.util.JpaUtil;
import com.ibm.etools.webtools.jpa.util.NamedQueriesUtil;
import com.ibm.etools.webtools.jpa.wizard.ui.UIPartsUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SelectTargetQueryDialog
extends Dialog {
    private Text queryText;
    private final IType managerBeanType;
    private final IProject project;
    private final IMarker marker;
    private final String errorId;
    private ArrayList<String> queryNames = new ArrayList();
    private ArrayList<String> queryValues = new ArrayList();
    private String selectedQueryName = null;
    private org.eclipse.swt.widgets.List list;
    private String selectedQueryValue;

    public SelectTargetQueryDialog(Shell parentShell, IType managerBeanType, IProject project, IMarker marker, String errorId) {
        super(parentShell);
        this.managerBeanType = managerBeanType;
        this.project = project;
        this.marker = marker;
        this.errorId = errorId;
    }

    private void addNamedQueryNames(IType managerBeanType, IProject project, IMarker marker, String errorId) {
        String targetEntityName = JpaUtil.getEntityNameFromType(managerBeanType);
        IProject managerBeanProject = JpaUtil.getManagerBeanProject(managerBeanType, project);
        IProject targetEntityProject = JpaUtil.getTargetEntityProject(managerBeanProject, targetEntityName);
        JpaManagerBeanInfo managerBeanInfo = new JpaManagerBeanInfo(new JpaEntityInfo(null, targetEntityName, targetEntityProject), managerBeanType, false);
        JpaUtil.fillManagerBeanWithEntityType(project, managerBeanInfo);
        List<JpaQueryMethodInfo> existingNamedQueries = NamedQueriesUtil.getExistingNamedQueries(managerBeanInfo);
        int size = existingNamedQueries.size();
        int i = 0;
        while (i < size) {
            JpaQueryMethodInfo jpaQueryMethodInfo = existingNamedQueries.get(i);
            String queryName = jpaQueryMethodInfo.getQueryName();
            String queryValue = jpaQueryMethodInfo.getQueryValue();
            this.queryNames.add(queryName);
            this.queryValues.add(queryValue);
            ++i;
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        new Label(parent, 0);
        this.addNamedQueryNames(this.managerBeanType, this.project, this.marker, this.errorId);
        this.list = new org.eclipse.swt.widgets.List(parent, 2560);
        int i = 0;
        while (i < this.queryNames.size()) {
            this.list.add(this.queryNames.get(i));
            ++i;
        }
        this.list.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int selection = SelectTargetQueryDialog.this.list.getSelectionIndex();
                if (selection > -1) {
                    SelectTargetQueryDialog.this.queryText.setText((String)SelectTargetQueryDialog.this.queryValues.get(selection));
                }
            }
        });
        GridData data = new GridData();
        data.widthHint = 250;
        data.heightHint = 200;
        this.list.setLayoutData((Object)data);
        this.getShell().setText("Select existing target named query");
        new Label(parent, 0);
        UIPartsUtil.createLabel(parent, JpaUI._UI_Query_Statement, 1);
        this.queryText = UIPartsUtil.createMultiTextField(parent, 1, 8, 30);
        this.queryText.setSize(-1, 30);
        if (!this.queryNames.isEmpty()) {
            this.list.select(0);
            this.queryText.setText(this.queryValues.get(0));
        }
        Dialog.applyDialogFont((Control)parent);
        return parent;
    }

    public String getSelectedQueryName() {
        return this.selectedQueryName;
    }

    public String getSelectedQueryValue() {
        return this.selectedQueryValue;
    }

    protected GridLayout initGridLayout(GridLayout layout, boolean margins) {
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        if (margins) {
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        } else {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        return layout;
    }

    protected void okPressed() {
        int selection = this.list.getSelectionIndex();
        if (selection > -1) {
            this.selectedQueryName = this.queryNames.get(selection);
            this.selectedQueryValue = this.queryValues.get(selection);
        }
        super.okPressed();
    }
}

