/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.annotation;

import com.ibm.jpa.web.JPA;
import com.ibm.jpa.web.NamedQueryTarget;
import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.Messager;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.apt.core.util.EclipseMessager;

public class JPAPageAnnotationProcessor
implements AnnotationProcessor {
    public static final String ERROR_TARGET_NAMED_QUERY_METHOD_NOT_FOUND = "ERROR_TARGET_NAMED_QUERY_METHOD_NOT_FOUND";
    public static final String ERROR_TARGET_NAMED_QUERY_METHOD_INCONSISTENT = "ERROR_TARGET_NAMED_QUERY_METHOD_INCONSISTENT";
    private HashMap<String, ArrayList<String>> namedQueryHash;
    private AnnotationProcessorEnvironment _env;

    public JPAPageAnnotationProcessor(AnnotationProcessorEnvironment env) {
        this._env = env;
    }

    private String getTargetNamedQueries(TypeDeclaration targetManagerType) {
        String qualifiedName;
        ArrayList<String> arrayList;
        if (this.namedQueryHash == null || this.namedQueryHash.isEmpty()) {
            this.namedQueryHash = new HashMap();
        }
        if ((arrayList = this.namedQueryHash.get(qualifiedName = targetManagerType.getQualifiedName())) != null) {
            return null;
        }
        arrayList = new ArrayList();
        Collection methods = targetManagerType.getMethods();
        for (MethodDeclaration methodDeclaration : methods) {
            Collection mirrors = methodDeclaration.getAnnotationMirrors();
            for (AnnotationMirror mirror : mirrors) {
                if (!mirror.getAnnotationType().getDeclaration().getQualifiedName().equals(NamedQueryTarget.class.getName())) continue;
                Map valueMap = mirror.getElementValues();
                Set valueSet = valueMap.entrySet();
                for (Map.Entry annoKeyValue3 : valueSet) {
                    AnnotationValue annoValue3 = (AnnotationValue)annoKeyValue3.getValue();
                    Object value3 = annoValue3.getValue();
                    arrayList.add(value3.toString());
                }
            }
        }
        this.namedQueryHash.put(qualifiedName, arrayList);
        return "";
    }

    protected boolean isValidTarget(Declaration declaration) {
        return declaration instanceof MethodDeclaration;
    }

    public void process() {
        this.processNamedQueryTargetAnnotations();
        if (this.namedQueryHash != null) {
            this.namedQueryHash.clear();
        }
    }

    private void processNamedQueryTargetAnnotations() {
        Messager messager = this._env.getMessager();
        AnnotationTypeDeclaration annoDec = (AnnotationTypeDeclaration)this._env.getTypeDeclaration(JPA.class.getName());
        if (annoDec == null) {
            return;
        }
        Collection annotatedDecls = this._env.getDeclarationsAnnotatedWith(annoDec);
        if (annotatedDecls == null) {
            return;
        }
        for (Declaration decl : annotatedDecls) {
            if (!this.isValidTarget(decl)) continue;
            Collection mirrors = decl.getAnnotationMirrors();
            for (AnnotationMirror mirror : mirrors) {
                if (!mirror.getAnnotationType().getDeclaration().getQualifiedName().equals(JPA.class.getName())) continue;
                Map valueMap = mirror.getElementValues();
                Set valueSet = valueMap.entrySet();
                String namedQueryTargetName = null;
                TypeDeclaration targetManagerType = null;
                AnnotationValue targetNamedQueryAnnoValue = null;
                for (Map.Entry annoKeyValue : valueSet) {
                    AnnotationValue annoValue;
                    Object value;
                    String nameVal = ((AnnotationTypeElementDeclaration)annoKeyValue.getKey()).getSimpleName();
                    if (nameVal.equals("targetNamedQuery")) {
                        targetNamedQueryAnnoValue = (AnnotationValue)annoKeyValue.getValue();
                        namedQueryTargetName = targetNamedQueryAnnoValue.getValue().toString();
                        continue;
                    }
                    if (!nameVal.equals("targetEntityManager") || (value = (annoValue = (AnnotationValue)annoKeyValue.getValue()).getValue()) == null || !(value instanceof TypeDeclaration)) continue;
                    targetManagerType = (TypeDeclaration)value;
                }
                if (targetManagerType == null || namedQueryTargetName == null) continue;
                this.getTargetNamedQueries(targetManagerType);
                ArrayList<String> namedQueryList = this.namedQueryHash.get(targetManagerType.getQualifiedName());
                if (namedQueryList == null || namedQueryList.contains(namedQueryTargetName)) continue;
                EclipseMessager eclipseMessager = (EclipseMessager)messager;
                eclipseMessager.printFixableWarning(targetNamedQueryAnnoValue.getPosition(), String.valueOf(namedQueryTargetName) + ": target named query method not found.", "com.ibm.etools.webtools.jpa", ERROR_TARGET_NAMED_QUERY_METHOD_NOT_FOUND);
            }
        }
    }
}

