/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.actions;

import com.ibm.etools.webtools.jpa.JpaPlugin;
import com.ibm.etools.webtools.jpa.actions.AbstractProjectAction;
import com.ibm.etools.webtools.jpa.models.JpaManagerBeanInfo;
import com.ibm.etools.webtools.jpa.nls.JpaMsg;
import com.ibm.etools.webtools.jpa.util.FacetUtil;
import com.ibm.etools.webtools.jpa.util.JpaUtil;
import com.ibm.etools.webtools.jpa.wizard.JpaManagerBeanWizard;
import com.ibm.etools.webtools.jpa.wizard.model.JpaManagerBeanDataModelProvider;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class ConfigureEntitiesAction
extends AbstractProjectAction {
    private IDataModel model;
    private Object[] fSelectedObjects;

    @Override
    protected boolean getEnableStateForSelection(IStructuredSelection selection) {
        this.fSelectedObjects = selection.toArray();
        return true;
    }

    protected IRunnableWithProgress getPrimeDataModelOperation() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        IResource file = ConfigureEntitiesAction.this.getResourceForSelectedObject(ConfigureEntitiesAction.this.fSelectedObjects[0]);
                        monitor.beginTask(JpaMsg._Message_Loading_Entities, 5);
                        monitor.worked(1);
                        if (FacetUtil.installJpaFacetIfNeeded(file.getProject(), monitor)) {
                            monitor.worked(1);
                            JpaManagerBeanDataModelProvider provider = new JpaManagerBeanDataModelProvider();
                            ConfigureEntitiesAction.this.model = DataModelFactory.createDataModel((IDataModelProvider)provider);
                            ConfigureEntitiesAction.this.model.setProperty("IJpaDataModelProperties.selectedProject", (Object)file.getProject());
                            monitor.worked(2);
                            IWorkbench workbench = JpaPlugin.getDefault().getWorkbench();
                            if (workbench != null) {
                                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                                ConfigureEntitiesAction.this.model.setProperty("IJpaManagerBeanDataModelProperties.targetPart", (Object)window.getActivePage().getActivePart());
                            }
                            ConfigureEntitiesAction.this.model.setBooleanProperty("IJpaDataModelProperties.isConfigure", false);
                            ConfigureEntitiesAction.this.model.setBooleanProperty("IJpaDataModelProperties.isConfigureEntities", true);
                            if (FacetUtil.isFacetDefinedOnProject(file.getProject(), "jst.jsf")) {
                                ConfigureEntitiesAction.this.model.setStringProperty("IJpaDataModelProperties.generationType", "JSF");
                            } else {
                                ConfigureEntitiesAction.this.model.setStringProperty("IJpaDataModelProperties.generationType", "JSP");
                            }
                            IProject project = (IProject)ConfigureEntitiesAction.this.model.getProperty("IJpaDataModelProperties.selectedProject");
                            ConfigureEntitiesAction.this.model.setBooleanProperty("IJpaDataModelProperties.showAllInClasspath", false);
                            List<JpaManagerBeanInfo> managerBeans = JpaUtil.createManagerBeanModels(project, true);
                            ConfigureEntitiesAction.this.model.setProperty("IJpaDataModelProperties.availableSelections", managerBeans);
                            ArrayList<JpaManagerBeanInfo> selectedManagers = new ArrayList<JpaManagerBeanInfo>();
                            Object[] objectArray = ConfigureEntitiesAction.this.fSelectedObjects;
                            int n = objectArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object resource = objectArray[n2];
                                IResource selectedFile = ConfigureEntitiesAction.this.getResourceForSelectedObject(resource);
                                if (!(selectedFile instanceof IProject)) {
                                    for (JpaManagerBeanInfo managerBean : managerBeans) {
                                        if (!JpaUtil.getJavaResourceFromPersistentType(managerBean.getEntity().getPersistentType()).getFullPath().equals((Object)selectedFile.getFullPath())) continue;
                                        selectedManagers.add(managerBean);
                                        break;
                                    }
                                }
                                ++n2;
                            }
                            ConfigureEntitiesAction.this.model.setProperty("IJpaDataModelProperties.userSelections", (Object)selectedManagers.toArray());
                            monitor.worked(1);
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        return runnable;
    }

    private IResource getResourceForSelectedObject(Object object) {
        if (object instanceof PersistentType) {
            return JpaUtil.getJavaResourceFromPersistentType((PersistentType)object);
        }
        return (IResource)object;
    }

    protected void primeDataModel() throws InvocationTargetException, InterruptedException {
        IRunnableWithProgress primeDataModelOp = this.getPrimeDataModelOperation();
        if (primeDataModelOp != null) {
            ProgressMonitorDialog pmDlg = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
            pmDlg.run(false, false, primeDataModelOp);
        }
    }

    public void run(IAction action) {
        try {
            this.primeDataModel();
            if (this.model != null) {
                JpaManagerBeanWizard wizard = new JpaManagerBeanWizard(this.model);
                WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
                dialog.open();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

