/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.jsf.refactoring;

import com.ibm.etools.webtools.codebehind.pdm.util.DocletParser;
import com.ibm.etools.webtools.javamodel.api.JavaDocElement;
import com.ibm.etools.webtools.javamodel.api.JavaDocInfo;
import com.ibm.etools.webtools.javamodel.api.JavaModel;
import com.ibm.etools.webtools.javamodel.api.JavaModelManager;
import com.ibm.etools.webtools.javamodel.commands.CreateEntireMethodFromContentsCommand;
import com.ibm.etools.webtools.javamodel.commands.DeleteMethodCommand;
import com.ibm.etools.webtools.javamodel.commands.ReadMethodCommand;
import com.ibm.etools.webtools.jpa.jsf.nls.JpaUI;
import com.ibm.etools.webtools.pagedatamodel.util.JavaTypeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class JPAMethodRenameActionReferencesChange
extends Change {
    private final IMethod renamedMethod;
    private final String newName;

    public JPAMethodRenameActionReferencesChange(IMethod renamedMethod, String newName) {
        this.renamedMethod = renamedMethod;
        this.newName = newName;
    }

    public Object getModifiedElement() {
        return null;
    }

    public String getName() {
        return JpaUI.JPAMethodRenameActionReferencesChange_0;
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws OperationCanceledException {
        return RefactoringStatus.create((IStatus)Status.OK_STATUS);
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        IType type = this.renamedMethod.getTypeRoot().findPrimaryType();
        String propName = JavaTypeUtil.getPropertyName((String)this.renamedMethod.getElementName());
        propName = JavaTypeUtil.decapitalizePropertyName((String)propName);
        String newPropertyName = JavaTypeUtil.getPropertyName((String)this.newName);
        newPropertyName = JavaTypeUtil.decapitalizePropertyName((String)newPropertyName);
        IPath relativePath = this.renamedMethod.getResource().getProjectRelativePath();
        JavaModel javaModel = JavaModelManager.getInstance().getModel("codebehind", this.renamedMethod.getResource().getProject(), relativePath);
        javaModel.prepareCompilationUnit(pm);
        try {
            ArrayList<IMethod> methodsToUpdate = new ArrayList<IMethod>(1);
            ArrayList<JavaDocInfo> oldJavaDocInfo = new ArrayList<JavaDocInfo>(1);
            int i = 0;
            while (i < type.getMethods().length) {
                DocletParser dparser;
                Map parsedValues;
                Object idTag;
                IMethod method = type.getMethods()[i];
                ReadMethodCommand readCmd = new ReadMethodCommand();
                readCmd.setIdentifier(method.getElementName());
                readCmd.setParameterNames(method.getParameterNames());
                readCmd.setParameters(method.getParameterTypes());
                readCmd.execute(javaModel, pm);
                JavaDocInfo jdInfo = readCmd.getJavadoc();
                if (jdInfo != null && jdInfo.getCommentForTag("action") != null && (idTag = (parsedValues = (dparser = new DocletParser(jdInfo.getCommentForTag("action"))).parse()).get("id")) != null && idTag.equals(propName)) {
                    methodsToUpdate.add(method);
                    oldJavaDocInfo.add(jdInfo);
                }
                ++i;
            }
            i = 0;
            while (i < methodsToUpdate.size()) {
                CreateEntireMethodFromContentsCommand cmd = new CreateEntireMethodFromContentsCommand();
                JavaDocInfo jdInfo = (JavaDocInfo)oldJavaDocInfo.get(i);
                List doclets = jdInfo.getDocletList();
                for (JavaDocElement element : doclets) {
                    if (!element.getTagName().equals("action")) continue;
                    element.setTagComment("id=" + newPropertyName);
                }
                if (jdInfo != null) {
                    cmd.setJavadoc(jdInfo);
                }
                cmd.setContents(((IMethod)methodsToUpdate.get(i)).getSource());
                DeleteMethodCommand delMethodCmd = new DeleteMethodCommand();
                delMethodCmd.setIdentifier(((IMethod)methodsToUpdate.get(i)).getElementName());
                delMethodCmd.execute(javaModel, pm);
                pm.worked(1);
                cmd.execute(javaModel, pm);
                ++i;
            }
        }
        finally {
            if (javaModel != null) {
                javaModel.release();
            }
        }
        return null;
    }
}

