/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.jpa.jsf.codegen;

import com.ibm.etools.webtools.codebehind.java.FacesConfigUtil;
import com.ibm.etools.webtools.javamodel.api.JavaCodeUtil;
import com.ibm.etools.webtools.jpa.jsf.codegen.PageCodeGenUtil;
import com.ibm.etools.webtools.jpa.jsf.codegen.template.DataParameter;
import com.ibm.etools.webtools.jpa.jsf.codegen.template.EntityConverterClass;
import com.ibm.etools.webtools.jpa.jsf.codegen.template.PageCodeTemplateHelper;
import com.ibm.etools.webtools.jpa.models.JpaAttributeInfo;
import com.ibm.etools.webtools.jpa.models.JpaFilterParameterInfo;
import com.ibm.etools.webtools.jpa.models.JpaManagerBeanInfo;
import com.ibm.etools.webtools.jpa.models.JpaQueryMethodInfo;
import com.ibm.etools.webtools.jpa.util.JpaUtil;
import com.ibm.etools.webtools.jpa.util.ManagerBeanUtil;
import com.ibm.etools.webtools.jpa.wizard.model.JpaPageDataModelProvider;
import com.ibm.etools.webtools.jpa.wizard.operations.JpaPageOperation;
import com.ibm.etools.webtools.packagepreferences.packages.PackageNamePreferences;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jpt.core.context.PersistentAttribute;

public class CreateEntityConverterJob
extends Job {
    public static final String JPA_ENTITY_CONVERTER_PACKAGE_ID = "jpa.converter.package.prefix";
    public static final Object JAVAMODELJOB_KEY = new Object();
    private final JpaManagerBeanInfo managerBeanInfo;

    public CreateEntityConverterJob(JpaManagerBeanInfo managerBeanInfo) {
        super("CreateEntityConverterJob");
        this.managerBeanInfo = managerBeanInfo;
    }

    private static String addConverterClass(JpaManagerBeanInfo managerBeanInfo, IProgressMonitor monitor) {
        String packageName;
        IMethod targetManagerMethod = ManagerBeanUtil.getManagerMethodForAction((IType)managerBeanInfo.getExistingManagerBeanType(), (String)"Action.ACTION_TYPE.FIND");
        if (targetManagerMethod == null) {
            return null;
        }
        JpaQueryMethodInfo queryMethod = JpaPageDataModelProvider.getFindQueryFromMethod((JpaManagerBeanInfo)managerBeanInfo, (IMethod)targetManagerMethod);
        String fullyQualifiedEntityManagerClassName = managerBeanInfo.getExistingManagerBeanType().getFullyQualifiedName();
        String managerBeanName = Signature.getSimpleName((String)fullyQualifiedEntityManagerClassName);
        String managerFacesName = PageCodeGenUtil.getManagerFacesName(managerBeanInfo.getProject(), fullyQualifiedEntityManagerClassName, managerBeanName);
        String targetMethodName = targetManagerMethod.getElementName();
        String resolvedReturnType = JavaCodeUtil.getResolvedReturnType((IMethod)targetManagerMethod);
        resolvedReturnType = Signature.getTypeErasure((String)resolvedReturnType);
        int numberOfParameters = targetManagerMethod.getNumberOfParameters();
        String[] paramNames = new String[]{};
        try {
            paramNames = targetManagerMethod.getParameterNames();
        }
        catch (JavaModelException e1) {
            e1.printStackTrace();
        }
        String[] paramTypes = targetManagerMethod.getParameterTypes();
        int filterStringCount = 0;
        List filterParameters = null;
        if (queryMethod.getFilter(managerBeanInfo.getEntity()) != null) {
            filterParameters = queryMethod.getFilter(managerBeanInfo.getEntity()).getParameters();
            filterStringCount = filterParameters.size();
        }
        ArrayList<DataParameter> dataParameters = new ArrayList<DataParameter>(numberOfParameters);
        ArrayList<String> resolvedTypesToImport = new ArrayList<String>(1);
        int i = 0;
        while (i < numberOfParameters) {
            DataParameter param = new DataParameter();
            param.setName(paramNames[i]);
            if (i < filterStringCount && filterParameters != null) {
                param.setParameterString(((JpaFilterParameterInfo)filterParameters.get(i)).getParameterValue());
            }
            String resolvedParamType = JavaCodeUtil.getResolvedParamType((IMethod)targetManagerMethod, (String)paramTypes[i]);
            param.setFullyResolvedType(resolvedParamType);
            if (!resolvedTypesToImport.contains(resolvedParamType)) {
                resolvedTypesToImport.add(resolvedParamType);
            }
            dataParameters.add(param);
            ++i;
        }
        List primaryKeyAttributes = managerBeanInfo.getEntity().getPrimaryKeyAttributes();
        int size = primaryKeyAttributes.size();
        String[] primaryKeyMethodNames = new String[size];
        int i2 = 0;
        while (i2 < size) {
            JpaAttributeInfo jpaAttributeInfo = (JpaAttributeInfo)primaryKeyAttributes.get(i2);
            String methodName = null;
            if (jpaAttributeInfo.isPartOfCompositePrimaryKey()) {
                JpaAttributeInfo parentAttribute = jpaAttributeInfo.getParentAttribute();
                if (parentAttribute != null) {
                    String attributeName = parentAttribute.getAttributeName();
                    methodName = JpaUtil.getMethodName((String)attributeName, (boolean)true);
                    PersistentAttribute attribute = jpaAttributeInfo.getAttribute();
                    if (attribute != null) {
                        String name = attribute.getName();
                        name = JpaUtil.getMethodName((String)name, (boolean)true);
                        methodName = String.valueOf(methodName) + "()." + name;
                    }
                }
            } else {
                String attributeName = jpaAttributeInfo.getAttributeName();
                methodName = JpaUtil.getMethodName((String)attributeName, (boolean)true);
            }
            primaryKeyMethodNames[i2] = methodName;
            ++i2;
        }
        PageCodeTemplateHelper helper = new PageCodeTemplateHelper();
        IProject project = managerBeanInfo.getProject();
        String entityPackage = managerBeanInfo.getEntity().getFullyQualifiedEntityName();
        int lastIndex = entityPackage.lastIndexOf(46);
        if (lastIndex != -1) {
            entityPackage = entityPackage.substring(0, lastIndex);
        }
        String converterPath = packageName = PackageNamePreferences.getPackageText((String)JPA_ENTITY_CONVERTER_PACKAGE_ID, (IProject)project);
        packageName = packageName.replace("${targetEntityPackage}", entityPackage);
        converterPath = converterPath.replace('.', '/');
        converterPath = converterPath.replace("${targetEntityPackage}", entityPackage);
        String converterName = String.valueOf(managerBeanInfo.getEntity().getEntityName()) + "Converter";
        String converterJavaName = String.valueOf(converterName) + ".java";
        IPath classpath = new Path(converterPath).append(converterJavaName);
        IFolder sourceFolder = JavaCodeUtil.getWebSourceFolder((IProject)managerBeanInfo.getProject());
        if (classpath.segmentCount() > 0 && classpath.segment(0).equals(sourceFolder.getName())) {
            classpath = classpath.removeFirstSegments(1);
        }
        helper.setPackageName(packageName);
        helper.setConverterClassName(converterName);
        helper.setPrimaryKeyGetterNames(primaryKeyMethodNames);
        helper.setFullyQualifiedEntityName(managerBeanInfo.getEntity().getFullyQualifiedEntityName());
        helper.setFullyQualifiedManagerBeanType(fullyQualifiedEntityManagerClassName);
        helper.setManagerBeanName(managerBeanName);
        helper.setManagerBeanVariableName(ManagerBeanUtil.getLegalEntityVariableName((String)managerBeanName));
        helper.setManagerBeanTargetMethodName(targetMethodName);
        helper.setManagerFacesName(managerFacesName);
        helper.setDataParameters(dataParameters);
        String contents = new EntityConverterClass().generate(helper);
        JavaCodeUtil.createClass((IProject)managerBeanInfo.getProject(), (IPath)classpath, (String)packageName, (String)converterJavaName, (String)contents, (boolean)true, (boolean)false, (IProgressMonitor)monitor);
        return String.valueOf(packageName) + "." + converterName;
    }

    public boolean belongsTo(Object family) {
        return family == JAVAMODELJOB_KEY;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        monitor.beginTask("", -1);
        try {
            JpaPageOperation.importWebJpaJar((IProject)this.managerBeanInfo.getProject(), (IProgressMonitor)monitor);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        String converterClass = CreateEntityConverterJob.addConverterClass(this.managerBeanInfo, monitor);
        if (converterClass != null) {
            FacesConfigUtil.createConverterForClass((IProject)this.managerBeanInfo.getProject(), null, (String)this.managerBeanInfo.getEntity().getFullyQualifiedEntityName(), (String)converterClass);
        }
        monitor.done();
        return status;
    }
}

